/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class SetFilterDimPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dimMaps = (String)formShowParameter.getCustomParam("dimMaps");
        String filterDims = (String)formShowParameter.getCustomParam("filterDims");
        if (StringUtils.isNotEmpty((String)dimMaps)) {
            List dims = (List)SerializationUtils.fromJsonString((String)dimMaps, List.class);
            this.initEntryEntity(dims, filterDims);
        }
    }

    private void initEntryEntity(List<Map<String, String>> dimMaps, String filterDims) {
        if (CollectionUtils.isEmpty(dimMaps)) {
            return;
        }
        List filterDimNumbers = new ArrayList(16);
        if (StringUtils.isNotEmpty((String)filterDims)) {
            filterDimNumbers = (List)SerializationUtils.fromJsonString((String)filterDims, List.class);
        }
        ArrayList<Integer> selRows = new ArrayList<Integer>(dimMaps.size());
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        dataModel.deleteEntryData("entryentity");
        dataModel.batchCreateNewEntryRow("entryentity", dimMaps.size());
        for (int i = 0; i < dimMaps.size(); ++i) {
            Map<String, String> map = dimMaps.get(i);
            String number = map.get("number");
            dataModel.setValue("number", (Object)number, i);
            dataModel.setValue("name", (Object)map.get("name"), i);
            if (!filterDimNumbers.contains(number)) continue;
            selRows.add(i);
        }
        dataModel.endInit();
        this.getView().updateView("entryentity");
        if (CollectionUtils.isNotEmpty(selRows)) {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            int[] rows = selRows.stream().mapToInt(x -> x).toArray();
            entry.selectRows(rows, 0);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opKey = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(opKey)) {
            this.setReturnDataToParent();
            this.getView().close();
        }
    }

    private void setReturnDataToParent() {
        List<String> dimNumbers = this.getEntryEntityRows();
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(dimNumbers));
    }

    private List<String> getEntryEntityRows() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        ArrayList<String> dimNumbers = new ArrayList<String>(16);
        if (rows != null) {
            IDataModel dataModel = this.getModel();
            for (int row : rows) {
                dimNumbers.add((String)dataModel.getValue("number", row));
            }
        }
        return dimNumbers;
    }
}

