/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.TemplateStatus;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.spread.template.BgTemplate;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class TemplateHelper {
    public static Set<Long> queryTemplateId(Long modelId, Long businessModelId) {
        List dataSetIdByBizModelId = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(businessModelId);
        if (CollectionUtils.isEmpty((Collection)dataSetIdByBizModelId)) {
            return new HashSet<Long>(16);
        }
        return TemplateHelper.queryTemplateId(modelId, dataSetIdByBizModelId);
    }

    public static Set<Long> queryTemplateId(Long modelId, List<Long> dataSetList) {
        HashSet<Long> result = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dataset", "in", dataSetList);
        qFilter.and("templatestatus", "!=", (Object)TemplateStatus.INTERIM.getValue());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)"id", (QFilter[])qFilter.toArray());
        if (load == null || load.length == 0) {
            return result;
        }
        for (DynamicObject dynamicObject : load) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    public static void handleOpenTemplateProcess(@NotNull DynamicObject dyna1, @NotNull IFormView view, @NotNull IFormPlugin formPlugin) {
        IFormView toshowform;
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)dyna1.getLong("id"), (String)"eb_templateentity");
        BgTemplate templateBaseInfo = new BgTemplate();
        Predicate<String> pexist = prop -> dyna.getDataEntityType().getProperties().containsKey(prop) && dyna.get(prop) != null;
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setTemplatetype(dyna.getInt("templatetype"));
        templateBaseInfo.setDataunit(StringUtils.isEmpty((String)dyna.getString("dataunit")) ? "0" : dyna.getString("dataunit"));
        templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset.id")));
        templateBaseInfo.setModelID(TemplateHelper.defaultIfNotExist(pexist, "model", 0L, () -> dyna.getDynamicObject("model").getLong("id")));
        templateBaseInfo.setCatalog(TemplateHelper.defaultIfNotExist(pexist, "templateCatalog", 0L, () -> dyna.getDynamicObject("templateCatalog").getLong("id")));
        templateBaseInfo.setStatus(dyna.getString("templatestatus"));
        templateBaseInfo.setIsReadOnly(dyna.getBoolean("isreadonly") ? "1" : "0");
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        templateBaseInfo.setFloatcalculate(dyna.getBoolean("floatcalculate") ? "1" : "0");
        templateBaseInfo.setRptReadOnly(Boolean.valueOf(dyna.getBoolean("rptreadonly")));
        DynamicObjectCollection dynamicObjectCollection = dyna.getDynamicObjectCollection("dimrelationinfo2");
        List dimRelations = dynamicObjectCollection.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        templateBaseInfo.setDimRelations(dimRelations);
        templateBaseInfo.setBizModel(DatasetServiceHelper.getInstance().queryBizmodelByDatasetId(Long.valueOf(dyna.getLong("dataset.id"))));
        templateBaseInfo.setDimMemDefaultDisplayType(dyna.getInt("dimmemdefaultdisplaytype"));
        String data = (String)dyna.get("data");
        templateBaseInfo.setVarBase((String)dyna.get("varbaseforeb"));
        kd.epm.eb.formplugin.utils.TemplateHelper.setBgTemplateRunExamineOrRuleWhenOpen(templateBaseInfo, dyna);
        IFormView mainPageView = view.getMainView();
        String pageId = view.getPageId() + templateBaseInfo.getId();
        IFormView iFormView = toshowform = mainPageView == null ? null : mainPageView.getView(pageId);
        if (toshowform == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            IFormView parentview = view.getParentView();
            if (parentview != null) {
                formShowParameter.setParentPageId(parentview.getPageId());
            }
            formShowParameter.setCustomParam("RealParentPageId", (Object)view.getPageId());
            formShowParameter.setPageId(pageId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            CloseCallBack closeCallBack = new CloseCallBack(formPlugin, "templateprocessclosecallback");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (templateBaseInfo.getTemplatetype() == 4) {
                formShowParameter.setFormId("eb_fixtemplate");
                formShowParameter.setCaption(ResManager.loadResFormat((String)"\u7f16\u8f91\u56fa\u5b9a\u6a21\u677f-%1", (String)"BgTemplateListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[]{templateBaseInfo.getName()}));
                formShowParameter.setCustomParam("spreadserial", (Object)dyna.getString("spreadserial"));
            } else {
                formShowParameter.setFormId("eb_dynamictemplate");
                formShowParameter.setCaption(ResManager.loadResFormat((String)"\u7f16\u8f91\u52a8\u6001\u6a21\u677f-%1", (String)"BgTemplateListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{templateBaseInfo.getName()}));
            }
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)templateBaseInfo.getModelID());
            formShowParameter.setCustomParam("bgtemplate_info", (Object)ObjectSerialUtil.toByteSerialized((Object)templateBaseInfo));
            formShowParameter.setCustomParam("varbaseforeb", (Object)((String)dyna.get("varbaseforeb")));
            formShowParameter.setCustomParam("TemplateModel", (Object)data);
            formShowParameter.setCustomParam("parentpageid", (Object)view.getPageId());
            formShowParameter.setCustomParam("templateid", (Object)dyna.getString("id"));
            formShowParameter.setCustomParam("template_id", (Object)dyna.getString("id"));
            formShowParameter.setCustomParam("template_number", (Object)dyna.getString("number"));
            view.showForm(formShowParameter);
        } else {
            toshowform.activate();
            view.sendFormAction(toshowform);
        }
    }

    public static <R> R defaultIfNotExist(Predicate<String> p, String prop, R defaultValue, Supplier<R> supplier) {
        if (!p.test(prop)) {
            return defaultValue;
        }
        return supplier.get();
    }
}

