/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.enums.template.FormulaTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BgTemplateFormulaSettingPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_clear"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean showEntityPageView = (Boolean)customParams.get("showEntityPageView");
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("formulatype");
        if (comboEdit != null) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            for (FormulaTypeEnum formulaTypeEnum : FormulaTypeEnum.values()) {
                if (Boolean.FALSE.equals(showEntityPageView) && formulaTypeEnum == FormulaTypeEnum.ENTITY_PAGEVIEW) continue;
                items.add(new ComboItem(new LocaleString(formulaTypeEnum.getDesc()), formulaTypeEnum.getNumber()));
            }
            comboEdit.setComboItems(items);
        }
        this.setValue(customParams, "preText");
        this.setValue(customParams, "formulaType");
    }

    private void setValue(Map<String, Object> customParams, String property) {
        Object value = customParams.get(property);
        if (value != null) {
            this.getModel().setValue(property.toLowerCase(), value);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        HashMap<String, String> retData = new HashMap<String, String>(16);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ok".equals(key)) {
            this.addRetValue(retData, "preText");
            if (this.checkPreTextLength(retData)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u7f00\u4e0d\u5f97\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            this.addRetValue(retData, "formulaType");
        } else {
            retData.put("clear", "true");
        }
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    private boolean checkPreTextLength(Map<String, String> retData) {
        String preText = retData.get("preText");
        return StringUtils.isNotEmpty((String)preText) && preText.length() > 50;
    }

    private void addRetValue(Map<String, String> retDataMap, String property) {
        Object retData = this.getModel().getValue(property.toLowerCase());
        if (retData != null && StringUtils.isNotEmpty((String)retData.toString())) {
            retDataMap.put(property, retData.toString());
        }
    }
}

