/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.metric.DefaultMetricDimMmeber;
import kd.epm.eb.spread.template.metric.IMetricDimMmeber;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;

public class DrillThroughHelper {
    protected SpreadSelector spreadSelector;
    protected IEbSpreadManager ebSpreadManager;
    protected ITemplateModel templateModel;
    protected IModelCacheHelper modelCacheHelper;
    protected Map<String, String> defaultMember = new HashMap<String, String>(16);

    public DrillThroughHelper(SpreadSelector spreadSelector, IEbSpreadManager ebSpreadManager, ITemplateModel templateModel) {
        this.spreadSelector = spreadSelector;
        this.ebSpreadManager = ebSpreadManager;
        this.templateModel = templateModel;
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
    }

    public DrillThroughHelper getTemplateModel() {
        if (this.spreadSelector == null || this.spreadSelector.getStartRow() != this.spreadSelector.getEndRow()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u884c\u7684\u8fde\u7eed\u5355\u5143\u683c\u3002", (String)"DrillThroughHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (this.spreadSelector.getStartRow() < this.ebSpreadManager.getEbook().getSheet(0).getValueAreaRowStart() || this.spreadSelector.getStartCol() < this.ebSpreadManager.getEbook().getSheet(0).getValueAreaColStart()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u6570\u503c\u7684\u5355\u5143\u683c\u3002", (String)"DrillThroughHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.clearPartition();
        this.initDimensionViews();
        this.collectSelectColdims();
        return this;
    }

    private void initDimensionViews() {
        if (this.templateModel != null && this.templateModel.getDimemsionViews() != null) {
            Map tempDimViews = this.templateModel.getDimemsionViews();
            HashMap partDimViews = new HashMap(16);
            Set<String> rowPartViewKeys = tempDimViews.keySet().stream().filter(e -> e.contains("_r")).collect(Collectors.toSet());
            Set<String> colPartViewKeys = tempDimViews.keySet().stream().filter(e -> e.contains("_c")).collect(Collectors.toSet());
            Object dimNumber = null;
            Object partNum = null;
            String partViewKey = null;
            if (rowPartViewKeys.size() > 0) {
                Map rowdims = this.ebSpreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(this.spreadSelector.getStartRow()));
                Object selectedRowPartViewKeys = null;
                if (rowdims != null && rowdims.size() > 0) {
                    for (Map.Entry entry : rowdims.entrySet()) {
                        partViewKey = (String)entry.getKey() + "_" + ((CellDimMember)entry.getValue()).getPartition();
                        if (!tempDimViews.containsKey(partViewKey)) continue;
                        if (partDimViews.get(entry.getKey()) != null && !((Long)partDimViews.get(entry.getKey())).equals(tempDimViews.get(partViewKey))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u884c\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FixDrillThroughHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        partDimViews.put(entry.getKey(), tempDimViews.get(partViewKey));
                    }
                }
                rowPartViewKeys.forEach(e -> {
                    Long cfr_ignored_0 = (Long)tempDimViews.remove(e);
                });
            }
            if (colPartViewKeys.size() > 0) {
                int maxcol = this.spreadSelector.getEndCol();
                for (int col = this.spreadSelector.getStartCol(); col <= maxcol; ++col) {
                    Map coldims = this.ebSpreadManager.getColpartitionDimMemsByCol(Integer.valueOf(col));
                    if (coldims == null || coldims.size() <= 0) continue;
                    for (Map.Entry entry : coldims.entrySet()) {
                        partViewKey = (String)entry.getKey() + "_" + ((CellDimMember)entry.getValue()).getPartition();
                        if (!tempDimViews.containsKey(partViewKey)) continue;
                        if (partDimViews.get(entry.getKey()) != null && !((Long)partDimViews.get(entry.getKey())).equals(tempDimViews.get(partViewKey))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u884c\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FixDrillThroughHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        partDimViews.put(entry.getKey(), tempDimViews.get(partViewKey));
                    }
                }
                colPartViewKeys.forEach(e -> {
                    Long cfr_ignored_0 = (Long)tempDimViews.remove(e);
                });
            }
            tempDimViews.putAll(partDimViews);
        }
    }

    private void collectSelectColdims() {
        int maxcol = this.spreadSelector.getEndCol();
        for (int col = this.spreadSelector.getStartCol(); col <= maxcol; ++col) {
            Map coldims = this.ebSpreadManager.getColpartitionDimMemsByCol(Integer.valueOf(col));
            if (coldims == null || coldims.size() <= 0) continue;
            RowColPartition colPartition = new RowColPartition();
            for (Map.Entry coldimentry : coldims.entrySet()) {
                if (coldimentry.getValue() instanceof MetricCellDimMember) {
                    MetricCellDimMember metricCellDimMember = (MetricCellDimMember)coldimentry.getValue();
                    Member member_temp = this.modelCacheHelper.getMember((String)coldimentry.getKey(), (Long)this.templateModel.getDimemsionViews().get(coldimentry.getKey()), ((CellDimMember)coldimentry.getValue()).getDimMemberNumber());
                    DefaultMetricDimMmeber metricDimMember = new DefaultMetricDimMmeber();
                    metricDimMember.setName(member_temp.getName());
                    metricDimMember.setNumber(metricCellDimMember.getDimMemberNumber());
                    metricDimMember.setDecimalnum(metricCellDimMember.getDecimalnum());
                    metricDimMember.setSign(metricCellDimMember.getSign());
                    colPartition.setMetricDimMmebers((List)Lists.newArrayList((Object[])new IMetricDimMmeber[]{metricDimMember}));
                    continue;
                }
                Member member = this.modelCacheHelper.getMember((String)coldimentry.getKey(), (Long)this.templateModel.getDimemsionViews().get(coldimentry.getKey()), ((CellDimMember)coldimentry.getValue()).getDimMemberNumber());
                if (member == null) continue;
                DefaultRowColDimensionEntry colDimensionEntry = new DefaultRowColDimensionEntry();
                DefaultDimension dimension = new DefaultDimension();
                dimension.setNumber((String)coldimentry.getKey());
                dimension.setName(this.modelCacheHelper.getDimension((String)coldimentry.getKey()).getName());
                colDimensionEntry.setDimension((IDimension)dimension);
                DefaultDimMember dimensionMember = new DefaultDimMember();
                dimensionMember.setNumber(((CellDimMember)coldimentry.getValue()).getDimMemberNumber());
                dimensionMember.setName(member.getName());
                dimensionMember.setScope(10);
                colDimensionEntry.addOneMember((IDimensionMember)dimensionMember);
                colPartition.addOneRowColDimensionEntry((IRowColDimensionEntry)colDimensionEntry);
            }
            this.templateModel.getPartitionSetting().getColPartition().add(colPartition);
        }
    }

    private Map<String, CellDimMember> getColpartitionDimMemsByCol(int col) {
        if (this.templateModel == null || this.ebSpreadManager == null) {
            return null;
        }
        int templateType = this.templateModel.getTemplateBaseInfo().getTemplatetype();
        if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(String.valueOf(templateType))) {
            return this.ebSpreadManager.getColpartitionDimMemsByCol(Integer.valueOf(col));
        }
        if (BgTemplateTypeEnum.EBFIX.getNumber().equals(String.valueOf(templateType))) {
            // empty if block
        }
        return null;
    }

    private void clearPartition() {
        this.templateModel.getPartitionSetting().getPartitionInfo().setStartposition("A1");
        this.templateModel.getPartitionSetting().setRowPartition(new ArrayList(16));
        this.templateModel.getPartitionSetting().setColPartition(new ArrayList(16));
    }

    public DrillThroughHelper transforRowDimIntoPageDim() {
        Map rowdims = this.ebSpreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(this.spreadSelector.getStartRow()));
        for (Map.Entry rowdimentry : rowdims.entrySet()) {
            if (rowdimentry.getValue() instanceof MetricCellDimMember) {
                this.addMetricIntoRowPartition((MetricCellDimMember)rowdimentry.getValue());
                continue;
            }
            DefaultPageDimensionEntry pageDimEntry = new DefaultPageDimensionEntry();
            Dimension dimension_temp = this.modelCacheHelper.getDimension((String)rowdimentry.getKey());
            DefaultDimension dimension = new DefaultDimension();
            dimension.setName(dimension_temp.getName());
            dimension.setNumber(dimension_temp.getNumber());
            pageDimEntry.setDimension((IDimension)dimension);
            Set memnums = (Set)this.ebSpreadManager.getAlldimensionWithMembers().get(dimension.getNumber());
            for (String memnum : memnums) {
                Member member_temp = this.modelCacheHelper.getMember((String)rowdimentry.getKey(), (Long)this.templateModel.getDimemsionViews().get(rowdimentry.getKey()), memnum);
                if (member_temp == null) continue;
                DefaultDimMember dimensionMember = new DefaultDimMember();
                dimensionMember.setScope(10);
                dimensionMember.setName(member_temp.getName());
                dimensionMember.setNumber(member_temp.getNumber());
                pageDimEntry.addOneMember((IDimensionMember)dimensionMember);
            }
            this.templateModel.getPagemembentry().add(pageDimEntry);
            this.defaultMember.put(dimension.getNumber(), ((CellDimMember)rowdimentry.getValue()).getDimMemberNumber());
        }
        return this;
    }

    private void addMetricIntoRowPartition(MetricCellDimMember value) {
        RowColPartition rowpartition = new RowColPartition();
        DefaultMetricDimMmeber metricDimMmeber = new DefaultMetricDimMmeber();
        metricDimMmeber.setNumber(value.getDimMemberNumber());
        metricDimMmeber.setSign(value.getSign());
        metricDimMmeber.setDecimalnum(value.getDecimalnum());
        metricDimMmeber.setScope(10);
        metricDimMmeber.setName(this.modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, value.getDimMemberNumber()).getName());
        rowpartition.setMetricDimMmebers((List)Lists.newArrayList((Object[])new IMetricDimMmeber[]{metricDimMmeber}));
        this.templateModel.getPartitionSetting().setRowPartition((List)Lists.newArrayList((Object[])new RowColPartition[]{rowpartition}));
    }

    public DrillThroughHelper initPageDimFilter(IFormView view) {
        return this;
    }

    public ITemplateModel collect() {
        return this.templateModel;
    }

    public Map<String, String> getDefaultMember() {
        return this.defaultMember;
    }
}

