/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.metric.DefaultMetricDimMmeber;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.DefaultPartitionSetting;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.partition.PartitionInfo;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;

public class FixDrillThroughHelper {
    private static final Set<String> hidedims = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber()});
    private SpreadSelector spreadSelector;
    private ITemplateModel templateModel;
    private IEbSpreadManager spreadManager;
    private ITemplateModel dynamic_templateModel;
    private Map<String, String> defaultMember = new HashMap<String, String>(16);
    private boolean isEntityInPage = false;
    private IModelCacheHelper modelCacheHelper = null;
    Set<MultiAreaManager> multiAreaManagers = new HashSet<MultiAreaManager>(16);

    public FixDrillThroughHelper(SpreadSelector spreadSelector, ITemplateModel templateModel, IEbSpreadManager spreadManager) {
        this.spreadSelector = spreadSelector;
        this.templateModel = templateModel;
        this.spreadManager = spreadManager;
    }

    public FixDrillThroughHelper getTemplateModel() {
        if (this.spreadSelector == null || this.spreadSelector.getStartRow() != this.spreadSelector.getEndRow()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u884c\u7684\u8fde\u7eed\u5355\u5143\u683c\u3002", (String)"FixDrillThroughHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (int col = this.spreadSelector.getStartCol(); col <= this.spreadSelector.getEndCol(); ++col) {
            AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(this.spreadSelector.getStartRow(), col);
            if (areaInfo == null) continue;
            this.multiAreaManagers.add(areaInfo.getMultiAreaManager());
        }
        if (this.multiAreaManagers.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5305\u542b\u591a\u4e2a\u4e0d\u540c\u7684\u6570\u636e\u533a\u57df\u3002", (String)"FixDrillThroughHelper_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (MultiAreaManager multiAreaManager : this.multiAreaManagers) {
            List rowdims = multiAreaManager.getRowpartitionDims();
            List coldims = multiAreaManager.getColpartitionDims();
            if ((rowdims == null || rowdims.size() != 1 || !SysDimensionEnum.Metric.getNumber().equals(rowdims.get(0))) && (coldims == null || coldims.size() != 1 || !SysDimensionEnum.Metric.getNumber().equals(coldims.get(0)))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u533a\u57df\u7684\u884c\u7ef4\u6216\u5217\u7ef4\u4ec5\u8bbe\u7f6e\u4e86\u5ea6\u91cf\u7ef4\u5ea6\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u5206\u6790\u3002", (String)"FixDrillThroughHelper_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.dynamic_templateModel = TemplateFactory.buildTemplateModel();
        this.initPartitionInfo(this.dynamic_templateModel);
        this.initBgTemplate(this.dynamic_templateModel);
        this.initDimensionViews();
        this.initViewDimension(this.dynamic_templateModel);
        this.initPageDimension(this.dynamic_templateModel);
        this.initRowColDims();
        return this;
    }

    private void initDimensionViews() {
        if (this.templateModel != null && this.templateModel.getDimemsionViews() != null && this.multiAreaManagers.size() > 0) {
            HashMap partDimViews = new HashMap(16);
            String[] partViewKey = null;
            for (MultiAreaManager multiAreaManager : this.multiAreaManagers) {
                for (Map.Entry entry : this.templateModel.getDimemsionViews().entrySet()) {
                    if (((String)entry.getKey()).contains("_")) {
                        partViewKey = ((String)entry.getKey()).split("_");
                        String dimNumber = partViewKey[0];
                        String partNumber = partViewKey[1];
                        if (!partNumber.equals(multiAreaManager.getAreaIndex())) continue;
                        if (partDimViews.get(dimNumber) != null && !((Long)partDimViews.get(dimNumber)).equals(entry.getValue())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u884c\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FixDrillThroughHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        partDimViews.put(dimNumber, entry.getValue());
                        continue;
                    }
                    this.dynamic_templateModel.getDimemsionViews().put(entry.getKey(), entry.getValue());
                }
            }
            this.dynamic_templateModel.getDimemsionViews().putAll(partDimViews);
        }
    }

    public FixDrillThroughHelper initEntityFilter(QFilter entityqfilter) {
        for (IPageDimensionEntry iPageDimensionEntry : this.dynamic_templateModel.getPagemembentry()) {
            String dimnumber = iPageDimensionEntry.getDimension().getNumber();
            if (!"Entity".equals(dimnumber)) continue;
            iPageDimensionEntry.setMembers(new ArrayList(16));
            ArrayList qfilters = Lists.newArrayList((Object[])new QFilter[]{entityqfilter});
            if (qfilters == null) {
                return this;
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_entitymembertree", (String)"name, number", (QFilter[])qfilters.toArray(new QFilter[0]), null);
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    DefaultDimMember dimensionMember = new DefaultDimMember();
                    dimensionMember.setName(row.getString("name"));
                    dimensionMember.setNumber(row.getString("number"));
                    dimensionMember.setScope(10);
                    iPageDimensionEntry.addOneMember((IDimensionMember)dimensionMember);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return this;
    }

    public FixDrillThroughHelper initDefaultPageDimMember(IFormView formView) {
        for (IPageDimensionEntry pageDimensionEntry : this.dynamic_templateModel.getPagemembentry()) {
            String dimnumber = pageDimensionEntry.getDimension().getNumber();
            String f7key = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber).toLowerCase();
            Object value = null;
            try {
                value = ((Set)this.spreadManager.getAlldimensionWithMembers().get(dimnumber)).iterator().next();
            }
            catch (Exception e) {
                try {
                    value = formView.getModel().getValue(f7key);
                }
                catch (Exception e2) {
                    value = ((IDimensionMember)pageDimensionEntry.getMembers().get(0)).getNumber();
                }
            }
            if (value instanceof DynamicObject) {
                this.defaultMember.putIfAbsent(dimnumber, ((DynamicObject)value).getString("number"));
                continue;
            }
            if (!(value instanceof String)) continue;
            this.defaultMember.putIfAbsent(dimnumber, (String)value);
        }
        return this;
    }

    public ITemplateModel collect() {
        return this.dynamic_templateModel;
    }

    private void initPartitionInfo(ITemplateModel dynamic_templateModel) {
        DefaultPartitionSetting partitionSetting = new DefaultPartitionSetting();
        PartitionInfo partitionInfo = new PartitionInfo();
        partitionInfo.setStartposition("A1");
        partitionSetting.setPartitionInfo(partitionInfo);
        dynamic_templateModel.setPartitionSetting((IPartitionSetting)partitionSetting);
    }

    private void initRowColDims() {
        IMultiAreaSetting this_areaRangeEntry = null;
        int arearowstart = 0;
        int areacolstart = 0;
        int arearowend = 0;
        int areacolend = 0;
        AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(this.spreadSelector.getStartRow(), this.spreadSelector.getStartCol());
        if (areaInfo != null && areaInfo.getMultiAreaManager() != null) {
            String areaIndex = areaInfo.getMultiAreaManager().getAreaIndex();
            for (IMultiAreaSetting multiAreaSetting : this.templateModel.getAreaRanges()) {
                if (!multiAreaSetting.getAreaRange().split(":")[0].equals(areaIndex)) continue;
                this_areaRangeEntry = multiAreaSetting;
                arearowstart = areaInfo.getMultiAreaManager().getAreaRange().getY_start();
                arearowend = areaInfo.getMultiAreaManager().getAreaRange().getY_end();
                areacolstart = areaInfo.getMultiAreaManager().getAreaRange().getX_start();
                areacolend = areaInfo.getMultiAreaManager().getAreaRange().getX_end();
                break;
            }
        }
        if (this_areaRangeEntry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u6570\u503c\u7684\u5355\u5143\u683c\u3002", (String)"FixDrillThroughHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        LinkedHashSet<String> rowdimnumbers = new LinkedHashSet<String>();
        for (String rowDim : this_areaRangeEntry.getRowdims()) {
            if (!rowDim.equals(SysDimensionEnum.Metric.getNumber())) {
                rowdimnumbers.add(rowDim);
                continue;
            }
            this.setMetric(rowdimnumbers, rowDim);
        }
        this.putRowdimIntoPageEntry(arearowstart, arearowend, this.spreadSelector.getStartCol(), this.spreadSelector.getEndCol(), rowdimnumbers, this.spreadManager.getDimemsionViews(), areaInfo.getMultiAreaManager().getAreaIndex());
        this.putRowdimIntoRowPartition();
        this.getDefaultRowDimMembers(rowdimnumbers);
        LinkedHashSet<String> coldimnumbers = new LinkedHashSet<String>(this_areaRangeEntry.getColdims().size());
        for (String colDim : this_areaRangeEntry.getColdims()) {
            coldimnumbers.add(colDim);
        }
        if (coldimnumbers.contains(SysDimensionEnum.Metric.getNumber())) {
            this.dynamic_templateModel.getAreaRangeEntry().setMetricInRow(Boolean.FALSE);
            ((RowColPartition)this.dynamic_templateModel.getPartitionSetting().getRowPartition().get(0)).getMetricDimMmebers().clear();
        }
        this.putColdimIntoColpartition(coldimnumbers);
    }

    protected void setMetric(Set<String> rowdimnumbers, String rowDim) {
        this.dynamic_templateModel.getAreaRangeEntry().setMetricInRow(Boolean.TRUE);
    }

    protected void putRowdimIntoPageEntry(int arearowstart, int arearowend, int startcol, int endCol, Set<String> rowdimnumbers, Map<String, Long> dimensionViews, String areaIndex) {
        HashMap<String, Set<String>> dimmembers = new HashMap<String, Set<String>>(16);
        this.getRowDimnumberFromCell(dimmembers, arearowstart, arearowend, startcol, endCol, rowdimnumbers);
        dimmembers.forEach((dimnumber, numbers) -> {
            DefaultPageDimensionEntry pageDim = new DefaultPageDimensionEntry();
            DefaultDimension dimension = new DefaultDimension();
            dimension.setNumber(dimnumber);
            dimension.setName(this.getModelCacheHelper().getDimension(dimnumber).getName());
            pageDim.setDimension((IDimension)dimension);
            Long viewId = DimensionViewServiceHelper.getViewId((Map)dimensionViews, (String)dimnumber, (String)areaIndex);
            for (String number : numbers) {
                Member member = this.getModelCacheHelper().getMember(dimnumber, viewId, number);
                if (member == null) continue;
                DefaultDimMember dimmember = new DefaultDimMember();
                dimmember.setName(member.getName());
                dimmember.setNumber(number);
                dimmember.setScope(10);
                pageDim.addOneMember((IDimensionMember)dimmember);
            }
            this.dynamic_templateModel.addPagemembentry((IPageDimensionEntry)pageDim);
        });
    }

    private void getRowDimnumberFromCell(Map<String, Set<String>> dimmembers, int arearowstart, int arearowend, int startcol, int endCol, Set<String> rowdimnumbers) {
        for (int i = arearowstart; i <= arearowend; ++i) {
            Map areaPageViewDims;
            AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(i, endCol);
            if (areaInfo == null || i < areaInfo.getRow_start() || areaInfo.getRelativerow() < 0) continue;
            Map dimMemberMap = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow());
            if (dimMemberMap != null) {
                for (Map.Entry entry : dimMemberMap.entrySet()) {
                    String dimnumber = (String)entry.getKey();
                    if (!rowdimnumbers.contains(dimnumber) || entry.getValue() == null) continue;
                    Set<String> members_temp = dimmembers.get(dimnumber);
                    if (members_temp == null) {
                        members_temp = new HashSet<String>(16);
                        dimmembers.put(dimnumber, members_temp);
                    }
                    members_temp.add(((CellDimMember)entry.getValue()).getDimMemberNumber());
                }
            }
            if ((areaPageViewDims = areaInfo.getMultiAreaManager().getAreaPageViewDims()) == null) continue;
            for (Map.Entry entry : areaPageViewDims.entrySet()) {
                String dimnumber = (String)entry.getKey();
                Set<String> members_temp = dimmembers.get(dimnumber);
                if (members_temp == null) {
                    members_temp = new HashSet<String>(16);
                    dimmembers.put(dimnumber, members_temp);
                }
                members_temp.add(((PageViewDimMember)entry.getValue()).getNumber());
            }
        }
        if (--endCol >= startcol && dimmembers.size() == 0) {
            this.getRowDimnumberFromCell(dimmembers, arearowstart, arearowend, startcol, endCol, rowdimnumbers);
        }
    }

    private void putRowdimIntoRowPartition() {
        RowColPartition rowPartition = new RowColPartition();
        if (this.dynamic_templateModel.getPartitionSetting().getRowPartition().size() > 0) {
            rowPartition = (RowColPartition)this.dynamic_templateModel.getPartitionSetting().getRowPartition().get(0);
        } else {
            this.dynamic_templateModel.getPartitionSetting().getRowPartition().add(rowPartition);
        }
        for (int col = this.spreadSelector.getStartCol(); col <= this.spreadSelector.getEndCol(); ++col) {
            int row = this.spreadSelector.getStartRow();
            AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(row, col);
            Map dimemsionViews = this.spreadManager.getDimemsionViews();
            if (areaInfo == null || col < areaInfo.getCol_start() || areaInfo.getRelativerow() < 0) continue;
            Map dimMemberMap = null;
            dimMemberMap = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow());
            if (dimMemberMap == null) continue;
            for (Map.Entry entry : dimMemberMap.entrySet()) {
                String dimnumber = (String)entry.getKey();
                Long viewId = DimensionViewServiceHelper.getViewId((Map)dimemsionViews, (String)dimnumber, (String)areaInfo.getMultiAreaManager().getAreaIndex());
                Member member_cache = this.getModelCacheHelper().getMember(dimnumber, viewId, ((CellDimMember)entry.getValue()).getDimMemberNumber());
                Dimension dimension_cache = this.getModelCacheHelper().getDimension(dimnumber);
                if (member_cache == null || dimension_cache == null) continue;
                if (SysDimensionEnum.Metric.getNumber().equals(dimnumber) && rowPartition.getMetricDimMmebers().isEmpty()) {
                    Member member = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, ((CellDimMember)entry.getValue()).getDimMemberNumber());
                    if (member == null) continue;
                    DefaultMetricDimMmeber metricDimMmeber = new DefaultMetricDimMmeber();
                    metricDimMmeber.setName(member.getName());
                    metricDimMmeber.setNumber(member.getNumber());
                    rowPartition.getMetricDimMmebers().add(metricDimMmeber);
                    continue;
                }
                DefaultRowColDimensionEntry colDimensionEntry = new DefaultRowColDimensionEntry();
                DefaultDimension dimension = new DefaultDimension();
                dimension.setNumber(dimension_cache.getNumber());
                dimension.setName(dimension_cache.getName());
                colDimensionEntry.setDimension((IDimension)dimension);
                DefaultDimMember dimensionMember = new DefaultDimMember();
                dimensionMember.setName(member_cache.getName());
                dimensionMember.setNumber(member_cache.getNumber());
                colDimensionEntry.setMembers((List)Lists.newArrayList((Object[])new IDimensionMember[]{dimensionMember}));
                rowPartition.addOneRowColDimensionEntry((IRowColDimensionEntry)colDimensionEntry);
            }
        }
    }

    private void putColdimIntoColpartition(Set<String> coldimnumbers) {
        ArrayList<RowColPartition> colPartitions = new ArrayList<RowColPartition>(16);
        for (int col = this.spreadSelector.getStartCol(); col <= this.spreadSelector.getEndCol(); ++col) {
            int row = this.spreadSelector.getStartRow();
            AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(row, col);
            if (areaInfo == null || col < areaInfo.getCol_start() || areaInfo.getRelativerow() < 0) continue;
            Map dimMemberMap = null;
            dimMemberMap = areaInfo.getMultiAreaManager().getColpartitionDimMemsByCol(areaInfo.getRelativecol());
            if (dimMemberMap == null) continue;
            RowColPartition colPartition = new RowColPartition();
            for (Map.Entry entry : dimMemberMap.entrySet()) {
                for (String coldimnumber : coldimnumbers) {
                    if (!coldimnumber.equals(entry.getKey())) continue;
                    Map dimemsionViews = this.spreadManager.getDimemsionViews();
                    Long viewId = DimensionViewServiceHelper.getViewId((Map)dimemsionViews, (String)coldimnumber, (String)areaInfo.getMultiAreaManager().getAreaIndex());
                    Member member_cache = this.getModelCacheHelper().getMember(coldimnumber, viewId, ((CellDimMember)entry.getValue()).getDimMemberNumber());
                    Dimension dimension_cache = this.getModelCacheHelper().getDimension(coldimnumber);
                    if (member_cache == null || dimension_cache == null) continue;
                    if (coldimnumber.equals(SysDimensionEnum.Metric.getNumber())) {
                        DefaultMetricDimMmeber metricDimMmeber = new DefaultMetricDimMmeber();
                        metricDimMmeber.setName(member_cache.getName());
                        metricDimMmeber.setNumber(member_cache.getNumber());
                        colPartition.getMetricDimMmebers().add(metricDimMmeber);
                        continue;
                    }
                    DefaultRowColDimensionEntry colDimensionEntry = new DefaultRowColDimensionEntry();
                    DefaultDimension dimension = new DefaultDimension();
                    dimension.setNumber(dimension_cache.getNumber());
                    dimension.setName(dimension_cache.getName());
                    colDimensionEntry.setDimension((IDimension)dimension);
                    DefaultDimMember dimensionMember = new DefaultDimMember();
                    dimensionMember.setName(member_cache.getName());
                    dimensionMember.setNumber(member_cache.getNumber());
                    colDimensionEntry.setMembers((List)Lists.newArrayList((Object[])new IDimensionMember[]{dimensionMember}));
                    colPartition.addOneRowColDimensionEntry((IRowColDimensionEntry)colDimensionEntry);
                }
            }
            if (colPartition.getRowColDimensionEntries() == null || colPartition.getRowColDimensionEntries().isEmpty()) continue;
            colPartitions.add(colPartition);
        }
        if (colPartitions.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5217\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FixDrillThroughHelper_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.dynamic_templateModel.getPartitionSetting().getColPartition().addAll(colPartitions);
    }

    private void getDefaultRowDimMembers(Set<String> rowdimnumbers) {
        boolean find = false;
        for (int col = this.spreadSelector.getStartCol(); col <= this.spreadSelector.getEndCol(); ++col) {
            Map dimMemberMap;
            int row = this.spreadSelector.getStartRow();
            AreaInfo areaInfo = this.spreadManager.getAreaInfoByRowCol(row, col);
            if (areaInfo == null || row < areaInfo.getRow_start() || areaInfo.getRelativerow() < 0 || (dimMemberMap = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow())) == null) continue;
            for (Map.Entry entry : dimMemberMap.entrySet()) {
                if (!rowdimnumbers.contains(entry.getKey())) continue;
                this.defaultMember.put((String)entry.getKey(), ((CellDimMember)entry.getValue()).getDimMemberNumber());
                find = true;
            }
            if (find) break;
        }
        if (!find) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u884c\u65e0\u6709\u6548\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u6570\u503c\u7684\u884c\u3002", (String)"FixDrillThroughHelper_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void initPageDimension(ITemplateModel dynamic_templateModel) {
        for (IPageDimensionEntry pageDimEntry : this.templateModel.getPagemembentry()) {
            DefaultPageDimensionEntry pageDim = new DefaultPageDimensionEntry();
            DefaultDimension dimension = new DefaultDimension();
            dimension.setNumber(pageDimEntry.getDimension().getNumber());
            dimension.setName(this.getModelCacheHelper().getDimension(pageDimEntry.getDimension().getNumber()).getName());
            pageDim.setDimension((IDimension)dimension);
            for (IDimensionMember member : pageDimEntry.getMembers()) {
                DefaultDimMember dimmember = new DefaultDimMember();
                dimmember.setName(member.getName());
                dimmember.setNumber(member.getNumber());
                dimmember.setScope(member.getScope());
                pageDim.addOneMember((IDimensionMember)dimmember);
            }
            dynamic_templateModel.addPagemembentry((IPageDimensionEntry)pageDim);
            if (!dimension.getNumber().equals(SysDimensionEnum.Entity.getNumber())) continue;
            this.isEntityInPage = true;
        }
    }

    private void initViewDimension(ITemplateModel dynamic_templateModel) {
        for (IViewPointDimensionEntry viewDimEntry : this.templateModel.getViewpointmembentry()) {
            DefaultViewPointDimensionEntry viewpoint = new DefaultViewPointDimensionEntry();
            DefaultDimension dimension = new DefaultDimension();
            dimension.setNumber(viewDimEntry.getDimension().getNumber());
            dimension.setName(viewDimEntry.getDimension().getName());
            viewpoint.setDimension((IDimension)dimension);
            DefaultDimMember dimmember = new DefaultDimMember();
            dimmember.setName(viewDimEntry.getMember().getName());
            dimmember.setNumber(viewDimEntry.getMember().getNumber());
            dimmember.setScope(viewDimEntry.getMember().getScope());
            viewpoint.setMember((IDimensionMember)dimmember);
            if (hidedims.contains(viewDimEntry.getDimension().getNumber())) {
                dynamic_templateModel.addHidedimentry((IViewPointDimensionEntry)viewpoint);
                continue;
            }
            dynamic_templateModel.addViewpointmembentry((IViewPointDimensionEntry)viewpoint);
            this.defaultMember.put(dimension.getNumber(), dimmember.getNumber());
        }
    }

    private void initBgTemplate(ITemplateModel dynamic_templateModel) {
        dynamic_templateModel.setTemplateBaseInfo(this.templateModel.getTemplateBaseInfo());
        dynamic_templateModel.setMetricCellStyleInfo(this.templateModel.getMetricCellStyleInfo());
    }

    public Map<String, String> getDefaultMember() {
        return this.defaultMember;
    }

    public boolean isEntityInPage() {
        return this.isEntityInPage;
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.templateModel.getModelId());
        }
        return this.modelCacheHelper;
    }
}

