/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.template.TitleSplitTypeEnum;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.SpreadAreaUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.spread.template.afix.multisetting.FixTemplateDynTitle;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FixTemplateDynamicTitlePlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String SPLIT_MARK = ":";

    public void afterCreateNewData(EventObject e) {
        this.setDefaultData();
        this.clearCache();
    }

    private void clearCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put("pageid", this.getView().getPageId());
            pageCache.put("selectRows", "");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        block6: {
            Object oldValue;
            Object newValue;
            DynamicObject rowEntity;
            int rowIndex;
            String name;
            block7: {
                block5: {
                    name = e.getProperty().getName();
                    rowIndex = e.getChangeSet()[0].getRowIndex();
                    rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                    newValue = e.getChangeSet()[0].getNewValue();
                    oldValue = e.getChangeSet()[0].getOldValue();
                    if (!"dimension".equals(name)) break block5;
                    if (newValue == null) {
                        return;
                    }
                    String currentTitleRange = rowEntity.getString("titleRange");
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        if (rowIndex == i) continue;
                        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                        String dimension = dynamicObject.getString("dimension");
                        String titleRange = dynamicObject.getString("titlerange");
                        if (!Objects.equals(dimension, newValue) || !StringUtils.equals((CharSequence)currentTitleRange, (CharSequence)titleRange) || StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{currentTitleRange, titleRange})) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u52a8\u6001\u5217\u533a\u57df\u53d6\u503c\u5217\u7ef4\u5ea6\u4e0d\u80fd\u91cd\u590d", (String)"FixTemplateDynamicTitlePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("dimension", oldValue, rowIndex);
                        return;
                    }
                    break block6;
                }
                if (!"splittype".equals(name)) break block7;
                if (newValue != null && !Objects.equals(TitleSplitTypeEnum.NONE.getType(), newValue)) break block6;
                this.getModel().setValue("splitcount", null, rowIndex);
                break block6;
            }
            if ("titlerange".equals(name)) {
                if (newValue == null) {
                    return;
                }
                String currentDimension = rowEntity.getString("dimension");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    if (rowIndex == i) continue;
                    String titleRange = dynamicObject.getString("titlerange");
                    String dimension = dynamicObject.getString("dimension");
                    if (!Objects.equals(titleRange, newValue) || !StringUtils.equals((CharSequence)currentDimension, (CharSequence)dimension) || StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{currentDimension, dimension})) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u52a8\u6001\u5217\u533a\u57df\u53d6\u503c\u5217\u7ef4\u5ea6\u4e0d\u80fd\u91cd\u590d", (String)"FixTemplateDynamicTitlePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("titlerange", oldValue, rowIndex);
                    return;
                }
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                String titleRange = dynamicObject.getString("titlerange");
                String dimension = dynamicObject.getString("dimension");
                String splitType = dynamicObject.getString("splittype");
                if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{titleRange, dimension, splitType})) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6309\u8981\u6c42\u586b\u5199\u597d\u52a8\u6001\u5217\u8bbe\u7f6e", (String)"FixTemplateDynamicTitlePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key) && this.validate()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<FixTemplateDynTitle> fixTemplateDynTitles = new ArrayList<FixTemplateDynTitle>(entryEntity.size());
            String areaRange = (String)this.getView().getFormShowParameter().getCustomParam("areaRange");
            String[] split = areaRange.split(SPLIT_MARK);
            Point point = ExcelUtils.pos2Point((String)split[0]);
            for (DynamicObject dynamicObject : entryEntity) {
                FixTemplateDynTitle fixTemplateDynTitle = new FixTemplateDynTitle();
                String titleRange = dynamicObject.getString("titlerange");
                String[] strings = titleRange.split(SPLIT_MARK);
                Point startPoint = ExcelUtils.pos2Point((String)strings[0]);
                Point endPoint = ExcelUtils.pos2Point((String)strings[1]);
                fixTemplateDynTitle.setTitleStartPosition(startPoint.x - point.x + SPLIT_MARK + (startPoint.y - point.y));
                fixTemplateDynTitle.setTitleEndPosition(endPoint.x - point.x + SPLIT_MARK + (endPoint.y - point.y));
                fixTemplateDynTitle.setTitleRange(titleRange);
                fixTemplateDynTitle.setTitlePrefix(dynamicObject.getString("prefix"));
                fixTemplateDynTitle.setTitleDimension(dynamicObject.getString("dimension"));
                fixTemplateDynTitle.setTitleSplitType(dynamicObject.getString("splittype"));
                fixTemplateDynTitle.setTitleSplitCount(dynamicObject.getInt("splitcount"));
                fixTemplateDynTitle.setTitleSuffix(dynamicObject.getString("suffix"));
                fixTemplateDynTitles.add(fixTemplateDynTitle);
            }
            this.getView().returnDataToParent(fixTemplateDynTitles);
            this.getView().close();
        }
    }

    private boolean validate() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object rowHeaderSize = customParams.get("rowHeaderSize");
        Object startPosition = customParams.get("startPosition");
        Object areaRange = customParams.get("areaRange");
        if (startPosition == null || areaRange == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570areaRange\u5f02\u5e38", (String)"FixTemplateDynamicTitlePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String[] areaSplit = String.valueOf(areaRange).split(SPLIT_MARK);
        String[] positionSplit = String.valueOf(startPosition).split(SPLIT_MARK);
        if (areaSplit.length != 2 || positionSplit.length != 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570areaRange\u5f02\u5e38", (String)"FixTemplateDynamicTitlePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String mixRowIndex = areaSplit[0].replaceAll("[a-zA-Z]", "");
        String maxColumnIndex = areaSplit[1].replaceAll("[^a-zA-Z]", "");
        String rowPosition = positionSplit[1];
        int maxRowIndex = Integer.parseInt(mixRowIndex) + Integer.parseInt(rowPosition) - 1;
        Point point = ExcelUtils.pos2Point((String)areaSplit[0]);
        String validPosition = ExcelUtils.xy2Pos((int)(point.x + Integer.parseInt(String.valueOf(rowHeaderSize)) + Integer.parseInt(positionSplit[0])), (int)point.y) + SPLIT_MARK + maxColumnIndex + maxRowIndex;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            String titleRange = dynamicObject.getString("titlerange");
            if (FixTemplateProcessHelper.validateArea(titleRange) && SpreadAreaUtil.isInArea((String)titleRange, (String)validPosition)) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165%1\u5185\u7684\u6709\u6548\u533a\u57df", (String)"FixTemplateDynamicTitlePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{validPosition}));
            return false;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String titleRange = ((DynamicObject)entryEntity.get(i)).getString("titlerange");
            for (int j = i + 1; j < entryEntity.size(); ++j) {
                String validRange = ((DynamicObject)entryEntity.get(j)).getString("titlerange");
                if (!ExcelUtils.isOverlap((String)titleRange, (String)validRange) || StringUtils.equals((CharSequence)titleRange, (CharSequence)validRange)) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u52a8\u6001\u6807\u9898\u5217\u533a\u57df%1\u4e0e%2\u5b58\u5728\u91cd\u53e0\u7684\u533a\u57df\u3002", (String)"FixTemplateDynamicTitlePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{titleRange, validRange}));
                return false;
            }
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
    }

    @Override
    public Long getModelId() {
        String model = this.getPageCache().get("model");
        if (StringUtils.isNotEmpty((CharSequence)model)) {
            return IDUtils.toLong((Object)model);
        }
        Object customParam = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        return IDUtils.toLong((Object)customParam);
    }

    private void setDefaultData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            Object modelObj = customParams.get("KEY_MODEL_ID");
            Long modelId = IDUtils.toLong(modelObj);
            if (!IDUtils.isNotNull((Long)modelId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff1a\u4f53\u7cfb\u4e3a\u7a7a\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FixTemplateDynamicTitlePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanel", "btnok"});
                return;
            }
            this.getPageCache().put("model", String.valueOf(modelObj));
            Object coldims = customParams.get("coldims");
            if (coldims == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff1a\u5217\u7ef4\u5ea6\u4fe1\u606f\u4e3a\u7a7a\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FixTemplateDynamicTitlePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanel", "btnok"});
                return;
            }
            this.buildDimensionItem((List)SerializationUtils.deSerializeFromBase64((String)String.valueOf(coldims)));
            Object rowHeaderSize = customParams.get("rowHeaderSize");
            if (rowHeaderSize == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff1a\u884c\u6807\u9898\u4fe1\u606f\u4e3a\u7a7a\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FixTemplateDynamicTitlePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanel", "btnok"});
                return;
            }
            Object dynamicTitle = customParams.get("dynamicTitle");
            if (dynamicTitle != null) {
                List fixTemplateDynTitles = (List)SerializationUtils.deSerializeFromBase64((String)String.valueOf(dynamicTitle));
                if (CollectionUtils.isEmpty((Collection)fixTemplateDynTitles)) {
                    return;
                }
                this.getModel().beginInit();
                int[] entryentities = this.getModel().batchCreateNewEntryRow("entryentity", fixTemplateDynTitles.size());
                this.getModel().endInit();
                Object areaRange = customParams.get("areaRange");
                String[] areaSplit = String.valueOf(areaRange).split(SPLIT_MARK);
                String areaStart = areaSplit[0];
                Point point = ExcelUtils.pos2Point((String)areaStart);
                for (int i = 0; i < entryentities.length; ++i) {
                    FixTemplateDynTitle fixTemplateDynTitle = (FixTemplateDynTitle)fixTemplateDynTitles.get(i);
                    String titleStartPosition = fixTemplateDynTitle.getTitleStartPosition();
                    String titleEndPosition = fixTemplateDynTitle.getTitleEndPosition();
                    String[] startSplit = titleStartPosition.split(SPLIT_MARK);
                    String[] endSplit = titleEndPosition.split(SPLIT_MARK);
                    String titleStart = ExcelUtils.xy2Pos((int)(point.x + Integer.parseInt(startSplit[0])), (int)(point.y + Integer.parseInt(startSplit[1])));
                    String titleEnd = ExcelUtils.xy2Pos((int)(point.x + Integer.parseInt(endSplit[0])), (int)(point.y + Integer.parseInt(endSplit[1])));
                    this.getModel().setValue("titlerange", (Object)(titleStart + SPLIT_MARK + titleEnd), i);
                    this.getModel().setValue("prefix", (Object)fixTemplateDynTitle.getTitlePrefix(), i);
                    this.getModel().setValue("dimension", (Object)fixTemplateDynTitle.getTitleDimension(), i);
                    this.getModel().setValue("splittype", (Object)fixTemplateDynTitle.getTitleSplitType(), i);
                    this.getModel().setValue("splitcount", (Object)fixTemplateDynTitle.getTitleSplitCount(), i);
                    this.getModel().setValue("suffix", (Object)fixTemplateDynTitle.getTitleSuffix(), i);
                }
            }
        }
    }

    private void buildDimensionItem(List<String> dimensionNumbers) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("dimension");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dimensionNumbers.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (String number : dimensionNumbers) {
            items.add(new ComboItem(new LocaleString(modelCacheHelper.getDimension(number).getName()), number));
        }
        comboEdit.setComboItems(items);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        int rowIndex = rowDataEntities[0].getRowIndex();
        int[] selectRows = new int[]{rowIndex};
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put("pageid", this.getView().getPageId());
            pageCache.put("selectRows", SerializationUtils.serializeToBase64((Object)selectRows));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.cacheSelectRow();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        this.cacheSelectRow();
    }

    private void cacheSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put("pageid", this.getView().getPageId());
            pageCache.put("selectRows", SerializationUtils.serializeToBase64((Object)selectRows));
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

