/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.TemplateStatus;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTree;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTreeBuilder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.memberf7.newf7.F7CommonUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class FixTemplateHyperLinkF7Plugin
extends AbstractListPlugin
implements ListRowClickListener,
F7SelectedListRemoveListener,
SelectRowsEventListener,
SearchEnterListener {
    private static final String LEFT_TREE = "lefttree";
    private static final String LEFT_TREE_SEARCH = "treesearch";
    private static final String LEFT_TREE_TREE_UP = "treeup";
    private static final String LEFT_TREE_TREE_DOWN = "treedown";
    private static final String BILLLISTAP = "billlistap";
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String TEMPLATE_SELECTED = "templateSelected";
    private static final String SEARCHAP = "searchap";
    private static final String BTN_OK = "btn_ok";
    public static final String KEY_ID = "id";
    public static final String KEY_NUMBER = "nu";
    public static final String KEY_NAME = "na";
    public static final String TYPE_INDEX_MEMBER = "A";

    public void initialize() {
        Search searchap;
        F7SelectedList selectedList;
        super.initialize();
        BillList viewList = (BillList)this.getControl(BILLLISTAP);
        if (viewList != null) {
            viewList.addListRowClickListener((ListRowClickListener)this);
            viewList.addListRowDoubleClickListener((ListRowClickListener)this);
            viewList.setFilter(this.getBillListQfilter());
        }
        if ((selectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP)) != null) {
            selectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
            selectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        }
        if ((searchap = (Search)this.getControl(SEARCHAP)) != null) {
            searchap.addEnterListener((SearchEnterListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LEFT_TREE_TREE_UP, LEFT_TREE_TREE_DOWN, BTN_OK});
        Search search = (Search)this.getControl(LEFT_TREE_SEARCH);
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), FixTemplateHyperLinkF7Plugin.this.getView(), FixTemplateHyperLinkF7Plugin.this.getPageCache(), new TreeSearchUtil.TreeSearchParam(FixTemplateHyperLinkF7Plugin.LEFT_TREE));
                } else {
                    FixTemplateHyperLinkF7Plugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"BgTemplateListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        TreeView tview = (TreeView)this.getControl(LEFT_TREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                FixTemplateHyperLinkF7Plugin.this.refrushBillList();
            }
        });
    }

    protected void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(this.getBillListQfilter());
        billList.setClearSelection(true);
        billList.refresh();
    }

    private QFilter getSearchQfilter() {
        Search search = (Search)this.getControl(SEARCHAP);
        if (search != null) {
            QFilter searchFilter;
            QFBuilder cusBuilder = new QFBuilder();
            String _searchText = search.getSearchKey();
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)_searchText) && (searchFilter = F7CommonUtils.getSearchFilter(_searchText, false)) != null) {
                cusBuilder.add(searchFilter);
            }
            return cusBuilder.toFilter();
        }
        return null;
    }

    private QFilter getBillListQfilter() {
        Object businessModelId;
        Object templateNumber;
        QFilter searchQfilter;
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter and = new QFilter("templatestatus", "=", (Object)TemplateStatus.PUBLISH.getValue()).and(new QFilter("templatetype", "=", (Object)"4"));
        QFilter qFilter2 = new QFilter("templatetype", "=", (Object)"1");
        qFilter.and(and.or(qFilter2));
        String focusnodeid = ((TreeView)this.getControl(LEFT_TREE)).getTreeState().getFocusNodeId();
        if (focusnodeid != null) {
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue("treecheckbox").toString());
            QFilter qFilter1 = new QFilter("templatecatalog", "=", (Object)Convert.toLong((Object)focusnodeid));
            if (isallchild) {
                TreeModel treemodel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
                List childrenids = treemodel.seekChildrenByGivenNodeIds(Long.valueOf(Long.parseLong(focusnodeid)), true);
                qFilter1 = new QFilter("templatecatalog", "in", (Object)childrenids);
            }
            qFilter = qFilter.and(qFilter1);
        }
        if ((searchQfilter = this.getSearchQfilter()) != null) {
            qFilter.and(searchQfilter);
        }
        if ((templateNumber = this.getView().getFormShowParameter().getCustomParam("templateNumber")) != null) {
            qFilter.and("number", "!=", templateNumber);
        }
        if ((businessModelId = this.getView().getFormShowParameter().getCustomParam("businessModel")) != null) {
            qFilter.and(new QFilter("dataset.businessmodel.id", "=", businessModelId));
        }
        return qFilter;
    }

    public void afterCreateNewData(EventObject e) {
        this.refrushTree(null);
        this.refrushBillList();
        this.initData();
    }

    private void initData() {
        DynamicObject dynamicObject;
        Object selectId = this.getView().getFormShowParameter().getCustomParam("selectId");
        if (selectId != null && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectId, (String)"eb_templateentity")) != null) {
            HashMap<String, String> selectData = new HashMap<String, String>();
            selectData.put(KEY_ID, dynamicObject.getString(KEY_ID));
            selectData.put(KEY_NUMBER, dynamicObject.getString("number"));
            selectData.put(KEY_NAME, dynamicObject.getString("name"));
            LinkedHashMap<String, Map<String, String>> selectedDatas = new LinkedHashMap<String, Map<String, String>>(1);
            selectedDatas.put(dynamicObject.getString(KEY_ID), selectData);
            this.cacheSelectMember(this.getPageCache(), selectedDatas);
            this.updateSelected();
        }
    }

    private TreeModel refrushTree(TreeNode selecttreeNode) {
        TreeView treeview = (TreeView)this.getControl(LEFT_TREE);
        Long modelID = this.getModelId();
        TemplateCataLogTree root = TemplateCataLogTreeBuilder.getTemplateCataTree((Long)modelID, (String)((Object)((Object)this)).getClass().getName());
        if (root == null) {
            return null;
        }
        TreeModel treeModel = new TreeModel((ITreeNode)root);
        TreeNode treeNode = treeModel.buildEntryTree(treeview);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)treeNode));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        treeModel.cache2page(this.getPageCache());
        if (selecttreeNode == null) {
            treeview.focusNode(new TreeNode(null, String.valueOf(root.getId()), null));
        } else {
            treeview.focusNode(selecttreeNode);
        }
        return treeModel;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (LEFT_TREE_TREE_UP.equals(key) || LEFT_TREE_TREE_DOWN.equals(key)) {
            String nodeId = ((TreeView)this.getControl(LEFT_TREE)).getTreeState().getFocusNodeId();
            if (StringUtils.isEmpty((String)nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u6a21\u677f\u5206\u7c7b\u3002", (String)"BgTemplateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (key.toLowerCase(Locale.getDefault())) {
                case "treeup": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(LEFT_TREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                    break;
                }
                case "treedown": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(LEFT_TREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                    break;
                }
            }
        } else if (BTN_OK.equals(key)) {
            Map<String, Map<String, String>> selectData = this.getSelectedIdsFromCache(this.getPageCache());
            if (selectData.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"OrganizationViewEditPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map.Entry<String, Map<String, String>> next = selectData.entrySet().iterator().next();
            this.getView().returnDataToParent(next.getValue());
            this.getView().close();
        }
    }

    public Long getModelId() {
        Long modelId = 0L;
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        if (model != null) {
            modelId = IDUtils.toLong((Object)model);
        }
        return modelId;
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        this.cacheSelectMember(this.getPageCache(), null);
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList;
        Map<String, Map<String, String>> selectedIds = this.getSelectedIdsFromCache(this.getPageCache());
        selectedIds.clear();
        if (evt.getSource() instanceof BillList && (billList = (BillList)evt.getSource()) != null) {
            HashSet<String> removeIds = new HashSet<String>(selectedIds.size());
            for (Map.Entry<String, Map<String, String>> entry : selectedIds.entrySet()) {
                if (!TYPE_INDEX_MEMBER.equals(entry.getValue().get("ty"))) continue;
                removeIds.add(entry.getKey());
            }
            for (String removeId : removeIds) {
                selectedIds.remove(removeId);
            }
            selectedIds.putAll(this.getSelectRows(evt.getListSelectedRowCollection()));
        }
        this.cacheSelectMember(this.getPageCache(), selectedIds);
        this.updateSelected();
    }

    private void updateSelected() {
        F7SelectedList selectedF7 = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        Map<String, Map<String, String>> selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selectedMembers.size());
        for (Map<String, String> member : selectedMembers.values()) {
            valueTextItems.add(new ValueTextItem(member.get(KEY_ID), member.get(KEY_NAME) + "(" + member.get(KEY_NUMBER) + ")"));
        }
        selectedF7.addItems(valueTextItems);
        this.getView().updateView(F7SELECTEDLISTAP);
    }

    private void cacheSelectMember(IPageCache pageCache, Map<String, Map<String, String>> selectedIds) {
        if (selectedIds == null || selectedIds.isEmpty()) {
            pageCache.remove(TEMPLATE_SELECTED);
        } else {
            pageCache.put(TEMPLATE_SELECTED, JSON.toJSONString(selectedIds));
        }
    }

    private Map<String, Map<String, String>> getSelectedIdsFromCache(IPageCache pageCache) {
        String cacheStr = pageCache.get(TEMPLATE_SELECTED);
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            return (Map)JSON.parseObject((String)cacheStr, LinkedHashMap.class);
        }
        return new LinkedHashMap<String, Map<String, String>>();
    }

    private Map<String, Map<String, String>> getSelectRows(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap selectedDatas = Maps.newLinkedHashMapWithExpectedSize((int)rows.size());
        for (ListSelectedRow row : rows) {
            String pk = IDUtils.toString((Object)row.getPrimaryKeyValue());
            String number = row.getNumber();
            String name = row.getName();
            HashMap<String, String> selectData = new HashMap<String, String>();
            selectData.put(KEY_ID, pk);
            selectData.put(KEY_NUMBER, number);
            selectData.put(KEY_NAME, name);
            selectedDatas.put(pk, selectData);
        }
        return selectedDatas;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.refrushBillList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refrushBillList();
                break;
            }
        }
    }
}

