/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.templateview;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.common.analysereport.constants.DimMemberTypeEnum;
import kd.epm.eb.common.analysereport.constants.SectionEventType;
import kd.epm.eb.common.analysereport.constants.VariableTypeEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysereport.AnalyseRptMemberEntrySupport;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class RptSectionPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
AnalyseRptMemberEntrySupport {
    private static final String pageDimEntryKey = "memberentry";
    private static final String orderDimEntryKey = "orderentry";
    private List<IPageDimensionEntry> pageDimensionEntries;
    private String batSettingMark;

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"member", "member1"});
        this.addAfterF7SelectListener(this, new String[]{"member", "member1"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBaseInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("dimmembertype1".equals(propName) || "dimmembertype".equals(propName)) {
            this.dealDimTypeChange(this.isOrderEntryKey(propName), (String)changeData.getNewValue(), changeData.getRowIndex());
        } else if ("member1".equals(propName) || "member".equals(propName)) {
            this.dealMemberChange(this.isOrderEntryKey(propName), changeData.getNewValue(), changeData.getRowIndex());
        }
    }

    private void dealMemberChange(boolean isOrderEntry, Object newVal, int rowIndex) {
        if (this.isEmpty(newVal)) {
            this.getModel().setValue(this.getDimViewKey(isOrderEntry), null, rowIndex);
        }
    }

    private void dealDimTypeChange(boolean isOrderEntry, String newVal, int rowIndex) {
        String dimNum = (String)this.getEntryValue(this.getDimKey(isOrderEntry), "number", rowIndex);
        this.dealDimTypeChange(isOrderEntry, false, newVal, dimNum, rowIndex);
    }

    private void dealDimTypeChange(boolean isOrderEntry, boolean isInit, String newVal, String dimNumber, int rowIndex) {
        boolean isParam = this.isParamRow(newVal);
        String memberKey = this.getDimMemberKey(isOrderEntry);
        boolean isPeriod = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber);
        if (isParam) {
            if (isPeriod) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{memberKey});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{memberKey});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{memberKey});
        }
        if (!isInit) {
            this.getModel().setValue(memberKey, null, rowIndex);
            if (isPeriod) {
                String dimMemberType = isParam ? VariableTypeEnum.Parameter.getMetadata() : SysDimensionEnum.BudgetPeriod.getMemberTreemodel();
                this.getModel().setValue(this.getMemberTypeKey(isOrderEntry), (Object)dimMemberType, rowIndex);
            }
        }
    }

    private boolean isParamRow(int rowIndex, boolean isOrderEntry) {
        return this.isParamRow((String)this.getEntryValue(this.getEntryKey(isOrderEntry), this.getDimTypeKey(isOrderEntry), rowIndex));
    }

    private boolean isParamRow(String paramVal) {
        return DimMemberTypeEnum.PARAM.getIndex().equals(paramVal);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", pageDimEntryKey});
    }

    private void setBaseInfo() {
        this.getModel().setValue("template", (Object)this.getTempId());
        this.getModel().setValue("model", (Object)this.getModelId());
        this.getModel().setValue("bizmodel", (Object)this.getBizModelId());
        this.getModel().setValue("range", (Object)"ALL");
        this.buildDimEntry();
        this.buildOrderEntry();
    }

    private void buildOrderEntry() {
        IDataModel dataModel = this.getModel();
        List dimensionList = this.getIModelCacheHelper().getDimensionList(new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber()});
        dataModel.batchCreateNewEntryRow(orderDimEntryKey, dimensionList.size());
        String memberKey = this.getDimMemberKey(true);
        String dimKey = this.getDimKey(true);
        for (int index = 0; index < dimensionList.size(); ++index) {
            Dimension dimension = (Dimension)dimensionList.get(index);
            dataModel.setValue(dimKey, (Object)dimension.getId(), index);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                dataModel.setValue("memberclasstype1", (Object)VariableTypeEnum.Parameter.getMetadata(), index);
            } else {
                dataModel.setValue("memberclasstype1", (Object)dimension.getMemberModel(), index);
            }
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{memberKey});
        }
    }

    private void buildDimEntry() {
        List<IPageDimensionEntry> pageDimInfo = this.getPageViewFilter();
        if (pageDimInfo.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.batchCreateNewEntryRow(pageDimEntryKey, pageDimInfo.size());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        int rowIndex = 0;
        for (IPageDimensionEntry dimensionEntry : pageDimInfo) {
            dataModel.setValue("dimension", (Object)modelCacheHelper.getDimension(dimensionEntry.getDimension().getNumber()).getId(), rowIndex);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionEntry.getDimension().getNumber())) {
                dataModel.setValue("memberclasstype", (Object)VariableTypeEnum.Parameter.getMetadata(), rowIndex);
            } else {
                dataModel.setValue("memberclasstype", (Object)SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionEntry.getDimension().getNumber()), rowIndex);
            }
            ++rowIndex;
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (this.isMemberCol(key)) {
            boolean isOrderEntry = this.isOrderEntryKey(key);
            this.openF7(evt, (IFormPlugin)this, (qFilters, dimNumber) -> {
                if (!isOrderEntry) {
                    IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                    List<IPageDimensionEntry> pageViewFilter = this.getPageViewFilter();
                    IPageDimensionEntry dimensionEntry = pageViewFilter.stream().filter(dim -> dim.getDimension().getNumber().equals(dimNumber)).findFirst().get();
                    HashSet<String> idFilters = new HashSet<String>(16);
                    Long bizModelId = this.getBizModelId();
                    Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, dimNumber);
                    List entryMembers = dimensionEntry.getMembers();
                    if (entryMembers.size() > 0) {
                        for (IDimensionMember member : entryMembers) {
                            if (TemplateVarCommonUtil.checkIsVar((String)member.getNumber(), (String)dimNumber).booleanValue()) {
                                idFilters.add(member.getNumber());
                                continue;
                            }
                            List members = modelCacheHelper.getMember(dimNumber, viewId, member.getNumber(), member.getScope());
                            if (members == null) continue;
                            members.forEach(m -> idFilters.add(m.getNumber()));
                        }
                        qFilters.add(new QFilter("number", "in", idFilters));
                    }
                }
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String errorMes = this.checkTemplate();
        if (this.notEmpty(errorMes)) {
            this.getView().showTipNotification(errorMes);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap4", "confirm"});
        } else {
            this.updateEntryItemStatus(false);
            this.updateEntryItemStatus(true);
        }
    }

    private String checkTemplate() {
        String errorMes = null;
        if (this.isBatSetting()) {
            List<Long> batSettingIds = this.getBatSettingIds();
            DynamicObjectCollection settingObj = QueryServiceHelper.query((String)VariableTypeEnum.RptSection.getMetadata(), (String)"name,template.number as tempNum", (QFilter[])new QFilter("id", "in", batSettingIds).toArray());
            ArrayList<String> errorNames = new ArrayList<String>(16);
            for (DynamicObject obj : settingObj) {
                if (!this.isEmpty(obj.getString("tempNum"))) continue;
                errorNames.add(obj.getString("name"));
            }
            if (errorNames.size() > 0) {
                errorMes = ResManager.loadResFormat((String)"\u5207\u7247%1\u5173\u8054\u7684\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5220\u9664\u8fd9\u4e9b\u5207\u7247\u3002", (String)"RptSectionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{errorNames});
            }
        } else {
            String tempNumber = (String)this.getValue("template", "number");
            if (this.isEmpty(tempNumber)) {
                errorMes = ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u6b64\u62a5\u8868\u5207\u7247\u3002", (String)"RptSectionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return errorMes;
    }

    private void updateEntryItemStatus(boolean isOrderEntry) {
        String entryKey = this.getEntryKey(isOrderEntry);
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(entryKey);
        String dimTypeKey = this.getDimTypeKey(isOrderEntry);
        String dimKey = this.getDimKey(isOrderEntry) + ".number";
        for (int index = 0; index < entryRows.size(); ++index) {
            DynamicObject row = (DynamicObject)entryRows.get(index);
            String dimType = row.getString(dimTypeKey);
            String dimNumber = row.getString(dimKey);
            this.dealDimTypeChange(isOrderEntry, true, dimType, dimNumber, index);
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getCustomFormParam("modelId");
        if (modelId == null) {
            modelId = (Long)this.getValue("model", "id");
        }
        return modelId;
    }

    @Override
    public Long getBizModelId() {
        Long bizModelId = (Long)this.getCustomFormParam("bizModelId");
        if (bizModelId == null) {
            bizModelId = (Long)this.getValue("bizmodel", "id");
        }
        return bizModelId;
    }

    private Long getTempId() {
        Long templateId = (Long)this.getCustomFormParam("templateId");
        if (templateId == null) {
            templateId = (Long)this.getValue("template", "id");
        }
        return templateId;
    }

    private List<IPageDimensionEntry> getPageViewFilter() {
        if (this.pageDimensionEntries == null) {
            String paramStr = (String)this.getCustomFormParam("pageViewInfo");
            this.pageDimensionEntries = this.notEmpty(paramStr) ? (List<Object>)SerializationUtils.deSerializeFromBase64((String)paramStr) : new ArrayList<IPageDimensionEntry>(16);
        }
        return this.pageDimensionEntries;
    }

    private Map<String, Long> getPageViewDimMap() {
        String paramStr = (String)this.getCustomFormParam("dimViewMap");
        HashMap<String, Long> result = this.notEmpty(paramStr) ? (HashMap<String, Long>)SerializationUtils.deSerializeFromBase64((String)paramStr) : new HashMap<String, Long>(16);
        return result;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("confirm".equals(itemKey) && this.checkB4Save()) {
            this.saveData();
        }
    }

    private boolean checkB4Save() {
        ArrayList<String> errorList = new ArrayList<String>(16);
        if (!this.isBatSetting()) {
            String nameError;
            String number = (String)this.getValue("number", null);
            String numberError = NumberCheckUtils.checkNumberRule((String)number);
            if (this.notEmpty(numberError)) {
                errorList.add(numberError);
            } else {
                QFBuilder qb = new QFBuilder("model", "=", (Object)this.getModelId());
                qb.add("bizmodel", "=", (Object)this.getBizModelId());
                qb.and("number", "=", (Object)number);
                Long id = this.getModel().getDataEntity().getLong("id");
                if (this.notEmpty(id)) {
                    qb.add("id", "!=", (Object)id);
                }
                if (QueryServiceHelper.exists((String)VariableTypeEnum.RptSection.getMetadata(), (QFilter[])qb.toArray())) {
                    errorList.add(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RptSectionPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            String string = nameError = this.isEmpty(this.getValue("name", "string")) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptSectionPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]) : null;
            if (this.notEmpty(nameError)) {
                errorList.add(nameError);
            }
            this.checkEntry(false, errorList);
        }
        this.checkEntry(true, errorList);
        if (errorList.size() > 0) {
            String title = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"RptSectionPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (errorList.size() == 1) {
                this.getView().showTipNotification(title + "\uff0c" + (String)errorList.get(0));
            } else {
                CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), errorList, (String)title);
            }
        }
        return errorList.isEmpty();
    }

    private void checkEntry(boolean isOrderEntry, List<String> errorList) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(this.getEntryKey(isOrderEntry));
        String dimTypeKey = this.getDimTypeKey(isOrderEntry);
        String memberKey = this.getDimMemberKey(isOrderEntry);
        String entryText = isOrderEntry ? ResManager.loadKDString((String)"\u6a21\u677f\u4e0b\u8fbe\u4fe1\u606f", (String)"RptSectionPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ef4\u5ea6\u53d6\u503c", (String)"RptSectionPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        for (int index = 0; index < entryRows.size(); ++index) {
            DynamicObject row = (DynamicObject)entryRows.get(index);
            String dimType = row.getString(dimTypeKey);
            if (!DimMemberTypeEnum.MEMBER.getIndex().equals(dimType) || !this.isEmpty(row.get(memberKey))) continue;
            errorList.add(ResManager.loadResFormat((String)"%1\u7b2c%2\u884c\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptSectionPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{entryText, index + 1}));
        }
    }

    private void saveData() {
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>();
        ArrayList<DynamicObject> sectionObjs = new ArrayList<DynamicObject>();
        boolean isNew = this.selObj2Save(sectionObjs, quotes);
        List<String> errorList = this.checkSameDimMember(sectionObjs);
        if (errorList.size() > 0) {
            this.markNotCheckMemberSame(false);
            String errorStr = ResManager.loadResFormat((String)"%1\uff0c\u751f\u6210\u62a5\u544a\u65f6\u5c06\u65e0\u6cd5\u751f\u6210\u62a5\u8868\u5207\u7247\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"RptSectionPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\uff0c", errorList)});
            this.getView().showConfirm(errorStr, MessageBoxOptions.YesNo, new ConfirmCallBackListener("CheckMemberSame", (IFormPlugin)this));
            return;
        }
        if (sectionObjs.size() > 0) {
            try (TXHandle tx = TX.required((String)"saveRptSection");){
                try {
                    SaveServiceHelper.save((DynamicObject[])sectionObjs.toArray(new DynamicObject[1]));
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
                    this.getView().updateView();
                    this.getModel().setDataChanged(false);
                }
                catch (Exception ex) {
                    tx.markRollback();
                    log.error("saveRptSection: \n" + ex);
                    throw new KDBizException(ex.getMessage());
                }
            }
            HashSet rptNumbers = new HashSet(sectionObjs.size());
            ArrayList rptSectionIds = new ArrayList(sectionObjs.size());
            sectionObjs.forEach(obj -> {
                rptNumbers.add(obj.getString("number"));
                rptSectionIds.add(obj.getLong("id"));
            });
            SectionEventType eventType = isNew ? SectionEventType.ADD : SectionEventType.MODIFY;
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RptSectionService", (String)"notify4Change2Bcm", (Object[])new Object[]{this.getModelId(), this.getBizModelId(), rptSectionIds, eventType});
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "AnalyseReportUtil_20", "epm-eb-business");
            this.addObjOpLog(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AnalyseReportUtil_20", (String)"epm-eb-business", (Object[])new Object[0]), opNameBridge, rptNumbers);
        }
        IFormView parentView = this.getView().getParentView();
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RptSectionPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private List<String> checkSameDimMember(List<DynamicObject> objs) {
        ArrayList<String> errorList = new ArrayList<String>(16);
        if (this.isNotCheckMemberSame()) {
            return errorList;
        }
        String dimTypeKey = this.getDimTypeKey(false);
        String dimTypeKey1 = this.getDimTypeKey(true);
        String dimKey = this.getDimKey(false) + ".number";
        String dimNameKey = this.getDimKey(false) + ".name";
        String dimKey1 = this.getDimKey(true) + ".number";
        String memberKey = this.getDimMemberKey(false) + ".number";
        String memberKey1 = this.getDimMemberKey(true) + ".number";
        String viewKey1 = this.getDimViewKey(true) + ".number";
        String viewKey = this.getDimViewKey(false) + ".number";
        boolean isBat = this.isBatSetting();
        for (DynamicObject obj : objs) {
            String dimNum;
            String memberNum;
            DynamicObjectCollection orderEntry = obj.getDynamicObjectCollection(orderDimEntryKey);
            DynamicObjectCollection pageMemberEntry = obj.getDynamicObjectCollection(pageDimEntryKey);
            HashMap<String, String> orderMemberMap = new HashMap<String, String>();
            ArrayList<String> errorDim = new ArrayList<String>(16);
            for (DynamicObject row : orderEntry) {
                if (!DimMemberTypeEnum.MEMBER.getIndex().equals(row.getString(dimTypeKey1)) || TemplateVarCommonUtil.checkIsVar((String)(memberNum = row.getString(memberKey1)), (String)(dimNum = row.getString(dimKey1))).booleanValue()) continue;
                String viewNum = row.getString(viewKey1);
                orderMemberMap.put(dimNum, memberNum + "," + viewNum);
            }
            for (DynamicObject row : pageMemberEntry) {
                if (!DimMemberTypeEnum.MEMBER.getIndex().equals(row.getString(dimTypeKey))) continue;
                memberNum = row.getString(memberKey);
                dimNum = row.getString(dimKey);
                String dimName = row.getString(dimNameKey);
                if (TemplateVarCommonUtil.checkIsVar((String)memberNum, (String)dimNum).booleanValue()) continue;
                String viewNum = row.getString(viewKey);
                String orderMemberStr = (String)orderMemberMap.get(dimNum);
                if (orderMemberStr == null || orderMemberStr.equals(memberNum + "," + viewNum)) continue;
                errorDim.add(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6", (String)"RptSectionPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
            }
            if (errorDim.size() <= 0) continue;
            String preText = isBat ? ResManager.loadResFormat((String)"\u5207\u7247%1", (String)"RptSectionPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{obj.getString("name")}) : "";
            String errorStr = ResManager.loadResFormat((String)"%1\u5728\u7ef4\u5ea6\u53d6\u503c\u4e0e\u5173\u8054\u6a21\u677f\u4e0b\u8fbe\u4fe1\u606f\u4e2d\u914d\u7f6e\u7684\u6210\u5458\u4e0d\u4e00\u81f4", (String)"RptSectionPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{preText + String.join((CharSequence)",", errorDim)});
            errorList.add(errorStr);
        }
        return errorList;
    }

    private boolean isNotCheckMemberSame() {
        return this.notEmpty(this.getPageCache().get("NotCheckMemberSame"));
    }

    private void markNotCheckMemberSame(boolean isRemove) {
        if (isRemove) {
            this.getPageCache().remove("NotCheckMemberSame");
        } else {
            this.getPageCache().put("NotCheckMemberSame", "true");
        }
    }

    private boolean selObj2Save(List<DynamicObject> sectionObjs, List<MemberQuoteDao> quotes) {
        boolean isNew = false;
        if (!this.isBatSetting()) {
            DynamicObject object = this.getModel().getDataEntity(true);
            long id = object.getLong("id");
            if (this.isEmpty(id)) {
                id = GlobalIdUtil.genGlobalLongId();
                object.set("id", (Object)id);
                isNew = true;
            }
            AnalyseReportUtil.getInstance().selRptSectionRefDimInfo(object, quotes);
            sectionObjs.add(object);
        } else {
            DynamicObjectCollection orderEntry = this.getModel().getEntryEntity(orderDimEntryKey);
            String dimKey = this.getDimKey(true) + ".id";
            Map<Long, DynamicObject> dimRowMap = orderEntry.stream().collect(Collectors.toMap(row1 -> row1.getLong(dimKey), row2 -> row2));
            List<Long> batSettingIds = this.getBatSettingIds();
            DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])batSettingIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)VariableTypeEnum.RptSection.getMetadata()));
            List propNames = orderEntry.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).filter(pName -> !"id".equals(pName) && !"seq".equals(pName)).collect(Collectors.toList());
            for (DynamicObject object : objects) {
                DynamicObjectCollection _orderEntry = object.getDynamicObjectCollection(orderDimEntryKey);
                for (DynamicObject row : _orderEntry) {
                    Long dimId = row.getLong(dimKey);
                    DynamicObject rowObj = dimRowMap.get(dimId);
                    if (rowObj == null) continue;
                    for (String pName2 : propNames) {
                        row.set(pName2, rowObj.get(pName2));
                    }
                }
                AnalyseReportUtil.getInstance().selRptSectionRefDimInfo(object, quotes);
                sectionObjs.add(object);
            }
        }
        return isNew;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CheckMemberSame".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.saveData();
            }
            this.markNotCheckMemberSame(true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.handleMemberFillBack(closedCallBackEvent);
    }

    @Override
    public String getCurrentDimNumber(String controlKey) {
        boolean isOrderEntry = this.isOrderEntryKey(controlKey);
        String dimKey = this.getDimKey(isOrderEntry);
        return (String)this.getValue(dimKey, "number");
    }

    @Override
    public boolean isMemberCol(String f7Key) {
        return "member".equals(f7Key) || "member1".equals(f7Key);
    }

    private boolean isBatSetting() {
        if (this.batSettingMark == null) {
            this.batSettingMark = (String)this.getCustomFormParam("BatSetting");
        }
        return this.notEmpty(this.batSettingMark);
    }

    private List<Long> getBatSettingIds() {
        String paramStr = (String)this.getCustomFormParam("BatSettingIds");
        List result = this.isEmpty(paramStr) ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)paramStr, List.class);
        return result;
    }

    @Override
    public Long getDefaultViewId(String dimNumber) {
        Map<String, Long> pageViewDimMap = this.getPageViewDimMap();
        return pageViewDimMap.get(dimNumber);
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        this.dealAfterF7Select(afterF7SelectEvent);
    }
}

