/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template.weavedesc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentDownLoadEvent;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class TemplateWeaveDescSettingPlugin
extends AbstractFormPlugin
implements UploadListener,
AttachmentDownloadListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
        attach.addDownloadListener((AttachmentDownloadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        if (!this.isFromTemplate()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_close"});
        }
    }

    public void attachmentAfterDownload(AttachmentDownLoadEvent evt) {
        Object attachmentObj = evt.getTargetAttachments();
        if (attachmentObj == null) {
            return;
        }
        List attachments = (List)attachmentObj;
        for (Map attachment : attachments) {
            String realPath = AttachmentHelper.getRealPath((Map)attachment);
            if (realPath == null) continue;
            attachment.put("url", realPath);
        }
    }

    private void initData() {
        DynamicObject weaveInfo;
        Long templateId;
        long weaveId = 0L;
        List<Map<String, Object>> attachments = new ArrayList(16);
        String file_url = this.getView().getParentView().getPageCache().get("file_url");
        String desc = this.getView().getParentView().getPageCache().get("desc_info");
        String weaveStr = this.getView().getParentView().getPageCache().get("weaveId");
        if (StringUtils.isNotEmpty((String)weaveStr)) {
            weaveId = ConvertUtils.toLong((Object)weaveStr);
        }
        if (StringUtils.isEmpty((String)file_url) && StringUtils.isEmpty((String)desc) && (templateId = this.getTemplateId()) != 0L && (weaveInfo = BusinessDataServiceHelper.loadSingle((String)"eb_weavedescentity", (String)"id, desc", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)})) != null) {
            desc = weaveInfo.getLocaleString("desc").getLocaleValue();
            weaveId = weaveInfo.getLong("id");
            this.getView().getParentView().getPageCache().put("weaveId", String.valueOf(weaveId));
        }
        this.getModel().setValue("description", (Object)desc);
        if (!StringUtils.isEmpty((String)file_url)) {
            attachments = (List)SerializationUtils.deSerializeFromBase64((String)file_url);
        } else if (weaveId != 0L) {
            attachments.addAll(AttachmentServiceHelper.getAttachments((String)"eb_weavedescentity", (Object)weaveId, (String)"attachmentpanelap"));
        } else {
            return;
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List<Map<String, Object>> attachmentDelRepeat = this.getAttachmentDelRepeat(attachments);
        if (attachmentDelRepeat.size() != 0) {
            Map attachCache = AttachmentHelper.saveToTemp(attachmentDelRepeat, (String)"attachmentpanelap");
            this.getPageCache().put("TampAttCache" + this.getView().getPageId(), SerializationUtils.toJsonString((Object)attachCache));
            AttachmentHelper.addPreView(attachmentDelRepeat);
            attachmentPanel.bindData(attachmentDelRepeat);
        }
        this.getView().updateView("description");
    }

    private Long getTemplateId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object templateId = formShowParameter.getCustomParam("templateId");
        if (templateId == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)templateId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        String desc = "";
        OrmLocaleValue descLocal = (OrmLocaleValue)this.getModel().getValue("description");
        if (descLocal != null) {
            desc = descLocal.getLocaleValue();
        }
        if (this.isFromTemplate()) {
            this.getView().getParentView().getPageCache().put("file_url", SerializationUtils.serializeToBase64(attachmentData));
            this.getView().getParentView().getPageCache().put("desc_info", desc);
            if (this.getView().getParentView().getPageCache().get("weaveId") == null) {
                this.getView().getParentView().getPageCache().put("weaveId", String.valueOf(GlobalIdUtil.genGlobalLongId()));
            }
        }
        this.getView().close();
    }

    public void upload(UploadEvent evt) {
        ArrayList<Map<String, Object>> urls = new ArrayList<Map<String, Object>>(16);
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        ArrayList errMessage = new ArrayList(16);
        for (Object url : evt.getUrls()) {
            Map urlData = (Map)url;
            if (this.checkAttachmentContains(attachmentData, urlData, false)) {
                errMessage.add(urlData.get("name"));
                continue;
            }
            urls.add(urlData);
        }
        if (errMessage.size() != 0) {
            evt.setCancel(true);
            evt.setCancelMsg(ResManager.loadResFormat((String)"%1\u5df2\u5b58\u5728\u4e8e\u4e0a\u4f20\u7684\u5217\u8868\u5f53\u4e2d\uff0c\u4e0a\u4f20\u5931\u8d25\u3002", (String)"TemplateWeaveDescSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{((Object)errMessage).toString()}));
            this.uploadFiles(urls);
            attachmentData.addAll(urls);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            attachmentPanel.bindData(attachmentData);
        } else if (urls.size() != 1) {
            this.saveWeaveId();
        }
    }

    private boolean checkAttachmentContains(List<Map<String, Object>> attachmentData, Map<String, Object> urlData, Boolean isInitData) {
        ArrayList<Map<String, Object>> attachmentData_tmp = new ArrayList<Map<String, Object>>(attachmentData);
        for (Map map : attachmentData_tmp) {
            Date date2;
            Date date1;
            String name = map.get("name").toString();
            Long size = Convert.toLong(map.get("size"));
            if (!name.equals(urlData.get("name")) || !size.equals(Convert.toLong((Object)urlData.get("size")))) continue;
            if (isInitData.booleanValue() && (date1 = this.getConvertedDate(map)).before(date2 = this.getConvertedDate(urlData))) {
                attachmentData.remove(map);
                attachmentData.add(urlData);
            }
            return true;
        }
        return false;
    }

    private Date getConvertedDate(Map<String, Object> url) {
        Date modifyTime = null;
        try {
            if (url.containsKey("lastModified")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Long time = sdf.parse(url.get("lastModified").toString()).getTime();
                modifyTime = Convert.toDate((Object)time);
            } else {
                modifyTime = Convert.toDate((Object)System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            modifyTime = Convert.toDate((Object)url.get("lastModified"));
        }
        return modifyTime;
    }

    private List<Map<String, Object>> getAttachmentData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (attachmentData != null) {
            return attachmentData;
        }
        return new ArrayList<Map<String, Object>>(16);
    }

    private void uploadFiles(List<Map<String, Object>> attachments) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        if (attachments != null && attachments.size() != 0) {
            attachmentPanel.upload(attachments);
            this.saveWeaveId();
        }
    }

    private void saveWeaveId() {
        long weaveId = DB.genGlobalLongId();
        String weaveIdStr = this.getView().getParentView().getPageCache().get("weaveId");
        if (StringUtils.isNotEmpty((String)weaveIdStr)) {
            weaveId = ConvertUtils.toLong((Object)weaveIdStr);
        } else {
            DynamicObject weaveInfo;
            Long templateId = this.getTemplateId();
            if (templateId != 0L && (weaveInfo = QueryServiceHelper.queryOne((String)"eb_weavedescentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)})) != null) {
                weaveId = weaveInfo.getLong("id");
            }
        }
        this.getView().getParentView().getPageCache().put("weaveId", String.valueOf(weaveId));
    }

    private List<Map<String, Object>> getAttachmentDelRepeat(List<Map<String, Object>> attachments) {
        ArrayList<Map<String, Object>> returnAttach = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> attachment : attachments) {
            if (this.checkAttachmentContains(returnAttach, attachment, true)) continue;
            returnAttach.add(attachment);
        }
        return returnAttach;
    }

    private boolean isFromTemplate() {
        IFormView parentView = this.getView().getParentView();
        String entityId = parentView.getEntityId();
        return "eb_fixtemplate".equalsIgnoreCase(entityId) || "eb_dynamictemplate".equalsIgnoreCase(entityId);
    }
}

