/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.templateImport;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.lang3.StringUtils;

public class BgMoreExportPlugin
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_export"});
    }

    public void afterCreateNewData(EventObject e) {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId()).and("templatetype", "=", (Object)String.valueOf(this.getTempateType()));
        FilterParameter fp = new FilterParameter();
        Long templateId = this.getTemplateId();
        if (templateId != 0L) {
            filter.and("id", "=", (Object)templateId);
        }
        List qFilters = fp.getQFilters();
        qFilters.add(filter);
        QFilter filter1 = new QFilter("status", "=", (Object)"1");
        qFilters.add(filter1);
        billlistap.setFilterParameter(fp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        IDataEntityProperty property = e.getProperty();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        String name = property.getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"enable")) {
            BillList billlistap = (BillList)this.getView().getControl("billlistap");
            FilterParameter filterParameter = billlistap.getFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (((Boolean)newValue).booleanValue()) {
                QFilter filter = new QFilter("status", "=", (Object)"1");
                qFilters.add(filter);
            } else {
                Iterator iterator = qFilters.iterator();
                while (iterator.hasNext()) {
                    QFilter next = (QFilter)iterator.next();
                    String prop = next.getProperty();
                    if (!StringUtils.equals((CharSequence)prop, (CharSequence)"status")) continue;
                    iterator.remove();
                    break;
                }
            }
            billlistap.setFilterParameter(filterParameter);
            billlistap.refresh();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_export": {
                this.openPage();
                break;
            }
        }
    }

    private void openPage() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        if (selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BgMoreExportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (selectedRows.size() > 10) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u5bfc\u51fa10\u884c\u3002", (String)"BgMoreExportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        List<Long> templateId = this.getTemplateId(selectedRows);
        if (this.isBcm()) {
            formShowParameter.setCustomParam("templateIds", templateId);
            formShowParameter.setCustomParam("more", (Object)"1");
        } else {
            formShowParameter.setCustomParam("templateId", (Object)SerializationUtils.serializeToBase64(templateId));
            formShowParameter.setCustomParam("more", (Object)2);
        }
        formShowParameter.setCustomParam("pageDomain", this.getPageDomain());
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setFormId("eb_newexport");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap1");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6a21\u677f\u5bfc\u51fa", "BgMoreExportPlugin_2", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u51faID\uff1a%1$s\u3002", "BgMoreExportPlugin_3", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"export", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", templateId.toString())});
        this.getView().showForm(formShowParameter);
    }

    private Object getPageDomain() {
        return this.getView().getFormShowParameter().getCustomParam("pageDomain");
    }

    public void setListFilter() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        billlistap.getDataPermQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and("templatetype", "=", (Object)this.getTempateType()));
    }

    public boolean isBcm() {
        return this.getTempateType() == 0;
    }

    public DynamicObject[] getListTemplateDynamicObject(List<Long> ids) {
        DynamicObject[] dimensionDyObjArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_templateentity_bg"));
        return dimensionDyObjArray;
    }

    public List<Long> getTemplateId(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (ListSelectedRow listSelectedRow : selectedRows) {
            ids.add(Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        return ids;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("close")) {
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        if (this.getView().getFormShowParameter().getCustomParam("modelId") != null) {
            return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        }
        return 0L;
    }

    public Integer getTempateType() {
        if (this.getView().getFormShowParameter().getCustomParam("type") != null) {
            return (Integer)this.getView().getFormShowParameter().getCustomParam("type");
        }
        return 0;
    }

    public Long getTemplateId() {
        if (this.getView().getFormShowParameter().getCustomParam("templateId") != null) {
            return (Long)this.getView().getFormShowParameter().getCustomParam("templateId");
        }
        return 0L;
    }
}

