/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.templateImport;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.model.SpreadDataModel;
import kd.epm.eb.common.dao.TaskPojo;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.domain.view.js.SpreadProperties;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportTemplatePlugin
extends AbstractFormPlugin {
    private ITemplateModel ebTemplateModel;
    private SpreadContainer spreadInvoker;
    private int maxRow;
    private static final Log log = LogFactory.getLog(ExportTemplatePlugin.class);
    private TemplateModel baseTemplateModel = null;

    public void initialize() {
        this.spreadInvoker = new SpreadContainer(this.getView(), this.getSpreadKey());
        this.addSpreadService();
    }

    private void addSpreadService() {
        this.getView().addService(ISpreadAction.class, (Object)new SpreadDataModel((kd.bos.form.plugin.AbstractFormPlugin)this));
    }

    private String getSpreadKey() {
        return "template_spread";
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isBcm()) {
            String json = this.splitJason();
            if (StringUtils.isBlank((String)json)) {
                return;
            }
            this.spreadInvoker.rebuildSpread(json);
            this.buildMoreTem();
        }
    }

    public Long getmodelId() {
        if (this.getView().getFormShowParameter().getCustomParam("modelId") != null) {
            return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        }
        return 0L;
    }

    public boolean isBcm() {
        return this.getView().getFormShowParameter().getCustomParam("more").toString().equals("1");
    }

    private String splitJason() {
        List<Long> templateIds = this.getTemplateIds();
        HashMap<Integer, TemplateModel> TempMap = new HashMap<Integer, TemplateModel>(16);
        this.getTempMap(templateIds, TempMap);
        if (TempMap.size() == 0) {
            return "";
        }
        this.baseTemplateModel = (TemplateModel)((Map.Entry)TempMap.entrySet().stream().findFirst().get()).getValue();
        String jason = this.baseTemplateModel.getRptSpreadJson();
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)(StringUtils.isNotEmpty((String)this.baseTemplateModel.getRptData()) ? this.baseTemplateModel.getRptData() : this.baseTemplateModel.getData()));
        String spreadjson = jason.substring(6);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson)));
        JSONObject object = JSONObject.parseObject((String)ssjson);
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        for (Map.Entry entry : TempMap.entrySet()) {
            Integer value = (Integer)entry.getKey();
            if (value == 0) continue;
            TemplateModel template_new = (TemplateModel)entry.getValue();
            SpreadManager spreadManager_new = JsonSerializerUtil.toSpreadManager((String)(StringUtils.isNotEmpty((String)template_new.getRptData()) ? template_new.getRptData() : template_new.getData()));
            spreadManager.getBook().addSheet(spreadManager_new.getBook().getSheet(0));
            String jason_new = template_new.getRptSpreadJson();
            String spreadjson_new = jason_new.substring(6);
            String ssjson_new = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadjson_new)));
            JSONObject object_new = JSONObject.parseObject((String)ssjson_new);
            JSONObject sheets_new = (JSONObject)object_new.get((Object)"sheets");
            JSONObject sheets_new1 = (JSONObject)sheets_new.get(sheets_new.keySet().toArray()[0]);
            sheets_new1.put("name", (Object)template_new.getName());
            sheets_new1.put("index", (Object)value);
            sheets.put(template_new.getName(), sheets_new.get(sheets_new.keySet().toArray()[0]));
        }
        object.put("sheetCount", (Object)templateIds.size());
        object.put("activeSheetIndex", (Object)0);
        String pJson = JSONObject.toJSONString((Object)object);
        String s = new String(Base64.getEncoder().encode(GZIPUtils.compress((String)pJson)));
        this.baseTemplateModel.setRptData(SerializationUtils.serializeToBase64((Object)spreadManager));
        return "base64" + s;
    }

    private DynamicObject[] getTempMap(List<Long> templateId, Map<Integer, TemplateModel> TempMap) {
        DynamicObject[] dynamicObjects = this.getListTemplateDynamicObject(templateId);
        int i = 0;
        for (DynamicObject doc : dynamicObjects) {
            TemplateModel template = new TemplateModel();
            template.loadDynaObj2Model(doc);
            TempMap.put(i, template);
            ++i;
        }
        return dynamicObjects;
    }

    public DynamicObject[] getListTemplateDynamicObject(List<Long> ids) {
        DynamicObject[] dimensionDyObjArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_templateentity_bg"));
        return dimensionDyObjArray;
    }

    private List<Long> getTemplateIds() {
        Object templateIds = this.getView().getFormShowParameter().getCustomParam("templateIds");
        return (List)templateIds;
    }

    private void buildMoreTem() {
        if (!this.isBcm()) {
            return;
        }
        RequestContext context = RequestContextCreator.createForThreadPool();
        List<Long> templateIds = this.getTemplateIds();
        Object pageDomain = this.getView().getFormShowParameter().getCustomParam("pageDomain");
        int maximumPoolSize = Runtime.getRuntime().availableProcessors() + 1;
        if (maximumPoolSize < 3) {
            maximumPoolSize = 3;
        }
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(3, maximumPoolSize, 50L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ExecutorService es = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)poolExecutor);
        CountDownLatch count = new CountDownLatch(templateIds.size());
        int needToExportTemplateSize = templateIds.size();
        for (int i = 0; i < templateIds.size(); ++i) {
            Long templateId = templateIds.get(i);
            es.execute(new BuildData(count, context, templateId, i, this.baseTemplateModel, pageDomain != null ? (Map)pageDomain : null));
        }
        try {
            count.await();
        }
        catch (InterruptedException ex) {
            log.error("budget-data-log : ", (Throwable)ex);
            Thread.currentThread().interrupt();
            throw new KDBizException(ex.getMessage());
        }
        this.handleTwoReport(needToExportTemplateSize);
        this.exportMoreFile(this.baseTemplateModel);
    }

    public static TemplateModel getTemplateModel(Long templateId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity_bg");
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dynamicObject);
        return template;
    }

    private void exportMoreFile(TemplateModel baseTemplateModel) {
        this.spreadInvoker.exportExcelFile(baseTemplateModel.getName());
        this.spreadInvoker.callbackAction("closeView");
    }

    private LinkedList<String> getDimMem(Map<String, String> memberFromUserObjectDimNumbers, List<String> dim) {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> s : memberFromUserObjectDimNumbers.entrySet()) {
            if (!dim.contains(s.getKey())) continue;
            list.add(s.getValue());
        }
        return list;
    }

    private void handleTwoReport(int si) {
        List<Dimension> dimensionList = this.getDimension();
        Map<String, Map<String, String>> dimMemberByModel = this.getDimMemberByModel(dimensionList);
        this.spreadInvoker.addSheets(si, ResManager.loadKDString((String)"\u7ef4\u5ea6\u8303\u56f4", (String)"ExportTemplatePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.maxRow + 100, 200);
        this.fillDimMemberToSheet(dimMemberByModel, null, null, si);
    }

    private void fillDimMemberToSheet(Map<String, Map<String, String>> dimMemberByModel, XSSFSheet sheet, XSSFWorkbook workBook, int si) {
        if (this.isBcmTemplate()) {
            ArrayList<Map<String, Object>> updataValue = new ArrayList<Map<String, Object>>(16);
            ArrayList<Integer> cols = new ArrayList<Integer>(16);
            int newCol = 1;
            updataValue.add(this.packedUpdateCellMap(0, 0, ResManager.loadKDString((String)"\u7ef4\u5ea6\u67e5\u8be2\u5bf9\u7167\u8868", (String)"ExportTemplatePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            for (Map<String, String> dimMembers : dimMemberByModel.values()) {
                int newRow = 0;
                updataValue.add(this.packedUpdateCellMap(newRow, newCol * 3 - 2, ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportTemplatePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                updataValue.add(this.packedUpdateCellMap(newRow, newCol * 3 - 1, ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportTemplatePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                this.setOtherMessageCellStyle(newRow, newCol * 3 - 2, 1, 2, "#FF0000", "2", si);
                for (Map.Entry<String, String> entry : dimMembers.entrySet()) {
                    updataValue.add(this.packedUpdateCellMap(++newRow, newCol * 3 - 2, entry.getKey()));
                    updataValue.add(this.packedUpdateCellMap(newRow, newCol * 3 - 1, entry.getValue()));
                }
                cols.add(newCol * 3 - 2);
                cols.add(newCol * 3 - 1);
                ++newCol;
            }
            this.setBcmColWidth(cols);
            this.spreadInvoker.updateCellValueAddSheet(updataValue, si);
        } else {
            if (sheet == null || workBook == null) {
                return;
            }
            String[] dimNumbers = dimMemberByModel.keySet().toArray(new String[0]);
            for (int row = 0; row <= this.maxRow; ++row) {
                XSSFRow cellRow = sheet.createRow(row);
                for (int col = 0; col <= dimMemberByModel.size(); ++col) {
                    Map<String, String> map;
                    XSSFCell cell1;
                    XSSFCell cell;
                    if (row == 0) {
                        if (col == 0) {
                            sheet.setColumnWidth(col, 5000);
                            XSSFCell cell2 = cellRow.createCell(col);
                            cell2.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u67e5\u8be2\u5bf9\u7167\u8868", (String)"ExportTemplatePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        XSSFCellStyle style = workBook.createCellStyle();
                        XSSFFont font = workBook.createFont();
                        font.setColor(IndexedColors.RED.getIndex());
                        style.setFont((Font)font);
                        cell = cellRow.createCell(col * 3 - 2);
                        cell.setCellValue(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportTemplatePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        cell1 = cellRow.createCell(col * 3 - 1);
                        cell1.setCellValue(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportTemplatePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        cell.setCellStyle((CellStyle)style);
                        cell1.setCellStyle((CellStyle)style);
                        continue;
                    }
                    if (col == 0 || (map = dimMemberByModel.get(dimNumbers[col - 1])).size() < row) continue;
                    String dim = map.keySet().toArray(new String[0])[row - 1];
                    cell = cellRow.createCell(col * 3 - 2);
                    cell.setCellValue(dim);
                    cell1 = cellRow.createCell(col * 3 - 1);
                    cell1.setCellValue(map.get(dim));
                }
            }
            for (int col = 1; col <= dimMemberByModel.size() * 3; ++col) {
                sheet.setColumnWidth(col, 3500);
                if (col % 3 != 0) continue;
                sheet.setColumnWidth(col / 3 * 3, 1000);
            }
        }
    }

    private void setBcmColWidth(List<Integer> cols) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>(16);
        featureMap.put("index", cols);
        featureMap.put("num", 125);
        featureMap.put("si", 1);
        this.spreadInvoker.setColumnsWidthAddSheet(featureMap);
    }

    private void setOtherMessageCellStyle(int rowStart, int colStart, int rows, int cols, String color, String isFont, int si) {
        ArrayList<CellArea> range = new ArrayList<CellArea>(16);
        CellArea cellArea = new CellArea(rowStart, colStart, rows, cols);
        range.add(cellArea);
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        if ("1".equals(isFont)) {
            cellStyleInfo.setBkc(color);
        } else if ("2".equals(isFont)) {
            cellStyleInfo.setFrc(color);
        } else if ("3".equals(isFont)) {
            cellStyleInfo.setF(ResManager.loadKDString((String)"11pt \u5b8b\u4f53", (String)"ExportTemplatePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        AreasStyle areasStyle = new AreasStyle(range, cellStyleInfo);
        ArrayList<AreasStyle> areasStyles = new ArrayList<AreasStyle>(16);
        areasStyles.add(areasStyle);
        this.spreadInvoker.setCellStyleAddSheet(areasStyles, si);
    }

    private List<Dimension> getDimension() {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(16);
        long modelId = 0L;
        modelId = this.getmodelId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        DataSet result = QueryServiceHelper.queryDataSet((String)"EPM", (String)"epm_dimension", (String)"id,name,number,membermodel", (QFilter[])qfBuilder.toArray(), (String)"");
        for (Row memberRow : result) {
            Dimension dimension = new Dimension(memberRow.getLong("id"), memberRow.getString("name"), memberRow.getString("number"));
            dimension.setMemberModel(memberRow.getString("membermodel"));
            dimensionList.add(dimension);
        }
        return dimensionList;
    }

    private void addOtherQf(QFBuilder qfBuilder, Dimension dimension) {
        if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            qfBuilder.add("number", "!=", (Object)"RatePreset");
        } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber())) {
            qfBuilder.add("number", "!=", (Object)"CWP");
            qfBuilder.add("number", "!=", (Object)"ManualJournal");
            qfBuilder.add("number", "!=", (Object)"AutoJournal");
            qfBuilder.add("number", "!=", (Object)"ADJE");
        }
    }

    private Map<String, Map<String, String>> getDimMemberByModel(List<Dimension> dimensionList) {
        LinkedHashMap<String, Map<String, String>> allDimMember = new LinkedHashMap<String, Map<String, String>>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            int dimSize = 0;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension", "=", (Object)dimension.getId());
            this.addOtherQf(qfBuilder, dimension);
            map.put(dimension.getNumber(), dimension.getName());
            DataSet result = QueryServiceHelper.queryDataSet((String)"epm", (String)dimension.getMemberModel(), (String)"name,number", (QFilter[])qfBuilder.toArray(), (String)"dseq");
            Iterator rows = result.iterator();
            while (rows.hasNext()) {
                ++dimSize;
                Row memberRow = (Row)rows.next();
                map.put(memberRow.getString("number"), memberRow.getString("name"));
            }
            allDimMember.put(dimension.getNumber(), map);
            if (dimSize <= this.maxRow) continue;
            this.maxRow = dimSize;
        }
        this.isDseqByPeriod(allDimMember);
        return allDimMember;
    }

    public void closeView() {
        this.getView().close();
    }

    private String numberToLetter(int num) {
        if (num <= 0) {
            return null;
        }
        String letter = "";
        --num;
        do {
            if (letter.length() > 0) {
                --num;
            }
            letter = (char)(num % 26 + 65) + letter;
        } while ((num = (num - num % 26) / 26) > 0);
        return letter;
    }

    public Map<Integer, Map<String, String>> getMoreNewRangeRowDim(TemplateModel moreTemplate) {
        List areaRangeEntries = moreTemplate.getAreaRangeEntries();
        HashMap<Integer, Map<String, String>> areaRangeMap = new HashMap<Integer, Map<String, String>>(areaRangeEntries.size());
        int i = 0;
        for (AreaRangeEntry areaRangeEntry : areaRangeEntries) {
            HashMap<String, String> rangeRowAndCol = new HashMap<String, String>(16);
            String areaRange = areaRangeEntry.getAreaRange();
            if (areaRange.indexOf(":") == -1) continue;
            int index = areaRange.indexOf(":");
            String starCell = areaRange.substring(0, index);
            String endCell = areaRange.substring(index + 1);
            int bfirstNumIndex = this.getFirstNumIndex(starCell);
            int efirstNumIndex = this.getFirstNumIndex(endCell);
            if (bfirstNumIndex != -1 && efirstNumIndex != -1) {
                rangeRowAndCol.put("col", ExportTemplatePlugin.excelColStrToNum(starCell.substring(0, bfirstNumIndex)) - 1 + "@" + (ExportTemplatePlugin.excelColStrToNum(endCell.substring(0, efirstNumIndex)) - 1));
                rangeRowAndCol.put("row", Integer.parseInt(starCell.substring(bfirstNumIndex)) - 1 + "@" + (Integer.parseInt(endCell.substring(efirstNumIndex)) - 1));
            }
            areaRangeMap.put(i, rangeRowAndCol);
            ++i;
        }
        return areaRangeMap;
    }

    public static int excelColStrToNum(String column) {
        int num = 0;
        int result = 0;
        int length = column.length();
        for (int i = 0; i < length; ++i) {
            char ch = column.charAt(length - i - 1);
            num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }

    public int getFirstNumIndex(String value) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            return i;
        }
        return -1;
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    private int getBeginRow(String row) {
        if (row.indexOf("@") != -1) {
            return Integer.parseInt(row.substring(0, row.indexOf("@")));
        }
        return 0;
    }

    private int getEndRow(String row) {
        if (row.indexOf("@") != -1) {
            return Integer.parseInt(row.substring(row.indexOf("@") + 1));
        }
        return 0;
    }

    private int getBeginCol(String col) {
        if (col.indexOf("@") != -1) {
            return Integer.parseInt(col.substring(0, col.indexOf("@")));
        }
        return 0;
    }

    private int getEndCol(String col) {
        if (col.indexOf("@") != -1) {
            return Integer.parseInt(col.substring(col.indexOf("@") + 1));
        }
        return 0;
    }

    public boolean isBcmTemplate() {
        return this.getView().getFormShowParameter().getCustomParam("more") != null && this.getView().getFormShowParameter().getCustomParam("more").equals("1");
    }

    private void isDseqByPeriod(Map<String, Map<String, String>> allDimMember) {
        Map<String, String> map = allDimMember.get("Period");
        LinkedHashMap<String, String> new_map = new LinkedHashMap<String, String>(map.size());
        String removePeriod = map.remove("Period");
        new_map.put("Period", removePeriod);
        ArrayList<Integer> mom = new ArrayList<Integer>(16);
        for (String value : map.keySet()) {
            if (!value.startsWith("M_M")) continue;
            mom.add(Integer.valueOf(value.substring(3)));
        }
        Collections.sort(mom);
        for (int i = 0; i < mom.size(); ++i) {
            String period = "M_M" + String.format("%02d", mom.get(i));
            String remove = map.remove(period);
            new_map.put(period, remove);
        }
        new_map.putAll(map);
        allDimMember.remove("Period");
        allDimMember.put("Period", new_map);
    }

    class BuildData
    implements Runnable {
        private CountDownLatch count = null;
        private RequestContext context;
        private TemplateModel moreTemplate;
        private SpreadManager spreadManager;
        private Map<String, Object> pageDimDomain;
        private int j;

        public BuildData(CountDownLatch count, RequestContext context, Long templateId, int j, TemplateModel baseMoreTemplate, Map<String, Object> pageDimDomain) {
            this.count = count;
            this.context = context;
            this.moreTemplate = ExportTemplatePlugin.getTemplateModel(templateId);
            this.j = j;
            this.spreadManager = JsonSerializerUtil.toSpreadManager((String)(StringUtils.isNotEmpty((String)baseMoreTemplate.getRptData()) ? baseMoreTemplate.getRptData() : baseMoreTemplate.getData()));
            this.pageDimDomain = pageDimDomain;
        }

        @Override
        public void run() {
            String threadId = this.toString();
            long begin = System.nanoTime();
            log.info("begin insertexcel- " + threadId);
            try {
                this.build();
            }
            catch (Throwable ex) {
                log.error("buildData error:", ex);
                throw ex;
            }
            finally {
                this.count.countDown();
                long use = System.nanoTime() - begin;
                log.info("end save data - " + threadId + "; use = " + TimeUnit.NANOSECONDS.toMillis(use));
            }
        }

        protected void build() {
            RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
            if (ExportTemplatePlugin.this.isBcm()) {
                Sheet moresheet = this.spreadManager.getBook().getSheet(this.j);
                Map<Integer, Map<String, String>> rangeRowDim = ExportTemplatePlugin.this.getMoreNewRangeRowDim(this.moreTemplate);
                Object[] moreTaskPojoMessage_new = this.getMoreTaskPojoMessage_new(rangeRowDim);
                String serTaskMessage = SerializationUtils.serializeToBase64((Object)moreTaskPojoMessage_new);
                HashMap<String, Map<Integer, Integer>> groupMessage = new HashMap<String, Map<Integer, Integer>>(16);
                this.insertDealRowAndCol(moreTaskPojoMessage_new, moresheet, groupMessage, true);
                this.insertDealRowAndCol(moreTaskPojoMessage_new, moresheet, groupMessage, false);
                this.setMoreCellValue_new((TaskPojo[])moreTaskPojoMessage_new, moresheet, serTaskMessage);
                boolean isInsertThreeCol = this.setMoreGroup_new(groupMessage);
                this.setMoreHideAndPageDimMessage_new(isInsertThreeCol, (TaskPojo[])moreTaskPojoMessage_new, null, moresheet);
                this.getMoreDataRangeUpdata_new((TaskPojo[])moreTaskPojoMessage_new, isInsertThreeCol, serTaskMessage);
                this.expandMoreRowAndCol();
            }
        }

        private void getMoreDataRangeUpdata_new(TaskPojo[] taskPojoMessage, boolean isInsertThreeCol, String serTaskMessage) {
            TaskPojo[] taskPojoMessage_old = (TaskPojo[])SerializationUtils.deSerializeFromBase64((String)serTaskMessage);
            LinkedHashSet<String> dataRangeList = new LinkedHashSet<String>();
            for (TaskPojo taskPojo_old : taskPojoMessage_old) {
                for (TaskPojo taskPojo : taskPojoMessage) {
                    if (taskPojo_old.getBeginRow() != taskPojo.getBeginRow() || taskPojo_old.getBeginCol() != taskPojo.getBeginCol()) continue;
                    int beginRow = taskPojo.getcBeginRow() + this.getMoreOtherMessageCount() + 1;
                    int endRow = taskPojo.getcEndRow() + this.getMoreOtherMessageCount() + 1;
                    int beginCol = taskPojo.getcBeginCol() + 1;
                    int endCol = taskPojo.getcEndCol() + 1;
                    if (isInsertThreeCol) {
                        beginCol = taskPojo.getcBeginCol() + 5;
                        endCol = taskPojo.getcEndCol() + 5;
                    }
                    String beginCol_new = ExportTemplatePlugin.this.numberToLetter(beginCol);
                    String endCol_new = ExportTemplatePlugin.this.numberToLetter(endCol);
                    dataRangeList.add(beginRow + beginCol_new + ":" + endRow + endCol_new);
                }
            }
            int i = 1;
            ArrayList<Map<String, Object>> updataValue = new ArrayList<Map<String, Object>>(16);
            for (String dataRange : dataRangeList) {
                updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, 0, dataRange));
                ++i;
            }
            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(0, 1, this.getMoreTemplateNumber()));
            ExportTemplatePlugin.this.spreadInvoker.updateCellValueAddSheet(updataValue, this.j);
        }

        private void setMoreHideAndPageDimMessage_new(boolean isInsertThreeCol, TaskPojo[] taskPojoMessage, Map<String, Map<String, String>> dimMemberByModel, Sheet moresheet) {
            if (isInsertThreeCol) {
                this.insertMoreSpaceRow(moresheet, 0, 4, false);
            }
            this.insertMoreSpaceRow(moresheet, 0, this.getMoreOtherMessageCount(), true);
            ExportTemplatePlugin.this.spreadInvoker.setCol0rRowGroupbyOnesheet(this.getMoreViewDim().size() + 2, 0, this.j, true);
            this.updataMoreOtherMessageValue(dimMemberByModel, moresheet);
        }

        private boolean setMoreGroup_new(Map<String, Map<Integer, Integer>> groupMessage) {
            boolean isInsertThreeCol = false;
            Map<Integer, Integer> row = groupMessage.get("row");
            for (Map.Entry<Integer, Integer> entry : row.entrySet()) {
                ExportTemplatePlugin.this.spreadInvoker.setCol0rRowGroupbyOnesheet(entry.getValue().intValue(), entry.getKey() - entry.getValue(), this.j, true);
            }
            Map<Integer, Integer> col = groupMessage.get("col");
            for (Map.Entry<Integer, Integer> entry : col.entrySet()) {
                if (entry.getKey() - entry.getValue() < 3) {
                    isInsertThreeCol = true;
                }
                ExportTemplatePlugin.this.spreadInvoker.setCol0rRowGroupbyOnesheet(entry.getValue().intValue(), entry.getKey() - entry.getValue(), this.j, false);
            }
            return isInsertThreeCol;
        }

        private void setMoreCellValue_new(TaskPojo[] taskPojoMessage, Sheet moreSheet, String serTaskMessage) {
            TaskPojo[] taskPojoMessage_old = (TaskPojo[])SerializationUtils.deSerializeFromBase64((String)serTaskMessage);
            ArrayList<Map<String, Object>> updataValue = new ArrayList<Map<String, Object>>(16);
            int range = 0;
            for (TaskPojo taskPojo_old : taskPojoMessage_old) {
                for (TaskPojo taskPojo : taskPojoMessage) {
                    if (taskPojo_old.getBeginRow() != taskPojo.getBeginRow() || taskPojo_old.getBeginCol() != taskPojo.getBeginCol()) continue;
                    List<String> colDim = this.getMoreColDim(range);
                    List<String> rowDim = this.getMoreRowDim(range);
                    for (int i = taskPojo.getcBeginRow(); i <= taskPojo.getcEndRow(); ++i) {
                        for (int j = taskPojo.getcBeginCol(); j <= taskPojo.getcEndCol(); ++j) {
                            int k;
                            Cell cell = moreSheet.getCell(i, j);
                            Map memberFromUserObjectDimNumbers = cell.getMemberFromUserObjectDimNumbers();
                            LinkedList colDimMem = ExportTemplatePlugin.this.getDimMem(memberFromUserObjectDimNumbers, rowDim);
                            LinkedList rowDimMem = ExportTemplatePlugin.this.getDimMem(memberFromUserObjectDimNumbers, colDim);
                            if (i == taskPojo.getcBeginRow()) {
                                if (memberFromUserObjectDimNumbers != null && memberFromUserObjectDimNumbers.size() != 0) {
                                    if (rowDimMem.size() != 0) {
                                        for (k = rowDimMem.size(); k > 0; --k) {
                                            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i - k, j, rowDimMem.get(k - 1)));
                                        }
                                    }
                                    if (j == taskPojo.getcBeginCol() && colDimMem.size() != 0) {
                                        for (k = colDimMem.size(); k > 0; --k) {
                                            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j - k, colDimMem.get(k - 1)));
                                        }
                                    }
                                }
                                updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, ""));
                                continue;
                            }
                            if (j == taskPojo.getcBeginCol() && colDimMem.size() != 0) {
                                for (k = colDimMem.size(); k > 0; --k) {
                                    updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j - k, colDimMem.get(k - 1)));
                                }
                            }
                            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, ""));
                        }
                    }
                }
                ++range;
            }
            ExportTemplatePlugin.this.spreadInvoker.updateCellValueAddSheet(updataValue, this.j);
        }

        private void insertDealRowAndCol(Object[] moreTaskPojoMessage, Sheet moresheet, Map<String, Map<Integer, Integer>> groupMessage, boolean isRow) {
            int i;
            if (isRow) {
                this.bubbleSort(moreTaskPojoMessage, true);
            }
            LinkedHashMap<Integer, Integer> insertRowAndCount = new LinkedHashMap<Integer, Integer>();
            HashMap<Integer, Integer> groupMap = new HashMap<Integer, Integer>(16);
            int realCount = 0;
            for (i = 0; i < moreTaskPojoMessage.length; ++i) {
                int integer;
                TaskPojo taskPojo = (TaskPojo)moreTaskPojoMessage[i];
                TaskPojo taskPojo_new = null;
                taskPojo_new = i == moreTaskPojoMessage.length - 1 ? (TaskPojo)moreTaskPojoMessage[i] : (TaskPojo)moreTaskPojoMessage[i + 1];
                int bef_begin = 0;
                int bef_Count = 0;
                int bef_cBegin = 0;
                int bef_cEnd = 0;
                int after_begin = 0;
                int after_cbegin = 0;
                int after_End = 0;
                int after_Count = 0;
                int after_cEnd = 0;
                if (isRow) {
                    bef_begin = taskPojo.getBeginRow();
                    bef_Count = taskPojo.getRowCount();
                    bef_cBegin = taskPojo.getcBeginRow();
                    bef_cEnd = taskPojo.getcEndRow();
                    after_begin = taskPojo_new.getBeginRow();
                    after_cbegin = taskPojo_new.getcBeginRow();
                    after_cEnd = taskPojo_new.getcEndRow();
                    after_Count = taskPojo_new.getRowCount();
                    after_End = taskPojo_new.getEndRow();
                } else {
                    bef_begin = taskPojo.getBeginCol();
                    bef_Count = taskPojo.getColCount();
                    bef_cBegin = taskPojo.getcBeginCol();
                    bef_cEnd = taskPojo.getcEndCol();
                    after_begin = taskPojo_new.getBeginCol();
                    after_cbegin = taskPojo_new.getcBeginCol();
                    after_cEnd = taskPojo_new.getcEndCol();
                    after_Count = taskPojo_new.getColCount();
                    after_End = taskPojo_new.getEndCol();
                }
                if (i == moreTaskPojoMessage.length - 1) {
                    if (insertRowAndCount.containsKey(bef_begin)) continue;
                    insertRowAndCount.put(bef_begin, bef_Count);
                    groupMap.put(bef_cBegin, bef_Count);
                    continue;
                }
                if (bef_begin < after_begin) {
                    if (realCount == 0) {
                        realCount = bef_Count;
                    }
                    if (isRow) {
                        taskPojo_new.setcBeginRow(after_cbegin + realCount);
                        taskPojo_new.setcEndRow(after_cEnd + realCount);
                    } else {
                        taskPojo_new.setcBeginCol(after_cbegin + realCount);
                        taskPojo_new.setcEndCol(after_cEnd + realCount);
                    }
                    realCount = after_Count + realCount;
                    if (insertRowAndCount.get(bef_begin) != null) {
                        integer = (Integer)insertRowAndCount.get(bef_begin);
                        if (bef_Count <= integer) continue;
                        insertRowAndCount.put(bef_begin, bef_Count);
                        groupMap.put(bef_cBegin, bef_Count);
                        continue;
                    }
                    insertRowAndCount.put(bef_begin, bef_Count);
                    groupMap.put(bef_cBegin, bef_Count);
                    continue;
                }
                if (bef_begin != after_begin) continue;
                if (bef_Count > after_Count) {
                    if (isRow) {
                        taskPojo_new.setcBeginRow(after_begin + realCount);
                        taskPojo_new.setcEndRow(after_End + realCount);
                    } else {
                        taskPojo_new.setcBeginCol(after_begin + realCount);
                        taskPojo_new.setcEndCol(after_End + realCount);
                    }
                    if (realCount == 0) {
                        realCount = bef_Count;
                    }
                    if (insertRowAndCount.get(bef_begin) != null) {
                        integer = (Integer)insertRowAndCount.get(bef_begin);
                        if (bef_Count <= integer) continue;
                        insertRowAndCount.put(bef_begin, bef_Count);
                        groupMap.put(bef_cBegin, bef_Count);
                        continue;
                    }
                    insertRowAndCount.put(bef_begin, bef_Count);
                    groupMap.put(bef_cBegin, bef_Count);
                    continue;
                }
                if (bef_Count < after_Count) {
                    if (realCount == 0) {
                        realCount = bef_Count;
                    }
                    if (isRow) {
                        taskPojo.setcBeginRow(bef_cBegin - (bef_Count - after_Count));
                        taskPojo.setcEndRow(bef_cEnd - (bef_Count - after_Count));
                        taskPojo_new.setcBeginRow(after_cbegin + realCount - bef_Count);
                        taskPojo_new.setcEndRow(after_cEnd + realCount - bef_Count);
                    } else {
                        taskPojo.setcBeginCol(bef_cBegin - (bef_Count - after_Count));
                        taskPojo.setcEndCol(bef_cEnd - (bef_Count - after_Count));
                        taskPojo_new.setcBeginCol(after_cbegin + realCount - bef_Count);
                        taskPojo_new.setcEndCol(after_cEnd + realCount - bef_Count);
                    }
                    if (i + 1 == moreTaskPojoMessage.length - 1) {
                        if (isRow) {
                            taskPojo_new.setcBeginRow(after_cbegin + realCount - bef_Count);
                            taskPojo_new.setcEndRow(after_cEnd + realCount - bef_Count);
                        } else {
                            taskPojo_new.setcBeginCol(after_cbegin + realCount - bef_Count);
                            taskPojo_new.setcEndCol(after_cEnd + realCount - bef_Count);
                        }
                    }
                    realCount = realCount + after_Count - bef_Count;
                    insertRowAndCount.put(bef_begin, after_Count);
                    if (isRow) {
                        groupMap.put(taskPojo.getcBeginRow(), after_Count);
                        continue;
                    }
                    groupMap.put(taskPojo.getcBeginCol(), after_Count);
                    continue;
                }
                if (realCount == 0) {
                    realCount = bef_Count;
                }
                if (isRow) {
                    taskPojo_new.setcBeginRow(after_cbegin + realCount - bef_Count);
                    taskPojo_new.setcEndRow(after_cEnd + realCount - bef_Count);
                    continue;
                }
                taskPojo_new.setcBeginCol(after_cbegin + realCount - bef_Count);
                taskPojo_new.setcEndCol(after_cEnd + realCount - bef_Count);
            }
            for (i = insertRowAndCount.size() - 1; i >= 0; --i) {
                int value = (Integer)insertRowAndCount.keySet().toArray()[i];
                this.insertMoreSpaceRow(moresheet, value, (Integer)insertRowAndCount.get(value), isRow);
            }
            this.setBegin(moreTaskPojoMessage, isRow, groupMap);
            this.setCEndRow(groupMap, moreTaskPojoMessage, isRow);
            if (isRow) {
                groupMessage.put("row", groupMap);
                this.bubbleSort(moreTaskPojoMessage, false);
            } else {
                groupMessage.put("col", groupMap);
            }
        }

        private void setBegin(Object[] moreTaskPojoMessage, boolean isRow, Map<Integer, Integer> groupMap) {
            Object[] moreTaskPojoMessage_new = (Object[])moreTaskPojoMessage.clone();
            int begin_bef = 0;
            int cbegin_bef = 0;
            int begin_after = 0;
            int cbegin_after = 0;
            for (int i = 0; i < moreTaskPojoMessage.length; ++i) {
                for (int j = 0; j < moreTaskPojoMessage_new.length; ++j) {
                    if (i == j) continue;
                    if (isRow) {
                        begin_bef = ((TaskPojo)moreTaskPojoMessage[i]).getBeginRow();
                        cbegin_bef = ((TaskPojo)moreTaskPojoMessage[i]).getcBeginRow();
                        begin_after = ((TaskPojo)moreTaskPojoMessage_new[j]).getBeginRow();
                        cbegin_after = ((TaskPojo)moreTaskPojoMessage_new[j]).getcBeginRow();
                    } else {
                        begin_bef = ((TaskPojo)moreTaskPojoMessage[i]).getBeginCol();
                        cbegin_bef = ((TaskPojo)moreTaskPojoMessage[i]).getcBeginCol();
                        begin_after = ((TaskPojo)moreTaskPojoMessage_new[j]).getBeginCol();
                        cbegin_after = ((TaskPojo)moreTaskPojoMessage_new[j]).getcBeginCol();
                    }
                    if (begin_after != begin_bef || cbegin_after == cbegin_bef || cbegin_after <= cbegin_bef) continue;
                    groupMap.remove(cbegin_bef);
                    if (isRow) {
                        ((TaskPojo)moreTaskPojoMessage[i]).setcBeginRow(cbegin_after);
                        ((TaskPojo)moreTaskPojoMessage[i]).setcEndRow(((TaskPojo)moreTaskPojoMessage[i]).getcEndRow() + cbegin_after - cbegin_bef);
                        continue;
                    }
                    ((TaskPojo)moreTaskPojoMessage[i]).setcBeginCol(cbegin_after);
                    ((TaskPojo)moreTaskPojoMessage[i]).setcEndCol(((TaskPojo)moreTaskPojoMessage[i]).getcEndCol() + cbegin_after - cbegin_bef);
                }
            }
        }

        private void setCEndRow(Map<Integer, Integer> groupMessage, Object[] moreTaskPojoMessage, boolean isRow) {
            HashMap<Integer, Integer> groupMessage_new = new HashMap<Integer, Integer>(16);
            groupMessage_new.putAll(groupMessage);
            Object[] moreTaskPojoMessage_new = (Object[])moreTaskPojoMessage.clone();
            int bef_Begin = 0;
            int bef_End = 0;
            int after_begin = 0;
            int after_cbegin = 0;
            for (int i = 0; i < moreTaskPojoMessage.length; ++i) {
                int addRow = 0;
                TaskPojo taskPojo = (TaskPojo)moreTaskPojoMessage[i];
                for (int k = 0; k < moreTaskPojoMessage_new.length; ++k) {
                    if (k <= i) continue;
                    TaskPojo taskPojo_nwe = (TaskPojo)moreTaskPojoMessage_new[k];
                    if (isRow) {
                        bef_Begin = taskPojo.getBeginRow();
                        bef_End = taskPojo.getEndRow();
                        after_begin = taskPojo_nwe.getBeginRow();
                        after_cbegin = taskPojo_nwe.getcBeginRow();
                    } else {
                        bef_Begin = taskPojo.getBeginCol();
                        bef_End = taskPojo.getEndCol();
                        after_begin = taskPojo_nwe.getBeginCol();
                        after_cbegin = taskPojo_nwe.getcBeginCol();
                    }
                    if (bef_Begin == after_begin || bef_End < after_begin || groupMessage_new.get(after_cbegin) == null) continue;
                    addRow = (Integer)groupMessage_new.remove(after_cbegin);
                    if (isRow) {
                        taskPojo.setcEndRow(taskPojo.getcEndRow() + addRow);
                        continue;
                    }
                    taskPojo.setcEndCol(taskPojo.getcEndCol() + addRow);
                }
            }
        }

        public TaskPojo[] getMoreTaskPojoMessage_new(Map<Integer, Map<String, String>> rangeRowDim) {
            TaskPojo[] task = new TaskPojo[rangeRowDim.size()];
            int r = 0;
            for (Map.Entry<Integer, Map<String, String>> range : rangeRowDim.entrySet()) {
                TaskPojo taskPojo;
                Map<String, String> map = rangeRowDim.get(range.getKey());
                List<String> rowDimEntries = this.getMoreRowDim(range.getKey());
                List<String> colDimEntries = this.getMoreColDim(range.getKey());
                String row = map.get("row");
                String col = map.get("col");
                int beginRow = ExportTemplatePlugin.this.getBeginRow(row);
                int endRow = ExportTemplatePlugin.this.getEndRow(row);
                int beginCol = ExportTemplatePlugin.this.getBeginCol(col);
                int endCol = ExportTemplatePlugin.this.getEndCol(col);
                int colSize = colDimEntries.size();
                int rowSize = rowDimEntries.size();
                int cBeginRow = 0;
                int cEndRow = 0;
                int cBeginCol = 0;
                int cEndCol = 0;
                boolean rowCount = false;
                boolean colCount = false;
                cBeginRow = beginRow + colSize;
                cEndRow = endRow + colSize;
                cBeginCol = beginCol + rowSize;
                cEndCol = endCol + rowSize;
                task[r] = taskPojo = new TaskPojo(beginRow, endRow, beginCol, endCol, colSize, rowSize, cBeginRow, cEndRow, cBeginCol, cEndCol, 0, 0);
                ++r;
            }
            return task;
        }

        private void bubbleSort(Object[] arr, boolean isRow) {
            for (int i = 0; i < arr.length; ++i) {
                for (int j = 0; j < arr.length - i - 1; ++j) {
                    int beginrow = 0;
                    int beginrow_other = 0;
                    if (isRow) {
                        beginrow = ((TaskPojo)arr[j]).getBeginRow();
                        beginrow_other = ((TaskPojo)arr[j + 1]).getBeginRow();
                    } else {
                        beginrow = ((TaskPojo)arr[j]).getBeginCol();
                        beginrow_other = ((TaskPojo)arr[j + 1]).getBeginCol();
                    }
                    if (beginrow <= beginrow_other) continue;
                    Object temp = arr[j];
                    arr[j] = arr[j + 1];
                    arr[j + 1] = temp;
                }
            }
        }

        private String getMoreTemplateNumber() {
            if (ExportTemplatePlugin.this.isBcmTemplate()) {
                return this.moreTemplate.getNumber();
            }
            return ExportTemplatePlugin.this.ebTemplateModel.getTemplateBaseInfo().getNumber();
        }

        public List<String> getMoreRowDim(int range) {
            List rowDimEntries = ((AreaRangeEntry)this.moreTemplate.getAreaRangeEntries().get(range)).getRowDimEntries();
            ArrayList<String> dimList = new ArrayList<String>(rowDimEntries.size());
            for (RowDimensionEntry rowDimensionEntry : rowDimEntries) {
                dimList.add(rowDimensionEntry.getDimension().getNumber());
            }
            return dimList;
        }

        public List<String> getMoreColDim(int range) {
            List colDimEntries = ((AreaRangeEntry)this.moreTemplate.getAreaRangeEntries().get(range)).getColDimEntries();
            ArrayList<String> dimList = new ArrayList<String>(colDimEntries.size());
            for (ColDimensionEntry colDimensionEntry : colDimEntries) {
                dimList.add(colDimensionEntry.getDimension().getNumber());
            }
            return dimList;
        }

        private void expandMoreRowAndCol() {
            ExportTemplatePlugin.this.spreadInvoker.expandRowOrColOutlines(1, false, this.j, true);
            ExportTemplatePlugin.this.spreadInvoker.expandRowOrColOutlines(1, false, this.j, false);
        }

        private void updataMoreOtherMessageValue(Map<String, Map<String, String>> dimMemberByModel, Sheet moresheet) {
            Map<String, String> hideMap = this.fillMoreHideDim(null, null, dimMemberByModel);
            Map<String, String> pageMap = this.fillMorePageDim();
            hideMap.putAll(pageMap);
            this.getMoreOtherMessageCell(hideMap);
        }

        private Map<String, String> fillMoreHideDim(XSSFSheet xssfSheet, XSSFWorkbook workBook, Map<String, Map<String, String>> dimMemberByModel) {
            LinkedHashMap<String, String> hideDimMap = new LinkedHashMap<String, String>();
            if (ExportTemplatePlugin.this.isBcm()) {
                List viewPointDimensionEntries = this.moreTemplate.getViewPointDimensionEntries();
                this.putMoreDataToDimMap(viewPointDimensionEntries, hideDimMap, null, null);
            }
            return hideDimMap;
        }

        private void putMoreDataToDimMap(List<ViewPointDimensionEntry> allMembers, Map<String, String> hideDimMap, List<IViewPointDimensionEntry> viewpointmembentry, Map<String, Map<String, String>> dimMemberByModel) {
            if (allMembers != null) {
                for (ViewPointDimensionEntry iDimMember : allMembers) {
                    kd.epm.eb.ebBusiness.template.model.Dimension dimension = iDimMember.getDimension();
                    String key = dimension.getNumber();
                    String value = iDimMember.getMember().getNumber() + "@" + iDimMember.getMember().getName();
                    hideDimMap.put(key, value);
                }
            } else {
                for (IViewPointDimensionEntry iDimMember : viewpointmembentry) {
                    IDimension dimension = iDimMember.getDimension();
                    String key = dimension.getNumber();
                    String value = "";
                    value = dimMemberByModel == null ? iDimMember.getMember().getNumber() + "@" + iDimMember.getMember().getNumber() : iDimMember.getMember().getNumber() + "@" + dimMemberByModel.get(key).get(iDimMember.getMember().getNumber());
                    hideDimMap.put(key, value);
                }
            }
        }

        private Map<String, String> fillMorePageDim() {
            HashMap<String, String> hideDimMap = new HashMap<String, String>(16);
            if (ExportTemplatePlugin.this.isBcmTemplate()) {
                List pageDimensionEntries = this.moreTemplate.getPageDimensionEntries();
                this.putMoreDataToDimMapByCol(pageDimensionEntries, hideDimMap);
            }
            return hideDimMap;
        }

        private void putMoreDataToDimMapByCol(List<PageDimensionEntry> pageDimensionEntries, Map<String, String> hideDimMap) {
            if (pageDimensionEntries != null) {
                for (PageDimensionEntry iDimMember : pageDimensionEntries) {
                    kd.epm.eb.ebBusiness.template.model.Dimension dimension = iDimMember.getDimension();
                    String key = dimension.getNumber();
                    String value = "1@1";
                    hideDimMap.put(key, value);
                }
            }
        }

        public List<ViewPointDimensionEntry> getMoreViewDim() {
            return this.moreTemplate.getViewPointDimensionEntries();
        }

        private int getMoreOtherMessageCount() {
            return this.moreTemplate.getViewPointDimensionEntries().size() + this.moreTemplate.getPageDimensionEntries().size() + 2;
        }

        private void getMoreOtherMessageCell(Map<String, String> hideMap) {
            ArrayList<Map<String, Object>> updataValue = new ArrayList<Map<String, Object>>(16);
            int viewSize = this.moreTemplate.getViewPointDimensionEntries().size();
            int pageSize = this.moreTemplate.getPageDimensionEntries().size();
            for (int i = 2; i < hideMap.size() + 2; ++i) {
                String key = (String)hideMap.keySet().toArray()[i - 2];
                String value = hideMap.get(key);
                String number = "";
                String name = "";
                int index = value.indexOf("@");
                if (index != -1) {
                    number = value.substring(0, index);
                    name = value.substring(index + 1);
                }
                Map memberMap = new HashMap(16);
                if (this.pageDimDomain != null) {
                    memberMap = (Map)this.pageDimDomain.get(key);
                }
                for (int j = 1; j < 4; ++j) {
                    if (j == 1) {
                        updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, key));
                    }
                    if (i < viewSize + 2) {
                        if (j == 2) {
                            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, number));
                        }
                        if (j != 3) continue;
                        updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, name));
                        continue;
                    }
                    if (j == 2) {
                        if (memberMap != null && memberMap.containsKey("memberNumber")) {
                            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, memberMap.get("memberNumber")));
                        } else {
                            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801", (String)"ExportTemplatePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                        }
                    }
                    if (j != 3) continue;
                    if (memberMap != null && memberMap.containsKey("memberName")) {
                        updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, memberMap.get("memberName")));
                        continue;
                    }
                    updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(i, j, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0", (String)"ExportTemplatePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                }
            }
            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(1, 1, "factual"));
            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(1, 2, this.getMoreTemplateType()));
            updataValue.add(ExportTemplatePlugin.this.packedUpdateCellMap(0, 0, "Kingdee"));
            ExportTemplatePlugin.this.spreadInvoker.updateCellValueAddSheet(updataValue, this.j);
            ExportTemplatePlugin.this.setOtherMessageCellStyle(0, 0, 1, 1, "#00EEEE", "1", this.j);
            ExportTemplatePlugin.this.setOtherMessageCellStyle(viewSize + 2, 2, pageSize, 2, "#A9A9A9", "2", this.j);
        }

        private String getMoreTemplateType() {
            int dataunit = 1;
            if (ExportTemplatePlugin.this.isBcm()) {
                if (this.moreTemplate.getDataUnit() == null) {
                    SpreadManager moreSpread = JsonSerializerUtil.toSpreadManager((String)(StringUtils.isNotEmpty((String)this.moreTemplate.getRptData()) ? this.moreTemplate.getRptData() : this.moreTemplate.getData()));
                    dataunit = (Integer)moreSpread.getBook().getSheet(0).getUserObject().get("dataunit");
                } else {
                    dataunit = Integer.parseInt(this.moreTemplate.getDataUnit());
                }
            }
            if (dataunit == DataUnitEnum.YUAN.getIndex()) {
                return "1";
            }
            if (dataunit == DataUnitEnum.THOUSAND.getIndex()) {
                return "1000";
            }
            if (dataunit == DataUnitEnum.TENTHOUSAND.getIndex()) {
                return "10000";
            }
            if (dataunit == DataUnitEnum.MILLIONS.getIndex()) {
                return "1000000";
            }
            if (dataunit == DataUnitEnum.BILLIONS.getIndex()) {
                return "100000000";
            }
            return "1";
        }

        private int insertMoreSpaceRow(Sheet sheet, int rowNumber, int insertCount, boolean isRow) {
            ArrayList<Integer> insertRowNumbers = new ArrayList<Integer>(insertCount);
            for (int j = 0; j < insertCount; ++j) {
                insertRowNumbers.add(rowNumber);
                if (isRow) {
                    sheet.insertRow(rowNumber);
                    continue;
                }
                sheet.insertColumn(rowNumber);
            }
            if (isRow) {
                ExportTemplatePlugin.this.spreadInvoker.insertRowColAddSheet(insertRowNumbers, new ArrayList(16), this.j);
            } else {
                ExportTemplatePlugin.this.spreadInvoker.insertRowColAddSheet(new ArrayList(16), insertRowNumbers, this.j);
            }
            return insertCount;
        }
    }
}

