/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.templateImport;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.templateImport.ExportTemplatePlugin;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TemplateImport
extends AbstractFormPlugin
implements UploadListener {
    private Map<String, String> mertic = new HashMap<String, String>(16);
    private Map<String, Set<String>> noPrem = new HashMap<String, Set<String>>(16);
    private Set<String> PermNotYZ = new HashSet<String>(Lists.newArrayList((Object[])new String[]{"Year", "Period", "Currency", "InternalCompany"}));
    private static final Log log = LogFactory.getLog(ExportTemplatePlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            this.checkUrlData_new();
        }
    }

    private boolean isOverrange() {
        Object radiogroupfield = this.getModel().getValue("radiogroupfield");
        if (radiogroupfield == null || radiogroupfield.toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bfc\u5165\u65b9\u5f0f\u3002", (String)"TemplateImport_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return !"1".equals(radiogroupfield.toString());
    }

    public void checkUrlData_new() {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            if (this.getPageCache().get("file_url") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6570\u636e", (String)"TemplateImport_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            List file_urls = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("file_url"));
            InputStream inputStream = null;
            List<kd.epm.eb.common.model.Dimension> dimension = this.getMoreDimension();
            HashMap<String, Set<String>> hasWritePermDim = new HashMap<String, Set<String>>(16);
            HashMap<String, List<String>> isNotleaf = new HashMap<String, List<String>>(16);
            Map<String, List<String>> dimmemsionByDim = this.getDimmemsionByDim(dimension, hasWritePermDim, isNotleaf);
            boolean overrange = this.isOverrange();
            for (String file_url : file_urls) {
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"TemplateImport_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String[] reqParams = new URL(file_url).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                inputStream = content.getInputStream();
                this.handleInputStream_new(inputStream, isNotleaf, dimmemsionByDim, hasWritePermDim, overrange);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private List<kd.epm.eb.common.model.Dimension> getMoreDimension() {
        ArrayList<kd.epm.eb.common.model.Dimension> dimensionList = new ArrayList<kd.epm.eb.common.model.Dimension>(16);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getMoreModelId()));
        DataSet result = QueryServiceHelper.queryDataSet((String)"EPM", (String)"epm_dimension", (String)"id,name,number,membermodel", (QFilter[])qfBuilder.toArrays(), (String)"");
        for (Row memberRow : result) {
            kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension(memberRow.getLong("id"), memberRow.getString("name"), memberRow.getString("number"));
            dimension.setMemberModel(memberRow.getString("membermodel"));
            dimensionList.add(dimension);
        }
        return dimensionList;
    }

    public boolean isEb() {
        return this.getView().getFormShowParameter().getCustomParam("isEb") != null;
    }

    public void upload(UploadEvent evt) {
        String urles = "";
        ArrayList<String> urls = new ArrayList<String>(10);
        for (Object url : evt.getUrls()) {
            urles = (String)((Map)url).get("url");
            urls.add(urles);
        }
        this.getPageCache().put("file_url", SerializationUtils.serializeToBase64(urls));
    }

    public void remove(UploadEvent evt) {
        String urles = "";
        List urls = null;
        ArrayList<String> new_urls = new ArrayList<String>(10);
        for (Object url : evt.getUrls()) {
            urles = (String)((Map)url).get("url");
            new_urls.add(urles);
        }
        if (this.getPageCache().get("file_url") == null) {
            urls = new ArrayList(16);
        } else {
            urls = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("file_url"));
            for (String value : new_urls) {
                urls.remove(value);
            }
        }
        this.getPageCache().put("file_url", SerializationUtils.serializeToBase64(urls));
    }

    private void handleInputStream_new(InputStream inputStream, Map<String, List<String>> isNotleaf, Map<String, List<String>> dimmemsionByDim, Map<String, Set<String>> hasWritePermDim, boolean overrange) {
        XSSFWorkbook xssFWorkbook = null;
        try {
            try {
                xssFWorkbook = new XSSFWorkbook(inputStream);
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6587\u4ef6\uff0cExcel\u9700\u4e3a2007\u4ee5\u4e0a\u7248\u672c\u3002", (String)"TemplateImport_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            XSSFWorkbook errorOrTipBook = new XSSFWorkbook();
            Map<String, Object> temNumberAndData = this.getTemNumberAndData();
            this.moreDealData(xssFWorkbook, errorOrTipBook, temNumberAndData, isNotleaf, dimmemsionByDim, hasWritePermDim, overrange);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (xssFWorkbook != null) {
                try {
                    xssFWorkbook.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Map<String, Object> getTemNumberAndData() {
        DynamicObject[] dynamicObjects;
        HashMap<String, Object> numberAndData = new HashMap<String, Object>(16);
        String selectFiled = "id,number,data";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getMoreModelId()));
        DynamicObjectCollection dimensionDyObjArray = null;
        ArrayList<Long> list = new ArrayList<Long>(16);
        qfBuilder.add(new QFilter("templatetype", "=", (Object)"0"));
        qfBuilder.add(new QFilter("status", "=", (Object)"1"));
        dimensionDyObjArray = QueryServiceHelper.query((String)"eb_templateentity_bg", (String)selectFiled, (QFilter[])qfBuilder.toArrays());
        for (DynamicObject dynamicObject : dimensionDyObjArray) {
            list.add(dynamicObject.getLong("id"));
        }
        for (DynamicObject doc : dynamicObjects = this.getListTemplateDynamicObject(list)) {
            TemplateModel template = new TemplateModel();
            template.loadDynaObj2Model(doc);
            numberAndData.put(doc.getString("number"), template);
        }
        return numberAndData;
    }

    public DynamicObject[] getListTemplateDynamicObject(List<Long> ids) {
        DynamicObject[] dimensionDyObjArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_templateentity_bg"));
        return dimensionDyObjArray;
    }

    private boolean checkOneCell(XSSFSheet sheet) {
        XSSFCell cell;
        XSSFRow row = sheet.getRow(0);
        return row != null && this.getStringValue((Cell)(cell = row.getCell(0))).equals(ResManager.loadKDString((String)"\u7ef4\u5ea6\u67e5\u8be2\u5bf9\u7167\u8868", (String)"TemplateImport_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void addMer(XSSFSheet firstSheet, XSSFSheet tipSheet) {
        List mergedRegions = firstSheet.getMergedRegions();
        for (CellRangeAddress cellRangeAddress : mergedRegions) {
            tipSheet.addMergedRegion(cellRangeAddress);
        }
    }

    private void saveDataToOlap(List<Map<String, String>> dimlist) {
        EbBatchSave batchSave = EbOlapServiceHelper.getBatchSave();
        SaveCommandInfo saveCommandInfo = null;
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getMoreModelId());
        List dimensions = cacheHelper.getDimensionList();
        ArrayList<String> dimesnionNums = new ArrayList<String>(dimensions.size());
        for (Dimension dimension : dimensions) {
            dimesnionNums.add(dimension.getNumber());
        }
        try {
            for (Map map : dimlist) {
                String value;
                BgData bgData = new BgData(this.getMoreModelId());
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null || ((String)entry.getKey()).equals(FacTabFieldDefEnum.FIELD_MONEY.getField())) continue;
                    bgData.setMember((String)entry.getKey(), (String)entry.getValue());
                }
                if (saveCommandInfo == null) {
                    saveCommandInfo = new SaveCommandInfo();
                    saveCommandInfo.addDimensions(cacheHelper.getModelobj().getDimensionNums());
                    saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                    batchSave.open(this.getMoreModelNumber(), saveCommandInfo);
                }
                if ((value = (String)map.get(FacTabFieldDefEnum.FIELD_MONEY.getField())) == null) continue;
                try {
                    batchSave.add(dimesnionNums, bgData, (Object)new BigDecimal(value));
                }
                catch (Exception ex) {
                    batchSave.add(dimesnionNums, bgData, (Object)value);
                }
            }
            batchSave.flush();
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"OLAP\u4fdd\u5b58\u5931\u8d25\u201c%1\u201d\u3002", (String)"TemplateImport_3", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            batchSave.close();
        }
    }

    private void setDataToErrorOrTipSheet(XSSFSheet firstSheet, XSSFSheet errorSheet, XSSFWorkbook errorBook, boolean isError, List<String> tipMessageList, List<String> errorMessageList) {
        int i;
        int maxColNum = 0;
        int lastRowNum = firstSheet.getLastRowNum();
        for (i = 0; i <= lastRowNum; ++i) {
            XSSFRow row = firstSheet.getRow(i);
            XSSFRow errorRow = errorSheet.createRow(i);
            if (row == null) continue;
            int cellNum = row.getLastCellNum();
            if (cellNum > maxColNum) {
                maxColNum = cellNum;
            }
            for (int j = 0; j <= cellNum; ++j) {
                XSSFCell cell = row.getCell(j);
                XSSFCell errorCell = errorRow.createCell(j + 1);
                try {
                    if (cell == null) {
                        cell = row.createCell(j);
                    }
                    this.copyCell(row, errorCell, j);
                    continue;
                }
                catch (Exception ex) {
                    errorCell.setCellValue("");
                }
            }
        }
        if (isError) {
            this.insertHeadToErrorOrTipSheet(errorSheet, errorBook, null, errorMessageList);
        } else {
            this.insertHeadToErrorOrTipSheet(errorSheet, errorBook, tipMessageList, errorMessageList);
        }
        for (i = 0; i < maxColNum; ++i) {
            errorSheet.setColumnWidth(i, 5000);
        }
    }

    public Long getMoreModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
    }

    public String getMoreModelNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("modelNumber");
    }

    private void insertHeadToErrorOrTipSheet(XSSFSheet errorSheet, XSSFWorkbook errorBook, List<String> tipMessageList, List<String> errorMessageList) {
        for (int i = 0; i < 2; ++i) {
            XSSFCellStyle cellStyle = errorBook.createCellStyle();
            XSSFRow row = errorSheet.getRow(i);
            if (row == null) {
                row = errorSheet.createRow(i);
            }
            XSSFCell cell = row.createCell(0);
            XSSFFont font = errorBook.createFont();
            if (tipMessageList == null) {
                font.setColor((short)10);
                if (i == 0) {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"TemplateImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (i == 1) {
                    cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                    cellStyle.setWrapText(true);
                    cell.setCellValue(errorMessageList.get(0));
                }
            } else {
                font.setColor(IndexedColors.LIGHT_ORANGE.getIndex());
                if (i == 0) {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cell.setCellValue(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"TemplateImport_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (i == 1) {
                    String message = null;
                    cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                    cellStyle.setWrapText(true);
                    for (String tipMessage : tipMessageList) {
                        if (message == null) {
                            message = tipMessage;
                            continue;
                        }
                        message = message + "\r\n" + tipMessage;
                    }
                    cell.setCellValue(message);
                }
            }
            cellStyle.setFont((Font)font);
            cell.setCellStyle((CellStyle)cellStyle);
        }
        CellRangeAddress cellRangeAddress = new CellRangeAddress(1, errorSheet.getLastRowNum(), 0, 0);
        errorSheet.addMergedRegion(cellRangeAddress);
    }

    private void copyCell(XSSFRow row, XSSFCell errorCell, int j) {
        if (row.getCell(j) != null) {
            String stringValue = this.getStringValue((Cell)row.getCell(j));
            errorCell.setCellValue(stringValue);
        }
    }

    private void showMoreErrorOrTipMessage(XSSFWorkbook errorOrTipBook, boolean isError) {
        String message = "";
        String fileName = "";
        if (isError) {
            message = ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519", (String)"TemplateImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            fileName = ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f--\u6570\u636e\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"TemplateImport_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            message = ResManager.loadKDString((String)"\u6570\u636e\u90e8\u5206\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImport_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            fileName = ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f--\u5bfc\u5165\u4e0d\u6210\u529f\u6570\u636e\u8be6\u60c5", (String)"TemplateImport_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        this.getView().showTipNotification(message);
        try {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)TemplateImport.writeFile(errorOrTipBook, fileName));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, List<String>> getDimmemsionByDim(List<kd.epm.eb.common.model.Dimension> dimensions, Map<String, Set<String>> hasWritePermDim, Map<String, List<String>> isNotleaf) {
        HashMap<String, List<String>> dimMember = new HashMap<String, List<String>>(dimensions.size());
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            String selectFiled = "name,number,isleaf";
            ArrayList<String> list = new ArrayList<String>(16);
            ArrayList<String> isNotleafList = new ArrayList<String>(16);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension", "=", (Object)dimension.getId());
            if ("Metric".equals(dimension.getNumber())) {
                selectFiled = selectFiled + ",datatype";
            }
            DataSet result = QueryServiceHelper.queryDataSet((String)"epm", (String)dimension.getMemberModel(), (String)selectFiled, (QFilter[])qfBuilder.toArrays(), (String)"level");
            for (Row memberRow : result) {
                list.add(memberRow.getString("number"));
                if (isNotleaf != null && !memberRow.getBoolean("isleaf").booleanValue()) {
                    isNotleafList.add(memberRow.getString("number"));
                }
                if (!"Metric".equals(dimension.getNumber())) continue;
                this.mertic.put(memberRow.getString("number"), memberRow.getString("datatype"));
            }
            dimMember.put(dimension.getNumber(), list);
            if (isNotleaf != null) {
                isNotleaf.put(dimension.getNumber(), isNotleafList);
            }
            if (hasWritePermDim == null) continue;
            IMemberPermCache build = MemberPermCacheServiceHelper.build((Long)this.getMoreModelId(), (String[])new String[]{dimension.getNumber()});
            Set writePermMems = build.getWritePermMems(dimension.getNumber(), Long.valueOf(0L));
            Set nopermMems = build.getNopermMems(dimension.getNumber(), Long.valueOf(0L));
            if (this.PermNotYZ.contains(dimension.getNumber())) continue;
            if (writePermMems != null) {
                hasWritePermDim.put(dimension.getNumber(), writePermMems);
            }
            if (nopermMems == null) continue;
            this.noPrem.put(dimension.getNumber(), nopermMems);
        }
        return dimMember;
    }

    private List<String> getDataRnage(XSSFSheet firstSheet) {
        LinkedList<String> dataRange = new LinkedList<String>();
        for (int i = 1; i < firstSheet.getLastRowNum(); ++i) {
            String value;
            XSSFRow row = firstSheet.getRow(i);
            XSSFCell cell = null;
            if (row == null) break;
            cell = row.getCell(0);
            if (cell == null || (value = this.getStringValue((Cell)cell)).isEmpty() || !value.contains(":")) continue;
            dataRange.add(value);
        }
        return dataRange;
    }

    private boolean isNull(XSSFRow row, int i, List<String> errorMessageList) {
        errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7b2c%2\u5217\u7684\u503c\u4e3a\u7a7a\u3002", (String)"TemplateImport_23", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getRowNum() + 1, i + 1}));
        return false;
    }

    public boolean checkDim(XSSFRow row, Map<String, String> pageAndViewDimensions, int i, List<String> errorMessageList) {
        String stringValue = this.getStringValue((Cell)row.getCell(i));
        if (!pageAndViewDimensions.containsKey(stringValue)) {
            errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c\u201c%1\u201d\u884c\u7b2c\u201c%2\u201d\u5217\u7684\u7ef4\u5ea6\u5728\u8be5\u6a21\u677f\u7684\u9875\u9762\u7ef4\u6216\u8005\u8be5\u4f53\u7cfb\u5185\u4e0d\u5b58\u5728\u3002", (String)"TemplateImport_24", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getRowNum() + 1, i + 1}));
            return false;
        }
        pageAndViewDimensions.remove(row.getCell(i).getStringCellValue());
        return true;
    }

    public String getStringValue(Cell cell) {
        String value = null;
        switch (cell.getCellType()) {
            case NUMERIC: {
                value = cell.getNumericCellValue() + "";
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    if (date != null) {
                        value = new SimpleDateFormat("yyyy-MM-dd").format(date);
                        break;
                    }
                    value = "";
                    break;
                }
                value = new DecimalFormat("0").format(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                value = value.replace(" ", "");
                value = value.replace("\n", "");
                value = value.replace("\t", "");
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula() + "";
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = ResManager.loadKDString((String)"\u975e\u6cd5\u5b57\u7b26", (String)"TemplateImport_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                value = ResManager.loadKDString((String)"\u672a\u77e5\u7c7b\u578b", (String)"TemplateImport_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return value;
    }

    private boolean checkKingdee(XSSFRow row, List<String> errorMessageList) {
        String stringValue = this.getStringValue((Cell)row.getCell(0));
        if (stringValue == null || !"kingdee".equals(stringValue.toLowerCase(Locale.getDefault()))) {
            errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u7b2c1\u5217\u4e0d\u5b58\u5728kingdee\u5173\u952e\u5b57\u3002", (String)"TemplateImport_32", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getRowNum() + 1}));
            return false;
        }
        return true;
    }

    public void putDimenmemsionToMap(List<IDimension> dimensions, Map<String, String> numberAndNameMap) {
        for (IDimension iDimension : dimensions) {
            numberAndNameMap.put(iDimension.getNumber(), iDimension.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(XSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public int getFirstNumIndex(String value) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return i;
        }
        return 0;
    }

    public static int excelColStrToNum(String column) {
        int num = 0;
        int result = 0;
        int length = column.length();
        for (int i = 0; i < length; ++i) {
            char ch = column.charAt(length - i - 1);
            num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moreDealData(XSSFWorkbook xssFWorkbook, XSSFWorkbook errorOrTipBook, Map<String, Object> temNumberAndData, Map<String, List<String>> isNotleaf, Map<String, List<String>> dimmemsionByDim, Map<String, Set<String>> hasWritePermDim, boolean overrange) {
        int numberOfSheets = xssFWorkbook.getNumberOfSheets();
        if (numberOfSheets > 101) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u5c11\u4e8e100\u4e2a\u9875\u7b7e\u7684excel\u8868\u3002", (String)"TemplateImport_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RequestContext context = RequestContextCreator.createForThreadPool();
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() + 1, 50L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        poolExecutor.allowCoreThreadTimeOut(true);
        ExecutorService es = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)poolExecutor);
        CountDownLatch count = new CountDownLatch(numberOfSheets);
        int i = 0;
        for (XSSFSheet sheet : xssFWorkbook) {
            block8: {
                String sheetName = "";
                sheetName = sheet.getSheetName().length() > 31 ? sheet.getSheetName().substring(0, 29) + i : sheet.getSheetName();
                errorOrTipBook.createSheet(sheetName);
                Future<?> submit = es.submit(new BuildData(count, context, sheet, errorOrTipBook, temNumberAndData, isNotleaf, dimmemsionByDim, sheetName, hasWritePermDim, overrange));
                try {
                    if (submit.get() != null) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    XSSFSheet sheet_error = errorOrTipBook.getSheet(sheetName);
                    if (sheet_error.getRow(0) != null) break block8;
                    XSSFRow row = sheet_error.createRow(0);
                    XSSFCell cell = row.createCell(0);
                    cell.setCellValue(e.getCause().getMessage());
                }
            }
            ++i;
        }
        try {
            count.await();
        }
        catch (InterruptedException ex) {
            log.error("budget-data-log : ", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        this.removeSheet(errorOrTipBook);
        if (errorOrTipBook.getNumberOfSheets() != 0) {
            this.showMoreErrorOrTipMessage(errorOrTipBook, true);
            return;
        }
        this.getView().getParentView().setReturnData((Object)"success");
        this.getView().returnDataToParent((Object)"success");
        this.getView().setReturnData((Object)"success");
        this.getView().close();
    }

    private void removeSheet(XSSFWorkbook errorOrTipBook) {
        for (int i = 0; i < errorOrTipBook.getNumberOfSheets(); ++i) {
            XSSFSheet sheetAt = errorOrTipBook.getSheetAt(i);
            XSSFRow row = sheetAt.getRow(0);
            if (row != null) continue;
            errorOrTipBook.removeSheetAt(i);
            this.removeSheet(errorOrTipBook);
        }
    }

    class BuildData
    implements Runnable {
        private CountDownLatch count = null;
        private RequestContext context = null;
        private XSSFSheet moreSheet;
        private XSSFWorkbook errorOrTipBook;
        private Map<String, Object> temNumberAndData;
        private TemplateModel moreTemplate;
        private Map<String, List<String>> isNotleaf;
        private Map<String, List<String>> dimmemsionByDim_old;
        private Map<String, List<String>> dimmemsionByDim = new HashMap<String, List<String>>(16);
        private int moreColNum;
        private int moredataunit;
        private String sheetName;
        private final Map<String, Set<String>> hasWritePermDim;
        private boolean isNum = true;
        private boolean overrange;

        public BuildData(CountDownLatch count, RequestContext context, XSSFSheet sheet, XSSFWorkbook errorOrTipBook, Map<String, Object> temNumberAndData, Map<String, List<String>> isNotleaf, Map<String, List<String>> dimmemsionByDim, String sheetName, Map<String, Set<String>> hasWritePermDim, boolean overrange) {
            this.count = count;
            this.context = context;
            this.moreSheet = sheet;
            this.errorOrTipBook = errorOrTipBook;
            this.temNumberAndData = temNumberAndData;
            this.isNotleaf = isNotleaf;
            this.dimmemsionByDim_old = dimmemsionByDim;
            this.sheetName = sheetName;
            this.hasWritePermDim = hasWritePermDim;
            this.overrange = overrange;
        }

        @Override
        public void run() {
            String threadId = this.toString();
            long begin = System.nanoTime();
            log.info("begin insertexcel- " + threadId);
            try {
                this.build();
            }
            catch (Throwable ex) {
                log.error("buildData error:", ex);
                throw ex;
            }
            finally {
                this.count.countDown();
                long use = System.nanoTime() - begin;
                log.info("end save data - " + threadId + "; use = " + TimeUnit.NANOSECONDS.toMillis(use));
            }
        }

        protected void build() {
            RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
            ArrayList<String> errorMessageList = new ArrayList<String>(1);
            if (TemplateImport.this.checkOneCell(this.moreSheet)) {
                return;
            }
            HashMap<String, String> dimAndDimmemberMap = new HashMap<String, String>(16);
            HashMap<String, Map<Integer, String>> colAndRowDimMap = new HashMap<String, Map<Integer, String>>(16);
            if (this.getTemplateModel(this.temNumberAndData, errorMessageList)) {
                this.checkMoreData(this.moreSheet, dimAndDimmemberMap, errorMessageList, colAndRowDimMap);
            }
            if (errorMessageList.size() != 0) {
                XSSFSheet errorSheet = this.errorOrTipBook.getSheet(this.sheetName);
                TemplateImport.this.setDataToErrorOrTipSheet(this.moreSheet, errorSheet, this.errorOrTipBook, true, null, errorMessageList);
            } else {
                XSSFSheet errorSheet = this.errorOrTipBook.getSheet(this.sheetName);
                ArrayList<String> tipMessageList = new ArrayList<String>(16);
                List<Map<String, String>> moreListMapToSheet = this.getMoreListMapToSheet(dimAndDimmemberMap, this.moreSheet, tipMessageList, colAndRowDimMap);
                TemplateImport.this.saveDataToOlap(moreListMapToSheet);
                if (tipMessageList.size() != 0) {
                    TemplateImport.this.setDataToErrorOrTipSheet(this.moreSheet, errorSheet, this.errorOrTipBook, false, tipMessageList, errorMessageList);
                    TemplateImport.this.addMer(this.moreSheet, errorSheet);
                }
            }
        }

        private List<Map<String, String>> getMoreListMapToSheet(Map<String, String> dimAndDimmemberMap, XSSFSheet firstSheet, List<String> tipMessageList, Map<String, Map<Integer, String>> colAndRowDimMap_new) {
            ArrayList<Map<String, String>> colAndRowDimMap = new ArrayList<Map<String, String>>(16);
            this.addMoreBcmDimToMap(colAndRowDimMap, firstSheet, dimAndDimmemberMap, this.dimmemsionByDim, this.hasWritePermDim, tipMessageList, this.isNotleaf, colAndRowDimMap_new);
            return colAndRowDimMap;
        }

        public boolean checkDimMember(XSSFRow row, Map<String, List<String>> dimmemsionByDim, int i, int dimCol, boolean isCol, XSSFSheet firstSheet, Map<String, List<String>> isNotleaf, List<String> errorMessageList) {
            if (row.getCell(i) != null) {
                String stringValue = TemplateImport.this.getStringValue((Cell)row.getCell(i));
                if (stringValue.isEmpty() && i == row.getLastCellNum() - 1) {
                    return true;
                }
                List<String> list = dimmemsionByDim.get(TemplateImport.this.getStringValue((Cell)row.getCell(dimCol)));
                if (isCol) {
                    XSSFRow rowDim = firstSheet.getRow(0);
                    list = dimmemsionByDim.get(TemplateImport.this.getStringValue((Cell)rowDim.getCell(i)));
                }
                if (!list.contains(stringValue)) {
                    errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7b2c%2\u5217\u7684\u7ef4\u5ea6\u6210\u5458\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TemplateImport_39", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getRowNum() + 1, i + 1}));
                    return false;
                }
                String dim = TemplateImport.this.getStringValue((Cell)row.getCell(dimCol));
                if (isNotleaf != null && isNotleaf.get(dim).contains(stringValue)) {
                    errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7b2c%2\u5217\u7684\u7ef4\u5ea6\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"TemplateImport_26", (String)"epm-eb-formplugin", (Object[])new Object[]{row.getRowNum() + 1, i + 1}));
                    return false;
                }
                if (!TemplateImport.this.isEb() && "Metric".equals(row.getCell(dimCol).toString())) {
                    boolean b;
                    this.isNum = b = this.checkMetric(stringValue);
                }
                if (TemplateImport.this.noPrem.get(dim) != null && ((Set)TemplateImport.this.noPrem.get(dim)).contains(stringValue)) {
                    errorMessageList.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u6ca1\u6709\u76f8\u5173\u7684\u6743\u9650\u3002", (String)"TemplateImport_38", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, stringValue}));
                    return false;
                }
                if (this.hasWritePermDim.get(dim) != null && !this.hasWritePermDim.get(dim).contains(stringValue)) {
                    errorMessageList.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u6ca1\u6709\u5199\u7684\u6743\u9650\u3002", (String)"TemplateImport_47", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, stringValue}));
                    return false;
                }
                dimmemsionByDim.remove(TemplateImport.this.getStringValue((Cell)row.getCell(dimCol)));
            }
            return true;
        }

        private boolean checkMetric(String stringValue) {
            return !((String)TemplateImport.this.mertic.get(stringValue)).equals(MetricDataTypeEnum.DATE.getIndex()) && !((String)TemplateImport.this.mertic.get(stringValue)).equals(MetricDataTypeEnum.ENUM.getIndex()) && !((String)TemplateImport.this.mertic.get(stringValue)).equals(MetricDataTypeEnum.RATE.getIndex()) && !((String)TemplateImport.this.mertic.get(stringValue)).equals(MetricDataTypeEnum.TEXT.getIndex());
        }

        private void addMoreBcmDimToMap(List<Map<String, String>> colAndRowDimMap, XSSFSheet firstSheet, Map<String, String> dimAndDimmemberMap, Map<String, List<String>> dimmemsionByDim, Map<String, Set<String>> hasWritePermDim, List<String> tipMessageList, Map<String, List<String>> isNotleaf, Map<String, Map<Integer, String>> colAndRowDimMap_new) {
            List dataRnage = TemplateImport.this.getDataRnage(firstSheet);
            int r = 0;
            int startRow = 0;
            int startCol = 0;
            int endRow = 0;
            int endCol = 0;
            int templateAreaRangeEntrySize = this.moreTemplate.getAreaRangeEntries().size();
            BigDecimal moredataunit_big = new BigDecimal(this.moredataunit);
            for (String value : dataRnage) {
                if (r >= templateAreaRangeEntrySize) break;
                int rowSize = ((AreaRangeEntry)this.moreTemplate.getAreaRangeEntries().get(r)).getRowDimEntries().size();
                int colSize = ((AreaRangeEntry)this.moreTemplate.getAreaRangeEntries().get(r)).getColDimEntries().size();
                String start = value.substring(0, value.indexOf(":"));
                String end = value.substring(value.indexOf(":") + 1);
                int firstStartNumIndex = TemplateImport.this.getFirstNumIndex(start);
                startRow = Integer.parseInt(start.substring(0, firstStartNumIndex));
                startCol = TemplateImport.excelColStrToNum(start.substring(firstStartNumIndex));
                int firstEndNumIndex = TemplateImport.this.getFirstNumIndex(end);
                endRow = Integer.parseInt(end.substring(0, firstEndNumIndex));
                endCol = TemplateImport.excelColStrToNum(end.substring(firstEndNumIndex));
                block3: for (int i = startRow - 1; i < endRow; ++i) {
                    XSSFRow row = firstSheet.getRow(i);
                    if (row == null) continue;
                    for (int j = startCol - 1; j < endCol; ++j) {
                        String dimMem;
                        String dim;
                        boolean isPerm = true;
                        boolean isNext = true;
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        XSSFCell cell = row.getCell(j);
                        if (!this.overrange && (cell == null || TemplateImport.this.getStringValue((Cell)cell).isEmpty())) continue;
                        if (cell == null) {
                            XSSFCell cell_null = row.createCell(j);
                            cell_null.setCellValue("0");
                        }
                        if (cell != null && TemplateImport.this.getStringValue((Cell)cell).isEmpty()) {
                            cell.setCellValue("0");
                        }
                        boolean isNeed = true;
                        for (int k = 1; k <= colSize; ++k) {
                            XSSFRow dim_row = firstSheet.getRow(startRow - k - 1);
                            dim = colAndRowDimMap_new.get(r + "row").get(startRow - k - 1);
                            if (dim_row.getCell(j) == null) {
                                isNext = false;
                                break;
                            }
                            dimMem = TemplateImport.this.getStringValue((Cell)dim_row.getCell(j));
                            if (dim.equals("Metric") && !this.checkMetric(dimMem)) {
                                isNeed = false;
                            }
                            if (!dimmemsionByDim.get(dim).contains(dimMem)) {
                                isNext = false;
                                break;
                            }
                            if (isNotleaf.get(dim).contains(dimMem)) {
                                isPerm = false;
                                break;
                            }
                            if (TemplateImport.this.noPrem.get(dim) != null && ((Set)TemplateImport.this.noPrem.get(dim)).contains(dimMem)) {
                                isNext = false;
                                tipMessageList.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u6ca1\u6709\u76f8\u5173\u7684\u6743\u9650\u3002", (String)"TemplateImport_38", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, dimMem}));
                                break;
                            }
                            if (hasWritePermDim.get(dim) != null && !hasWritePermDim.get(dim).contains(dimMem)) {
                                isNext = false;
                                tipMessageList.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u6ca1\u6709\u5199\u7684\u6743\u9650\u3002", (String)"TemplateImport_47", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, dimMem}));
                                break;
                            }
                            map.put(dim, dimMem);
                        }
                        if (!isNext || !isPerm) continue;
                        for (int c = 1; c <= rowSize; ++c) {
                            XSSFCell dimmem_cell = row.getCell(startCol - c - 1);
                            if (dimmem_cell == null) {
                                isNext = false;
                                break;
                            }
                            dim = colAndRowDimMap_new.get(r + "col").get(startCol - c - 1);
                            dimMem = TemplateImport.this.getStringValue((Cell)dimmem_cell);
                            if (!dimmemsionByDim.get(dim).contains(dimMem)) {
                                isNext = false;
                                break;
                            }
                            if (dim.equals("Metric") && !this.checkMetric(dimMem)) {
                                isNeed = false;
                            }
                            if (isNotleaf.get(dim).contains(dimMem)) {
                                isNext = false;
                                break;
                            }
                            if (TemplateImport.this.noPrem.get(dim) != null && ((Set)TemplateImport.this.noPrem.get(dim)).contains(dimMem)) {
                                isNext = false;
                                tipMessageList.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u6ca1\u6709\u76f8\u5173\u7684\u6743\u9650\u3002", (String)"TemplateImport_38", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, dimMem}));
                                break;
                            }
                            if (hasWritePermDim.get(dim) != null && !hasWritePermDim.get(dim).contains(dimMem)) {
                                isNext = false;
                                tipMessageList.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u6ca1\u6709\u5199\u7684\u6743\u9650\u3002", (String)"TemplateImport_47", (String)"epm-eb-formplugin", (Object[])new Object[]{dim, dimMem}));
                                break;
                            }
                            map.put(dim, dimMem);
                        }
                        if (!isNext) continue block3;
                        try {
                            if (this.isNum) {
                                if (isNeed) {
                                    String value_num = "";
                                    value_num = row.getCell(j).getCellType().equals((Object)CellType.NUMERIC) && !DateUtil.isCellDateFormatted((Cell)row.getCell(j)) ? new DecimalFormat("0.000").format(row.getCell(j).getNumericCellValue()) : TemplateImport.this.getStringValue((Cell)row.getCell(j));
                                    BigDecimal bigDecimal = new BigDecimal(value_num);
                                    BigDecimal multiply = bigDecimal.multiply(moredataunit_big);
                                    map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), multiply.toPlainString());
                                } else {
                                    map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), TemplateImport.this.getStringValue((Cell)row.getCell(j)));
                                }
                            } else {
                                map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), TemplateImport.this.getStringValue((Cell)row.getCell(j)));
                            }
                        }
                        catch (Exception ex) {
                            isPerm = false;
                        }
                        if (!isPerm) continue;
                        map.putAll(dimAndDimmemberMap);
                        colAndRowDimMap.add(map);
                    }
                }
                ++r;
            }
        }

        private boolean getTemplateModel(Map<String, Object> temNumberAndData, List<String> errorMessageList) {
            boolean isNext = true;
            XSSFRow row = this.moreSheet.getRow(0);
            if (row != null) {
                XSSFCell cell = row.getCell(1);
                if (cell != null) {
                    String stringValue = TemplateImport.this.getStringValue((Cell)cell);
                    if (stringValue.isEmpty() || !temNumberAndData.containsKey(stringValue)) {
                        errorMessageList.add(ResManager.loadKDString((String)"\u7b2c1\u884c\u7b2c2\u5217\u5728\u8be5\u4f53\u7cfb\u5185\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u6a21\u677f\u3002", (String)"TemplateImport_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isNext = false;
                    }
                    if (isNext) {
                        this.moreTemplate = (TemplateModel)temNumberAndData.get(stringValue);
                    }
                } else {
                    errorMessageList.add(ResManager.loadKDString((String)"\u7b2c1\u884c\u7b2c2\u5217\u5728\u8be5\u4f53\u7cfb\u5185\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u6a21\u677f\u3002", (String)"TemplateImport_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isNext = false;
                }
            } else {
                errorMessageList.add(ResManager.loadKDString((String)"\u7b2c1\u884c\u7b2c1\u5217\u4e0d\u5b58\u5728Kingdee\u5173\u952e\u5b57\u3002", (String)"TemplateImport_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                isNext = false;
            }
            return isNext;
        }

        private Map<String, String> getMorePageAndViewDimensions() {
            HashMap<String, String> numberAndNameMap = new HashMap<String, String>(16);
            List pageDimensionEntries = this.moreTemplate.getPageDimensionEntries();
            List viewPointDimensionEntries = this.moreTemplate.getViewPointDimensionEntries();
            this.putMorePageDimenmemsionToMap(pageDimensionEntries, numberAndNameMap);
            this.putMoreViewDimenmemsionToMap(viewPointDimensionEntries, numberAndNameMap);
            return numberAndNameMap;
        }

        public void putMorePageDimenmemsionToMap(List<PageDimensionEntry> pageDimensionEntries, Map<String, String> numberAndNameMap) {
            for (PageDimensionEntry pageDimensionEntry : pageDimensionEntries) {
                numberAndNameMap.put(pageDimensionEntry.getDimension().getNumber(), pageDimensionEntry.getDimension().getName());
            }
        }

        public void putMoreViewDimenmemsionToMap(List<ViewPointDimensionEntry> viewPointDimensionEntries, Map<String, String> numberAndNameMap) {
            for (ViewPointDimensionEntry viewPointDimensionEntry : viewPointDimensionEntries) {
                numberAndNameMap.put(viewPointDimensionEntry.getDimension().getNumber(), viewPointDimensionEntry.getDimension().getName());
            }
        }

        private List<String> getMoreColDim(List<kd.epm.eb.spread.template.dimension.IDimension> coldimensions) {
            ArrayList<String> list = new ArrayList<String>(coldimensions.size());
            for (kd.epm.eb.spread.template.dimension.IDimension iDimension : coldimensions) {
                list.add(iDimension.getNumber());
            }
            return list;
        }

        private void checkMoreData(XSSFSheet firstSheet, Map<String, String> dimAndDimmemberMap, List<String> errorMessageList, Map<String, Map<Integer, String>> colAndRowDimMap) {
            int i = 0;
            boolean isNext = true;
            Map<String, String> pageAndViewDimensions = this.getMorePageAndViewDimensions();
            Object colDimension = null;
            Object rowDimension = null;
            boolean rowDimensionSize = false;
            boolean colSize = false;
            this.dimmemsionByDim.putAll(this.dimmemsionByDim_old);
            int pageAndViewDimensionSize = pageAndViewDimensions.size();
            List dataRnage = null;
            if (!TemplateImport.this.isEb()) {
                dataRnage = TemplateImport.this.getDataRnage(firstSheet);
            }
            do {
                XSSFRow row = firstSheet.getRow(i);
                if (i == 0) {
                    isNext = TemplateImport.this.checkKingdee(row, errorMessageList);
                } else if (i == 1) {
                    isNext = this.checkMoreFactual(row, errorMessageList);
                } else if (i >= 2 && i < pageAndViewDimensionSize + 2) {
                    isNext = this.checkMorePageAndViewDimensions(row, pageAndViewDimensions, dimAndDimmemberMap, errorMessageList);
                } else if (i != pageAndViewDimensionSize + 2 && i > pageAndViewDimensionSize + 2) {
                    isNext = this.checkMoreBcmRowAndColDim(dataRnage, firstSheet, this.dimmemsionByDim, errorMessageList, colAndRowDimMap);
                    break;
                }
                ++i;
            } while (isNext);
        }

        private boolean checkMorePageAndViewDimensions(XSSFRow row, Map<String, String> pageAndViewDimensions, Map<String, String> dimAndDimmemberMap, List<String> errorMessageList) {
            boolean isNext = true;
            for (int i = this.moreColNum; i < this.moreColNum + 2 && isNext; ++i) {
                if (row.getCell(i) != null) {
                    if (i == this.moreColNum) {
                        isNext = TemplateImport.this.checkDim(row, pageAndViewDimensions, i, errorMessageList);
                        continue;
                    }
                    if (i != this.moreColNum + 1) continue;
                    isNext = this.checkDimMember(row, this.dimmemsionByDim, i, i - 1, false, null, this.isNotleaf, errorMessageList);
                    dimAndDimmemberMap.put(TemplateImport.this.getStringValue((Cell)row.getCell(i - 1)), TemplateImport.this.getStringValue((Cell)row.getCell(i)));
                    continue;
                }
                isNext = TemplateImport.this.isNull(row, i, errorMessageList);
            }
            return isNext;
        }

        private boolean checkMoreFactual(XSSFRow row, List<String> errorMessageList) {
            boolean isTrue;
            block11: {
                isTrue = false;
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    String stringValue;
                    XSSFCell cell = row.getCell(i);
                    if (cell == null || (stringValue = TemplateImport.this.getStringValue((Cell)cell)) == null || !"factual".equals(stringValue.toLowerCase(Locale.getDefault()))) continue;
                    this.moreColNum = i;
                    isTrue = true;
                    break;
                }
                if (isTrue) {
                    XSSFCell cell = row.getCell(this.moreColNum + 1);
                    if (cell != null) {
                        if (!CellType.NUMERIC.equals((Object)cell.getCellType())) {
                            if (CellType.STRING.equals((Object)cell.getCellType())) {
                                try {
                                    int cellNum = Integer.parseInt(cell.getStringCellValue());
                                    if (cellNum % 10 == 0) {
                                        this.moredataunit = cellNum;
                                        break block11;
                                    }
                                    this.moredataunit = 1;
                                }
                                catch (Exception e) {
                                    isTrue = false;
                                    errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c2\u884c\u7b2c%1\u5217\u8bf7\u586b\u5199\u6570\u5b57\u3002", (String)"TemplateImport_30", (String)"epm-eb-formplugin", (Object[])new Object[]{this.moreColNum + 1}));
                                }
                            }
                        } else {
                            double numericCellValue = cell.getNumericCellValue();
                            this.moredataunit = numericCellValue % 10.0 == 0.0 ? (int)numericCellValue : 1;
                        }
                    } else {
                        this.moredataunit = 1;
                    }
                } else {
                    errorMessageList.add(ResManager.loadKDString((String)"\u7b2c2\u884c\u4e0d\u5b58\u5728\u5173\u952e\u5b57factual", (String)"TemplateImport_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            return isTrue;
        }

        private boolean checkMoreBcmRowAndColDim(List<String> dataRnage, XSSFSheet firstSheet, Map<String, List<String>> dimmemsionByDim, List<String> errorMessageList, Map<String, Map<Integer, String>> colAndRowDimMap) {
            boolean isNext = true;
            int i = 0;
            int startRow = 0;
            int startCol = 0;
            int endRow = 0;
            int endCol = 0;
            for (String value : dataRnage) {
                Map dimmemsionByDim_clone = (Map)SerializationUtils.deSerializeFromBase64((String)SerializationUtils.serializeToBase64(dimmemsionByDim));
                if (isNext) {
                    try {
                        String start = value.substring(0, value.indexOf(":"));
                        String end = value.substring(value.indexOf(":") + 1);
                        int firstStartNumIndex = TemplateImport.this.getFirstNumIndex(start);
                        startRow = Integer.parseInt(start.substring(0, firstStartNumIndex));
                        startCol = TemplateImport.excelColStrToNum(start.substring(firstStartNumIndex));
                        int firstEndNumIndex = TemplateImport.this.getFirstNumIndex(end);
                        endRow = Integer.parseInt(end.substring(0, firstEndNumIndex));
                        endCol = TemplateImport.excelColStrToNum(end.substring(firstEndNumIndex));
                    }
                    catch (Exception e) {
                        errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u533a\u57df\u8303\u56f4\u586b\u5199\u9519\u8bef\u3002", (String)"TemplateImport_19", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 2}));
                        return isNext;
                    }
                    isNext = this.checkMoreBcmRowDim(startRow, startCol, firstSheet, i, dimmemsionByDim_clone, errorMessageList, endCol, colAndRowDimMap);
                    if (isNext) {
                        isNext = this.checkMoreBcmColDim(startRow, startCol, firstSheet, i, dimmemsionByDim_clone, errorMessageList, endRow, colAndRowDimMap);
                    }
                    ++i;
                    continue;
                }
                return isNext;
            }
            return isNext;
        }

        private boolean checkMoreBcmColDim(int startRow, int startCol, XSSFSheet firstSheet, int k, Map<String, List<String>> dimmemsionByDim, List<String> errorMessageList, int endRow, Map<String, Map<Integer, String>> colAndRowDimMap) {
            boolean isNext = true;
            if (this.moreTemplate == null || this.moreTemplate.getAreaRangeEntries() == null || k >= this.moreTemplate.getAreaRangeEntries().size()) {
                return isNext;
            }
            List rowDimEntries = ((AreaRangeEntry)this.moreTemplate.getAreaRangeEntries().get(k)).getRowDimEntries();
            HashMap<Integer, String> colAndDim = new HashMap<Integer, String>(16);
            for (int i = startCol - rowDimEntries.size() - 1; i < startCol - 1; ++i) {
                if (isNext) {
                    for (int j = startRow - 1; j <= endRow - 1; ++j) {
                        XSSFRow row = firstSheet.getRow(j);
                        boolean isPut = true;
                        XSSFCell cell = row.getCell(i);
                        if (cell != null) {
                            String stringValue = TemplateImport.this.getStringValue((Cell)cell);
                            for (RowDimensionEntry rowDimensionEntry : rowDimEntries) {
                                List<String> strings = dimmemsionByDim.get(rowDimensionEntry.getDimension().getNumber());
                                if (strings != null && strings.contains(stringValue)) {
                                    colAndDim.put(i, rowDimensionEntry.getDimension().getNumber());
                                    isPut = false;
                                }
                                if (isPut) continue;
                                break;
                            }
                        }
                        if (isPut) continue;
                        dimmemsionByDim.remove(colAndDim.get(i));
                        colAndRowDimMap.put(k + "col", colAndDim);
                        break;
                    }
                }
                if (colAndRowDimMap.get(k + "col") != null) continue;
                errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u5217\u7b2c%2\u6570\u636e\u533a\u57df\u4e0d\u5b58\u5728\u4f53\u7cfb\u76f8\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u3002", (String)"TemplateImport_43", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, k + 1}));
                isNext = false;
            }
            return isNext;
        }

        private boolean checkMoreBcmRowDim(int startRow, int startCol, XSSFSheet firstSheet, int k, Map<String, List<String>> dimmemsionByDim, List<String> errorMessageList, int endCol, Map<String, Map<Integer, String>> colAndRowDimMap) {
            boolean isNext = true;
            if (this.moreTemplate == null || this.moreTemplate.getAreaRangeEntries() == null || k >= this.moreTemplate.getAreaRangeEntries().size()) {
                return isNext;
            }
            List colDimEntries = ((AreaRangeEntry)this.moreTemplate.getAreaRangeEntries().get(k)).getColDimEntries();
            HashMap<Integer, String> rowAndDim = new HashMap<Integer, String>(16);
            for (int i = startRow - colDimEntries.size() - 1; i < startRow - 1; ++i) {
                XSSFRow row = firstSheet.getRow(i);
                if (row == null) {
                    errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0d\u5b58\u5728\u4f53\u7cfb\u76f8\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f,\u8bf7\u68c0\u67e5\u6570\u636e\u533a\u57df\u6216\u76f8\u5e94\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"TemplateImport_44", (String)"epm-eb-formplugin", (Object[])new Object[]{i}));
                    isNext = false;
                    return isNext;
                }
                for (int j = startCol - 1; j <= endCol - 1; ++j) {
                    boolean isPut = true;
                    XSSFCell cell = row.getCell(j);
                    if (cell != null) {
                        String stringValue = TemplateImport.this.getStringValue((Cell)cell);
                        for (ColDimensionEntry colDimensionEntry : colDimEntries) {
                            List<String> strings = dimmemsionByDim.get(colDimensionEntry.getDimension().getNumber());
                            if (strings != null && strings.contains(stringValue)) {
                                rowAndDim.put(i, colDimensionEntry.getDimension().getNumber());
                                isPut = false;
                            }
                            if (isPut) continue;
                            break;
                        }
                    }
                    if (isPut) continue;
                    dimmemsionByDim.remove(rowAndDim.get(i));
                    colAndRowDimMap.put(k + "row", rowAndDim);
                    break;
                }
                if (colAndRowDimMap.get(k + "row") != null) continue;
                errorMessageList.add(ResManager.loadResFormat((String)"\u7b2c%1\u5217\u7b2c%2\u6570\u636e\u533a\u57df\u4e0d\u5b58\u5728\u4f53\u7cfb\u76f8\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u3002", (String)"TemplateImport_43", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, k + 1}));
                isNext = false;
                return isNext;
            }
            return isNext;
        }
    }
}

