/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.templateperm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.templateperm.TemplatePermQueryUtil;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.templateperm.EntityTypeEnum;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.UserTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class UserTemplatePermListDataPlugin
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filter = reportQueryParam.getFilter();
        QFBuilder qfBuilder = new QFBuilder();
        HashMap<Long, BasedataPojo> baseDataMap = new HashMap<Long, BasedataPojo>(16);
        this.addModelQFilter(qfBuilder, filter, baseDataMap);
        HashMap<Long, List<Long>> usrGroupMap = new HashMap<Long, List<Long>>(16);
        this.addUserQFilter(qfBuilder, filter, usrGroupMap, baseDataMap);
        this.addTemplateQFilter(qfBuilder, filter, baseDataMap);
        HashSet<Long> selectedEntityIds = new HashSet<Long>(16);
        this.addEntityQFilter(qfBuilder, filter, selectedEntityIds, baseDataMap);
        ArrayList<Object[]> data = new ArrayList<Object[]>(10);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"id, templateid, userid, usertype, modelid, applytemplate, templatetype, entityid, entity_range, entity_exclude, entitytype, viewgroup", (QFilter[])qfBuilder.toArrays(), (String)"viewgroup");
        long modelId_filter = this.getModelIdByFilter(filter);
        TemplatePermQueryUtil.removeNotIncludeRecord((DynamicObjectCollection)records, baseDataMap, selectedEntityIds, (long)modelId_filter, (Long)filter.getLong("entity_view"));
        if (records.size() != 0) {
            for (DynamicObject record : records) {
                long userId = record.getLong("userid");
                String userType = record.getString("usertype");
                UserTypeEnum userTypeEnum = UserTypeEnum.getUserTypeByCode((String)userType);
                ArrayList<Long> refUserIds = (ArrayList<Long>)usrGroupMap.get(userId);
                boolean isInGroup = false;
                if (refUserIds != null && refUserIds.size() != 0) {
                    isInGroup = true;
                    userTypeEnum = UserTypeEnum.USER;
                } else {
                    refUserIds = new ArrayList<Long>(16);
                    refUserIds.add(userId);
                }
                Long modelId = record.getLong("modelid");
                String templateType = record.getString("templatetype");
                Long template = null;
                TemplateTypeEnum templateTypeEnum = null;
                if (TemplateTypeEnum.APPLY.getCode().equals(templateType)) {
                    template = record.getLong("applytemplate");
                    templateTypeEnum = TemplateTypeEnum.APPLY;
                } else if (TemplateTypeEnum.BUDGET.getCode().equals(templateType)) {
                    template = record.getLong("templateid");
                    templateTypeEnum = TemplateTypeEnum.BUDGET;
                }
                Long entityId = record.getLong("entityid");
                String entityRange = record.getString("entity_range");
                String entityExclude = record.getString("entity_exclude");
                String entityType = record.getString("entitytype");
                Long viewGroupId = record.getLong("viewgroup");
                for (Long refUserId : refUserIds) {
                    Object[] datum = new Object[13];
                    if (isInGroup) {
                        this.setBaseDataValue(baseDataMap, userId, "name", datum, 12);
                    }
                    this.setValue(userTypeEnum.getDesc(), datum, 0);
                    this.setBaseDataValue(baseDataMap, refUserId, "name", datum, 1);
                    this.setBaseDataValue(baseDataMap, refUserId, "number", datum, 2);
                    this.setBaseDataValue(baseDataMap, modelId, "name", datum, 3);
                    if (templateTypeEnum != null) {
                        this.setValue(templateTypeEnum.getDesc(), datum, 4);
                    }
                    this.setBaseDataValue(baseDataMap, template, "name", datum, 5);
                    this.setBaseDataValue(baseDataMap, template, "number", datum, 6);
                    this.setBaseDataValue(baseDataMap, entityId, "name", datum, 7);
                    this.setBaseDataValue(baseDataMap, entityId, "number", datum, 8);
                    if (entityId != 0L && StringUtils.isNotEmpty((String)entityRange)) {
                        this.setValue(RangeEnum.getRangeByVal((int)Integer.parseInt(entityRange)).getName(), datum, 9);
                        this.setBaseDataValue(baseDataMap, viewGroupId, "name", datum, 10);
                        this.setValue(entityExclude, datum, 11);
                    }
                    this.setSourceValue(entityType, datum);
                    data.add(datum);
                }
            }
        }
        Algo algo = Algo.create((String)this.algoKey);
        Iterator iterator = data.iterator();
        return algo.createDataSet(iterator, TemplatePermQueryUtil.getRowMeta());
    }

    private void setSourceValue(String entityType, Object[] datum) {
        EntityTypeEnum enumByCode = EntityTypeEnum.getEnumByCode((String)entityType);
        if (enumByCode == EntityTypeEnum.DEFINED_PROPERTY) {
            String property = ResManager.loadKDString((String)"\u5c5e\u6027", (String)"UserTemplatePermListDataPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            Object source = datum[12];
            datum[12] = source != null ? source.toString() + ";" + property : property;
        }
    }

    private void setBaseDataValue(Map<Long, BasedataPojo> baseDataMap, Long baseDataId, String baseDataField, Object[] datum, int column) {
        if (baseDataId == null) {
            return;
        }
        BasedataPojo basedataPojo = baseDataMap.get(baseDataId);
        if (basedataPojo == null) {
            return;
        }
        String showValue = "";
        switch (baseDataField) {
            case "name": {
                showValue = basedataPojo.getName();
                break;
            }
            case "number": {
                showValue = basedataPojo.getNumber();
                break;
            }
        }
        this.setValue(showValue, datum, column);
    }

    private void setValue(String showValue, Object[] datum, int column) {
        datum[column] = showValue;
    }

    private void addModelQFilter(QFBuilder qfBuilder, FilterInfo filter, Map<Long, BasedataPojo> baseDataMap) {
        QFilter model = new QFilter("modelid", "=", (Object)this.getModelIdByFilter(filter, baseDataMap));
        qfBuilder.add(model);
    }

    private long getModelIdByFilter(FilterInfo filter) {
        return this.getModelIdByFilter(filter, null);
    }

    private long getModelIdByFilter(FilterInfo filter, Map<Long, BasedataPojo> baseDataMap) {
        DynamicObject selectModel = filter.getDynamicObject("selectmodel");
        long modelId = selectModel.getLong("id");
        if (baseDataMap != null) {
            BasedataPojo basedataPojo = new BasedataPojo(Long.valueOf(modelId), selectModel.getString("name"), selectModel.getString("shownumber"));
            baseDataMap.put(modelId, basedataPojo);
        }
        return modelId;
    }

    private void addUserQFilter(QFBuilder qfBuilder, FilterInfo filter, Map<Long, List<Long>> usrGroupMap, Map<Long, BasedataPojo> baseDataMap) {
        String selectUserType = filter.getString("selectusertype");
        if (UserTypeEnum.USER.getCode().equals(selectUserType)) {
            DynamicObjectCollection selectUsers = filter.getDynamicObjectCollection("selectuser");
            if (selectUsers == null || selectUsers.size() == 0) {
                return;
            }
            HashSet<Long> userIds = new HashSet<Long>(16);
            TemplatePermQueryUtil.addToBaseDataMap((DynamicObjectCollection)selectUsers, baseDataMap, userIds);
            Map usrGrpUserList = TemplatePermServiceHelper.getUsrGrpUserList(userIds);
            HashSet userGroupIds = new HashSet(16);
            usrGrpUserList.forEach((key, value) -> value.forEach(j -> {
                List users = usrGroupMap.computeIfAbsent((Long)j, k -> new ArrayList(16));
                users.add(key);
                userGroupIds.add(j);
            }));
            Map usrGrpInfoMap = TemplatePermQueryUtil.getUsrGrpObjById(new ArrayList(userGroupIds));
            for (Map.Entry entry : usrGrpInfoMap.entrySet()) {
                Long usrGrpId = ConvertUtils.toLong(entry.getKey());
                userIds.add(usrGrpId);
                DynamicObject userGroup = (DynamicObject)entry.getValue();
                BasedataPojo basedataPojo = new BasedataPojo(usrGrpId, userGroup.getString("name"), userGroup.getString("number"));
                baseDataMap.put(usrGrpId, basedataPojo);
            }
            QFilter user = new QFilter("userid", "in", userIds);
            qfBuilder.add(user);
        } else if (UserTypeEnum.USERGROUP.getCode().equals(selectUserType)) {
            DynamicObjectCollection selectUserGroups = filter.getDynamicObjectCollection("selectusergroup");
            if (selectUserGroups == null || selectUserGroups.size() == 0) {
                return;
            }
            HashSet grpIds = new HashSet(16);
            TemplatePermQueryUtil.addToBaseDataMap((DynamicObjectCollection)selectUserGroups, baseDataMap, grpIds);
            QFilter user = new QFilter("userid", "in", grpIds);
            qfBuilder.add(user);
        }
    }

    private void addTemplateQFilter(QFBuilder qfBuilder, FilterInfo filter, Map<Long, BasedataPojo> baseDataMap) {
        String selectTemplateType = filter.getString("selecttemplatetype");
        DynamicObjectCollection selectTemplates = null;
        String templateField = null;
        if (TemplateTypeEnum.BUDGET.getCode().equals(selectTemplateType)) {
            selectTemplates = filter.getDynamicObjectCollection("selectbudgettpt");
            templateField = "templateid";
            qfBuilder.add(new QFilter("templatetype", "=", (Object)TemplateTypeEnum.BUDGET.getCode()));
        } else if (TemplateTypeEnum.APPLY.getCode().equals(selectTemplateType)) {
            selectTemplates = filter.getDynamicObjectCollection("selectapplytpt");
            templateField = "applytemplate";
            qfBuilder.add(new QFilter("templatetype", "=", (Object)TemplateTypeEnum.APPLY.getCode()));
        }
        if (selectTemplates == null || selectTemplates.size() == 0 || StringUtils.isEmpty((String)templateField)) {
            return;
        }
        HashSet templateIds = new HashSet(16);
        TemplatePermQueryUtil.addToBaseDataMap((DynamicObjectCollection)selectTemplates, baseDataMap, templateIds);
        qfBuilder.add(new QFilter(templateField, "in", templateIds));
    }

    private void addEntityQFilter(QFBuilder qfBuilder, FilterInfo filter, Set<Long> selectedEntityIds, Map<Long, BasedataPojo> baseDataMap) {
        String selectedEntityJson = filter.getString("selectedentity");
        if (StringUtils.isEmpty((String)selectedEntityJson)) {
            return;
        }
        Long entityViewId = filter.getLong("entity_view");
        Map selectEntityIds = (Map)SerializationUtils.fromJsonString((String)selectedEntityJson, HashMap.class);
        if (selectEntityIds.size() == 0) {
            return;
        }
        Long viewGroupId = TemplatePermQueryUtil.getViewGroupId((Long)entityViewId);
        List toQueryEntityIds = selectEntityIds.computeIfAbsent(RangeF7PropertyCataEnum.Property.getIndex(), k -> new ArrayList(16));
        long modelId = this.getModelIdByFilter(filter);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        for (Long toQueryEntityId : toQueryEntityIds) {
            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(SysDimensionEnum.Entity.getNumber(), toQueryEntityId);
            if (propertyValue == null) continue;
            BasedataPojo basedataPojo = new BasedataPojo(toQueryEntityId, propertyValue.getName(), propertyValue.getNumber());
            baseDataMap.put(toQueryEntityId, basedataPojo);
        }
        List memberIds = (List)selectEntityIds.get(RangeF7PropertyCataEnum.Member.getIndex());
        if (memberIds != null && memberIds.size() != 0) {
            toQueryEntityIds.addAll(memberIds);
            selectedEntityIds.addAll(memberIds);
            List propRelations = memberPropCache.getPropRelations(null);
            propRelations.stream().filter(e -> memberIds.contains(e.getMemberId())).forEach(e -> {
                Long propValueId = e.getPropValueId();
                if (!toQueryEntityIds.contains(propValueId)) {
                    toQueryEntityIds.add(propValueId);
                    CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(SysDimensionEnum.Entity.getNumber(), propValueId);
                    if (propertyValue != null) {
                        BasedataPojo basedataPojo = new BasedataPojo(propValueId, propertyValue.getName(), propertyValue.getNumber());
                        baseDataMap.put(propValueId, basedataPojo);
                    }
                }
            });
            HashSet ancestors = new HashSet(memberIds);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            List viewIds = (List)TemplatePermQueryUtil.getViewGroupToViewMap((Long)modelId).get(viewGroupId);
            if (viewIds != null) {
                for (Long viewId : viewIds) {
                    for (Long memberId : memberIds) {
                        TemplatePermQueryUtil.addAncestors(ancestors, (Dimension)dimension, (List)toQueryEntityIds, baseDataMap, (Long)memberId, (Long)viewId);
                    }
                }
            }
            toQueryEntityIds.add(0L);
        }
        qfBuilder.add(new QFilter("entityid", "in", (Object)toQueryEntityIds));
        UserTemplatePermListDataPlugin.addEntityViewGroupFilter(qfBuilder, viewGroupId);
    }

    private static void addEntityViewGroupFilter(QFBuilder qfBuilder, Long viewGroupId) {
        HashSet<Long> viewGroupIds = new HashSet<Long>(16);
        if (IDUtils.isNotEmptyLong((Long)viewGroupId).booleanValue()) {
            viewGroupIds.add(viewGroupId);
        }
        viewGroupIds.add(0L);
        qfBuilder.add(new QFilter("viewgroup", "in", viewGroupIds));
    }
}

