/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.templateperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.templateperm.UserTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.executeanalyse.ReportFormPlugin;
import kd.epm.eb.formplugin.reportscheme.helper.TemplateUserPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class UserTemplateQueryFormPlugin
extends ReportFormPlugin
implements BeforeF7SelectListener {
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "selectmodel": {
                this.setModelFilter(event);
                break;
            }
            case "selectbudgettpt": 
            case "selectapplytpt": {
                this.setTemplateFilter(event, name);
                break;
            }
            case "selectuser": 
            case "selectusergroup": {
                this.validUserType(event);
                ListFilterParameter listFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
                listFilterParameter.getQFilters().add(new QFilter("id", "not in", TemplateUserPermHelper.getAdminUserOrGroups(this.getUserType(name), this.getModelId())));
                break;
            }
        }
    }

    private String getUserType(String name) {
        String userType = UserTypeEnum.USER.getCode();
        if ("selectusergroup".equals(name)) {
            userType = UserTypeEnum.USERGROUP.getCode();
        }
        return userType;
    }

    private void validUserType(BeforeF7SelectEvent event) {
        String selectusertype = (String)this.getModel().getValue("selectusertype");
        if (StringUtils.isEmpty((String)selectusertype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7c7b\u578b\u3002", (String)"UserTemplateQueryFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    private boolean validModel() {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"UserTemplateQueryFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setTemplateFilter(BeforeF7SelectEvent event, String key) {
        if (this.validModel() && this.validTemplateType()) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            showParameter.setShowUsed(false);
            showParameter.setShowApproved(false);
            if ("selectapplytpt".equals(key)) {
                showParameter.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f\u5217\u8868", (String)"UserTemplateQueryFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                showParameter.setCustomParam("analysis.modelId", (Object)this.getModelId());
            }
            event.setFormShowParameter((FormShowParameter)showParameter);
        } else {
            event.setCancel(true);
        }
    }

    private boolean validTemplateType() {
        String selecttemplatetype = (String)this.getModel().getValue("selecttemplatetype");
        if (StringUtils.isEmpty((String)selecttemplatetype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"UserTemplateQueryFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setModelFilter(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("selectmodel")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        QFilter qFilter = new QFilter("reporttype", "in", (Object)new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BG.getIndex()});
        qFilter.and("status", "=", (Object)"C").and("enable", "!=", (Object)"0");
        qFilterList.add(qFilter);
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
        QFilter qIds = new QFilter("id", "in", (Object)modelIds);
        qFilterList.add(qIds);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        showParameter.setSelectedRow((Object)this.getModelId());
        event.setFormShowParameter((FormShowParameter)showParameter);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        String userType = filterInfo.getString("selectusertype");
        DynamicObject model = filterInfo.getDynamicObject("selectmodel");
        DynamicObjectCollection user = filterInfo.getDynamicObjectCollection("selectuser");
        DynamicObjectCollection userGroup = filterInfo.getDynamicObjectCollection("selectusergroup");
        DynamicObjectCollection budgetTemplate = filterInfo.getDynamicObjectCollection("selectbudgettpt");
        DynamicObjectCollection applyTemplate = filterInfo.getDynamicObjectCollection("selectapplytpt");
        String selectedEntityJson = filterInfo.getString("selectedentity");
        HashMap selectedEntityIds = new HashMap(16);
        if (StringUtils.isNotEmpty((String)selectedEntityJson)) {
            selectedEntityIds.putAll((Map)SerializationUtils.fromJsonString((String)selectedEntityJson, HashMap.class));
        }
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"UserTemplateQueryFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)userType)) {
            userType = this.getPageCache().get("lastUserType");
        }
        if ("bos_user".equals(userType)) {
            if (CollectionUtils.isEmpty((Collection)user) && CollectionUtils.isEmpty((Collection)budgetTemplate) && CollectionUtils.isEmpty((Collection)applyTemplate) && selectedEntityIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u3001\u6a21\u677f\u6216\u7ec4\u7ec7\u8fdb\u884c\u67e5\u8be2\u3002", (String)"UserTemplateQueryFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if ("bos_usergroup".equals(userType) && CollectionUtils.isEmpty((Collection)userGroup) && CollectionUtils.isEmpty((Collection)budgetTemplate) && CollectionUtils.isEmpty((Collection)applyTemplate) && selectedEntityIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7ec4\u3001\u6a21\u677f\u6216\u7ec4\u7ec7\u8fdb\u884c\u67e5\u8be2\u3002", (String)"UserTemplateQueryFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"configurereport"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectusergroup", "selectapplytpt"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectuser", "selectbudgettpt"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null) {
            Object model = customParams.get("model");
            if (model != null && Long.parseLong(String.valueOf(model)) != 0L) {
                this.getModel().setValue("selectmodel", model);
            } else {
                Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"selectmodel", (boolean)false);
                if (modelId != null && modelId != 0L) {
                    this.getModel().setValue("selectmodel", (Object)modelId);
                }
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportlistap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("selectusertype".equals(name)) {
            this.getModel().setValue("selectuser", null);
            this.getModel().setValue("selectusergroup", null);
            String oldValue = (String)changeData.getOldValue();
            this.getPageCache().put("lastUserType", oldValue);
            String selectusertype = (String)this.getModel().getValue("selectusertype");
            if ("bos_user".equals(selectusertype)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectuser"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectusergroup"});
            } else if ("bos_usergroup".equals(selectusertype)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectuser"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectusergroup"});
            }
        } else if ("selectmodel".equals(name)) {
            this.getModel().setValue("selectapplytpt", null);
            this.getModel().setValue("selectbudgettpt", null);
            Long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"UserTemplateQueryFormPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if ("selecttemplatetype".equals(name)) {
            this.getModel().setValue("selectbudgettpt", null);
            this.getModel().setValue("selectapplytpt", null);
            String selecttemplatetype = (String)this.getModel().getValue("selecttemplatetype");
            if ("0".equals(selecttemplatetype)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectbudgettpt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectapplytpt"});
            } else if ("1".equals(selecttemplatetype)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectbudgettpt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectapplytpt"});
            }
        } else if ("selectentity".equals(name) && ((newValue = changeData.getNewValue()) == null || StringUtils.isEmpty((String)newValue.toString()))) {
            this.getModel().setValue("selectedentity", null);
        }
    }

    public void registerListener(EventObject e) {
        this.registerBeforeF7("selectmodel", "selectbudgettpt", "selectapplytpt", "selectuser", "selectusergroup");
        this.addClickListeners(new String[]{"selectentity"});
    }

    private void registerBeforeF7(String ... names) {
        for (String name : names) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(name);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("selectmodel");
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        String userType = scheme.getString("selectusertype");
        String templateType = scheme.getString("selecttemplatetype");
        this.setVisible(userType, templateType);
    }

    private void setVisible(String userType, String templateType) {
        if ("bos_user".equals(userType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectuser"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectusergroup"});
        } else if ("bos_usergroup".equals(userType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectuser"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectusergroup"});
        }
        if ("0".equals(templateType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectbudgettpt"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectapplytpt"});
        } else if ("1".equals(templateType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectbudgettpt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"selectapplytpt"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (!"selectentity".equals(key)) {
            return;
        }
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"UserTemplateQueryFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)DynamicObject.class.getName());
        f8Param.setVerifyPermission(true);
        f8Param.setShowCustomProperty(true);
        f8Param.setShowCustomPropertyColumn(true);
        f8Param.setLockRangeSelect(true);
        f8Param.setReturnAllData(true);
        f8Param.setEnableView(true);
        f8Param.setLoadDefaultBusModel(false);
        f8Param.setViewId(this.getEntityF7ShowViewId());
        Object selectedEntity = this.getModel().getValue("selectedentity");
        if (selectedEntity != null && StringUtils.isNotEmpty((String)selectedEntity.toString())) {
            Map selectEntityIds = (Map)SerializationUtils.fromJsonString((String)selectedEntity.toString(), HashMap.class);
            HashSet selectedEntityIds = new HashSet(16);
            selectEntityIds.values().forEach(selectedEntityIds::addAll);
            f8Param.setSelectIds(selectedEntityIds);
        }
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "select_entity"));
    }

    private Long getEntityF7ShowViewId() {
        List entityViewIds = this.getIModelCacheHelper().getDimension(SysDimensionEnum.Entity.getNumber()).getViewList();
        if (entityViewIds.size() > 0) {
            Long selectedViewId = IDUtils.toLong((Object)this.getModel().getValue("entity_view"));
            if (entityViewIds.contains(selectedViewId)) {
                return selectedViewId;
            }
            return (Long)entityViewIds.get(0);
        }
        return 0L;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        if (backData == null) {
            return;
        }
        if (!"select_entity".equals(actionKey)) {
            return;
        }
        DynamicObjectCollection selectedRows = (DynamicObjectCollection)backData;
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        HashMap selectIdMap = new HashMap(16);
        ArrayList propertyIds = new ArrayList(16);
        ArrayList memberIds = new ArrayList(16);
        selectedRows.forEach(row -> {
            long mid = row.getLong("mid");
            String type = row.getString("type");
            if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
                propertyIds.add(mid);
            } else {
                memberIds.add(mid);
            }
        });
        if (propertyIds.size() != 0) {
            selectIdMap.put(RangeF7PropertyCataEnum.Property.getIndex(), propertyIds);
        }
        if (memberIds.size() != 0) {
            selectIdMap.put(RangeF7PropertyCataEnum.Member.getIndex(), memberIds);
        }
        Long viewId = ((DynamicObject)selectedRows.get(0)).getLong("viewid");
        Long modelId = this.getModelId();
        HashMap nameMap = new HashMap(16);
        if (memberIds.size() != 0) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            memberIds.forEach(e -> {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, e);
                nameMap.put(member.getId(), member.getName());
            });
        }
        if (propertyIds.size() != 0) {
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
            propertyIds.forEach(e -> {
                CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(SysDimensionEnum.Entity.getNumber(), e);
                nameMap.put(propertyValue.getId(), propertyValue.getName());
            });
        }
        ArrayList selectEntityShowArray = new ArrayList(16);
        selectedRows.forEach(row -> {
            long mid = row.getLong("mid");
            selectEntityShowArray.add(nameMap.get(mid));
        });
        this.getModel().setValue("selectentity", (Object)String.join((CharSequence)"\uff1b", selectEntityShowArray));
        this.getModel().setValue("selectedentity", (Object)SerializationUtils.toJsonString(selectIdMap));
        this.getModel().setValue("entity_view", (Object)String.valueOf(viewId));
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

