/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.unitupdate;

import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.DimensionView.ViewMemberUpgradeService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.unitupdate.pojo.UpdateItemPojo;
import kd.epm.eb.formplugin.unitupdate.pojo.UpdatePojo;

public class UpdateUtils {
    private static final Log log = LogFactory.getLog(UpdateUtils.class);
    public static final String KEY_STRING = "EPM_EB_UPDATE";

    public static void update(UpdatePojo updatePojo) {
        if (updatePojo == null) {
            log.info("UPDATEPOJO IS NULL");
            return;
        }
        List<UpdateItemPojo> updateItemPojoList = updatePojo.getUpdateItemPojoList();
        if (CollectionUtils.isEmpty(updateItemPojoList)) {
            log.info("UPDATEITEMPOJO IS EMPTY");
            return;
        }
        String traceIdString = RequestContext.get().getTraceId();
        log.info(StrUtils.format((String)"[{}][{}][START][MODEL:{}]", (Object[])new Object[]{KEY_STRING, traceIdString}));
        int updateItemPojoListSizeInt = updateItemPojoList.size();
        for (int i = 0; i < updateItemPojoListSizeInt; ++i) {
            UpdateItemPojo updateItemPojo = updateItemPojoList.get(i);
            try {
                ViewMemberUpgradeService.upgradeOldModel(Collections.singletonList(updateItemPojo.getModelIdLong()));
            }
            catch (Throwable throwable) {
                log.info(StrUtils.format((String)"[{}][{}][FAIL][MODEL:{}]", (Object[])new Object[]{KEY_STRING, traceIdString, updateItemPojo.getModelIdLong()}), (Object)throwable);
                continue;
            }
            log.info(StrUtils.format((String)"[{}][{}][SUCCESS][MODEL:{}][INDEX:{} OF {}]", (Object[])new Object[]{KEY_STRING, traceIdString, updateItemPojo.getModelIdLong(), i, updateItemPojoListSizeInt}));
        }
        log.info(StrUtils.format((String)"[{}][{}][END][MODEL:{}]", (Object[])new Object[]{KEY_STRING, traceIdString}));
    }
}

