/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils.BizRuleGroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class DataSetTreeCommon {
    public static final String TREE_MAPKEY_CATEGORY = "catalog";
    public static final String TREE_MAPKEY_DATA = "dataset";
    public static final String TREE_MAPKEY_TYPE = "type";
    private String treeViewctrlName;
    private AbstractFormPlugin plugIn;
    private String cache_headnodeid;
    private String cache_focusnodeid;
    private String cache_treeList;

    public void setCache_focusnodeid(String focusnodeid) {
        this.cache_focusnodeid = focusnodeid;
    }

    public void setCache_headnodeid(String headnodeid) {
        this.cache_headnodeid = headnodeid;
    }

    public void setCache_treeList(String cache_treeList) {
        this.cache_treeList = cache_treeList;
    }

    public void setTreeViewctrlName(String treeViewctrlName) {
        this.treeViewctrlName = treeViewctrlName;
    }

    public void initTree(String newId, Long modelId, Boolean isDataCube, AbstractFormPlugin plugIn) {
        this.plugIn = plugIn;
        String rootId = null;
        if (modelId != 0L) {
            TreeNode root = new TreeNode();
            QFBuilder qb = new QFBuilder();
            qb.add(new QFilter("model", "=", (Object)modelId));
            DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"eb_datasetcatalog", (String)"id,number,name,parent,createtime", (QFilter[])qb.toArrays(), (String)"createtime, number");
            List bizmodel = (List)plugIn.getView().getFormShowParameter().getCustomParam("bizmodel");
            if (CollectionUtils.isNotEmpty((Collection)bizmodel)) {
                qb.add(new QFilter("businessmodel", "in", (Object)bizmodel));
            }
            DynamicObjectCollection dataset = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number,name,catalog,createdate as createtime", (QFilter[])qb.toArrays(), (String)"createdate, number");
            ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
            if (!catalogs.isEmpty()) {
                Map<String, String> memberMap;
                for (DynamicObject catalog : catalogs) {
                    memberMap = this.createMemberMap(catalog, TREE_MAPKEY_CATEGORY);
                    treeList.add(memberMap);
                    if (!"0".equals(catalog.getString("parent"))) continue;
                    rootId = catalog.getString("id");
                }
                if (!dataset.isEmpty()) {
                    for (DynamicObject data : dataset) {
                        memberMap = this.createMemberMap(data, TREE_MAPKEY_DATA);
                        treeList.add(memberMap);
                    }
                }
                treeList.sort(Comparator.comparing(t -> (String)t.get("createtime")));
                if (this.cache_treeList != null) {
                    plugIn.getPageCache().put(this.cache_treeList, ObjectSerialUtil.toByteSerialized(treeList));
                }
            } else {
                return;
            }
            root.setId(rootId);
            root.setParentid("");
            root.setText(ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"DataSetTreeCommon_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put(TREE_MAPKEY_TYPE, TREE_MAPKEY_CATEGORY);
            root.setData(dataMap);
            this.setEntryNode(root, treeList, rootId);
            EpmTreeUtils.spreadAllNode((TreeNode)root);
            this.setTreeCache(root);
            plugIn.getPageCache().put(this.cache_headnodeid, rootId);
            TreeView tree = (TreeView)plugIn.getControl(this.treeViewctrlName);
            tree.deleteAllNodes();
            tree.addNode(root);
            if (newId != null) {
                TreeNode newNode = root.getTreeNode(newId, 20);
                if (newNode != null) {
                    tree.focusNode(newNode);
                }
            } else {
                tree.focusNode(root);
            }
            String s1 = SerializationUtils.toJsonString((Object)root);
            plugIn.getPageCache().put(this.cache_treeList + "1", s1);
            plugIn.getPageCache().put(this.cache_focusnodeid, tree.getTreeState().getFocusNodeId());
        }
    }

    private void setTreeCache(TreeNode root) {
        this.plugIn.getPageCache().put("treelist", SerializationUtils.serializeToBase64((Object)root));
    }

    private Map<String, String> createMemberMap(DynamicObject dynamicObject, String type) {
        HashMap<String, String> memberMap = new HashMap<String, String>();
        if (dynamicObject != null) {
            memberMap.put("id", dynamicObject.getString("id"));
            memberMap.put("number", dynamicObject.getString("number"));
            memberMap.put("name", dynamicObject.getString("name"));
            String createtime = dynamicObject.getString("createtime");
            if (createtime == null) {
                createtime = TimeServiceHelper.now().toString();
            }
            memberMap.put("createtime", createtime);
            if (TREE_MAPKEY_CATEGORY.equals(type)) {
                memberMap.put("parentid", dynamicObject.getString("parent"));
                memberMap.put(TREE_MAPKEY_TYPE, TREE_MAPKEY_CATEGORY);
            } else {
                memberMap.put("parentid", dynamicObject.getString(TREE_MAPKEY_CATEGORY));
                memberMap.put(TREE_MAPKEY_TYPE, TREE_MAPKEY_DATA);
            }
        }
        return memberMap;
    }

    private TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>(16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        return this.createNode(root, nodeMap, headId);
    }

    private TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(16);
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                dataMap.put(TREE_MAPKEY_TYPE, map.get(TREE_MAPKEY_TYPE));
                dataMap.put("dataset_number", map.get("number"));
                entry.setData(dataMap);
                String entryHeadId = map.get("id");
                this.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }
}

