/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class DimensionUtil {
    public static boolean isExpand2SecondLevel4MultiMemberF7(String membermodel) {
        boolean is = false;
        if (membermodel.equals("epm_entitymembertree") || membermodel.equals("epm_accountmembertree") || membermodel.equals("epm_changetypemembertree") || membermodel.equals("epm_icmembertree") || membermodel.equals("epm_userdefinedmembertree")) {
            is = true;
        }
        return is;
    }

    public static int getDSeq(long id, String entity) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)DimensionUtil.class.getName(), (String)entity, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public static List<String> getDimensionByBizModel(long bizModelId) {
        return DimensionUtil.getDimensionByBizModel(bizModelId, false);
    }

    public static List<String> getDimensionByBizModel(long bizModelId, Boolean isForceAccount) {
        ArrayList<String> dimensionList = new ArrayList<String>(16);
        if (bizModelId == 0L) {
            return dimensionList;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)bizModelId, (String)"eb_businessmodel");
        if (dynamicObject == null) {
            return dimensionList;
        }
        DynamicObjectCollection dynamicObjects1 = dynamicObject.getDynamicObjectCollection("viewentry");
        for (DynamicObject object1 : dynamicObjects1) {
            DynamicObject dimension = object1.getDynamicObject("dimension");
            String dimNum = dimension.getString("number");
            if (dimensionList.contains(dimNum)) continue;
            dimensionList.add(dimNum);
        }
        if (!dimensionList.contains(SysDimensionEnum.Account.getNumber()) && isForceAccount.booleanValue()) {
            dimensionList.add(SysDimensionEnum.Account.getNumber());
        }
        return dimensionList;
    }

    public static List<String> getAllChildMemeber(long modelId, String dimension, Long viewId, List<String> members) {
        if (members == null || members.size() == 0) {
            return members;
        }
        return DimensionUtil.getAllChildMemeber(modelId, dimension, viewId, members, false);
    }

    public static List<String> getAllChildMemeber(long modelId, String dimension, Long viewId, List<String> members, Boolean isOlyLeaf) {
        if (members == null || members.size() == 0) {
            return members;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet resultSet = new HashSet(members.size());
        for (String relationMem : members) {
            Member curMem = modelCacheHelper.getMember(dimension, viewId, relationMem);
            List childMems = modelCacheHelper.getAllChildrenSort(curMem, true);
            List curList = isOlyLeaf != false ? childMems.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toList()) : childMems.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            resultSet.addAll(curList);
        }
        return new ArrayList<String>(resultSet);
    }

    public static Set<Long> getDataSetByDimsion(long bizModle, Set<String> dimension) {
        HashSet<Long> result = new HashSet<Long>(16);
        String dimFields = "id,entryentity.datasetdim.number as dimnum";
        QFilter dimFilter = new QFilter("businessmodel.id", "=", (Object)bizModle);
        DynamicObjectCollection dataSetDimDys = QueryServiceHelper.query((String)"eb_dataset", (String)dimFields, (QFilter[])new QFilter[]{dimFilter});
        if (dataSetDimDys == null || dataSetDimDys.size() == 0) {
            return result;
        }
        HashMap dataSetDimMap = new HashMap(16);
        for (DynamicObject dataSetDimDy : dataSetDimDys) {
            Long dataSetId = dataSetDimDy.getLong("id");
            String dimNum = dataSetDimDy.getString("dimnum");
            if (dataSetDimMap.containsKey(dataSetId)) {
                ((Set)dataSetDimMap.get(dataSetId)).add(dimNum);
                continue;
            }
            HashSet<String> dimSet = new HashSet<String>(16);
            dimSet.add(dimNum);
            dimSet.add(SysDimensionEnum.Account.getNumber());
            dataSetDimMap.put(dataSetId, dimSet);
        }
        for (Map.Entry entry : dataSetDimMap.entrySet()) {
            if (dimension != null && dimension.size() != 0 && !((Set)entry.getValue()).containsAll(dimension)) continue;
            result.add((Long)entry.getKey());
        }
        return result;
    }

    public static Set<String> getBaseDataScopeNums(String entityName, String num, List<DynamicObject> allBizDys) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Set<String> result = new HashSet<String>(16);
        String parentField = DimensionUtil.getParendField((IDataEntityType)entityType);
        if (StringUtils.isEmpty((String)parentField)) {
            result.add(num);
        } else {
            List curNodeDys = allBizDys.stream().filter(dy -> dy.getString("number").equals(num)).collect(Collectors.toList());
            if (curNodeDys.size() != 0) {
                Map<Long, Long> parentMap = curNodeDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong(parentField)));
                DynamicObject curNodeDy = (DynamicObject)curNodeDys.get(0);
                Set<Long> childs = DimensionUtil.getAllChilds(curNodeDy.getLong("id"), parentMap);
                result = allBizDys.stream().filter(dy -> childs.contains(dy.getLong("id"))).map(dy -> dy.getString("number")).collect(Collectors.toSet());
            }
        }
        return result;
    }

    public static List<DynamicObject> getAllBaseDataIds(String entityName) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        String formId = DimensionUtil.changeFormId(entityName);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        String parentField = DimensionUtil.getParendField((IDataEntityType)entityType);
        if (StringUtils.isEmpty((String)parentField)) {
            return result;
        }
        String selectFields = DimensionUtil.getSelectFields(formId, parentField);
        QFilter[] filterArr = DimensionUtil.getBaseFilters(formId);
        DynamicObjectCollection allBizDys = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])filterArr);
        result.addAll((Collection<DynamicObject>)allBizDys);
        return result;
    }

    private static QFilter[] getBaseFilters(String formId) {
        ArrayList<QFilter> qFilterList = null;
        if ("bos_org_structure".equals(formId)) {
            qFilterList = new ArrayList<QFilter>(16);
            qFilterList.add(new QFilter("view.number", "=", (Object)"15"));
            return qFilterList.toArray(new QFilter[0]);
        }
        if ("bos_adminorg_structure".equals(formId)) {
            qFilterList = new ArrayList(16);
            qFilterList.add(new QFilter("view.number", "=", (Object)"01"));
            return qFilterList.toArray(new QFilter[0]);
        }
        return null;
    }

    private static String getSelectFields(String formId, String parentField) {
        String selectFields = "";
        selectFields = "bos_org_structure".equals(formId) || "bos_adminorg_structure".equals(formId) ? "org.id as id,org.number as number," + parentField : "id,number," + parentField;
        return selectFields;
    }

    private static String changeFormId(String formId) {
        if ("bos_org".equals(formId)) {
            return "bos_org_structure";
        }
        if ("bos_adminorg".equals(formId)) {
            return "bos_adminorg_structure";
        }
        return formId;
    }

    private static Set<Long> getAllChilds(long nodeId, Map<Long, Long> parentMap) {
        int befSize;
        HashSet<Long> childs = new HashSet<Long>(16);
        childs.add(nodeId);
        do {
            befSize = childs.size();
            Set curIdSet = parentMap.entrySet().stream().filter(kv -> childs.contains(kv.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            childs.addAll(curIdSet);
        } while (befSize != childs.size());
        return childs;
    }

    private static String getParendField(IDataEntityType entityType) {
        String field = "";
        if (entityType.getProperties().containsKey((Object)"parent") && !StringUtils.isEmpty((String)((IDataEntityProperty)entityType.getProperties().get((Object)"parent")).getAlias())) {
            field = "parent";
        } else if (entityType.getProperties().containsKey((Object)"parentid") && !StringUtils.isEmpty((String)((IDataEntityProperty)entityType.getProperties().get((Object)"parentid")).getAlias())) {
            field = "parentid";
        }
        return field;
    }
}

