/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.template.TitleSplitTypeEnum;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.afix.multisetting.FixTemplateDynTitle;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public class FixReportDynamicTitleUtils {
    public static List<ECell> getDynamicTitleCells(IMultiAreaSetting areaSetting, Map<String, Map<String, String>> varValus, IModelCacheHelper modelCacheHelper, Point areaStartPoint, boolean needDeleteRow) {
        ArrayList<ECell> updateCells = new ArrayList<ECell>(10);
        List fixTemplateDynTitles = areaSetting.getFixTemplateDynTitle();
        if (CollectionUtils.isEmpty((Collection)fixTemplateDynTitles)) {
            return updateCells;
        }
        ISheet areaSheet = areaSetting.getAreaSheet();
        String startPosition = areaSetting.getStartPosition();
        String[] split = startPosition.split(":");
        List coldims = areaSetting.getColdims();
        List rowHeaders = areaSetting.getRowHeaders();
        if (CollectionUtils.isEmpty((Collection)coldims)) {
            return updateCells;
        }
        ArrayList cells = new ArrayList(10);
        for (int i = 0; i < coldims.size(); ++i) {
            List row = areaSheet.getRow(i);
            cells.addAll(row);
        }
        Map titleSettingMap = fixTemplateDynTitles.stream().collect(Collectors.groupingBy(FixTemplateDynTitle::getTitleRange, Collectors.toList()));
        for (Map.Entry entry : titleSettingMap.entrySet()) {
            List<FixTemplateDynTitle> value = entry.getValue();
            String titleStartPosition = ((FixTemplateDynTitle)value.get(0)).getTitleStartPosition();
            String titleEndPosition = ((FixTemplateDynTitle)value.get(0)).getTitleEndPosition();
            String[] titleStartPositionSplit = titleStartPosition.split(":");
            String[] titleEndPositionSplit = titleEndPosition.split(":");
            int xStart = areaStartPoint.x + Integer.parseInt(titleStartPositionSplit[0]);
            int xEnd = areaStartPoint.x + Integer.parseInt(titleEndPositionSplit[0]);
            int yStart = areaStartPoint.y + Integer.parseInt(titleStartPositionSplit[1]);
            int colStart = xStart - areaStartPoint.x - Integer.parseInt(split[0]);
            int colEnd = xEnd - areaStartPoint.x - Integer.parseInt(split[0]);
            Point titleStartPoint = null;
            titleStartPoint = needDeleteRow ? new Point(xStart - rowHeaders.size(), yStart) : new Point(xStart, yStart);
            HashMap<Integer, Map<String, ECell>> cellMap = new HashMap<Integer, Map<String, ECell>>(16);
            for (ECell cell : cells) {
                int col = cell.getCol();
                if (col < colStart || col > colEnd) continue;
                Map stringECellMap = cellMap.computeIfAbsent(cell.getCol(), v -> new HashMap(6));
                Object dimnumber = cell.getUserObject("dimnumber");
                if (dimnumber == null || !StringUtils.isNotEmpty((String)dimnumber.toString())) continue;
                stringECellMap.put(String.valueOf(dimnumber), cell);
            }
            if (cellMap.isEmpty()) continue;
            FixReportDynamicTitleUtils.buildDynamicTitleCells(value, cellMap, colStart, colEnd, titleStartPoint, updateCells, varValus, modelCacheHelper);
        }
        return updateCells;
    }

    public static void buildDynamicTitleCells(List<FixTemplateDynTitle> titleList, Map<Integer, Map<String, ECell>> cellMap, int colStart, int colEnd, Point point, List<ECell> updateCells, Map<String, Map<String, String>> varValus, IModelCacheHelper modelCacheHelper) {
        ArrayList<ECell> cells = new ArrayList<ECell>(10);
        int x = point.x;
        int y = point.y;
        int offset = 0;
        boolean hasDelete = false;
        Long modelId = modelCacheHelper.getModelobj().getId();
        for (int i = colStart; i <= colEnd; ++i) {
            Map<String, ECell> stringECellMap = cellMap.get(i);
            if (stringECellMap != null && stringECellMap.size() != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (FixTemplateDynTitle dynTitle : titleList) {
                    String titleDimension = dynTitle.getTitleDimension();
                    ECell eCell = stringECellMap.get(titleDimension);
                    if (eCell == null) continue;
                    Object number = eCell.getUserObject("number");
                    Object name = eCell.getUserObject("name");
                    Object dimnumber = eCell.getUserObject("dimnumber");
                    if (number == null || name == null || dimnumber == null) continue;
                    String titlePrefix = dynTitle.getTitlePrefix();
                    stringBuilder.append(titlePrefix);
                    boolean isVal = String.valueOf(number).contains("@");
                    String nameStr = String.valueOf(name);
                    if (MapUtils.isEmpty(varValus) || !isVal) {
                        String titleSplitType = dynTitle.getTitleSplitType();
                        int titleSplitCount = dynTitle.getTitleSplitCount();
                        if (TitleSplitTypeEnum.LEFT.getType().equals(titleSplitType) && titleSplitCount > 0) {
                            stringBuilder.append(nameStr, 0, Math.min(titleSplitCount, nameStr.length()));
                        } else if (TitleSplitTypeEnum.RIGHT.getType().equals(titleSplitType) && titleSplitCount > 0) {
                            stringBuilder.append(nameStr, Math.max(nameStr.length() - titleSplitCount, 0), nameStr.length());
                        } else if (TitleSplitTypeEnum.NONE.getType().equals(titleSplitType)) {
                            stringBuilder.append(nameStr);
                        }
                    } else if (MapUtils.isEmpty(varValus)) {
                        stringBuilder.append(nameStr);
                    } else {
                        String realDimByVar = ReportVarUtil.getRealDimByVar((Long)modelId, (String)String.valueOf(number), (String)String.valueOf(dimnumber), varValus);
                        Member member = modelCacheHelper.getMemberByAnyView(String.valueOf(dimnumber), realDimByVar);
                        if (member == null) continue;
                        String memberName = member.getName();
                        String titleSplitType = dynTitle.getTitleSplitType();
                        int titleSplitCount = dynTitle.getTitleSplitCount();
                        if (TitleSplitTypeEnum.LEFT.getType().equals(titleSplitType) && titleSplitCount > 0) {
                            stringBuilder.append(memberName, 0, Math.min(titleSplitCount, memberName.length()));
                        } else if (TitleSplitTypeEnum.RIGHT.getType().equals(titleSplitType) && titleSplitCount > 0) {
                            stringBuilder.append(memberName, Math.max(memberName.length() - titleSplitCount, 0), memberName.length());
                        } else if (TitleSplitTypeEnum.NONE.getType().equals(titleSplitType)) {
                            stringBuilder.append(memberName);
                        }
                    }
                    stringBuilder.append(dynTitle.getTitleSuffix());
                }
                if (StringUtils.isNotEmpty((String)stringBuilder.toString())) {
                    ECell eCell = new ECell(y, x + offset, (Object)stringBuilder.substring(0, stringBuilder.length()));
                    cells.add(eCell);
                }
            }
            ++offset;
        }
        updateCells.addAll(cells);
    }
}

