/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.template.TemplateFormulaUtil;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.formplugin.excel.report.ExcelSpreadContainer;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.CellHyperLinkPOJO;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.AutoFloatHelper;

public class FixReportRowColDeleteHelper {
    private static Log log = LogFactory.getLog(FixReportRowColDeleteHelper.class);

    public static void invokeDeleteRowCol(ITemplateModel templateModel, IEbSpreadManager spreadManager, ISpreadContainer spreadContainer, IFormView formView, boolean resolveSpread) {
        if (templateModel == null || spreadManager == null || spreadContainer == null || formView == null) {
            log.info("template is null {} or spreadManager is null:{},spreadContainer is null:{},formView is null:{}", new Object[]{templateModel == null, spreadManager == null, spreadContainer == null, formView == null});
            return;
        }
        List areaSettings = templateModel.getAreaRanges();
        if (areaSettings == null || areaSettings.size() == 0) {
            return;
        }
        if (resolveSpread) {
            FixReportRowColDeleteHelper.hiddenTemplateHyperLink(areaSettings, spreadContainer);
        }
        boolean deleteRow = false;
        boolean deleteCol = false;
        if (areaSettings.size() > 1) {
            FixTemplateProcessHelper.sortAreas(areaSettings);
            String overlapType = FixTemplateProcessHelper.checkRowColOverlapOnAreas(templateModel.getAreaRanges());
            if ("col".equals(overlapType)) {
                deleteCol = true;
            } else if ("row".equals(overlapType)) {
                deleteRow = true;
            }
            if (deleteCol || deleteRow) {
                for (int i = 0; !(i >= areaSettings.size() - 1 || deleteRow && !(deleteRow = FixReportRowColDeleteHelper.isOnSameLine((IMultiAreaSetting)areaSettings.get(i), (IMultiAreaSetting)areaSettings.get(i + 1), true)) || deleteCol && !(deleteCol = FixReportRowColDeleteHelper.isOnSameLine((IMultiAreaSetting)areaSettings.get(i), (IMultiAreaSetting)areaSettings.get(i + 1), false))); ++i) {
                }
            }
        }
        for (int i = areaSettings.size() - 1; i >= 0; --i) {
            MultiAreaManager areaManager;
            IMultiAreaSetting areaSetting = (IMultiAreaSetting)areaSettings.get(i);
            String areaIndex = areaSetting.getAreaRange().split(":")[0];
            Optional<MultiAreaManager> first = spreadManager.getMultiAreaManager().stream().filter(a -> areaIndex.equals(a.getAreaIndex())).findFirst();
            if (!first.isPresent() || (areaManager = first.get()) == null) continue;
            Map propertyMap = areaManager.getDimPropertys();
            Point dataPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaManager.getAreaRange().toString(), areaSetting.getStartPosition());
            dataPoint = i == 0 ? FixReportRowColDeleteHelper.deleteRowColDimArea(templateModel, areaManager, areaSettings, i, dataPoint, propertyMap, deleteRow, deleteCol, formView, spreadManager, spreadContainer, resolveSpread) : FixReportRowColDeleteHelper.deleteRowColDimArea(templateModel, areaManager, areaSettings, i, dataPoint, propertyMap, false, false, formView, spreadManager, spreadContainer, resolveSpread);
            if (areaSetting.getFloatInfos() == null || areaSetting.getFloatInfos().size() <= 0) continue;
            FixReportRowColDeleteHelper.setFloatAreaStyle(areaManager, dataPoint, areaSetting, propertyMap, spreadContainer, resolveSpread, templateModel.getModelId());
            FixReportRowColDeleteHelper.setFloatCellF7Style(areaManager, dataPoint, spreadContainer, resolveSpread, templateModel.getModelId());
        }
    }

    public static void setFloatCellF7Style(MultiAreaManager areaManager, Point dataPoint, ISpreadContainer spreadContainer, boolean resolveSpread, Long modelId) {
        if (!resolveSpread) {
            return;
        }
        ArrayList floatcells = new ArrayList(16);
        ArrayList floatF7cells = new ArrayList(16);
        ArrayList floatF7cells_quickAddNew = new ArrayList(16);
        ArrayList floatF7Areas = new ArrayList(16);
        ArrayList fixMemberAreas = new ArrayList(16);
        areaManager.getData().getDataSheet().iteratorECells(cell -> {
            if (cell != null) {
                int absRow = cell.getRow() + dataPoint.y;
                int absCol = cell.getCol() + dataPoint.x;
                if (!TemplateHelper.checkPropertyCell(cell)) {
                    if (cell.isFloatCell()) {
                        ECell absCell = new ECell(absRow, absCol, cell.getValue());
                        if (cell.getValue() != null) {
                            floatcells.add(absCell);
                        }
                        if ("true".equals(cell.getUserObject("isQuickAddNew"))) {
                            floatF7cells_quickAddNew.add(absCell);
                        } else {
                            floatF7cells.add(absCell);
                        }
                        floatF7Areas.add(new CellArea(absRow, absCol, 1, 1));
                    } else {
                        fixMemberAreas.add(new CellArea(absRow, absCol, 1, 1));
                    }
                }
            }
        });
        boolean isExcelSpread = spreadContainer instanceof ExcelSpreadContainer;
        if ((resolveSpread || isExcelSpread) && floatF7cells.size() > 0) {
            spreadContainer.setFListCells(floatF7cells, true, false, false);
        }
        if ((resolveSpread || isExcelSpread) && floatF7cells_quickAddNew.size() > 0) {
            spreadContainer.setFListCells(floatF7cells_quickAddNew, true, false, true);
        }
        if ((resolveSpread || isExcelSpread) && fixMemberAreas.size() > 0) {
            spreadContainer.resetCell(fixMemberAreas);
        }
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setRange(floatF7Areas);
        CellStyleInfo floatcellstyle = new CellStyleInfo();
        if (!"1".equals(CommonUtils.getReportColorType((Long)modelId))) {
            floatcellstyle.setBkc("");
        }
        floatcellstyle.setFm("@");
        areasStyle.setStyle(floatcellstyle);
        if (resolveSpread || isExcelSpread) {
            spreadContainer.updateCellValue2(floatcells);
            spreadContainer.unlockCells(floatF7Areas);
            spreadContainer.setCellStyle((List)Lists.newArrayList((Object[])new AreasStyle[]{areasStyle}));
        }
    }

    private static void setFloatAreaStyle(MultiAreaManager areaManager, Point dataPoint, IMultiAreaSetting areaSetting, Map<String, List<PropertyObj>> propertyMap, ISpreadContainer spreadContainer, boolean resolveSpread, Long modelId) {
        if (!resolveSpread) {
            return;
        }
        boolean deleterowpartition = areaManager.getFloatonWhere() != 0;
        boolean deletecolpartition = areaManager.getFloatonWhere() != 1;
        int coldims = areaManager.getColpartitionDims().size();
        int rowdims = areaManager.getRowpartitionDims().size();
        if (propertyMap != null) {
            coldims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims());
            rowdims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
        }
        CellArea floatarea = null;
        if (!deleterowpartition) {
            floatarea = new CellArea(dataPoint.y, dataPoint.x, areaManager.getAreaRange().getY_end() - dataPoint.y + 1, rowdims);
        }
        if (!deletecolpartition) {
            floatarea = new CellArea(dataPoint.y, dataPoint.x, areaManager.getAreaRange().getX_end() - dataPoint.x + 1, coldims);
        }
        if (floatarea != null) {
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange((List)Lists.newArrayList((Object[])new CellArea[]{floatarea}));
            CellStyleInfo cellStyle = new CellStyleInfo();
            if (!"1".equals(CommonUtils.getReportColorType((Long)modelId))) {
                cellStyle.setBkc("");
            }
            areasStyle.setStyle(cellStyle);
            if (resolveSpread) {
                spreadContainer.setCellStyle((List)Lists.newArrayList((Object[])new AreasStyle[]{areasStyle}));
            }
        }
    }

    protected static Point deleteRowColDimArea(ITemplateModel templateModel, MultiAreaManager areaManager, List<IMultiAreaSetting> areaSettings, int index, Point dataPoint, Map<String, List<PropertyObj>> propertyMap, boolean deleteRow, boolean deleteCol, IFormView formView, IEbSpreadManager spreadManager, ISpreadContainer spreadContainer, boolean resolveSpread) {
        boolean canDeleteRow;
        IMultiAreaSetting areaSetting = areaSettings.get(index);
        boolean isFloat = areaSetting.getFloatOnWhere() == 0 || areaSetting.getFloatOnWhere() == 1;
        int coldims = areaSetting.getColdims().size();
        int rowdims = areaSetting.getRowdims().size();
        if (propertyMap != null) {
            if (!isFloat) {
                coldims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims());
            }
            rowdims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
        }
        CellArea cellArea = new CellArea(areaSetting.getAreaRange());
        AutoFloatHelper autoFloatHelper = new AutoFloatHelper(formView, spreadManager, spreadContainer, templateModel);
        String overlapType = autoFloatHelper.checkRowColOverlap();
        boolean bl = deleteRow ? deleteRow : (canDeleteRow = !"row".equals(overlapType));
        boolean canDeleteCol = deleteCol ? deleteCol : !"col".equals(overlapType);
        Point newDataPoint = dataPoint;
        if (!isFloat) {
            int i;
            if (resolveSpread) {
                spreadContainer.fieldDeleteRowCol(cellArea, dataPoint.x, rowdims, false);
                spreadContainer.fieldDeleteRowCol(cellArea, dataPoint.y, coldims, true);
            }
            areaManager.getAreaRange().setX_end(areaManager.getAreaRange().getX_end() - rowdims);
            areaManager.getAreaRange().setY_end(areaManager.getAreaRange().getY_end() - coldims);
            cellArea.setCc(cellArea.getCc() - rowdims);
            cellArea.setRc(cellArea.getRc() - coldims);
            for (i = 0; i < rowdims; ++i) {
                if (areaManager.getData().getDataSheet().getMaxColumnCount() <= 0) continue;
                areaManager.getData().getDataSheet().delColumn(0);
            }
            for (i = 0; i < coldims; ++i) {
                if (areaManager.getData().getDataSheet().getMaxRowCount() <= 0) continue;
                areaManager.getData().getDataSheet().delRow(0);
            }
        } else if (areaSetting.getFloatOnWhere() == 0) {
            boolean hasReservedFloatCols;
            String[] startPointSplit = areaManager.getStartpoint().split(":");
            boolean bl2 = hasReservedFloatCols = Integer.parseInt(startPointSplit[0]) >= rowdims;
            if (hasReservedFloatCols) {
                if (resolveSpread) {
                    spreadContainer.fieldDeleteRowCol(cellArea, dataPoint.y, coldims, true);
                }
                CellArea cellArea_header = new CellArea(cellArea.getR(), cellArea.getC() + rowdims, dataPoint.y - cellArea.getR(), cellArea.getCc() - rowdims);
                CellArea cellArea_data = new CellArea(dataPoint.y, cellArea.getC(), cellArea.getRc() - cellArea_header.getRc(), cellArea.getCc());
                if (resolveSpread) {
                    spreadContainer.fieldDeleteRowCol(cellArea_header, dataPoint.x, rowdims, false);
                    spreadContainer.fieldDeleteRowCol(cellArea_data, dataPoint.x - rowdims, rowdims, false);
                }
                areaManager.getAreaRange().setX_end(areaManager.getAreaRange().getX_end() - rowdims);
                areaManager.getAreaRange().setY_end(areaManager.getAreaRange().getY_end() - coldims);
                for (int i = 0; i < coldims; ++i) {
                    if (areaManager.getData().getDataSheet().getMaxRowCount() <= 0) continue;
                    areaManager.getData().getDataSheet().delRow(0);
                }
                cellArea.setRc(cellArea.getRc() - coldims);
                areaManager.setStartpoint(Integer.parseInt(startPointSplit[0]) - rowdims + ":" + startPointSplit[1]);
                newDataPoint = new Point(dataPoint.x - rowdims, dataPoint.y);
            } else {
                canDeleteCol = false;
                if (resolveSpread) {
                    spreadContainer.fieldDeleteRowCol(cellArea, dataPoint.y, coldims, true);
                }
                areaManager.getAreaRange().setY_end(areaManager.getAreaRange().getY_end() - coldims);
                for (int i = 0; i < coldims; ++i) {
                    if (areaManager.getData().getDataSheet().getMaxRowCount() <= 0) continue;
                    areaManager.getData().getDataSheet().delRow(0);
                }
                cellArea.setRc(cellArea.getRc() - coldims);
            }
        }
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(coldims);
        if (canDeleteRow) {
            List bottomAreas;
            for (int i = coldims; i > 0; --i) {
                rowIndexes.add(i + areaManager.getAreaRange().getY_end());
            }
            if (resolveSpread) {
                spreadContainer.deleteRowCol(rowIndexes, null);
            }
            if ((bottomAreas = autoFloatHelper.getListOfBottomAreas(areaManager)) != null) {
                for (MultiAreaManager m : bottomAreas) {
                    m.getAreaRange().setY_start(m.getAreaRange().getY_start() - rowIndexes.size());
                    m.getAreaRange().setY_end(m.getAreaRange().getY_end() - rowIndexes.size());
                }
            }
        }
        ArrayList<Integer> colIndexes = new ArrayList<Integer>(16);
        if (canDeleteCol) {
            List rightAreas;
            for (int i = rowdims; i > 0; --i) {
                colIndexes.add(i + areaManager.getAreaRange().getX_end());
            }
            if (resolveSpread) {
                spreadContainer.deleteRowCol(null, colIndexes);
            }
            if ((rightAreas = autoFloatHelper.getListOfRightAreas(areaManager)) != null) {
                for (MultiAreaManager m : rightAreas) {
                    m.getAreaRange().setX_start(m.getAreaRange().getX_start() - colIndexes.size());
                    m.getAreaRange().setX_end(m.getAreaRange().getX_end() - colIndexes.size());
                }
            }
        }
        areaManager.getData().getDataSheet().iteratorECells(f -> {});
        TemplateFormulaUtil.getInstance().updateFormulaMap(spreadManager.getFormulaMap(), rowIndexes, colIndexes);
        String sourceFrom = formView.getPageCache().get("sourceFrom");
        if (!"excel".equals(sourceFrom)) {
            TemplateFormulaUtil.getInstance().clearAllFormulas(spreadContainer, spreadManager.getOutAreaHyperLink(), false);
        }
        TemplateFormulaUtil.getInstance().updateFormulaMap(spreadManager.getOutAreaHyperLink(), rowIndexes, colIndexes);
        return newDataPoint;
    }

    public static boolean isOnSameLine(IMultiAreaSetting a1, IMultiAreaSetting a2, boolean isRow) {
        if (a1 != null && a2 != null) {
            int rowDims1 = a1.getRowdims().size();
            int colDims1 = a1.getColdims().size();
            int rowDims2 = a2.getRowdims().size();
            int colDims2 = a2.getColdims().size();
            if (isRow && rowDims1 != rowDims2 || !isRow && colDims1 != colDims2 || a1.getFloatOnWhere() != a2.getFloatOnWhere()) {
                return false;
            }
            String[] range1 = a1.getAreaRange().split(":");
            String[] range2 = a2.getAreaRange().split(":");
            Point startPoint1 = ExcelUtils.pos2Point((String)range1[0]);
            Point startPoint2 = ExcelUtils.pos2Point((String)range2[0]);
            Point endPoint1 = ExcelUtils.pos2Point((String)range1[1]);
            Point endPoint2 = ExcelUtils.pos2Point((String)range2[1]);
            if (isRow) {
                return startPoint1.y == startPoint2.y && endPoint1.y == endPoint2.y;
            }
            return startPoint1.x == startPoint2.x && endPoint1.x == endPoint2.x;
        }
        return false;
    }

    public static void hiddenTemplateHyperLink(List<IMultiAreaSetting> areaRanges, ISpreadContainer spreadContainer) {
        if (CollectionUtils.isEmpty(areaRanges) || spreadContainer == null) {
            return;
        }
        ArrayList<ECell> eCells = new ArrayList<ECell>(16);
        for (IMultiAreaSetting areaRange : areaRanges) {
            Point absolutePosPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaRange.getAreaRange(), areaRange.getStartPosition());
            Map cellHyperLinkInfo = areaRange.getCellHyperLinkMap();
            if (cellHyperLinkInfo == null || cellHyperLinkInfo.size() <= 0) continue;
            ISheet areaSheet = areaRange.getAreaSheet();
            for (Map.Entry entry : cellHyperLinkInfo.entrySet()) {
                Set value = (Set)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                for (CellHyperLinkPOJO pojo : value) {
                    ECell eCell = areaSheet.getECell(pojo.getR() + absolutePosPoint.y, pojo.getC() + absolutePosPoint.x);
                    eCell.setValue(null);
                    eCells.add(eCell);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(eCells)) {
            spreadContainer.updateCellValue2(eCells);
        }
    }
}

