/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.formplugin.utils.PageParamModel;

public class OpenMenuPageUtil {
    public static void showFormViewByParam(PageParamModel pageModel) {
        String menuPageID;
        IFormView thisView = pageModel.getThisView();
        String markId = OpenMenuPageUtil.getMarkIdByFormApp(pageModel.getEntityId(), pageModel.getThisView());
        IFormView mainPageView = thisView.getMainView();
        if (mainPageView.getView(menuPageID = markId + mainPageView.getPageId()) != null) {
            IFormView childFormView = mainPageView.getView(menuPageID);
            childFormView.activate();
            thisView.sendFormAction(childFormView);
        } else {
            FormShowParameter param = pageModel.getParam();
            param.setFormId(pageModel.getEntityId());
            param.setStatus(OperationStatus.ADDNEW);
            param.getOpenStyle().setShowType(ShowType.NewTabPage);
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setPageId(menuPageID);
            param.setCustomParam("model", (Object)pageModel.getModelId());
            IFormView appPageView = thisView.getView(pageModel.getAppPageId());
            appPageView.showForm(param);
            thisView.sendFormAction(appPageView);
        }
    }

    public static String getMarkIdByFormApp(String entityId, IFormView thisView) {
        QFilter filter = new QFilter("number", "=", (Object)entityId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj != null) {
            String formId = obj.getString("id");
            List allAppnum = ApplicationTypeEnum.getAllAppnum();
            filter = new QFilter("number", "in", (Object)allAppnum);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{filter});
            for (DynamicObject doj : query) {
                AppMetadata am = AppMetaServiceHelper.loadAppMetadataById((String)doj.getString("id"));
                for (AppMenuElement aa : am.getAppMenus()) {
                    if (aa == null || aa.getFormId() == null || !aa.getFormId().equals(formId)) continue;
                    return aa.getId();
                }
            }
        }
        return entityId;
    }
}

