/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.permission.pojo.UserPermQueryPojo;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import org.apache.commons.lang3.StringUtils;

public class PermQueryReportUtil {
    public static final List<String> allFieldKey = Lists.newArrayList((Object[])new String[]{"usertype", "username", "usernumber", "model", "bizmodel", "dimension", "singlenumber", "singlename", "viewnumber", "viewname", "groupdim", "groupnumber", "groupname", "groupviewnumber", "groupviewname", "permitem", "permsource"});

    public static void setBizModelFilter(BasedataEdit bizModel, long model) {
        bizModel.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ArrayList<QFilter> qFilters = bizModel.getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>(10);
            }
            QFilter qFilter = new QFilter("model", "=", (Object)model);
            qFilters.add(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        });
    }

    public static List<kd.epm.eb.common.model.Dimension> getDimensionListByBizModel(long bizModel) {
        DatasetServiceHelper instance = DatasetServiceHelper.getInstance();
        return instance.listDimensionBybizmodelId(Long.valueOf(bizModel));
    }

    public static RowMeta getRowMeta(long modelId, String formType, boolean needBuildDimension, boolean needBuildDimGroup) {
        ArrayList<Field> fields = new ArrayList<Field>(10);
        fields.add(new Field("usertype", (DataType)DataType.StringType));
        fields.add(new Field("username", (DataType)DataType.StringType));
        fields.add(new Field("usernumber", (DataType)DataType.StringType));
        fields.add(new Field("model", (DataType)DataType.StringType));
        if (ModelServiceHelper.isBGMDModel((Long)modelId) && !"manage".equals(formType)) {
            fields.add(new Field("bizmodel", (DataType)DataType.StringType));
        }
        if (needBuildDimension) {
            fields.add(new Field("dimension", (DataType)DataType.StringType));
            fields.add(new Field("singlenumber", (DataType)DataType.StringType));
            fields.add(new Field("singlename", (DataType)DataType.StringType));
            if (!AdjustUtil.isEBModel(modelId)) {
                fields.add(new Field("viewnumber", (DataType)DataType.StringType));
                fields.add(new Field("viewname", (DataType)DataType.StringType));
            }
        }
        if (needBuildDimGroup) {
            fields.add(new Field("groupdim", (DataType)DataType.StringType));
            fields.add(new Field("groupnumber", (DataType)DataType.StringType));
            fields.add(new Field("groupname", (DataType)DataType.StringType));
            if (!AdjustUtil.isEBModel(modelId)) {
                fields.add(new Field("groupviewnumber", (DataType)DataType.StringType));
                fields.add(new Field("groupviewname", (DataType)DataType.StringType));
            }
        }
        fields.add(new Field("permitem", (DataType)DataType.StringType));
        fields.add(new Field("permsource", (DataType)DataType.StringType));
        return new RowMeta(fields.toArray(new Field[0]));
    }

    public static List<String> getPermItem(String selectPermItem) {
        ArrayList<String> permItem = new ArrayList<String>(10);
        if (StringUtils.isNotEmpty((CharSequence)selectPermItem)) {
            String[] split;
            for (String s : split = selectPermItem.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                permItem.add(s);
            }
        }
        return permItem;
    }

    public static DimMembPermType getDimMembPerTypeByIndex(int index) {
        for (DimMembPermType value : DimMembPermType.values()) {
            if (value.getIndex() != index) continue;
            return value;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e0d\u5b58\u5728", (String)"PermQueryReportUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public static List<DimMembPermType> getDimMembPermTypeList(String selectPermItem) {
        ArrayList<DimMembPermType> types = new ArrayList<DimMembPermType>(4);
        if (StringUtils.isNotEmpty((CharSequence)selectPermItem)) {
            String[] split;
            for (String s : split = selectPermItem.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                types.add(PermQueryReportUtil.getDimMembPerTypeByIndex(Integer.parseInt(s)));
            }
        } else {
            types.add(DimMembPermType.MANAGER);
        }
        return types;
    }

    public static Set<String> getMemberQuery(String selectMember) {
        HashSet<String> memberList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)selectMember)) {
            String[] split = selectMember.split(",");
            memberList.addAll(Arrays.asList(split));
        }
        return memberList;
    }

    public static List<List<String>> getAllDimensionByType(long modelId, String formType) {
        ArrayList<List<String>> groupNumber = new ArrayList<List<String>>(10);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        if (StringUtils.equals((CharSequence)"manage", (CharSequence)formType)) {
            QFilter qFilter = new QFilter("number", "not in", (Object)DimMembPermHelper.noCheckDimsOnManPerm);
            modelQf.and(qFilter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{modelQf});
        for (DynamicObject dynamicObject : dynamicObjects) {
            groupNumber.add(Collections.singletonList(dynamicObject.getString("number")));
        }
        return groupNumber;
    }

    public static Long getUserId() {
        return UserUtils.getUserId();
    }

    public static String getMemberIdStr(Map<String, MemberItem> memberGroup, IModelCacheHelper modelCacheHelper) {
        StringBuilder stringBuilder = new StringBuilder();
        modelCacheHelper.getDimensionList().forEach(dimension -> {
            MemberItem memberItem = (MemberItem)memberGroup.get(dimension.getNumber());
            if (memberItem != null) {
                stringBuilder.append(memberItem.getMemberId()).append("!").append(memberItem.isMember() ? "1" : "2").append("_");
            }
        });
        if (stringBuilder.toString().contains("_")) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static void getPermRecord(UserPermQueryPojo userPermQueryPojo, List<Map<String, String>> list, Map<String, String> dimGroupNameMap, Map<String, List<Map<String, String>>> permMap, Map<String, Map<String, Set<Long>>> memberFilters) {
        UserInfo currentUser = userPermQueryPojo.getCurrentUser();
        boolean currentUserIsGroup = currentUser.isUserGroup();
        List userInfos = userPermQueryPojo.getUserInfos();
        Map<Long, String> userGroupMap = userInfos.stream().filter(UserInfo::isUserGroup).collect(Collectors.toMap(UserInfo::getId, UserInfo::getName));
        if (!currentUserIsGroup) {
            userInfos.removeIf(UserInfo::isUserGroup);
        }
        List userIds = userInfos.stream().map(UserInfo::getId).collect(Collectors.toList());
        long modelId = userPermQueryPojo.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)modelId);
        long bizModelId = userPermQueryPojo.getBizModelId();
        Map<Long, String> viewMap = PermQueryReportUtil.getAllViewsByModel(modelId);
        Map memberNumberMap = userPermQueryPojo.getMemberNumberMap();
        HashSet singleMember = new HashSet(16);
        for (Map.Entry stringSetEntry : memberNumberMap.entrySet()) {
            singleMember.addAll((Collection)stringSetEntry.getValue());
        }
        Map groupMemberNumberMap = userPermQueryPojo.getGroupMemberNumberMap();
        HashSet groupMember = new HashSet(16);
        for (Map.Entry stringSetEntry : groupMemberNumberMap.entrySet()) {
            groupMember.addAll((Collection)stringSetEntry.getValue());
        }
        boolean needBuildGroupColumn = userPermQueryPojo.isNeedBuildGroupColumn();
        boolean needBuildDimension = userPermQueryPojo.isNeedBuildDimension();
        String formType = userPermQueryPojo.getFormType();
        String bizModelName = userPermQueryPojo.getBizModelName();
        String modelName = userPermQueryPojo.getModelName();
        String userType = currentUserIsGroup ? ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"PermQueryReportUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7528\u6237", (String)"PermQueryReportUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String userName = currentUser.getName();
        String userNumber = currentUser.getNumber();
        List permTypes = userPermQueryPojo.getPermTypes();
        List dimGroups = userPermQueryPojo.getDimGroups();
        boolean isManage = "manage".equals(formType);
        HashSet hasBuildRow = new HashSet(16);
        ArrayList<Map<String, String>> permDataList = new ArrayList<Map<String, String>>(3);
        DimMembPermHelper.readMemberPermBat((Long)modelId, (Long)bizModelId, (List)dimGroups, userIds, (List)permTypes, memberFilters, permCheckResult -> {
            block14: {
                boolean isFromGroup;
                String permSource;
                boolean isGroup;
                ArrayList strings;
                Set set;
                String memberIdStr;
                byte permVal;
                Map memberGroup;
                block15: {
                    Dimension dimension2;
                    Object next;
                    block13: {
                        String[] dimSplit;
                        List collect;
                        if (list.size() > 200000) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u83b7\u53d6\u5230\u8f83\u5927\u6570\u636e\u91cf\uff08\u8d85\u8fc7\u9884\u8bbe\u4e0a\u9650%1\u884c\uff09\uff0c\u53ef\u80fd\u5f71\u54cd\u6027\u80fd\uff0c\u65e0\u6cd5\u7ee7\u7eed\u67e5\u8be2\u3002\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u3002", (String)"PermQueryReportUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[]{200000}));
                        }
                        memberGroup = permCheckResult.getMemberGroup();
                        permVal = permCheckResult.getPermVal();
                        memberIdStr = PermQueryReportUtil.getMemberIdStr(memberGroup, modelCacheHelper);
                        set = memberGroup.keySet();
                        strings = new ArrayList(set.size());
                        isGroup = set.size() != 1;
                        String dimShortNumStr = permCheckResult.getDimShortNumStr();
                        permSource = userGroupMap.get(permCheckResult.getRefUserGroup()) == null ? "" : (String)userGroupMap.get(permCheckResult.getRefUserGroup());
                        isFromGroup = false;
                        if (StringUtils.isNotBlank((CharSequence)dimShortNumStr) && (collect = Arrays.stream(dimSplit = dimShortNumStr.split("!")).filter(StringUtils::isNotEmpty).collect(Collectors.toList())).size() >= 2) {
                            isFromGroup = true;
                        }
                        if (!isManage) break block13;
                        next = memberGroup.entrySet().iterator().next();
                        dimension2 = modelCacheHelper.getDimension((String)next.getKey());
                        MemberItem memberItem = (MemberItem)next.getValue();
                        Long memberId = memberItem.getMemberId();
                        boolean isMember = memberItem.isMember();
                        Long viewId = memberItem.getViewId();
                        boolean viewValid = IDUtils.isNull((Long)userPermQueryPojo.getViewId()) || Objects.equals(userPermQueryPojo.getViewId(), viewId);
                        boolean hasPerm = DimMembPermType.MANAGER.hasPerm(permVal);
                        if (!hasPerm || !viewValid || !singleMember.isEmpty() && !singleMember.contains(memberIdStr) || !hasBuildRow.add(memberIdStr + "!" + DimMembPermType.MANAGER.getIndex() + "!" + permCheckResult.getRefUserGroup() + "!" + viewId)) break block14;
                        PermQueryReportUtil.buildSingleData(propCache, viewMap, bizModelName, modelName, userType, userName, userNumber, permDataList, permSource, dimension2, memberId, viewId, isMember, DimMembPermType.MANAGER);
                        break block14;
                    }
                    if (needBuildGroupColumn) break block15;
                    if (isFromGroup) break block14;
                    next = memberGroup.entrySet().iterator().next();
                    dimension2 = modelCacheHelper.getDimension((String)next.getKey());
                    MemberItem memberItem = (MemberItem)next.getValue();
                    Long memberId = memberItem.getMemberId();
                    Long viewId = memberItem.getViewId();
                    boolean isMember = memberItem.isMember();
                    for (DimMembPermType permType : permTypes) {
                        boolean hasPerm = permType.hasPerm(permVal);
                        if (!hasPerm || !singleMember.isEmpty() && !singleMember.contains(memberIdStr) || !hasBuildRow.add(memberIdStr + "!" + permType.getIndex() + "!" + permCheckResult.getRefUserGroup() + "!" + viewId)) continue;
                        PermQueryReportUtil.buildSingleData(propCache, viewMap, bizModelName, modelName, userType, userName, userNumber, permDataList, permSource, dimension2, memberId, viewId, isMember, permType);
                    }
                    break block14;
                }
                if (!isGroup && singleMember.isEmpty() || singleMember.contains(memberIdStr) || isGroup && (groupMember.isEmpty() || groupMember.contains(memberIdStr))) {
                    modelCacheHelper.getDimensionList().forEach(dimension -> {
                        if (set.contains(dimension.getNumber())) {
                            strings.add(dimension.getNumber());
                        }
                    });
                    if (!isGroup && needBuildDimension && !isFromGroup) {
                        for (String string : strings) {
                            Dimension dimension3 = modelCacheHelper.getDimension(string);
                            MemberItem memberItem = (MemberItem)memberGroup.get(string);
                            Long memberId = memberItem.getMemberId();
                            Long viewId = memberItem.getViewId();
                            boolean isMember = memberItem.isMember();
                            for (DimMembPermType permType : permTypes) {
                                boolean hasPerm = permType.hasPerm(permVal);
                                if (!hasPerm || !hasBuildRow.add(memberIdStr + "!" + permType.getIndex() + "!" + permCheckResult.getRefUserGroup() + "!" + viewId)) continue;
                                PermQueryReportUtil.buildSingleData(propCache, viewMap, bizModelName, modelName, userType, userName, userNumber, permDataList, permSource, dimension3, memberId, viewId, isMember, permType);
                            }
                        }
                    } else if (isGroup) {
                        StringBuilder memberGroupNumber = new StringBuilder();
                        StringBuilder dimensionGroupNumber = new StringBuilder();
                        StringBuilder memberGroupName = new StringBuilder();
                        StringBuilder _groupViewNumber = new StringBuilder();
                        StringBuilder _groupViewName = new StringBuilder();
                        StringBuilder groupViewId = new StringBuilder();
                        for (String dimensionStr : strings) {
                            Dimension dimension4 = modelCacheHelper.getDimension(dimensionStr);
                            MemberItem memberItem = (MemberItem)memberGroup.get(dimensionStr);
                            Long memberId = memberItem.getMemberId();
                            Long viewId = memberItem.getViewId();
                            boolean isMember = memberItem.isMember();
                            if (isMember) {
                                Member member = dimension4.getMember(viewId, memberId);
                                memberGroupNumber.append(member.getNumber()).append(",");
                                memberGroupName.append(member.getName()).append(",");
                                View view = dimension4.getView(viewId);
                                _groupViewNumber.append(view != null ? view.getNumber() : " ").append(",");
                                _groupViewName.append(view != null ? view.getName() : " ").append(",");
                                groupViewId.append(view != null ? view.getId() : "0").append("!");
                            } else {
                                CustomPropertyValue propertyValue = propCache.getPropertyValue(memberId);
                                memberGroupNumber.append(propertyValue.getProp().getNumber()).append("!").append(propertyValue.getNumber()).append(",");
                                memberGroupName.append(propertyValue.getName()).append(",");
                                _groupViewNumber.append(" ").append(",");
                                _groupViewName.append(" ").append(",");
                                groupViewId.append("0").append("!");
                            }
                            dimensionGroupNumber.append(dimensionStr).append("#");
                        }
                        for (DimMembPermType permType : permTypes) {
                            boolean hasPerm = permType.hasPerm(permVal);
                            if (!hasPerm || !hasBuildRow.add(memberIdStr + "!" + permType.getIndex() + "!" + permCheckResult.getRefUserGroup() + "!" + groupViewId)) continue;
                            HashMap<String, String> permData = new HashMap<String, String>(16);
                            permData.put("usertype", userType);
                            permData.put("username", userName);
                            permData.put("usernumber", userNumber);
                            permData.put("model", modelName);
                            permData.put("bizmodel", bizModelName);
                            String groupDim = (String)dimGroupNameMap.get(dimensionGroupNumber.substring(0, dimensionGroupNumber.length() - 1));
                            String groupNumber = memberGroupNumber.substring(0, memberGroupNumber.length() - 1);
                            String groupName = memberGroupName.substring(0, memberGroupName.length() - 1);
                            String groupViewNumber = _groupViewNumber.substring(0, _groupViewNumber.length() - 1);
                            String groupViewName = _groupViewName.substring(0, _groupViewName.length() - 1);
                            permData.put("permitem", permType.getName());
                            permData.put("groupdim", groupDim);
                            permData.put("groupnumber", groupNumber);
                            permData.put("groupname", groupName);
                            permData.put("groupviewnumber", groupViewNumber);
                            permData.put("groupviewname", groupViewName);
                            permData.put("permsource", permSource);
                            permDataList.add(permData);
                        }
                    }
                }
            }
        });
        PermQueryReportUtil.refactorPermData(list, userPermQueryPojo, modelId, permDataList, permMap);
    }

    public static void buildSingleData(MemberPropCache propCache, Map<Long, String> viewMap, String bizModelName, String modelName, String userType, String userName, String userNumber, List<Map<String, String>> permDataList, String permSource, Dimension dimension, Long memberId, Long viewId, boolean isMember, DimMembPermType permType) {
        String singleName;
        String singleNumber;
        HashMap<String, String> permData = new HashMap<String, String>(16);
        permData.put("usertype", userType);
        permData.put("username", userName);
        permData.put("usernumber", userNumber);
        permData.put("model", modelName);
        permData.put("bizmodel", bizModelName);
        permData.put("dimension", dimension.getName());
        String viewNumber = "";
        String viewName = "";
        Member member = dimension.getMember(viewId, memberId);
        if (isMember) {
            singleNumber = member.getNumber();
            singleName = member.getName();
            if (IDUtils.isNotNull((Long)viewId)) {
                String viewSplit = viewMap.get(viewId);
                String[] viewSplitArr = viewSplit.split("!");
                viewNumber = viewSplitArr[0];
                if (viewSplitArr.length > 1) {
                    viewName = viewSplitArr[1];
                }
            }
        } else {
            CustomPropertyValue propertyValue = propCache.getPropertyValue(memberId);
            singleNumber = propertyValue.getProp().getNumber() + "!" + propertyValue.getNumber();
            singleName = propertyValue.getName();
        }
        permData.put("singlenumber", singleNumber);
        permData.put("singlename", singleName);
        permData.put("viewnumber", viewNumber);
        permData.put("viewname", viewName);
        permData.put("permitem", permType.getName());
        permData.put("permsource", permSource);
        if (!isMember || !MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) {
            permDataList.add(permData);
        }
    }

    public static void refactorPermData(List<Map<String, String>> list, UserPermQueryPojo userPermQueryPojo, long modelId, List<Map<String, String>> permDataList, Map<String, List<Map<String, String>>> permMap) {
        boolean noView = AdjustUtil.isEBModel(modelId);
        boolean noBizModel = !AdjustUtil.isBGMModel(modelId) || "manage".equals(userPermQueryPojo.getFormType());
        for (Map<String, String> map : permDataList) {
            LinkedHashMap<String, String> permData = new LinkedHashMap<String, String>(16);
            for (String field : allFieldKey) {
                permData.put(field, map.get(field) == null ? "" : map.get(field));
            }
            if (!userPermQueryPojo.isNeedBuildDimension()) {
                permData.remove("dimension");
                permData.remove("singlenumber");
                permData.remove("singlename");
                permData.remove("viewnumber");
                permData.remove("viewname");
            }
            if (!userPermQueryPojo.isNeedBuildGroupColumn()) {
                permData.remove("groupdim");
                permData.remove("groupnumber");
                permData.remove("groupname");
                permData.remove("groupviewnumber");
                permData.remove("groupviewname");
            }
            if (noView) {
                permData.remove("viewnumber");
                permData.remove("viewname");
                permData.remove("groupviewnumber");
                permData.remove("groupviewname");
            }
            if (noBizModel) {
                permData.remove("bizmodel");
            }
            list.add(permData);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)permData.get("groupnumber")))) {
                List group = permMap.computeIfAbsent("group", v -> new ArrayList(10));
                group.add(permData);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)permData.get("singlenumber")))) continue;
            List single = permMap.computeIfAbsent("single", v -> new ArrayList(10));
            single.add(permData);
        }
    }

    public static Map<Long, String> getAllViewsByModel(Long modelId) {
        DynamicObject[] dimensionViews;
        if (IDUtils.isNull((Long)modelId)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> viewMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        for (DynamicObject dimensionView : dimensionViews = BusinessDataServiceHelper.load((String)"eb_dimensionview", (String)"id,number,name", (QFilter[])qFilter.toArray())) {
            Long viewId = dimensionView.getLong("id");
            String viewNumber = dimensionView.getString("number");
            String viewName = dimensionView.getLocaleString("name").getLocaleValue();
            viewMap.put(viewId, viewNumber + "!" + viewName);
        }
        return viewMap;
    }
}

