/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.templateperm.TemplatePermCheckHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessQuoteService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ReportOpenUtil {
    private static Log log = LogFactory.getLog(ReportOpenUtil.class);

    public static String openReoprt(IFormView view, ReportProcessPojo pojo) {
        return ReportOpenUtil.openReoprt(view, pojo, null, null);
    }

    public static String openReoprt(IFormView view, ReportProcessPojo pojo, String openSourceParam) {
        return ReportOpenUtil.openReoprt(view, pojo, null, openSourceParam);
    }

    public static String openReoprt(IFormView view, ReportProcessPojo pojo, Map<String, String> dimensionAndMemberNumberMap) {
        return ReportOpenUtil.openReoprt(view, pojo, dimensionAndMemberNumberMap, null);
    }

    public static String openReoprt(IFormView view, ReportProcessPojo pojo, Map<String, String> dimensionAndMemberNumberMap, String openSourceParam) {
        return ReportOpenUtil.openReoprt(view, pojo, dimensionAndMemberNumberMap, openSourceParam, null);
    }

    public static String openReoprt(IFormView view, ReportProcessPojo pojo, Map<String, String> dimensionAndMemberNumberMap, String openSourceParam, String floatRows) {
        String pageKeyString;
        ReportProcessQuote next;
        Set reportProcessQuotes;
        boolean findQuote;
        if (view == null || pojo == null) {
            log.error("view :{}  ,pojo:{}", (Object)view, (Object)pojo);
            return null;
        }
        log.info("pojo :{} , dimensionAndMemberNumberMap:{}", (Object)JSONObject.toJSONString((Object)pojo), dimensionAndMemberNumberMap);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pojo.getReportProcessIdLong(), (String)"eb_reportprocess");
        boolean isFromTask = pojo.getReportProcessTypeString().equals(ProcessTypeEnum.TASK.getNumber());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ReportOpenUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long modelId = dynamicObject.getLong("model.id");
        Map quotes = ReportProcessQuoteService.getInstance().getReportProcessQuote(Long.valueOf(dynamicObject.getLong("id")), Long.valueOf(modelId));
        if (quotes == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6765\u6e90\u672a\u627e\u5230\uff0c\u65e0\u6cd5\u6253\u5f00\u62a5\u8868\u3002", (String)"BgTaskExecutePlugin_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (isFromTask) {
            findQuote = true;
            reportProcessQuotes = (Set)quotes.get(ProcessTypeEnum.TASK);
            if (CollectionUtils.isEmpty((Collection)reportProcessQuotes)) {
                findQuote = false;
            }
            if (findQuote) {
                Optional<ReportProcessQuote> first = reportProcessQuotes.stream().filter(x -> x.getReportOrTaskIdLong().equals(pojo.getReportOrTaskIdLong())).findFirst();
                if (!first.isPresent()) {
                    ReportProcessQuote next2 = (ReportProcessQuote)reportProcessQuotes.iterator().next();
                    pojo.setReportOrTaskIdLong(next2.getReportOrTaskIdLong());
                }
            } else {
                log.info("\u6ca1\u6709\u627e\u5230\u4efb\u52a1\u627e\u7f16\u5236\u65b9\u6848\u770b\u80fd\u5426\u627e\u5230\u5f15\u7528");
                reportProcessQuotes = (Set)quotes.get(ProcessTypeEnum.REPORT);
                if (!CollectionUtils.isEmpty((Collection)reportProcessQuotes)) {
                    next = (ReportProcessQuote)reportProcessQuotes.iterator().next();
                    pojo.setReportOrTaskIdLong(next.getSourceId());
                    pojo.setReportProcessTypeString(ProcessTypeEnum.REPORT.getNumber());
                    isFromTask = false;
                    findQuote = true;
                }
            }
            if (!findQuote) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6765\u6e90\u672a\u627e\u5230\uff0c\u65e0\u6cd5\u6253\u5f00\u62a5\u8868\u3002", (String)"BgTaskExecutePlugin_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            findQuote = true;
            reportProcessQuotes = (Set)quotes.get(ProcessTypeEnum.REPORT);
            if (CollectionUtils.isEmpty((Collection)reportProcessQuotes)) {
                findQuote = false;
            }
            if (findQuote) {
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                qFilter.and("scheme", "=", (Object)pojo.getReportOrTaskIdLong());
                DynamicObjectCollection id = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (CollectionUtils.isEmpty((Collection)id)) {
                    findQuote = false;
                }
                if (findQuote) {
                    Set idSet = id.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                    Optional<ReportProcessQuote> first = reportProcessQuotes.stream().filter(x -> idSet.contains(x.getSourceId2())).findFirst();
                    if (!first.isPresent()) {
                        ReportProcessQuote next3 = (ReportProcessQuote)reportProcessQuotes.iterator().next();
                        pojo.setReportOrTaskIdLong(next3.getSourceId());
                    }
                } else {
                    ReportProcessQuote next4 = (ReportProcessQuote)reportProcessQuotes.iterator().next();
                    pojo.setReportOrTaskIdLong(next4.getSourceId());
                    findQuote = true;
                }
            } else {
                reportProcessQuotes = (Set)quotes.get(ProcessTypeEnum.TASK);
                log.info("\u6ca1\u6709\u627e\u5230\u65b9\u6848\u627e\u4efb\u52a1\u770b\u80fd\u5426\u627e\u5230\u5f15\u7528");
                if (!CollectionUtils.isEmpty((Collection)reportProcessQuotes)) {
                    next = (ReportProcessQuote)reportProcessQuotes.iterator().next();
                    pojo.setReportOrTaskIdLong(next.getReportOrTaskIdLong());
                    pojo.setReportProcessTypeString(ProcessTypeEnum.TASK.getNumber());
                    isFromTask = true;
                    findQuote = true;
                }
            }
            if (!findQuote) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6765\u6e90\u672a\u627e\u5230\uff0c\u65e0\u6cd5\u6253\u5f00\u62a5\u8868\u3002", (String)"BgTaskExecutePlugin_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        if (ReportOpenUtil.setFormId(modelId, pojo, dynamicObject, formShowParameter)) {
            return null;
        }
        formShowParameter.setCustomParam("modelid", (Object)modelId);
        formShowParameter.setCustomParam("tabkey", (Object)"tab_myreport");
        formShowParameter.setCustomParam("relationGraph", (Object)"1");
        formShowParameter.setCustomParam("model", (Object)String.valueOf(modelId));
        formShowParameter.setCustomParam("openSourceParam", (Object)openSourceParam);
        if (floatRows != null) {
            formShowParameter.setCustomParam("reportfloatrows" + pojo.getReportProcessIdLong(), (Object)floatRows);
        }
        if (isFromTask) {
            QFilter qFilter = new QFilter("task", "=", (Object)pojo.getReportOrTaskIdLong());
            qFilter.and("org", "=", (Object)dynamicObject.getLong("entity.id"));
            qFilter.and("template", "=", (Object)dynamicObject.getLong("template.id"));
            DynamicObjectCollection id = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id", (QFilter[])qFilter.toArray());
            List id1 = id.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            formShowParameter.setCustomParam("taskProcessIds", (Object)SerializationUtils.toJsonString(id1));
            formShowParameter.setCustomParam("orgid", (Object)String.valueOf(dynamicObject.getLong("entity.id")));
            if (pojo.getTemplatePojo() != null) {
                formShowParameter.setCustomParam("templateId", (Object)String.valueOf(pojo.getTemplatePojo().getTemplateIdLong()));
            } else {
                formShowParameter.setCustomParam("templateId", (Object)String.valueOf(dynamicObject.getLong("template.id")));
            }
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6211\u6267\u884c\u7684\u4efb\u52a1", (String)"ReportOpenUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter.setCustomParam("source", (Object)pojo.getReportOrTaskIdLong());
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u5217\u8868", (String)"ReportOpenUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (dimensionAndMemberNumberMap != null) {
            formShowParameter.setCustomParam("relationGraphMemberMap", (Object)SerializationUtils.toJsonString(dimensionAndMemberNumberMap));
            pageKeyString = view.getPageId() + dimensionAndMemberNumberMap.hashCode() + pojo.getReportProcessIdLong();
            formShowParameter.setPageId(pageKeyString);
        } else {
            Long reportProcessIdLong = pojo.getReportProcessIdLong();
            pageKeyString = view.getPageId() + reportProcessIdLong + System.currentTimeMillis();
            formShowParameter.setPageId(pageKeyString);
        }
        formShowParameter.setCustomParam("BILL_ORGID", (Object)dynamicObject.getLong("entity.id"));
        formShowParameter.setCustomParam("BILL_PROCESSID", (Object)SerializationUtils.toJsonString(Collections.singletonList(pojo.getReportProcessIdLong())));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(formShowParameter);
        return pageKeyString;
    }

    private static boolean setFormId(Long modelId, ReportProcessPojo pojo, DynamicObject dynamicObject, FormShowParameter formShowParameter) {
        long templateid = dynamicObject.getLong("template.id");
        long entityId = dynamicObject.getLong("entity.id");
        Long userId = ReportOpenUtil.getUserId();
        String reportProcessTypeString = pojo.getReportProcessTypeString();
        if (StringUtils.isEmpty((String)reportProcessTypeString)) {
            log.error("\u62a5\u8868\u7c7b\u578b\u4e3a\u7a7a");
            return true;
        }
        String formId = null;
        if (reportProcessTypeString.equals(ProcessTypeEnum.REPORT.getNumber())) {
            formId = "bgm_rptpreparation";
            QFilter qFilter = new QFilter("scheme", "=", (Object)pojo.getReportOrTaskIdLong());
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"id", (QFilter[])qFilter.toArray());
            if (ids.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ReportOpenUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!TemplatePermCheckHelper.checkUserOrUserGroupTemplatePerm((Long)modelId, (Long)userId, (Long)templateid, (Long)entityId, (Long)pojo.getReportOrTaskIdLong())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u9884\u7b97\u6a21\u677f\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"ReportOpenUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!ReportOpenUtil.checkUserHasOrgPerm(templateid, modelId, entityId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u62a5\u8868\u7f16\u5236\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"ReportOpenUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (reportProcessTypeString.equals(ProcessTypeEnum.TASK.getNumber())) {
            formId = "eb_executetask";
            QFilter qFilter = new QFilter("task", "=", (Object)pojo.getReportOrTaskIdLong());
            qFilter.and("org", "=", (Object)dynamicObject.getLong("entity.id"));
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"id", (QFilter[])qFilter.toArray());
            if (ids.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ReportOpenUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!ReportOpenUtil.checkDispatchUser(pojo, dynamicObject, formShowParameter)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u4efb\u52a1\u6267\u884c\u4eba\u6216\u76d1\u7763\u4eba\u3002", (String)"ReportOpenUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            log.error("\u62a5\u8868\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a{}", (Object)reportProcessTypeString);
            return true;
        }
        formShowParameter.setFormId(formId);
        return false;
    }

    private static boolean checkUserHasOrgPerm(Long templateId, Long modelId, Long entityId) {
        boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
        if (modelManager) {
            return true;
        }
        String selectFields = "id,dataset.businessmodel_id";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (dynamicObject == null) {
            return false;
        }
        Set<Long> hasPerm = ReportOpenUtil.getHasOrgPerm(dynamicObject.getLong("dataset.businessmodel_id"), modelId);
        if (hasPerm.size() == 0) {
            return false;
        }
        return hasPerm.contains(entityId);
    }

    private static Set<Long> getHasOrgPerm(Long bizModelId, Long modelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List viewList = modelCache.getViewGroupViewsByBusModelAndDimNumber(bizModelId, SysDimensionEnum.Entity.getNumber());
        if (CollectionUtils.isEmpty((Collection)viewList)) {
            return Collections.emptySet();
        }
        HashSet<Long> set = new HashSet<Long>(16);
        for (Long viewId : viewList) {
            Set entity = DimMembPermHelper.getReadPermMembIds((String)"Entity", (Long)modelId, (Long)bizModelId, (Long)viewId, (boolean)true);
            if (!CollectionUtils.isNotEmpty((Collection)entity)) continue;
            set.addAll(entity);
        }
        return set;
    }

    private static boolean checkDispatchUser(ReportProcessPojo pojo, DynamicObject dynamicObject, FormShowParameter formShowParameter) {
        HashSet executeSet = new HashSet(16);
        HashSet supervisorSet = new HashSet(16);
        StringBuilder stringBuilder = new StringBuilder("select  ts.fsupervisorid,te.fbasedataid from t_eb_taskprocess tp left join t_eb_taskprosupervisor ts on ts.fid = tp.fid left join t_eb_taskproces_executors te on tp .fid  = te.fid where tp.ftaskid = ? and tp.forgid = ? ");
        DB.query((DBRoute)DBRoute.of((String)"epm"), (String)stringBuilder.toString(), (Object[])new Object[]{pojo.getReportOrTaskIdLong(), dynamicObject.getLong("entity.id")}, rs -> {
            while (rs.next()) {
                supervisorSet.add(rs.getLong("fsupervisorid"));
                executeSet.add(rs.getLong("fbasedataid"));
            }
            if (supervisorSet.contains(ReportOpenUtil.getUserId()) && !executeSet.contains(ReportOpenUtil.getUserId())) {
                formShowParameter.setCustomParam("role", (Object)"supervisor");
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6211\u76d1\u7763\u7684\u4efb\u52a1", (String)"ReportOpenUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return executeSet.contains(ReportOpenUtil.getUserId()) || supervisorSet.contains(ReportOpenUtil.getUserId());
        });
        return executeSet.contains(ReportOpenUtil.getUserId()) || supervisorSet.contains(ReportOpenUtil.getUserId());
    }

    private static Long getUserId() {
        RequestContext requestContext = RequestContext.getOrCreate();
        Long userId = IDUtils.toLong((Object)requestContext.getUserId());
        return userId;
    }

    public static boolean checkDispatchUserByRole(Long processId, Long entityId, String role) {
        HashSet executeSet = new HashSet(16);
        HashSet supervisorSet = new HashSet(16);
        StringBuilder stringBuilder = new StringBuilder("select  ts.fsupervisorid,te.fbasedataid from t_eb_taskprocess tp left join t_eb_taskprosupervisor ts on ts.fid = tp.fid  left join \nt_eb_taskproces_executors te on tp .fid  = te.fid where tp.ftaskid = ? and tp.forgid = ? ");
        DB.query((DBRoute)DBRoute.of((String)"epm"), (String)stringBuilder.toString(), (Object[])new Object[]{processId, entityId}, rs -> {
            while (rs.next()) {
                supervisorSet.add(rs.getLong("fsupervisorid"));
                executeSet.add(rs.getLong("fbasedataid"));
            }
            if ("supervisor".equals(role)) {
                return supervisorSet.contains(ReportOpenUtil.getUserId());
            }
            return executeSet.contains(ReportOpenUtil.getUserId());
        });
        if ("supervisor".equals(role)) {
            return supervisorSet.contains(ReportOpenUtil.getUserId());
        }
        return executeSet.contains(ReportOpenUtil.getUserId());
    }
}

