/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.DimensionView.ViewMemberUpgradeService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.quote.QuoteTemplateUpgradeService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessUpgradeService;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.impl.ShrekMember;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.ApproveBill.ApproveBillUtil;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimMembers;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.formplugin.dimension.DimensionManagerList;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.metadata.KDCellMeta;
import org.apache.commons.collections4.CollectionUtils;

public class RuleAggregatePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(RuleAggregatePlugin.class);
    private static final String CACHE_DIMENSION = "cache_dimension";
    private static final String BTN_CLEAR_REF = "btnclearref";
    private static final String BTN_BUILD_DATA = "butbuilddata";
    private static final String SYNC_BUDGET_OCCUPATION = "sync_budget_occupation";
    private static final String BTN_UPCONTROLRECORD = "btnupcontrolrecord";
    private static final String BTN_OLAP2SHREK = "btnolap2shrek";
    private static final String versionTable = "t_eb_controlversion";
    private static final String mateRuleTable = "t_eb_dimmaterulebill";
    private static final String controlRuleTable = "t_eb_controlrulemain";
    private static final String dimmappingTable = "t_eb_dimmembermapping";
    private static final String centralizedTable = "t_eb_centralized_entity";
    private static final String UPBUSINESSMODEL = "upbusinessmodel";
    private static final String BTN_UPREPORTSTATUS = "btn_upreportstatus";
    private static final String BTN_DELETEREPEATRPT = "btn_deleterepeatrpt";
    private static final String BTN_MEMTEMPQOUTE = "btn_memtempqoute";
    private static final String BTN_ADJDATARESTORE = "btn_adjdatarestore";
    private static final String DB_DATASOURCE = "datasource";
    private static final String CLOSE_BACK_SELECTMEMBERS = "selectmembers";
    private static final String CLEARUSERSELECT = "clearuserselect";
    private static final String BTN_UPGRADEREPORTPROCESS = "btn_upgradereportprocess";
    private static final String BTN_UPDATEREPORTPROCESSSTATUS = "btn_updatestatus";
    private static final String BTN_UPDATEREPORTPROCESSDATA = "btn_updatedata";
    private static final String BTN_CHECK_SHREK = "btncheckshrek";
    private static final String BTN_UP_SHREK = "btnupshrek";
    private static final String BTN_APPROVEBILL_REJECT = "btn_approvebill_reject";
    private static final String BTN_LANGUAGE_UPGRADE = "btn_language_upgrade";
    private static final String BTN_GETDATALOCK = "btn_getdatalock";
    private static final String BTN_KUACUBE = "btn_kuacube";
    private static final String BTN_UPDATEDATALOCK = "btn_updatedatalock";
    private static final String BTN_UPDATERULECASE = "btn_updaterulecase";
    private static final String BTN_CHECK_L = "btncheckl";
    private static final String BTN_UPDATE_MODEL_VER_NUM = "btnupdatemodelvernum";
    private IModelCacheHelper modelCacheHelper = null;
    private static final Set<String> ProcessSet = new HashSet<String>(16);
    private static final Set<String> InternalCompany = new HashSet<String>(16);
    private static final Set<String> ChangeType = new HashSet<String>(16);

    public RuleAggregatePlugin() {
        ProcessSet.add("IRpt");
        InternalCompany.add("ICNone");
        ChangeType.add("CurrentPeriod");
    }

    public void destory() {
        super.destory();
        ModelCacheContext.remove();
        MemberPropCacheService.remove();
    }

    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    public IModelCacheHelper getModelCacheHelper(boolean isCreate) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getBizModel().getLong("id"), (boolean)isCreate);
        }
        return this.modelCacheHelper;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.getModelCacheHelper(false);
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_BUILD_DATA, BTN_CLEAR_REF});
        this.addClickListeners(new String[]{BTN_ADJDATARESTORE, BTN_UPREPORTSTATUS, BTN_UPGRADEREPORTPROCESS});
        this.addClickListeners(new String[]{"members", SYNC_BUDGET_OCCUPATION});
        this.addClickListeners(new String[]{BTN_UPCONTROLRECORD});
        this.addClickListeners(new String[]{BTN_OLAP2SHREK});
        this.addClickListeners(new String[]{CLEARUSERSELECT});
        this.addClickListeners(new String[]{BTN_DELETEREPEATRPT});
        this.addClickListeners(new String[]{BTN_UPDATEREPORTPROCESSSTATUS, BTN_UPDATEREPORTPROCESSDATA, BTN_APPROVEBILL_REJECT, BTN_GETDATALOCK, BTN_UPDATEDATALOCK, BTN_UPDATERULECASE});
        this.addClickListeners(new String[]{BTN_MEMTEMPQOUTE, BTN_CHECK_SHREK, BTN_UP_SHREK, "btntestapi", BTN_CHECK_L});
        this.addClickListeners(new String[]{BTN_KUACUBE});
        this.addClickListeners(new String[]{"btnviewupgrade", "btnrefviewupgrade", BTN_UPDATE_MODEL_VER_NUM});
        this.addClickListeners(new String[]{BTN_LANGUAGE_UPGRADE});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit busModel = (BasedataEdit)this.getControl("busmodel");
        busModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataset = (BasedataEdit)this.getControl("dataset");
        dataset.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datasource = (BasedataEdit)this.getControl(DB_DATASOURCE);
        datasource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
    }

    private void beginMessage(String msg, String key) {
        this.getView().showMessage(ResManager.loadResFormat((String)"\u5f00\u59cb%1", (String)"RuleAggregatePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{msg}));
        this.getView().addClientCallBack(key, Integer.valueOf(3000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clientCallBack(ClientCallBackEvent e) {
        String key = e.getName();
        try {
            switch (key) {
                case "btnclearref": {
                    this.clearMemberPropertyRef();
                    return;
                }
                case "butbuilddata": {
                    this.buildData();
                    return;
                }
                case "sync_budget_occupation": {
                    this.clickSyncBudgetOccupationBtn();
                    return;
                }
                case "btnupcontrolrecord": {
                    this.upBgControlRecord();
                    return;
                }
                case "btnolap2shrek": {
                    this.olap2Shrek();
                    return;
                }
                case "btn_adjdatarestore": {
                    this.restoreAdjData();
                    return;
                }
                case "upbusinessmodel": {
                    this.upBussmodel();
                    this.upControlRecord();
                    return;
                }
                case "btn_upreportstatus": {
                    this.restoreDynamicReportStatus();
                    return;
                }
                case "btn_upgradereportprocess": {
                    this.upgradeReportProcess();
                    return;
                }
                case "btn_deleterepeatrpt": {
                    this.deleteRepeatReportProcess();
                    return;
                }
                case "btn_updatestatus": {
                    this.updateReportProcessStatus();
                    return;
                }
                case "btn_updatedata": {
                    this.updateReportProcessData();
                    return;
                }
                case "btn_memtempqoute": {
                    this.saveMemberTemplateQuote();
                    return;
                }
                case "btncheckshrek": {
                    this.checkAndUpShrek(false);
                    return;
                }
                case "btnupshrek": {
                    this.checkAndUpShrek(true);
                    return;
                }
                case "btn_approvebill_reject": {
                    this.updateApproveBillReject();
                    return;
                }
                case "btn_language_upgrade": {
                    this.languageUpgrade();
                    return;
                }
                case "btn_kuacube": {
                    this.kuaCubeUpgrade();
                    return;
                }
            }
            return;
        }
        finally {
            this.enableOrdisable(true);
        }
    }

    private void kuaCubeUpgrade() {
        DynamicObject model = this.getBizModel();
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"RuleAggregatePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Model model1 = new Model();
        model1.setId((Long)model.get("id"));
        model1.setNumber((String)model.get("shownumber"));
        model1.setDataSourceId((Long)model.get("datasource.id"));
        model1.setReportType((String)model.get("reportType"));
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"KuaCubeUpgradeService", (String)"updateByModel", (Object[])new Object[]{model1});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"RuleAggregatePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void getDataLick() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"RuleAggregatePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void languageUpgrade() {
        DynamicObject model = this.getBizModel();
        String modelId = model != null ? model.getString("id") : null;
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"LanguageDimUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{modelId, null, null, null});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u591a\u8bed\u8a00\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u3002", (String)"BgmdModelList_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void saveMemberTemplateQuote() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            new QuoteTemplateUpgradeService().updateTemplateMemberQuote();
            this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RuleAggregatePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            try {
                new QuoteTemplateUpgradeService().saveTemplateMemberQuote(modelId);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RuleAggregatePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
                this.getView().showMessage(ResManager.loadResFormat((String)"\u4fdd\u5b58\u53d1\u751f\u5f02\u5e38\uff1a%1", (String)"RuleAggregatePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)exception)}));
            }
        }
    }

    private void deleteRepeatReportProcess() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        try {
            ReportProcessUpgradeService.getInstance().removeRepeatReportProcess(modelId);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            throw new KDBizException(ThrowableHelper.toString((Exception)exception));
        }
    }

    private void updateReportProcessStatus() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"RuleAggregatePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = model.getLong("id");
        this.updateReportProcessStatus(modelId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"RuleAggregatePlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void updateReportProcessData() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"RuleAggregatePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = model.getLong("id");
        QFilter reportProcessQFilter = new QFilter("model", "=", (Object)modelId);
        String reportSelect = "id,model,entity,template,period,version,datatype,approvebill,status,submituser,submitdate,submitentity";
        DynamicObjectCollection reportProcesses = QueryServiceHelper.query((String)"eb_reportprocess", (String)reportSelect, (QFilter[])reportProcessQFilter.toArray());
        HashMap<String, DynamicObject> reportMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dynamicObject : reportProcesses) {
            String str = this.createReportProcessDimStr(dynamicObject.getString("model"), dynamicObject.getString("period"), dynamicObject.getString("datatype"), dynamicObject.getString("version"), dynamicObject.getString("entity"), dynamicObject.getString("template"));
            reportMap.put(str, dynamicObject);
        }
        QFilter approveBillQFilter = new QFilter("modelid", "=", (Object)modelId);
        String approveBillSelect = "id,billstatus,modelid,dim_period,dim_datatype,dim_version,eborgid,entryentity.tempid,createrid,createdate";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)approveBillSelect, (QFilter[])approveBillQFilter.toArray());
        HashMap<String, Object> approveBillMap = new HashMap<String, Object>(16);
        for (Object dynamicObject : approveBills) {
            String string = this.createReportProcessDimStr(dynamicObject.getString("modelid"), dynamicObject.getString("dim_period"), dynamicObject.getString("dim_datatype"), dynamicObject.getString("dim_version"), dynamicObject.getString("eborgid"), dynamicObject.getString("entryentity.tempid"));
            approveBillMap.put(string, dynamicObject);
        }
        ArrayList<Object[]> needUpdateList = new ArrayList<Object[]>(16);
        for (Map.Entry entry : reportMap.entrySet()) {
            String str = (String)entry.getKey();
            DynamicObject reportProcess = (DynamicObject)entry.getValue();
            if (!approveBillMap.containsKey(str)) continue;
            String reportProcessStatus = reportProcess.getString("status");
            DynamicObject approveBill = (DynamicObject)approveBillMap.get(str);
            String approveBillStatus = approveBill.getString("billstatus");
            if (!BgTaskStateEnum.TEMPSAVE.getNumber().equals(reportProcessStatus) || !"B".equals(approveBillStatus)) continue;
            reportProcess.set("status", (Object)BgTaskStateEnum.UNDERWAY.getNumber());
            reportProcess.set("approvebill", (Object)approveBill.getLong("id"));
            reportProcess.set("submituser", (Object)approveBill.getLong("createrid"));
            reportProcess.set("submitentity", (Object)approveBill.getLong("eborgid"));
            reportProcess.set("submitdate", (Object)approveBill.getDate("id"));
            Object[] obj = new Object[]{BgTaskStateEnum.UNDERWAY.getNumber(), approveBill.getLong("id"), approveBill.getLong("createrid"), approveBill.getLong("eborgid"), approveBill.getDate("createdate"), reportProcess.getLong("id")};
            needUpdateList.add(obj);
        }
        if (CollectionUtils.isNotEmpty(needUpdateList)) {
            String updateSql = "update t_eb_reportprocess set fstatus = ?, fapprovebill = ?, fsubmituser = ?, fsubmitentity = ?, fsubmitdate = ? where fid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, needUpdateList);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u6210\u529f", (String)"RuleAggregatePlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e", (String)"RuleAggregatePlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String createReportProcessDimStr(String model, String period, String datatype, String version, String entity, String template) {
        return model + "#" + period + "#" + datatype + "#" + version + "#" + entity + "#" + template;
    }

    private void upgradeReportProcess() {
        Object model = this.getModel().getValue("model");
        if (model == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u8fd9\u4e2a\u6309\u94ae\u5347\u7ea7\u4f1a\u5347\u7ea7\u6240\u6709\u4f53\u7cfb\u7684\u5b9e\u4f8b\uff0c\u662f\u5426\u786e\u8ba4\u5347\u7ea7\uff1f", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("upgradeAllModelReportProcess", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u8fd9\u4e2a\u6309\u94ae\u5347\u7ea7\u4f1a\u5c06\u5df2\u5347\u7ea7\u8fc7\u7684\u5b9e\u4f8b\u72b6\u6001\u91cd\u7f6e\u4e3a\u65e7\u6570\u636e\u7684\u72b6\u6001\uff0c\u662f\u5426\u786e\u8ba4\u5347\u7ea7\uff1f", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("upgradeReportProcess", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (result == MessageBoxResult.Yes && org.apache.commons.lang3.StringUtils.equals((CharSequence)callBackId, (CharSequence)"upgradeReportProcess")) {
            ReportProcessUpgradeService.getInstance().updateSingleModelProcess(this.getModelId(), true);
            ReportProcessUpgradeService.getInstance().updateSingleModelReportAttachment(this.getModelId());
            this.updateReportProcessStatus(this.getModelId());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OK);
        } else if (result == MessageBoxResult.Yes && org.apache.commons.lang3.StringUtils.equals((CharSequence)callBackId, (CharSequence)"upgradeAllModelReportProcess")) {
            Set allBgmModelIdSet = ReportProcessUpgradeService.getInstance().getAllBgmModelIdSet();
            for (Long modelId : allBgmModelIdSet) {
                ReportProcessUpgradeService.getInstance().updateSingleModelProcess(modelId, false);
                ReportProcessUpgradeService.getInstance().updateSingleModelReportAttachment(modelId);
                this.updateReportProcessStatus(modelId);
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OK);
        } else if (result == MessageBoxResult.Yes && org.apache.commons.lang3.StringUtils.equals((CharSequence)callBackId, (CharSequence)BTN_UPDATEDATALOCK)) {
            Long modelId = this.getModelId();
            if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("delete from t_bgmd_datalockcasedetail where fcaseid in (select fid from t_bgmd_datalockcase where fmodelid = " + modelId + ")"));
            DeleteServiceHelper.delete((String)"bgmd_datalockcase", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"DataLockUpgradeImpl", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, new Object[]{modelId}});
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OK);
        } else if (result == MessageBoxResult.Yes && org.apache.commons.lang3.StringUtils.equals((CharSequence)callBackId, (CharSequence)BTN_UPDATERULECASE)) {
            Long modelId = this.getModelId();
            if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("delete from t_eb_ruleexeccase_rule where fid in (select fid from t_eb_executecase where fmodelid = " + modelId + ")"));
            DeleteServiceHelper.delete((String)"eb_ruleexeccase", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RuleCaseUpgradeImpl", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, new Object[]{modelId}});
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"", (String)"", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
    }

    private void updateReportProcessStatus(Long modelId) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_EB_REPORTPROCESS SET fstatus = '0' WHERE (fstatus = '' or fstatus = ' ')");
        sql.append(" and fmodel = ").append(modelId).append(";");
        DBRoute route = new DBRoute("EPM");
        DB.update((DBRoute)route, (String)sql.toString());
    }

    private Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model == null) {
            return 0L;
        }
        DynamicObject dynamicObject = (DynamicObject)model;
        return dynamicObject.getLong("id");
    }

    private void restoreDynamicReportStatus() {
        Object[] param;
        DynamicObject[] dynamicReportList;
        DynamicObject[] schemeAssigns = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
        HashSet<Long> schemeAssignIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : schemeAssigns) {
            schemeAssignIds.add(dynamicObject.getLong("id"));
        }
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> processIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicReportList = BusinessDataServiceHelper.load((String)"eb_dynamicreportentity", (String)"id, template, status", (QFilter[])new QFilter[]{new QFilter("schemeassign", "in", schemeAssignIds), new QFilter("status", "=", (Object)BgTaskStateEnum.UNSTARTED.getNumber())})) {
            templateIds.add(dynamicObject.getLong("template.id"));
            processIds.add(dynamicObject.getLong("id"));
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,entryentity.taskprocessjson,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", Arrays.asList("B", "E")), new QFilter("rptProcessType", "=", (Object)(ProcessTypeEnum.REPORT.getIndex() + "")), new QFilter("entryentity.tempid", "in", templateIds)});
        HashSet<Long> toUpdateEProcessIds = new HashSet<Long>(16);
        HashSet<Long> toUpdateBProcessIds = new HashSet<Long>(16);
        if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                String billstatus = dynamicObject.getString("billstatus");
                for (DynamicObject object : entryentity) {
                    String json = object.getString("taskprocessjson");
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)json)) continue;
                    Set taskProcessIds = IDUtils.toLongs((Set)ApproveBillUtil.getTaskProcessIdSet((String)json));
                    for (Long processId : processIds) {
                        if (!taskProcessIds.contains(processId)) continue;
                        if (StringUtils.equals((String)"B", (String)billstatus)) {
                            toUpdateBProcessIds.add(processId);
                            continue;
                        }
                        if (!StringUtils.equals((String)"E", (String)billstatus)) continue;
                        toUpdateEProcessIds.add(processId);
                    }
                }
            }
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(16);
        for (Long toUpdateBProcessId : toUpdateBProcessIds) {
            param = new Object[]{BgTaskStateEnum.UNDERWAY.getNumber(), toUpdateBProcessId};
            arrayList.add(param);
        }
        for (Long toUpdateEProcessId : toUpdateEProcessIds) {
            param = new Object[]{BgTaskStateEnum.COMPLETED.getNumber(), toUpdateEProcessId};
            arrayList.add(param);
        }
        if (CollectionUtils.isEmpty(arrayList)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_dynamicreport set fstatus = ? where fid = ?", arrayList);
        this.getView().showSuccessNotification("success");
    }

    public static List<String> getAllBgmdModel() {
        ArrayList<String> list = new ArrayList<String>(16);
        try (DataSet ds = DB.queryDataSet((String)"ControlRecordUpImpl", (DBRoute)BgBaseConstant.epm, (String)"select fid,fnumber,fcreatorid from t_eb_model where freporttype = '7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                list.add(row.getString("fid"));
            }
        }
        return list;
    }

    public static Map<Long, Long> getBussnessModel(List<String> modelList, UpgradeResult result) {
        HashMap<Long, Long> modelAndBuss = new HashMap<Long, Long>(modelList.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fmodel,fbasedatafield from t_eb_bgmcontroldimension where ", new Object[0]);
        sqlBuilder.appendIn("fmodel", IDUtils.toLongs(modelList).toArray(new Object[0]));
        try (DataSet ds = DB.queryDataSet((String)"ControlRecordUpImpl", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                if (row.getString("fbasedatafield") == null || row.getString("fbasedatafield").equals("0")) continue;
                if (!modelAndBuss.containsKey(row.getLong("fmodel"))) {
                    modelAndBuss.put(row.getLong("fmodel"), row.getLong("fbasedatafield"));
                    continue;
                }
                result.setErrorInfo(ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u5b58\u5728\u4e24\u4e2a\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u5148\u5220\u9664\u4e00\u4e2a\u518d\u8fdb\u884c\u624b\u52a8\u5347\u7ea7", (String)"bussnessMoldeUpImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
                modelAndBuss.remove(row.getLong("fmodel"));
            }
        }
        return modelAndBuss;
    }

    private void upControlRecord() {
        UpgradeResult result = new UpgradeResult();
        List<String> allBgmdModel = RuleAggregatePlugin.getAllBgmdModel();
        Map<Long, Long> bussnessModel = RuleAggregatePlugin.getBussnessModel(allBgmdModel, result);
        RuleAggregatePlugin.creatNewRecordTable(bussnessModel);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BizRuleGroupList2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public static String getFiledSql(List<String> columnNames) {
        if (columnNames != null && !columnNames.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : columnNames) {
                stringBuilder.append(s).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return null;
    }

    public static List<String> getAllFile(String tableName) {
        List columnNames = DB.getColumnNames((DBRoute)BgBaseConstant.epm, (String)tableName);
        ArrayList<String> columnName_new = new ArrayList<String>(columnNames.size());
        for (String s : columnNames) {
            columnName_new.add(s.toLowerCase());
        }
        return columnName_new;
    }

    private static void creatTable(String table_new, Long bussnessModleId, List<String> filed) {
        if (!DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)table_new)) {
            StringBuilder sql = new StringBuilder();
            sql.append("create table ").append(table_new).append(" (").append("fid bigint not null default 0, fmodelid bigint not null default 0, ").append("fentitynumber nvarchar(80) not null default ' ', fbizid nvarchar(80) not null default ' ',").append("fbiznumber nvarchar(80) not null default ' ', foperation  nvarchar(80) not null default ' ',").append("freqorgunitid bigint not null default 0, forgunitid bigint not null default 0,").append("freqaccountid bigint not null default 0, faccountid bigint not null default 0,").append("fbgperiodid bigint not null default 0, fcurrencyid bigint not null default 0, fversionid bigint not null default 0,").append("fatid bigint not null default 0, fctid bigint not null default 0, ").append("fdtid bigint not null default 0, fmetricid bigint default 0 not null, ").append("famount decimal(19,6) not null default 0, fcreatetime datetime, fcreatorid bigint not null default 0, ").append("fruleid bigint not null default 0, frefbizid nvarchar(80) not null default ' ', fentryid bigint not null default 0,");
            if (!filed.isEmpty()) {
                for (String s : filed) {
                    sql.append(s).append("  bigint not null default 0,");
                }
            }
            sql.deleteCharAt(sql.length() - 1).append(")");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            String index = BgControlUtils.getBgControlRecordIndexNew((Long)bussnessModleId);
            sql.setLength(0);
            sql.append("create index ").append(index).append(" ON ").append(table_new).append(" (fbizid)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            String entityIndex = BgControlUtils.getBgControlRecordEntityIndexNew((Long)bussnessModleId);
            sql.setLength(0);
            sql.append("create index ").append(entityIndex).append(" ON ").append(table_new).append(" (fentitynumber, fbiznumber)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            String oaIndex = BgControlUtils.getBgControlRecordOrgAccIndexNew((Long)bussnessModleId);
            sql.setLength(0);
            sql.append("create index ").append(oaIndex).append(" ON ").append(table_new).append(" (fcreatetime, forgunitid, faccountid, fbgperiodid)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
    }

    public static void creatNewRecordTable(Map<Long, Long> modelAndBuss) {
        StringBuilder updataSql = new StringBuilder();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        ArrayList list = Lists.newArrayList((Object[])new String[]{"fid", "fmodelid", "fentitynumber", "fbizid", "fbiznumber", "foperation", "freqorgunitid", "forgunitid", "freqaccountid", "faccountid", "fbgperiodid", "fcurrencyid", "fversionid", "fatid", "fctid", "fdtid", "fmetricid", "famount", "fcreatetime", "fcreatorid", "fruleid", "frefbizid"});
        for (Map.Entry<Long, Long> mapEntry : modelAndBuss.entrySet()) {
            Long modelId = mapEntry.getKey();
            Long bussmodelId = mapEntry.getValue();
            String table_old = "t_eb_cr" + modelId;
            String table_new = BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)bussmodelId);
            List<String> allFile = RuleAggregatePlugin.getAllFile(table_old);
            List<String> notExitList = RuleAggregatePlugin.getNotExitList(list, allFile);
            String alltableFiled = RuleAggregatePlugin.getFiledSql(allFile);
            RuleAggregatePlugin.creatTable(table_new, bussmodelId, notExitList);
            RuleAggregatePlugin.initData(updateList, table_old, table_new, alltableFiled);
        }
        updataSql.append("update ").append("t_eb_bgcontrolindex").append(" set FTABLE = ?").append(" where FTABLE = ?");
        if (updateList != null && !updateList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updataSql.toString(), updateList);
        }
    }

    private static void initData(List<Object[]> updateList, String table_old, String table_new, String alltableFiled) {
        if (DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)table_old)) {
            StringBuilder sql = new StringBuilder();
            updateList.add(new Object[]{table_new, table_old});
            sql.append("TRUNCATE TABLE ").append(table_new);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            sql.setLength(0);
            sql.append("insert into ").append(table_new).append("(").append(alltableFiled).append(")").append(" select  ").append(alltableFiled).append("  from ").append(table_old);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
    }

    private static List<String> getNotExitList(List<String> list, List<String> allFile) {
        ArrayList<String> list_new = new ArrayList<String>(16);
        list_new.addAll(allFile);
        list_new.removeAll(list);
        return list_new;
    }

    private void upBussmodel() {
        try {
            UpgradeResult result = new UpgradeResult();
            List<String> allBgmdModel = RuleAggregatePlugin.getAllBgmdModel();
            Map<Long, Long> bussnessModel = RuleAggregatePlugin.getBussnessModel(allBgmdModel, result);
            this.updateRows(versionTable, bussnessModel, true);
            this.updatemateRuleRows(mateRuleTable, bussnessModel);
            this.updateRows(controlRuleTable, bussnessModel, false);
            this.updateRows(dimmappingTable, bussnessModel, true);
            this.updateRows(centralizedTable, bussnessModel, true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BizRuleGroupList2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private List<Object[]> getControlMateRuleParms(Map<Long, Long> bussnessModel) {
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> mapEntry : bussnessModel.entrySet()) {
            updateList.add(new Object[]{mapEntry.getValue(), mapEntry.getKey()});
        }
        return updateList;
    }

    private List<Object[]> getControlVersionParms(Map<Long, Long> bussnessModel) {
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> mapEntry : bussnessModel.entrySet()) {
            updateList.add(new Object[]{mapEntry.getValue(), mapEntry.getKey()});
        }
        return updateList;
    }

    private void updatemateRuleRows(String mateRuleTable, Map<Long, Long> bussnessModelAndModel) {
        List<Object[]> controlmateRuleParms = this.getControlMateRuleParms(bussnessModelAndModel);
        if (controlmateRuleParms == null || controlmateRuleParms.isEmpty() && !DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)mateRuleTable)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update  ").append(mateRuleTable).append("  set fbussmodelid = ? where  FEntryID in (select FEntryID from t_eb_dimmateruleapp where fid in (select fid from t_eb_dimmaterule where fmodelid = ?))");
        if (controlmateRuleParms != null && !controlmateRuleParms.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), controlmateRuleParms);
        }
    }

    public void updateRows(String ebTableName, Map<Long, Long> bussnessModel, boolean isfmodel) {
        List<Object[]> controlVersionParms = this.getControlVersionParms(bussnessModel);
        if (controlVersionParms == null || controlVersionParms.isEmpty() && !DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)ebTableName)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        if (isfmodel) {
            sql.append("update  ").append(ebTableName).append("  set fbussmodelid = ? where fmodel = ?");
        } else {
            sql.append("update  ").append(ebTableName).append("  set fbussmodelid = ? where fmodelid = ?");
        }
        if (controlVersionParms != null && !controlVersionParms.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), controlVersionParms);
        }
    }

    private void restoreAdjData() {
        try {
            this.restoreBgmAdjData();
            this.restoreEbAdjData();
            this.getView().showSuccessNotification("success!");
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            throw new KDBizException(ThrowableHelper.toString((Exception)exception));
        }
    }

    private void restoreEbAdjData() {
        List<Map<String, Object>> errorEbAdjDetails = this.getErrorEbAdjDetails();
        this.putEbPeriodIdToErrorDetail(errorEbAdjDetails);
        this.updateEbErrorDetails(errorEbAdjDetails);
    }

    private void updateEbErrorDetails(List<Map<String, Object>> errorEbAdjDetails) {
        if (CollectionUtils.isEmpty(errorEbAdjDetails)) {
            return;
        }
        String updateSql = "update t_eb_adjdetail set fperiod = ? where fentryid = ?";
        ArrayList<Object[]> objs = new ArrayList<Object[]>(16);
        for (Map<String, Object> map : errorEbAdjDetails) {
            Object fperiod = map.get("fperiod");
            Object fentryid = map.get("fentryid");
            if (fperiod == null || fentryid == null) continue;
            Object[] obj = new Object[]{fperiod, fentryid};
            objs.add(obj);
        }
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, objs);
    }

    private void putEbPeriodIdToErrorDetail(List<Map<String, Object>> errorEbAdjDetails) {
        if (CollectionUtils.isEmpty(errorEbAdjDetails)) {
            return;
        }
        Map<Long, List<Long>> ebAdjPeriodMap = this.getEbAdjPeriodMap();
        for (Map<String, Object> map : errorEbAdjDetails) {
            Object billId = map.get("fbillid");
            Object ordersign = map.get("ordersign");
            int order = Integer.parseInt(ordersign.toString()) - 1;
            List<Long> ebAjdPeriodIds = ebAdjPeriodMap.get(IDUtils.toLong((Object)billId));
            if (CollectionUtils.isEmpty(ebAjdPeriodIds) || order < 0) continue;
            map.put("fperiod", ebAjdPeriodIds.get(order));
        }
    }

    private List<Map<String, Object>> getErrorEbAdjDetails() {
        ArrayList<Map<String, Object>> detailMapList = new ArrayList<Map<String, Object>>(16);
        String sql = "select a.fid billId, a.fbillnumber billNumber, b.fentryid entryId, b.fperiod period, b.fordersign ordersign from t_eb_adjustbill a, t_eb_adjdetail b,t_eb_model c where a.fid=b.fid and a.fmodel = c.fid and c.freporttype='4' and b.fperiod = 0 and b.fordersign != ' '";
        try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "restoreEbAdjData"), (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row next = ds.next();
                Long billId = next.getLong("billId");
                String billNumber = next.getString("billNumber");
                Long entryId = next.getLong("entryId");
                String period = next.getString("period");
                String ordersign = next.getString("ordersign");
                HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
                detailMap.put("fbillid", billId);
                detailMap.put("fbillnumber", billNumber);
                detailMap.put("fentryid", entryId);
                detailMap.put("fperiod", period);
                detailMap.put("ordersign", ordersign.split(":")[1]);
                detailMapList.add(detailMap);
            }
        }
        return detailMapList;
    }

    private Map<Long, List<Long>> getEbAdjPeriodMap() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        String sql1 = "select fid billId, fbasedataid periodId t_eb_adjbillperiods";
        try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "getEbAdjPeriodMap"), (DBRoute)DBRoute.of((String)"epm"), (String)sql1);){
            while (ds != null && ds.hasNext()) {
                Row next = ds.next();
                Long billId = next.getLong("billId");
                Long periodId = next.getLong("periodId");
                List periodIds = result.computeIfAbsent(billId, k -> new ArrayList(16));
                periodIds.add(periodId);
            }
        }
        return result;
    }

    private Map<Long, List<Long>> getBgmAdjPeriodMap() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        String sql1 = "select fid billId, fbasedataid periodId t_eb_adjustbill_bp";
        try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "getBgmAdjPeriodMap"), (DBRoute)DBRoute.of((String)"epm"), (String)sql1);){
            while (ds != null && ds.hasNext()) {
                Row next = ds.next();
                Long billId = next.getLong("billId");
                Long periodId = next.getLong("periodId");
                List periodIds = result.computeIfAbsent(billId, k -> new ArrayList(16));
                periodIds.add(periodId);
            }
        }
        return result;
    }

    private void restoreBgmAdjData() {
        List<Map<String, Object>> errorBgmAdjDetails = this.getErrorBgmAdjDetails();
        this.putBgmPeriodIdToErrorDetail(errorBgmAdjDetails);
        this.updateBgmErrorDetails(errorBgmAdjDetails);
    }

    private void updateBgmErrorDetails(List<Map<String, Object>> errorBgmAdjDetails) {
        if (CollectionUtils.isEmpty(errorBgmAdjDetails)) {
            return;
        }
        String updateSql = "update t_eb_adjdetail set fbudgetperiod = ? where fentryid = ?";
        ArrayList<Object[]> objs = new ArrayList<Object[]>(16);
        for (Map<String, Object> map : errorBgmAdjDetails) {
            Object fperiod = map.get("fperiod");
            Object fentryid = map.get("fentryid");
            if (fperiod == null || fentryid == null) continue;
            Object[] obj = new Object[]{fperiod, fentryid};
            objs.add(obj);
        }
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, objs);
    }

    private void putBgmPeriodIdToErrorDetail(List<Map<String, Object>> errorBgmAdjDetails) {
        if (CollectionUtils.isEmpty(errorBgmAdjDetails)) {
            return;
        }
        Map<Long, List<Long>> bgmAdjPeriodMap = this.getBgmAdjPeriodMap();
        for (Map<String, Object> map : errorBgmAdjDetails) {
            Object billId = map.get("fbillid");
            Object ordersign = map.get("ordersign");
            int order = Integer.parseInt(ordersign.toString()) - 1;
            List<Long> bgmAjdPeriodIds = bgmAdjPeriodMap.get(IDUtils.toLong((Object)billId));
            if (CollectionUtils.isEmpty(bgmAjdPeriodIds) || order < 0) continue;
            map.put("fperiod", bgmAjdPeriodIds.get(order));
        }
    }

    private List<Map<String, Object>> getErrorBgmAdjDetails() {
        ArrayList<Map<String, Object>> detailMapList = new ArrayList<Map<String, Object>>(16);
        String sql = "select a.fid billId, a.fbillnumber billNumber, b.fentryid entryId, b.fbudgetperiod period, b.fordersign ordersign from t_eb_adjustbill a, t_eb_adjdetail b,t_eb_model c where a.fid=b.fid and a.fmodel = c.fid and c.freporttype='7' and b.fbudgetperiod = 0 and b.fordersign != ' '";
        try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "restoreBgmAdjData"), (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row next = ds.next();
                String billNumber = next.getString("billNumber");
                Long entryId = next.getLong("entryId");
                String period = next.getString("period");
                String ordersign = next.getString("ordersign");
                Long billId = next.getLong("billId");
                HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
                detailMap.put("fbillid", billId);
                detailMap.put("fbillnumber", billNumber);
                detailMap.put("fentryid", entryId);
                detailMap.put("fperiod", period);
                detailMap.put("ordersign", ordersign.split(":")[1]);
                detailMapList.add(detailMap);
            }
        }
        return detailMapList;
    }

    private void clickSyncBudgetOccupationBtn() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showMessage("please choose model.");
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"SyncBudgetOccupation");){
            try {
                long modelId = model.getLong("id");
                QFilter qfs = new QFilter("model", "=", (Object)modelId);
                qfs.and("number", "=", (Object)"BudgetOccupation");
                DeleteServiceHelper.delete((String)"epm_audittrialmembertree", (QFilter[])qfs.toArray());
                DynamicObject root = this.getAuditTrailRoot(modelId);
                DynamicObject auditTrail = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.AuditTrail.getMemberTreemodel());
                auditTrail.set("model", (Object)modelId);
                auditTrail.set("dimension", root.get("dimension"));
                auditTrail.set("number", (Object)"BudgetOccupation");
                auditTrail.set("name", (Object)ResManager.loadKDString((String)"\u5728\u9014\u5360\u7528\u9884\u7b97", (String)"RuleAggregatePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                auditTrail.set("longNumber", (Object)(SysDimensionEnum.AuditTrail.getNumber() + "!" + "BudgetOccupation"));
                auditTrail.set("isleaf", (Object)true);
                auditTrail.set("level", (Object)2);
                auditTrail.set("parent", root.get("id"));
                auditTrail.set("creator", (Object)UserUtils.getUserId());
                auditTrail.set("createtime", (Object)TimeServiceHelper.now());
                auditTrail.set("modifier", (Object)UserUtils.getUserId());
                auditTrail.set("modifytime", (Object)TimeServiceHelper.now());
                auditTrail.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
                auditTrail.set("dseq", (Object)2);
                auditTrail.set("membersource", (Object)MemberSourceEnum.PRESET.getIndex());
                auditTrail.set("status", (Object)"C");
                auditTrail.set("enable", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{auditTrail});
                this.getView().showSuccessNotification("upgrade okk.");
            }
            catch (Exception e) {
                log.error(e.getMessage());
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            if ("4".equals(model.getString("reporttype"))) {
                OlapServiceHelper.dropDimensionMember((String)model.getString("number"), (String)SysDimensionEnum.AuditTrail.getNumber(), (String)"BudgetOccupation");
                OlapServiceHelper.createMember((String)model.getString("number"), (String)SysDimensionEnum.AuditTrail.getNumber(), (String)"BudgetOccupation");
            }
        }
    }

    private DynamicObject getAuditTrailRoot(Long modelId) {
        QFilter qfs = new QFilter("model", "=", (Object)modelId);
        qfs.and("number", "=", (Object)SysDimensionEnum.AuditTrail.getNumber());
        DynamicObject auditTrailRoot = QueryServiceHelper.queryOne((String)"epm_audittrialmembertree", (String)"model,id,dimension", (QFilter[])qfs.toArray());
        return auditTrailRoot;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "members": {
                this.selectMembers();
                break;
            }
            case "butbuilddata": {
                this.beginMessage(ResManager.loadKDString((String)"\u6784\u5efa\u6570\u636e", (String)"RuleAggregatePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "sync_budget_occupation": {
                this.beginMessage(ResManager.loadKDString((String)"\u540c\u6b65\u5f53\u524d\u9009\u62e9\u4f53\u7cfb\u7684\u5728\u9014\u5360\u7528\u9884\u7b97\u6210\u5458\u3002", (String)"RuleAggregatePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btnupcontrolrecord": {
                this.beginMessage(ResManager.loadKDString((String)"\u63a7\u5236\u8bb0\u5f55\u5347\u7ea7", (String)"RuleAggregatePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btnolap2shrek": {
                this.beginMessage(ResManager.loadKDString((String)"\u5173\u7cfb\u5e93\u6570\u636e\u6b63\u5728\u540c\u6b65\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"RuleAggregatePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_adjdatarestore": {
                this.beginMessage(ResManager.loadKDString((String)"\u8c03\u6574\u8c03\u5242\u5355\u6570\u636e\u4fee\u590d\u3002", (String)"RuleAggregatePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
            }
            case "btn_upreportstatus": {
                this.beginMessage(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7-\u62a5\u8868\u7f16\u5236\u5b9e\u4f8b\u72b6\u6001", (String)"RuleAggregatePlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "clearuserselect": {
                this.clearuserselect();
                break;
            }
            case "btn_upgradereportprocess": {
                this.beginMessage(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7-\u65b0\u62a5\u8868\u5b9e\u4f8b", (String)"RuleAggregatePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_deleterepeatrpt": {
                this.beginMessage(ResManager.loadKDString((String)"\u5220\u9664\u91cd\u590d\u7684\u62a5\u8868\u5b9e\u4f8b", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_updatestatus": {
                this.beginMessage(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d-\u62a5\u8868\u5b9e\u4f8b\u72b6\u6001", (String)"RuleAggregatePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_updatedata": {
                this.beginMessage(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d-\u62a5\u8868\u5b9e\u4f8b\u4e0e\u5ba1\u6279\u5355\u72b6\u6001\u6838\u51c6", (String)"RuleAggregatePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btntestapi": {
                this.testApi();
                break;
            }
            case "btn_memtempqoute": {
                this.beginMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u4fdd\u5b58\u6a21\u677f\u7ef4\u5ea6\u6210\u5458\u5f15\u7528", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btnclearref": {
                this.beginMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u6e05\u9664\u65e0\u6548\u6210\u5458\u7684\u5c5e\u6027\u5f15\u7528\u5173\u7cfb", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btncheckshrek": {
                this.beginMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u68c0\u67e5\u6307\u5b9a\u6570\u636e\u96c6\u7684\u8ba1\u7b97\u56e0\u5b50", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btnupshrek": {
                this.beginMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u66f4\u65b0\u6307\u5b9a\u6570\u636e\u96c6\u7684\u8ba1\u7b97\u56e0\u5b50", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_approvebill_reject": {
                this.beginMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u4fee\u590d\u9a73\u56de\u72b6\u6001\u5ba1\u6279\u5355\u6570\u636e", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_language_upgrade": {
                this.beginMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u591a\u8bed\u8a00\u5347\u7ea7", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_getdatalock": {
                this.getDataLick();
                break;
            }
            case "btn_kuacube": {
                this.beginMessage(ResManager.loadKDString((String)"\u8de8Cube\u8ba1\u7b97\u5347\u7ea7", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]), key);
                break;
            }
            case "btn_updatedatalock": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u6570\u636e\u9501\u5b9a\u524d\u4f1a\u5148\u6e05\u7a7a\u65b0\u8868\u4e2d\u8be5\u4f53\u7cfb\u7684\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5347\u7ea7\u3002", (String)"DimensionRelationListPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_UPDATEDATALOCK, (IFormPlugin)this));
                break;
            }
            case "btn_updaterulecase": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5347\u7ea7\u89c4\u5219\u65b9\u6848\u524d\u4f1a\u5148\u6e05\u7a7a\u65b0\u8868\u4e2d\u8be5\u4f53\u7cfb\u7684\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5347\u7ea7\u3002", (String)"DimensionRelationListPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_UPDATERULECASE, (IFormPlugin)this));
                break;
            }
            case "btncheckl": {
                this.click_check_l();
                break;
            }
            case "btnviewupgrade": {
                this.viewUpgrade();
                break;
            }
            case "btnrefviewupgrade": {
                this.refViewUpgrade();
                break;
            }
            case "btnupdatemodelvernum": {
                this.updateModelVerNum();
                break;
            }
        }
    }

    private void updateModelVerNum() {
        DynamicObjectCollection modelDyns = QueryServiceHelper.query((String)"epm_model", (String)"id,versionnumber", null, (String)"modifytime desc");
        HashSet<Long> needUpdateIds = new HashSet<Long>(modelDyns.size());
        if (!modelDyns.isEmpty()) {
            for (DynamicObject modelDyn : modelDyns) {
                long id = modelDyn.getLong("id");
                String versionNumber = modelDyn.getString("versionnumber");
                if (!kd.bos.util.StringUtils.isEmpty((String)versionNumber) && !(ViewMemberUpgradeService.getVersionNumber((String)versionNumber) < 2.0)) continue;
                needUpdateIds.add(id);
            }
        }
        ArrayList<Object[]> updateModelVerNumList = new ArrayList<Object[]>(16);
        for (Long needUpdateId : needUpdateIds) {
            updateModelVerNumList.add(new Object[]{"V2", needUpdateId});
        }
        ViewMemberUpgradeService.modelVersionNumberUpdateRows((String)"t_eb_model", updateModelVerNumList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"", (String)"", (Object[])new Object[0]));
    }

    private void refViewUpgrade() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u4f53\u7cfb\u3002", (String)"BgmdModelList_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dimGroups = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id,type,parent", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dimGroups)) {
            return;
        }
        HashMap<Long, Long> dirGroupMap = new HashMap<Long, Long>(16);
        for (DynamicObject dimGroup : dimGroups) {
            String type = dimGroup.getString("type");
            long id = dimGroup.getLong("id");
            long parent = dimGroup.getLong("parent");
            if (!"2".equals(type)) continue;
            dirGroupMap.put(id, parent);
        }
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,viewgroup", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> viewGroupMap = new HashMap<Long, Long>(16);
        for (DynamicObject dim : dims) {
            long id = dim.getLong("id");
            long viewGroup = dim.getLong("viewgroup");
            viewGroupMap.put(id, dirGroupMap.getOrDefault(viewGroup, viewGroup));
        }
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        List dimensionList = modelCacheHelper.getDimensionList();
        ArrayList<Object[]> viewMemberRefViewUpdateParams = new ArrayList<Object[]>(16);
        String outerRef = ViewMemberSourceEnum.OUTER_REF.getIndex();
        for (Dimension dimension : dimensionList) {
            if (View.NoViewDimNums.contains(dimension.getNumber()) || SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) continue;
            List viewList = dimension.getViewList();
            for (Long viewId : viewList) {
                View view = dimension.getView(viewId);
                if (view == null) continue;
                List allMembers = view.getAllMembers();
                for (Member member : allMembers) {
                    Long _dimGroup;
                    Long refDimGroup;
                    String source = member.getSource();
                    if (!source.equals(ViewMemberSourceEnum.INNER_REF.getIndex())) continue;
                    Long refViewId = member.getRefViewId();
                    Long _viewId = 0L;
                    Long vid = 0L;
                    if (member instanceof ViewMember) {
                        _viewId = ((ViewMember)member).getViewId();
                        vid = ((ViewMember)member).getVid();
                    }
                    if (IDUtils.isEmptyLong((Long)_viewId).booleanValue() || IDUtils.isEmptyLong((Long)vid).booleanValue() || (refDimGroup = viewGroupMap.getOrDefault(refViewId, 0L)).equals(_dimGroup = viewGroupMap.getOrDefault(_viewId, 0L))) continue;
                    viewMemberRefViewUpdateParams.add(new Object[]{outerRef, vid});
                }
            }
        }
        String innerRef = ViewMemberSourceEnum.INNER_REF.getIndex();
        ArrayList<Object[]> ctViewMemberRefViewUpdateParams = new ArrayList<Object[]>(16);
        Dimension ctDim = modelCacheHelper.getDimension(SysDimensionEnum.ChangeType.getNumber());
        Long defaultViewId = ctDim.getDefaultViewId();
        List viewList = ctDim.getViewList();
        HashSet<String> ctPresetMemSet = new HashSet<String>(DimensionManagerList.CHANGETYPE_VIEW_ALL_PRESET);
        for (Long viewId : viewList) {
            View view;
            if (defaultViewId.equals(viewId) || (view = ctDim.getView(viewId)) == null) continue;
            List allMembers = view.getAllMembers();
            for (Member member : allMembers) {
                String source = member.getSource();
                if (!ctPresetMemSet.contains(member.getNumber()) || source.equals(ViewMemberSourceEnum.INNER_REF.getIndex())) continue;
                Long vid = 0L;
                if (member instanceof ViewMember) {
                    vid = ((ViewMember)member).getVid();
                }
                if (IDUtils.isEmptyLong((Long)vid).booleanValue()) continue;
                ctViewMemberRefViewUpdateParams.add(new Object[]{innerRef, defaultViewId, vid});
            }
        }
        RuleAggregatePlugin.viewMemberRefViewUpdateRows("t_eb_viewmember", viewMemberRefViewUpdateParams);
        this.viewCtMemberRefViewUpdateRows("t_eb_viewmember", ctViewMemberRefViewUpdateParams);
        ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"", (String)"", (Object[])new Object[0]));
    }

    private void viewCtMemberRefViewUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fmembersource = ?,frefview = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberRefViewUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fmembersource = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    private void viewUpgrade() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u4f53\u7cfb\u3002", (String)"BgmdModelList_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ViewMemberUpgradeService.viewMemberUpgradeByPage(Collections.singletonList(modelId), (IFormView)this.getView());
    }

    private void testApi() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        DynamicObject entryData = this.getModel().getEntryRowEntity("entryentity", entry.getEntryState().getFocusRow());
        if (entryData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getBizModel().getLong("id");
        String modelNumber = this.getBizModel().getString("shownumber");
        Long busModelId = this.getBusModel() != null ? this.getBusModel().getLong("id") : 0L;
        String busModelNumber = this.getBusModel() != null ? this.getBusModel().getString("number") : null;
        Long datasetId = this.getDataset() != null ? this.getDataset().getLong("id") : 0L;
        String datasetNumber = this.getDataset() != null ? this.getDataset().getString("number") : null;
        Long dimensionId = entryData.getLong("dimid");
        String dimensionNumber = entryData.getString("dimnumber");
        Map<String, Set<Long>> members = this.getMemberIds();
        MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)dimensionId));
        f8Param.setBusModelId(busModelId);
        f8Param.setDatasetId(datasetId);
        f8Param.setVerifyPermission(false);
        f8Param.setSelectIds(members.get(dimensionNumber));
        f8Param.setEnableView(true);
        f8Param.setShowVariable(true);
        f8Param.setShowAnalyseMember(true);
        f8Param.setHideDecompose(false);
        f8Param.setShowDebitAndCredit(true);
        f8Param.setShowDisable(true);
        f8Param.setLockRangeSelect(true);
        f8Param.setMustSelected(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_BACK_SELECTMEMBERS);
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)closeCallBack);
    }

    private void checkAndUpShrek(boolean autoUpdate) {
        DynamicObject dataset;
        DynamicObject modelObj = this.getBizModel();
        if (modelObj == null) {
            this.getView().showMessage("please select a model.");
            return;
        }
        DynamicObject busModel = this.getBusModel();
        if (busModel == null) {
            this.getView().showMessage("please select a business model.");
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(true);
        if (!modelCacheHelper.getModelobj().isModelByEB() && (dataset = this.getDataset()) == null) {
            this.getView().showMessage("please select a dataset.");
            return;
        }
        Long datasetId = this.getDataset() != null ? this.getDataset().getLong("id") : 0L;
        Map<String, Set<String>> members = this.getMembers();
        DynamicObject dataset2 = DatasetServiceHelper.loadDatasets((Long)datasetId);
        List<Dataset> datasets = Collections.singletonList(Dataset.of((DynamicObject)dataset2));
        String[] dimNumbers = IDUtils.isNotNull((Long)datasetId) ? modelCacheHelper.getDimensionNums(datasetId) : modelCacheHelper.getDimensionNums();
        LinkedHashMap errors = Maps.newLinkedHashMapWithExpectedSize((int)dimNumbers.length);
        ShrekMember shrekMember = new ShrekMember();
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelCacheHelper.getModelobj());
        String[] stringArray = dimNumbers;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String dimNumber;
            Set<String> tmpNums = members.get(dimNumber = stringArray[i]);
            Set<String> memberNums = tmpNums == null || tmpNums.isEmpty() ? null : tmpNums;
            Map dimErrors = shrekMember.verifyMemberFactors(modelCacheHelper, datasets, dimNumber, memberNums, autoUpdate, config);
            if (dimErrors == null || dimErrors.isEmpty()) continue;
            for (Map.Entry _entry : dimErrors.entrySet()) {
                if (_entry.getValue() == null || ((Set)_entry.getValue()).isEmpty()) continue;
                Map dimData = errors.computeIfAbsent(_entry.getKey(), f -> Maps.newLinkedHashMap());
                dimData.put(dimNumber, _entry.getValue());
            }
        }
        if (!errors.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u4e0d\u6b63\u786e\u7684\u8ba1\u7b97\u56e0\u5b50\u3002", (String)"RuleAggregatePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, JSON.toJSONString((Object)errors), MessageTypes.Default);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u5b8c\u6210\uff0c\u7ef4\u5ea6\u6210\u5458\u8ba1\u7b97\u56e0\u5b50\u6b63\u786e\u3002", (String)"RuleAggregatePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateApproveBillReject() {
        DynamicObject model = this.getBizModel();
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        Long modelId = model.getLong("id");
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        DynamicObjectCollection approvebill = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,billstatus", (QFilter[])qFilter.toArray());
        HashMap<Long, String> approvebillMap = new HashMap<Long, String>(16);
        approvebill.forEach(e -> approvebillMap.put(e.getLong("id"), e.getString("billstatus")));
        qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("status", "=", (Object)BgTaskStateEnum.UNDERWAY.getNumber());
        DynamicObjectCollection reportprocess = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status,submituser,approvebill,submitdate,submitentity,modifier", (QFilter[])qFilter.toArray());
        String updateSql = "update t_eb_reportprocess set fstatus = ?, fsubmitentity = ?, fsubmitdate = ?, fsubmituser = ?, fapprovebill = ? where fid = ?";
        ArrayList<Object[]> reportProcessObjs = new ArrayList<Object[]>(16);
        for (DynamicObject dynamicObject : reportprocess) {
            Object[] obj = this.setReportProcessData(approvebillMap, dynamicObject);
            if (obj == null) continue;
            reportProcessObjs.add(obj);
        }
        if (CollectionUtils.isNotEmpty(reportProcessObjs)) {
            try (TXHandle tx = TX.required();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, reportProcessObjs);
                }
                catch (Throwable e2) {
                    tx.markRollback();
                    throw new KDBizException(e2.getMessage());
                }
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u590d\u5b8c\u6210", (String)"", (String)"", (Object[])new Object[0]));
    }

    private Object[] setReportProcessData(Map<Long, String> approvebillMap, DynamicObject reporProcess) {
        Object[] obj = new Object[6];
        Long id = reporProcess.getLong("id");
        Long modifier = reporProcess.getLong("modifier");
        String status = reporProcess.getString("status");
        Long approvebillId = reporProcess.getLong("approvebill");
        if ("3".equals(status)) {
            boolean needUpdate = false;
            if (IDUtils.isNull((Long)approvebillId)) {
                needUpdate = true;
            } else if (approvebillMap.containsKey(approvebillId)) {
                if ("C".equals(approvebillMap.get(approvebillId))) {
                    needUpdate = true;
                }
            } else {
                needUpdate = true;
            }
            if (needUpdate) {
                obj[0] = modifier == 0L ? BgTaskStateEnum.UNPREPARED.getNumber() : BgTaskStateEnum.TEMPSAVE.getNumber();
                obj[1] = 0;
                obj[2] = null;
                obj[3] = 0;
                obj[4] = 0;
                obj[5] = id;
                return obj;
            }
        }
        return null;
    }

    private void clearuserselect() {
        Object bos_user = this.getModel().getValue("bos_user");
        if (bos_user == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4eba\u5458", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        Long userId = ((DynamicObject)bos_user).getLong("id");
        int i = UserSelectUtils.clearUserSelect((Long)userId);
        this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u6e05\u9664\u5b8c\u6210,\u5171\u6e05\u9664%1\u6761\u6570\u636e", (String)"", (String)"", (Object[])new Object[]{i}));
    }

    private void enableOrdisable(boolean isEnable) {
        if (isEnable) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_BUILD_DATA});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_BUILD_DATA});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "model": {
                this.beforeF7Select_model(e);
                break;
            }
            case "dataset": {
                this.beforeF7select_dataset(e);
                break;
            }
            case "busmodel": {
                this.beforeF7select_busmodel(e);
                break;
            }
            case "datasource": {
                this.beforeF7select_datasource(e);
                break;
            }
        }
    }

    protected void beforeF7Select_model(BeforeF7SelectEvent e) {
    }

    protected void beforeF7select_busmodel(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)e.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("model", "=", (Object)(this.getBizModel() == null ? 0L : this.getBizModel().getLong("id"))));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    protected void beforeF7select_dataset(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)e.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("model", "=", (Object)(this.getBizModel() == null ? 0L : this.getBizModel().getLong("id"))));
        filters.add(new QFilter("businessmodel", "=", (Object)(this.getBusModel() == null ? 0L : this.getBusModel().getLong("id"))));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    protected void beforeF7select_datasource(BeforeF7SelectEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] datas;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("model".equals(propName)) {
            this.getModel().setValue("busmodel", null);
            this.getModel().setValue("dataset", null);
            this.clearDimension();
            DynamicObject model = this.getBizModel();
            if (model != null) {
                this.setModelCacheHelper(ModelCacheContext.getOrCreate((Long)model.getLong("id")));
                if (this.getModelCacheHelper().getModelobj().isModelByEB()) {
                    this.loadDimension(model, null);
                }
            }
        } else if ("busmodel".equals(propName)) {
            this.getModel().setValue("dataset", null);
            this.clearDimension();
        } else if ("dataset".equals(propName)) {
            DynamicObject model = this.getBizModel();
            DynamicObject dataset = (DynamicObject)this.getModel().getValue("dataset");
            this.loadDimension(model, dataset);
        } else if ("members".equals(propName) && (datas = e.getChangeSet()) != null && datas.length > 0 && (datas[0].getNewValue() == null || "".equals(datas[0].getNewValue()))) {
            this.updateMemberData(null);
        }
    }

    protected void clearDimension() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
    }

    protected void loadDimension(DynamicObject model, DynamicObject dataset) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        if (model == null || !BizModel.isEBByModel((DynamicObject)model) && dataset == null) {
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
        List dimensions = BgDimensionServiceHelper.getDimensionByModel((Long)model.getLong("id"));
        List refDims = dataset == null ? dimensions : DatasetServiceHelper.getRefDim1((Long)dataset.getLong("id"), (List)dimensions);
        if (refDims != null) {
            this.cacheDimension(refDims);
            kd.epm.eb.common.model.Dimension dimension = null;
            int[] rows = dataModel.batchCreateNewEntryRow("entryentity", refDims.size());
            int in = rows.length;
            for (int i = 0; i < in; ++i) {
                dimension = (kd.epm.eb.common.model.Dimension)refDims.get(i);
                dataModel.setValue("dimid", (Object)dimension.getId(), rows[i]);
                dataModel.setValue("dimname", (Object)dimension.getName(), rows[i]);
                dataModel.setValue("dimnumber", (Object)dimension.getNumber(), rows[i]);
            }
        }
    }

    protected void cacheDimension(List<kd.epm.eb.common.model.Dimension> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            return;
        }
        HashMap<String, Long> dimensionMap = new HashMap<String, Long>(16);
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            dimensionMap.put(dimension.getNumber(), dimension.getId());
        }
        this.getPageCache().put(CACHE_DIMENSION, SerializationUtils.toJsonString(dimensionMap));
    }

    protected DynamicObject getBizModel() {
        return (DynamicObject)this.getModel().getValue("model");
    }

    protected DynamicObject getBusModel() {
        return (DynamicObject)this.getModel().getValue("busmodel");
    }

    protected DynamicObject getDataset() {
        return (DynamicObject)this.getModel().getValue("dataset");
    }

    protected DynamicObject getDataSource() {
        return (DynamicObject)this.getModel().getValue(DB_DATASOURCE);
    }

    protected void selectMembers() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        DynamicObject entryData = this.getModel().getEntryRowEntity("entryentity", entry.getEntryState().getFocusRow());
        if (entryData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_BACK_SELECTMEMBERS);
        Long modelId = this.getBizModel().getLong("id");
        Long busModelId = this.getBusModel() != null ? this.getBusModel().getLong("id") : 0L;
        Long datasetId = this.getDataset() != null ? this.getDataset().getLong("id") : 0L;
        String dimensionNumber = entryData.getString("dimnumber");
        Map<String, Set<Long>> members = this.getMemberIds();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimensionNumber));
        f7Param.setBusModelId(busModelId);
        f7Param.setDatasetId(datasetId);
        f7Param.setVerifyPermission(false);
        f7Param.setHideDecompose(false);
        f7Param.setSelectIds(members.get(dimensionNumber));
        f7Param.setEnableView(true);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        if (CLOSE_BACK_SELECTMEMBERS.equals(e.getActionId())) {
            this.updateMemberData(e.getReturnData());
        }
    }

    protected void updateMemberData(Object obj) {
        String data = null;
        String memberShow = null;
        if (obj instanceof List) {
            List members = (List)obj;
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            DynamicObject entryData = this.getModel().getEntryRowEntity("entryentity", entry.getEntryState().getFocusRow());
            String dimNumber = entryData.getString("dimnumber");
            Dimension dimension = this.getModelCacheHelper().getDimension(dimNumber);
            ArrayList<kd.epm.eb.common.model.Member> _members = new ArrayList<kd.epm.eb.common.model.Member>(members.size());
            kd.epm.eb.common.model.Member clone = null;
            StringBuilder name = new StringBuilder();
            for (kd.epm.eb.common.model.Member member : members) {
                Member _member = dimension.getStructOfMember(member.getId());
                clone = new kd.epm.eb.common.model.Member();
                if (_member != null) {
                    clone.setId(_member.getId());
                    clone.setNumber(_member.getNumber());
                    clone.setName(_member.getName());
                } else {
                    clone.setId(member.getId());
                    clone.setNumber(member.getNumber());
                    clone.setName(member.getName());
                }
                _members.add(clone);
                name.append(clone.getName()).append(", ");
            }
            if (name.length() > 2) {
                name.setLength(name.length() - 2);
            }
            data = JSON.toJSONString(_members);
            memberShow = name.toString();
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int rowIndex = entry.getEntryState().getFocusRow();
        this.getModel().setValue("data", data, rowIndex);
        this.getModel().setValue("members", memberShow, rowIndex);
        this.getView().updateView("entryentity");
    }

    protected boolean verify() {
        boolean re = true;
        DynamicObjectCollection dimensions = this.getModel().getEntryEntity("entryentity");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                String json = dimension.getString("data");
                if (!kd.bos.util.StringUtils.isEmpty((String)json)) continue;
                re = false;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9%1\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"RuleAggregatePlugin_2_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getString("dimname")}));
            }
        }
        return re;
    }

    protected Map<String, Set<String>> getMembers() {
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(32);
        DynamicObjectCollection dimensions = this.getModel().getEntryEntity("entryentity");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                HashSet<String> memberSet = new HashSet<String>(16);
                memberMap.put(dimension.getString("dimnumber"), memberSet);
                String json = dimension.getString("data");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)json)) continue;
                List members = (List)JSON.parse((String)json);
                for (Map member : members) {
                    memberSet.add((String)member.get("number"));
                }
            }
        }
        return memberMap;
    }

    protected Map<String, Set<Long>> getMemberIds() {
        LinkedHashMap<String, Set<Long>> memberMap = new LinkedHashMap<String, Set<Long>>(16);
        DynamicObjectCollection dimensions = this.getModel().getEntryEntity("entryentity");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                LinkedHashSet<Long> memberSet = new LinkedHashSet<Long>(16);
                memberMap.put(dimension.getString("dimnumber"), memberSet);
                String json = dimension.getString("data");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)json)) continue;
                List members = (List)JSON.parse((String)json);
                for (Map member : members) {
                    memberSet.add(IDUtils.toLong(member.get("id")));
                }
            }
        }
        return memberMap;
    }

    protected void clearMemberPropertyRef() {
        CustomPropertyUtils.clearErrorPropertyByRef();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e0\u6548\u5173\u7cfb\u6e05\u9664\u5b8c\u6210", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    protected void buildData() {
        int dimensionSize;
        Map dimIndexMap;
        DynamicObject model = this.getBizModel();
        DynamicObject dataset = this.getDataset();
        Map<String, Set<String>> membersMap = this.getMembers();
        if (model == null || membersMap == null) {
            return;
        }
        boolean isEb = this.getModelCacheHelper().getModelobj().isModelByEB();
        if (!isEb && dataset == null) {
            return;
        }
        DynamicObject busModel = this.getBusModel();
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)(busModel == null ? 0L : busModel.getLong("id")));
        Dimension orgUnitDim = this.getModelCacheHelper().getDimension(SysDimensionEnum.Entity.getNumber());
        Dimension accountDim = this.getModelCacheHelper().getDimension(SysDimensionEnum.Account.getNumber());
        View orgView = orgUnitDim.getView((Long)viewIds.get("Entity"));
        List orgUnits = orgView != null ? orgView.getLeafMembers() : orgUnitDim.getLeafMembers();
        List accounts = accountDim.getLeafMembers();
        Long datasetId = 0L;
        if (dataset != null) {
            dimIndexMap = this.getModelCacheHelper().getDimIndexMap(Long.valueOf(dataset.getLong("id")), false);
            datasetId = dataset.getLong("id");
            dimensionSize = this.getModelCacheHelper().getDimensionList(datasetId).size();
        } else {
            dimIndexMap = this.getModelCacheHelper().getDimIndexMap(false);
            dimensionSize = this.getModelCacheHelper().getDimensionList().size();
        }
        int orgIndex = (Integer)dimIndexMap.get(SysDimensionEnum.Entity.getNumber());
        int accIndex = (Integer)dimIndexMap.get(SysDimensionEnum.Account.getNumber());
        Set orgFilter = orgView != null ? orgView.getLeaf(membersMap.get(SysDimensionEnum.Entity.getNumber())) : orgUnitDim.getLeaf(membersMap.get(SysDimensionEnum.Entity.getNumber()));
        Set accFilter = accountDim.getLeaf(membersMap.get(SysDimensionEnum.Account.getNumber()));
        RequestContext context = RequestContextCreator.createForThreadPool();
        String traceId = RequestContext.get().getTraceId();
        EBThreadPoolExecutor es = new EBThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        LinkedList<BuildData> tasks = new LinkedList<BuildData>();
        for (Member orgUnit : orgUnits) {
            if (orgFilter != null && !orgFilter.isEmpty() && !orgFilter.contains(orgUnit.getNumber())) continue;
            for (Member account : accounts) {
                if (accFilter != null && !accFilter.isEmpty() && !accFilter.contains(account.getNumber()) || !isEb && (account.getDatasetId() == null || account.getDatasetId().compareTo(datasetId) != 0)) continue;
                String[] memberNums = new String[dimensionSize];
                memberNums[orgIndex] = orgUnit.getNumber();
                memberNums[accIndex] = account.getNumber();
                KDCell cell = new KDCell(KDCellMeta.of((String[])memberNums));
                tasks.add(new BuildData(datasetId, (IKDCell)cell, membersMap, viewIds, this.getModelCacheHelper(), context, traceId));
            }
        }
        for (BuildData data : tasks) {
            es.submit(data);
        }
        es.shutdown();
        this.getView().showMessage("end build data.");
    }

    protected void upBgControlRecord() {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"ControlRecordService", (String)"updateRecord", (Object[])new Object[0]);
    }

    protected void olap2Shrek() {
        DynamicObject modelObj = this.getBizModel();
        if (modelObj == null) {
            this.getView().showMessage("no model");
            return;
        }
        DynamicObject dataset = this.getDataset();
        DynamicObject dataSource = this.getDataSource();
        if (dataSource == null) {
            this.getView().showMessage("no source");
            return;
        }
        Long modelId = modelObj.getLong("id");
        Long datasetId = dataset != null ? Long.valueOf(dataset.getLong("id")) : null;
        Long dataSourceId = dataSource.getLong("id");
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"Olap2ShrekService", (String)"updateData", (Object[])new Object[]{modelId, datasetId, dataSourceId});
        this.getView().showMessage("rolap2Shrek execute end.");
    }

    protected void click_check_l() {
    }

    static class BuildData
    implements Runnable {
        private final Long datasetId;
        private final IKDCell cell;
        private final Map<String, Set<String>> membersMap;
        private final Map<String, Long> viewIds;
        private final IModelCacheHelper cacheHelper;
        private final RequestContext context;
        private final String traceId;

        public BuildData(Long datasetId, IKDCell cell, Map<String, Set<String>> membersMap, Map<String, Long> viewIds, IModelCacheHelper cacheHelper, RequestContext context, String traceId) {
            this.datasetId = datasetId;
            this.cell = cell;
            this.membersMap = membersMap;
            this.viewIds = viewIds;
            this.cacheHelper = cacheHelper;
            this.context = context;
            this.traceId = traceId;
        }

        @Override
        public void run() {
            String threadId = this.toString();
            LogStats stats = new LogStats("budget-data-log : ");
            stats.addInfo("begin-save-data. " + threadId);
            try {
                this.build(stats);
            }
            catch (Throwable ex) {
                throw ex;
            }
            finally {
                stats.addInfo("end-save-data." + threadId);
                log.info(stats.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void build(LogStats stats) {
            RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
            List dimensions = IDUtils.isNotNull((Long)this.datasetId) ? this.cacheHelper.getDimensionList(this.datasetId) : this.cacheHelper.getDimensionList();
            String[] dimensionNum = IDUtils.isNotNull((Long)this.datasetId) ? this.cacheHelper.getDimensionNums(this.datasetId) : this.cacheHelper.getDimensionNums();
            Map dimIndexMap = IDUtils.isNotNull((Long)this.datasetId) ? this.cacheHelper.getDimIndexMap(this.datasetId, false) : this.cacheHelper.getDimIndexMap(false);
            boolean check = true;
            DimMembers dimMembers = new DimMembers();
            int in = dimensions.size();
            for (int i = 0; i < in; ++i) {
                Dimension dimension = (Dimension)dimensions.get(i);
                Set<String> members = this.filter(dimension, dimIndexMap);
                if (members == null || members.isEmpty()) {
                    check = false;
                    stats.addInfo("members is null." + dimension.getNumber());
                    break;
                }
                dimMembers.addMembers(dimension.getNumber(), new ArrayList<String>(members));
            }
            SecureRandom random = new SecureRandom();
            if (check) {
                int dataSize = 0;
                float Max = 100.0f;
                float Min = 1.0f;
                Map shrekProperties = ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats);
                shrekProperties.put("traceId", this.traceId);
                try (IShrekSave save = null;){
                    save = IDUtils.isNotNull((Long)this.datasetId) ? ShrekOlapServiceHelper.saveData((Model)this.cacheHelper.getModelobj(), (Dataset)Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)this.datasetId)), (String[])dimensionNum, (Map)shrekProperties) : EbShrekOlapServiceHelper.saveData((Model)this.cacheHelper.getModelobj(), (String[])dimensionNum, (Map)shrekProperties);
                    while (dimMembers.hasNext()) {
                        String[] member = dimMembers.next();
                        BigDecimal value = BigDecimal.valueOf(random.nextDouble() * (double)(Max - Min) + (double)Min);
                        value = value.setScale(2, RoundingMode.HALF_UP);
                        save.add(member, (Object)value);
                        ++dataSize;
                    }
                }
                stats.addInfo("build Data Size = " + dataSize);
            }
        }

        protected Set<String> filter(Dimension dimension, Map<String, Integer> dimIndexMap) {
            if (dimension == null) {
                return null;
            }
            Set<String> filters = new HashSet<String>();
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                filters.add(this.cell.getMeta().getNumber()[dimIndexMap.get(SysDimensionEnum.Entity.getNumber())]);
            } else if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                filters.add(this.cell.getMeta().getNumber()[dimIndexMap.get(SysDimensionEnum.Account.getNumber())]);
            } else {
                View view = dimension.getView(this.viewIds.get(dimension.getNumber()));
                Set<String> _filters = this.membersMap.get(dimension.getNumber());
                if (_filters == null || _filters.isEmpty()) {
                    filters = view != null ? view.getLeafMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet()) : dimension.getLeafMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                } else if (view != null) {
                    filters.addAll(view.getLeaf(_filters));
                } else {
                    filters.addAll(dimension.getLeaf(_filters));
                }
            }
            return this.filter(dimension.getNumber(), filters);
        }

        protected Set<String> filter(String dimensionNumber, Set<String> members) {
            if (dimensionNumber == null) {
                return members;
            }
            switch (dimensionNumber) {
                case "Process": {
                    members.retainAll(ProcessSet);
                    break;
                }
                case "InternalCompany": {
                    members.retainAll(InternalCompany);
                    break;
                }
                case "ChangeType": {
                    members.retainAll(ChangeType);
                }
            }
            return members;
        }
    }
}

