/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.ebSpread.util.DataAndJsonTranslator;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.CellHyperLinkPOJO;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;

public class TemplateCellHyperLinkUpdateUtils {
    public static void removeRepeatCellInfo(JSONObject spreadJson, JSONObject dataTable, ITemplateModel templateModel) {
        if (dataTable == null) {
            dataTable = DataAndJsonTranslator.getDataTable((JSONObject)spreadJson, null);
        }
        if (dataTable == null || templateModel == null || CollectionUtils.isEmpty((Collection)templateModel.getAreaRanges())) {
            return;
        }
        List areaRanges = templateModel.getAreaRanges();
        HashMap<String, RangeModel> areaSettingMap = new HashMap<String, RangeModel>(areaRanges.size());
        HashMap<String, Point> areaSetingPoingMap = new HashMap<String, Point>(areaRanges.size());
        for (IMultiAreaSetting areaRange : areaRanges) {
            RangeModel rangeModel = new RangeModel(areaRange.getAreaRange());
            areaSettingMap.put(areaRange.getAreaRange(), rangeModel);
            Point point = FixTemplateProcessHelper.getAbsolutePosPoint(areaRange.getAreaRange(), areaRange.getStartPosition());
            areaSetingPoingMap.put(areaRange.getAreaRange(), point);
        }
        HashMap<String, Map> areaCellHyperLinkMap = new HashMap<String, Map>(16);
        for (Map.Entry rowEntry : dataTable.entrySet()) {
            Integer r = Integer.valueOf(rowEntry.getKey() + "");
            JSONObject columns = (JSONObject)rowEntry.getValue();
            for (Map.Entry columnEntry : columns.entrySet()) {
                Point point;
                String areaIndex;
                Integer c = Integer.valueOf(columnEntry.getKey() + "");
                JSONObject column = (JSONObject)columnEntry.getValue();
                String value = column.getString("value");
                if (value == null || !value.startsWith("[") || !value.endsWith("]") || (areaIndex = TemplateCellHyperLinkUpdateUtils.getAreaIndex(r, c, areaSettingMap)) == null || (point = (Point)areaSetingPoingMap.get(areaIndex)) == null) continue;
                Map cellHyperLinkMap = areaCellHyperLinkMap.computeIfAbsent(areaIndex, k -> new HashMap(16));
                Set cellHyperLinkPOJOS = cellHyperLinkMap.computeIfAbsent(value, k -> new HashSet(16));
                cellHyperLinkPOJOS.add(new CellHyperLinkPOJO(r - point.y, c - point.x));
            }
        }
        for (IMultiAreaSetting areaRange : areaRanges) {
            Map newCellInfo = (Map)areaCellHyperLinkMap.get(areaRange.getAreaRange());
            if (newCellInfo == null || newCellInfo.size() == 0) {
                areaRange.setCellHyperLinkMap(null);
                continue;
            }
            Iterator iterator = areaRange.getCellHyperLinkMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String[] split = ((String)next.getKey()).split("]");
                if (!newCellInfo.containsKey(split[0] + "]")) {
                    iterator.remove();
                    continue;
                }
                next.setValue(newCellInfo.get(split[0] + "]"));
            }
        }
    }

    public static String getAreaIndex(Integer r, Integer c, Map<String, RangeModel> areaSettingMap) {
        if (r == null || c == null || areaSettingMap == null) {
            return null;
        }
        String index = null;
        for (Map.Entry<String, RangeModel> stringRangeModelEntry : areaSettingMap.entrySet()) {
            RangeModel value = stringRangeModelEntry.getValue();
            if (r < value.getY_start() || r > value.getY_end() || c < value.getX_start() || c > value.getX_end()) continue;
            index = stringRangeModelEntry.getKey();
            break;
        }
        return index;
    }
}

