/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.KdUtils;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyEntry;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyValueEntry;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class TemplateHelper {
    public static final String SET_FILTER_DIM = "setfilterdim";
    public static final String CALLBACK_SET_FILTER_DIM = "callback_setfilterdim";
    public static final String CACHE_SET_FILTER_DIM = "CACHE_SET_FILTER_DIM";

    public static List<Long> isExistsPropertySetDy(long templateId) {
        List<Long> pkIds = new ArrayList<Long>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("template", "=", (Object)templateId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dimproperty", (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            pkIds = dynamicObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        }
        return pkIds;
    }

    public static DynamicObject createDimPropertyDy(List<Map<String, String>> f7items, Long templateId, String arenRange, Long modelId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"eb_dimproperty");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject f7itemDy = new DynamicObject((DynamicObjectType)type);
        f7itemDy.set("model_id", (Object)modelId);
        f7itemDy.set("template_id", (Object)templateId);
        f7itemDy.set("arearange", (Object)arenRange);
        f7itemDy.set("name", (Object)" ");
        f7itemDy.set("number", (Object)" ");
        f7itemDy.set("status", (Object)"C");
        f7itemDy.set("enable", (Object)"1");
        f7itemDy.set("modifier", (Object)userId);
        f7itemDy.set("modifytime", (Object)now);
        f7itemDy.set("creator", (Object)userId);
        f7itemDy.set("createtime", (Object)now);
        TemplateHelper.addDimPropertyData(f7items, f7itemDy);
        return f7itemDy;
    }

    public static DynamicObject modifyDimPropertyDy(List<Map<String, String>> f7items, DynamicObject f7itemDy) {
        TemplateHelper.addDimPropertyData(f7items, f7itemDy);
        return f7itemDy;
    }

    public static void addDimPropertyData(List<Map<String, String>> f7items, DynamicObject f7itemDy) {
        Map<String, List<Map>> f7itemDimMap = f7items.stream().collect(Collectors.groupingBy(f7item -> (String)f7item.get("dimid")));
        DynamicObjectCollection dimEntries = f7itemDy.getDynamicObjectCollection("entryentity");
        dimEntries.clear();
        for (Map.Entry<String, List<Map>> f7itemMap : f7itemDimMap.entrySet()) {
            DynamicObject dimEntry = dimEntries.addNew();
            dimEntry.set("dimension_id", (Object)Long.parseLong(f7itemMap.getKey()));
            DynamicObjectCollection propertyEntries = dimEntry.getDynamicObjectCollection("subentryentity");
            for (int index = 0; index < f7itemMap.getValue().size(); ++index) {
                DynamicObject propertyEntry = propertyEntries.addNew();
                propertyEntry.set("customproperty_id", f7itemMap.getValue().get(index).get("id"));
                propertyEntry.set("addmustinput", (Object)BooleanUtils.toBoolean((String)((String)f7itemMap.getValue().get(index).get("addMustInput"))));
                propertyEntry.set("dseq", (Object)index);
            }
        }
    }

    public static List<Map<String, String>> getF7ItemByDy(DynamicObject dimPropertySetDy) {
        ArrayList<Map<String, String>> f7items = new ArrayList<Map<String, String>>(16);
        if (dimPropertySetDy == null) {
            return f7items;
        }
        DynamicObjectCollection dimEntries = dimPropertySetDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject dimEntry : dimEntries) {
            DynamicObjectCollection propertyEntries = dimEntry.getDynamicObjectCollection("subentryentity");
            List rowDys = propertyEntries.stream().sorted(Comparator.comparing(rowEntry -> rowEntry.getInt("dseq"))).collect(Collectors.toList());
            for (DynamicObject propertyEntry : rowDys) {
                DynamicObject propertyDy = propertyEntry.getDynamicObject("customproperty");
                if (propertyDy == null) continue;
                Map<String, String> propertyMap = TemplateHelper.getF7ItemMap(propertyDy);
                if (propertyEntry.getDataEntityType().getProperties().containsKey((Object)"addmustinput")) {
                    boolean addMustInput = propertyEntry.getBoolean("addmustinput");
                    propertyMap.put("addMustInput", String.valueOf(addMustInput));
                }
                f7items.add(propertyMap);
            }
        }
        return f7items;
    }

    public static Map<String, String> getF7ItemMap(DynamicObject propertyDy) {
        String keyStr = propertyDy.getString("dimension_id") + "#" + propertyDy.getString("id");
        String id = propertyDy.getString("id");
        String name = propertyDy.getString("name");
        String number = propertyDy.getString("number");
        String dimId = propertyDy.getDynamicObject("dimension").getString("id");
        String dimName = propertyDy.getDynamicObject("dimension").getString("name");
        String dimNum = propertyDy.getDynamicObject("dimension").getString("number");
        String dseq = propertyDy.getString("dseq");
        Map<String, String> propertyMap = TemplateHelper.getF7ItemMap(keyStr, id, name, number, dimId, dimName, dimNum, dseq);
        return propertyMap;
    }

    public static Map<String, String> getF7ItemMap(String key, String id, String name, String number, String dimId, String dimName, String dimNum, String dseq) {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(16);
        propertyMap.put("key", key);
        propertyMap.put("id", id);
        propertyMap.put("name", name);
        propertyMap.put("number", number);
        propertyMap.put("dimid", dimId);
        propertyMap.put("dimname", dimName);
        propertyMap.put("dimnum", dimNum);
        propertyMap.put("dseq", dseq);
        return propertyMap;
    }

    public static Map<String, String> getDimItemMap(IDimension dimension) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("id", dimension.getId() + "");
        result.put("name", dimension.getName());
        result.put("number", dimension.getNumber());
        result.put("entity", dimension.getMemberModel());
        result.put("seq", String.valueOf(dimension.getDSeq()));
        result.put("sign", dimension.getMemberModel());
        result.put("panel", "");
        return result;
    }

    public static List<Map<String, String>> getF7itemsByPropertyObj(Map<String, List<PropertyObj>> propertyMap, Long modelId) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (Map.Entry<String, List<PropertyObj>> property : propertyMap.entrySet()) {
            Dimension dimension = modelCacheHelper.getDimension(property.getKey());
            for (PropertyObj propertyObj : property.getValue()) {
                String key = dimension.getId() + "#" + propertyObj.getId();
                Map<String, String> f7itemMap = TemplateHelper.getF7ItemMap(key, propertyObj.getId() + "", propertyObj.getName(), propertyObj.getNumber(), dimension.getId() + "", dimension.getName(), dimension.getNumber(), propertyObj.getDseq() + "");
                f7itemMap.put("addMustInput", String.valueOf(propertyObj.isAddMustInput()));
                result.add(f7itemMap);
            }
        }
        return result;
    }

    public static void delDimproperty(List<Long> templateIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("template", "in", templateIds));
        DeleteServiceHelper.delete((String)"eb_dimproperty", (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }

    public static Map<Long, List<PropertyObj>> getDimPropertys(Map<Long, List<PropertyObj>> allDimPropertys, List<Map<String, String>> f7items) {
        LinkedHashMap<Long, List<PropertyObj>> result = new LinkedHashMap<Long, List<PropertyObj>>(16);
        Map<String, List<Map>> f7itemDimMap = f7items.stream().collect(Collectors.groupingBy(f7item -> (String)f7item.get("dimid")));
        for (Map.Entry<String, List<Map>> dimPropertyMaps : f7itemDimMap.entrySet()) {
            Long dimId = Long.parseLong(dimPropertyMaps.getKey());
            if (!allDimPropertys.containsKey(dimId) || allDimPropertys.get(dimId).size() == 0 || dimPropertyMaps.getValue().size() == 0) continue;
            Map<Long, PropertyObj> allPropertyMap = allDimPropertys.get(dimId).stream().collect(Collectors.toMap(property -> property.getId(), property -> property));
            ArrayList<PropertyObj> propertyList = new ArrayList<PropertyObj>(16);
            List<Map> dimPropertys = dimPropertyMaps.getValue();
            for (Map dimPropertyMap : dimPropertys) {
                Long propertyId = Long.parseLong((String)dimPropertyMap.get("id"));
                if (!allPropertyMap.containsKey(propertyId)) continue;
                propertyList.add(allPropertyMap.get(propertyId));
            }
            result.put(dimId, propertyList);
        }
        return result;
    }

    public static Map<String, List<PropertyObj>> filterDimPropertysByNum(Map<String, List<PropertyObj>> allDimPropertys, List<Map<String, String>> f7items) {
        LinkedHashMap<String, List<PropertyObj>> result = new LinkedHashMap<String, List<PropertyObj>>(16);
        Map<String, List<Map>> f7itemDimMap = f7items.stream().collect(Collectors.groupingBy(f7item -> (String)f7item.get("dimnum")));
        for (Map.Entry<String, List<Map>> dimPropertyMaps : f7itemDimMap.entrySet()) {
            String dimNum = dimPropertyMaps.getKey();
            if (!allDimPropertys.containsKey(dimNum) || allDimPropertys.get(dimNum).size() == 0 || dimPropertyMaps.getValue().size() == 0) continue;
            Map<Long, PropertyObj> allPropertyMap = allDimPropertys.get(dimNum).stream().collect(Collectors.toMap(property -> property.getId(), property -> property));
            ArrayList<PropertyObj> propertyList = new ArrayList<PropertyObj>(16);
            List<Map> dimPropertys = dimPropertyMaps.getValue();
            for (Map dimPropertyMap : dimPropertys) {
                Long propertyId = Long.parseLong((String)dimPropertyMap.get("id"));
                if (!allPropertyMap.containsKey(propertyId)) continue;
                PropertyObj propertyObj = allPropertyMap.get(propertyId);
                propertyObj.setAddMustInput(Boolean.parseBoolean((String)dimPropertyMap.get("addMustInput")));
                propertyList.add(propertyObj);
            }
            result.put(dimNum, propertyList);
        }
        return result;
    }

    public static List<Map<String, String>> filterF7itemsByDim(List<Map<String, String>> allF7items, List<Map<String, String>> curDims, Boolean isExists) {
        List dimNums = curDims.stream().map(dim -> (String)dim.get("number")).collect(Collectors.toList());
        ArrayList<Map<String, String>> curF7Items = new ArrayList<Map<String, String>>(16);
        for (Map<String, String> f7Item : allF7items) {
            if (isExists.booleanValue() && dimNums.contains(f7Item.get("dimnum"))) {
                curF7Items.add(f7Item);
                continue;
            }
            if (isExists.booleanValue() || dimNums.contains(f7Item.get("dimnum"))) continue;
            curF7Items.add(f7Item);
        }
        return curF7Items;
    }

    public static boolean checkPropertyCell(ECell cell) {
        Object _isProperty;
        boolean isProperty = false;
        if (cell != null && cell.hasUserObject() && (_isProperty = cell.getUserObject("isproperty")) != null) {
            isProperty = "1".equals(_isProperty);
        }
        return isProperty;
    }

    public static void setPropertyCellUserObject(ECell propertyCell, String dimNum, String memNum, String typeNum, String typeName, String properytNum) {
        if (propertyCell == null) {
            return;
        }
        propertyCell.setUserObject("isproperty", (Object)"1");
        propertyCell.setUserObject("dimnum", (Object)dimNum);
        propertyCell.setUserObject("memnum", (Object)memNum);
        propertyCell.setUserObject("typenum", (Object)typeNum);
        propertyCell.setUserObject("typename", (Object)typeName);
        propertyCell.setUserObject("properytnum", (Object)properytNum);
    }

    public static Map<String, Integer> getDimPosMap(List<IHeaderInfo> headerInfos) {
        HashMap<String, Integer> dimsIndex = new HashMap<String, Integer>(16);
        if (headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (!"Dimension".equals(headerInfo.getType())) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static String getDimNumByPos(Map<String, Integer> dimPosMap, int pos) {
        String dim = "";
        if (dimPosMap == null || dimPosMap.size() == 0) {
            return dim;
        }
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(dimPosMap.entrySet());
        list.sort(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        String befDim = null;
        for (Map.Entry entry : list) {
            if ((Integer)entry.getValue() > pos) {
                return StringUtils.isEmpty(befDim) ? (String)entry.getKey() : befDim;
            }
            befDim = (String)entry.getKey();
        }
        return befDim;
    }

    public static Map<String, List<String>> getRowColDimMemsMap(ITemplateModel templateModel) {
        Map<String, List<String>> memsMap = new HashMap<String, List<String>>(16);
        if (templateModel == null || templateModel.getPartitionSetting() == null) {
            return memsMap;
        }
        ArrayList<RowColPartition> rowColPartitions = new ArrayList<RowColPartition>(16);
        rowColPartitions.addAll(templateModel.getPartitionSetting().getRowPartition());
        rowColPartitions.addAll(templateModel.getPartitionSetting().getColPartition());
        memsMap = TemplateHelper.getDimMemsMap(rowColPartitions);
        return memsMap;
    }

    public static boolean updateDimProperty(ITemplateModel templateModel) {
        if (templateModel == null || templateModel.getPartitionSetting() == null) {
            return false;
        }
        ArrayList<RowColPartition> rowColPartitions = new ArrayList<RowColPartition>(16);
        rowColPartitions.addAll(templateModel.getPartitionSetting().getRowPartition());
        rowColPartitions.addAll(templateModel.getPartitionSetting().getColPartition());
        Map<String, List<String>> memsMap = TemplateHelper.getDimMemsMap(rowColPartitions);
        List rowColDims = memsMap.keySet().stream().collect(Collectors.toList());
        Map propertyMap = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertysByNum(templateModel.getModelId(), rowColDims);
        ArrayList rowColDimensions = new ArrayList(16);
        rowColDimensions.addAll(templateModel.getAreaRangeEntry().getColdimensions());
        rowColDimensions.addAll(templateModel.getAreaRangeEntry().getRowdimensions());
        boolean hasProp = false;
        for (IDimension dimension : rowColDimensions) {
            String dimNum = dimension.getNumber();
            if (!propertyMap.containsKey(dimNum) || dimension.getPropertyEntries() == null) continue;
            for (PropertyEntry propertyEntry : dimension.getPropertyEntries()) {
                TemplateHelper.setDimensionPropertyName(propertyEntry, (List)propertyMap.get(dimNum));
                hasProp = true;
            }
        }
        if (!hasProp) {
            return false;
        }
        Map memPropertyMap = DimPropertyHelper.getNewPropertyDimMap(memsMap, (long)templateModel.getModelId());
        String dimnum = "";
        String memnum = "";
        for (RowColPartition rowColPartition : rowColPartitions) {
            for (IRowColDimensionEntry rowColDimensionEntry : rowColPartition.getRowColDimensionEntries()) {
                dimnum = rowColDimensionEntry.getDimension().getNumber();
                for (IDimensionMember dimensionMember : rowColDimensionEntry.getMembers()) {
                    memnum = dimensionMember.getNumber();
                    for (int propertyIndex = 0; propertyIndex < dimensionMember.getPropertyValueEntries().size(); ++propertyIndex) {
                        PropertyEntry curPropertyEntry = (PropertyEntry)rowColDimensionEntry.getDimension().getPropertyEntries().get(propertyIndex);
                        if (curPropertyEntry == null) continue;
                        String propertyTypenum = curPropertyEntry.getNumber();
                        String propertyMemnum = "";
                        PropertyMemObj propertyMemObj = DimPropertyHelper.getMatchPropertyObj((String)dimnum, (String)memnum, (String)propertyTypenum, (String)propertyMemnum, (Map)memPropertyMap);
                        PropertyValueEntry propertyValueEntry = (PropertyValueEntry)dimensionMember.getPropertyValueEntries().get(propertyIndex);
                        if (propertyMemObj != null) {
                            if (propertyValueEntry != null && propertyValueEntry.getNumber().equals(propertyMemObj.getNumber())) {
                                propertyValueEntry.setName(propertyMemObj.getName());
                                continue;
                            }
                            PropertyValueEntry newPropertyEntry = new PropertyValueEntry(propertyMemObj.getId(), propertyMemObj.getName(), propertyMemObj.getNumber(), 10);
                            newPropertyEntry.setDseq(propertyMemObj.getDseq());
                            dimensionMember.getPropertyValueEntries().set(propertyIndex, newPropertyEntry);
                            continue;
                        }
                        dimensionMember.getPropertyValueEntries().set(propertyIndex, null);
                    }
                }
            }
        }
        return true;
    }

    public static Map<String, List<String>> getDimMemsMap(List<RowColPartition> rowColPartitions) {
        HashMap memsMap = new HashMap(16);
        String dimNum = "";
        for (RowColPartition rowColPartition : rowColPartitions) {
            for (IRowColDimensionEntry rowColDimensionEntry : rowColPartition.getRowColDimensionEntries()) {
                dimNum = rowColDimensionEntry.getDimension().getNumber();
                Set mems = rowColDimensionEntry.getMembers().stream().map(memObj -> memObj.getNumber()).collect(Collectors.toSet());
                if (memsMap.containsKey(dimNum)) {
                    ((Set)memsMap.get(dimNum)).addAll(mems);
                    continue;
                }
                memsMap.put(dimNum, mems);
            }
        }
        Map<String, List<String>> result = memsMap.entrySet().stream().collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> ((Set)kv.getValue()).stream().collect(Collectors.toList())));
        return result;
    }

    private static void setDimensionPropertyName(PropertyEntry propertyEntry, List<PropertyObj> propertyObjs) {
        if (propertyEntry == null) {
            return;
        }
        PropertyObj newProperty = propertyObjs.stream().filter(property -> property.getNumber().equals(propertyEntry.getNumber())).findFirst().orElse(null);
        if (newProperty != null) {
            propertyEntry.setName(newProperty.getName());
        }
    }

    public static Map<String, List<PropertyObj>> reloadHeadDimensionPropertys(Long modelId, Map<String, List<PropertyObj>> sourceMap) {
        Map<String, List<PropertyObj>> result = sourceMap;
        if (sourceMap != null && sourceMap.size() > 0) {
            List dimnums = result.keySet().stream().collect(Collectors.toList());
            Map allNewDimPropertyMap = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertysByNum(modelId, dimnums);
            if (allNewDimPropertyMap == null || allNewDimPropertyMap.size() == 0) {
                return sourceMap;
            }
            for (Map.Entry<String, List<PropertyObj>> sourcePair : sourceMap.entrySet()) {
                List newPropertys = (List)allNewDimPropertyMap.get(sourcePair.getKey());
                if (newPropertys == null || newPropertys.size() == 0) continue;
                HashMap<String, PropertyObj> newPropertyMap = new HashMap<String, PropertyObj>(16);
                for (PropertyObj newPropertyobj : newPropertys) {
                    if (StringUtils.isEmpty((String)newPropertyobj.getNumber())) continue;
                    newPropertyMap.put(newPropertyobj.getNumber(), newPropertyobj);
                }
                for (PropertyObj sourcePropertyObj : sourcePair.getValue()) {
                    PropertyObj newPropertyObj = (PropertyObj)newPropertyMap.get(sourcePropertyObj.getNumber());
                    if (newPropertyObj == null) continue;
                    sourcePropertyObj.setName(newPropertyObj.getName());
                }
            }
        }
        return result;
    }

    public static void copyMemberQuote(Map<Long, Long> sourceTargetIds) {
        if (sourceTargetIds != null && sourceTargetIds.size() > 0) {
            LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select qe.fsourceid, q.fmodelid, q.fdatasetid, q.fdimensionid, q.fmemberid from t_eb_memberquote q, t_eb_memberquoteentry qe", new Object[0]).append("where q.fid = qe.fquoteid ", new Object[0]).append("and qe.fsourcetype=" + MemberQuoteResourceEnum.Template.getType(), new Object[0]).append(" and ", new Object[0]).appendIn("qe.fsourceid", Arrays.asList(sourceTargetIds.keySet().toArray()));
            try (DataSet ds = DB.queryDataSet((String)"copyMemberQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    quotes.add(new MemberQuoteDao(row.getLong("fmodelid"), row.getLong("fdatasetid"), row.getLong("fdimensionid"), Collections.singleton(row.getLong("fmemberid")), MemberQuoteResourceEnum.Template, sourceTargetIds.get(row.getLong("fsourceid"))));
                }
            }
            if (quotes != null && quotes.size() > 0) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
        }
    }

    public static FormShowParameter getSetFilterDimFormShowParameter(String dimMaps, String filterDims) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setFormId("eb_setfilterdim");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("dimMaps", dimMaps);
        params.put("filterDims", filterDims);
        showParam.setCustomParams(params);
        return showParam;
    }

    public static List<String> getFilterDimsByCache(IPageCache pageCache) {
        List<String> filterDims = new ArrayList<String>(16);
        String filterDimsCache = pageCache.get(CACHE_SET_FILTER_DIM);
        if (!kd.bos.util.StringUtils.isEmpty((String)filterDimsCache)) {
            filterDims = (List)SerializationUtils.fromJsonString((String)filterDimsCache, List.class);
        }
        return filterDims;
    }

    public static void setFilterDimCallBack(ClosedCallBackEvent closedCallBackEvent, IPageCache pageCache) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (closedCallBackEvent.getReturnData() instanceof String && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)((String)closedCallBackEvent.getReturnData()))) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            List selDimNumbers = (List)SerializationUtils.fromJsonString((String)returnData, List.class);
            TemplateHelper.setSetFilterDimsCache(selDimNumbers, pageCache);
        }
    }

    public static void setSetFilterDimsCache(List<String> f7Items, IPageCache pageCache) {
        if (f7Items != null && f7Items.size() > 0) {
            String f7dimSetFilterJson = SerializationUtils.toJsonString(f7Items);
            pageCache.put(CACHE_SET_FILTER_DIM, f7dimSetFilterJson);
        } else {
            pageCache.remove(CACHE_SET_FILTER_DIM);
        }
    }

    public static void removeSetFilterDimsCache(Collection<String> rangeDims, IPageCache pageCache) {
        if (CollectionUtils.isEmpty(rangeDims)) {
            pageCache.remove(CACHE_SET_FILTER_DIM);
            return;
        }
        List<String> filterDims = TemplateHelper.getFilterDimsByCache(pageCache);
        if (CollectionUtils.isNotEmpty(filterDims)) {
            filterDims.removeIf(e -> !rangeDims.contains(e));
            TemplateHelper.setSetFilterDimsCache(filterDims, pageCache);
        }
    }

    public static void loadFilterDimsCache(ITemplateModel template, IPageCache pageCache) {
        if (template != null && CollectionUtils.isNotEmpty((Collection)template.getFilterDims())) {
            List filterDims = template.getFilterDims();
            TemplateHelper.setSetFilterDimsCache(filterDims, pageCache);
        }
    }

    public static void fillBack2TemplateModelFilterDims(ITemplateModel templateModel, IPageCache pageCache) {
        String f7dimFilterJson = pageCache.get(CACHE_SET_FILTER_DIM);
        if (kd.bos.util.StringUtils.isNotEmpty((String)f7dimFilterJson)) {
            List filterDimNumbers = (List)SerializationUtils.fromJsonString((String)f7dimFilterJson, List.class);
            templateModel.setFilterDims(filterDimNumbers);
        } else {
            templateModel.getFilterDims().clear();
        }
    }

    public static void setDynamicObjectRunExamineOrRuleWhenOpen(DynamicObject templateDynamicObject, BgTemplate bgTemplate) {
        boolean isReadOnlyBoolean = KdUtils.getBoolean((Object)bgTemplate.getIsReadOnly());
        if (isReadOnlyBoolean) {
            templateDynamicObject.set("runexaminewhenopen", (Object)Boolean.TRUE.equals(bgTemplate.getRunExamineWhenOpenBoolean()));
        } else {
            templateDynamicObject.set("runexaminewhenopen", (Object)false);
        }
        templateDynamicObject.set("runrulewhenopen", (Object)Boolean.TRUE.equals(bgTemplate.getRunRuleWhenOpenBoolean()));
    }

    public static void setBgTemplateRunExamineOrRuleWhenOpen(BgTemplate bgTemplate, DynamicObject templateDynamicObject) {
        bgTemplate.setRunExamineWhenOpenBoolean(Boolean.valueOf(templateDynamicObject.getBoolean("runexaminewhenopen")));
        bgTemplate.setRunRuleWhenOpenBoolean(Boolean.valueOf(templateDynamicObject.getBoolean("runrulewhenopen")));
    }
}

