/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.tree.Recorder;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.compress.object.node.Node2Array;

public class TreeSearchUtil {
    public static final Log log = LogFactory.getLog(TreeSearchUtil.class);
    public static final String SEARCHCONTROL = "searchap";
    public static final String SEARCH_BEFORE = "searchbefore";
    public static final String SEARCH_NEXT = "searchnext";
    public static final int MAX_lEVEL = 20;
    public static final String TREE_KEY = "treeviewap";
    public static final String FOCUS = "focus";
    public static final String RESULT_LIST = "resultList";
    public static final String TREE_CACHE_NAME = "treeCacheName";
    public static final String OLD_NODE_CACHE_NAME = "oldNodeCacheName";
    public static boolean CONTROL_SET_ORG_FLAG = false;

    public static void expand(String parentid, TreeView treeView, TreeNode root) {
        TreeNode treeNode;
        if (root == null || treeView == null || StringUtils.isEmpty((String)parentid)) {
            return;
        }
        HashMap<String, TreeNode> outRefMap = new HashMap<String, TreeNode>(16);
        TreeSearchUtil.getNode2Map(root, outRefMap);
        for (int i = 0; i < 20 && (treeNode = (TreeNode)outRefMap.get(parentid)) != null; ++i) {
            treeView.expand(treeNode.getId());
            parentid = treeNode.getParentid();
            if (StringUtils.isEmpty((String)parentid) || parentid.equals(root.getId())) break;
        }
    }

    public static void searchMember(String text, IFormView view, IPageCache pageCache, TreeSearchParam param) {
        TreeSearchUtil.searchMember(text, view, pageCache, param, false);
    }

    public static void searchMember(String text, IFormView view, IPageCache pageCache, TreeSearchParam param, boolean isQueryNumber) {
        if (text == null || "".equals(text)) {
            pageCache.put(param.getResultList(), null);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"TreeSearchUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String treeCache = pageCache.get(param.getTreeCacheName());
        if (treeCache == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = param.isNodeCompress() ? TreeSearchUtil.getCompressTreeNode(treeCache) : TreeSearchUtil.getTreeNode(treeCache);
        List<TreeNode> nodes = TreeSearchUtil.seekChildrenIf(root, p -> TreeSearchUtil.isMatch(p, text, isQueryNumber));
        if (!nodes.isEmpty() && param.isSkipRoot() && nodes.get(0).equals(root)) {
            nodes.remove(0);
        }
        if (!nodes.isEmpty()) {
            TreeSearchUtil.selectNode(nodes.get(0), TreeSearchUtil.getControl(view, param.getTreeKey()), root, pageCache, param.getOldNodeCacheName());
            pageCache.put(param.getResultList(), SerializationUtils.serializeToBase64((Object)TreeNodeUtils.getBaseClone(nodes)));
            pageCache.put(param.getFocus(), "0");
        } else {
            TreeNode old = F7TreeUtils.getCacheTreeNodeData((IPageCache)pageCache, (String)param.getOldNodeCacheName());
            if (old != null) {
                old.setColor("");
                ((TreeView)view.getControl(param.getTreeKey())).updateNode(old);
            }
            TreeSearchUtil.clearSearchPageCache(pageCache, param);
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private static boolean isMatch(TreeNode node, String text, boolean isQueryNumber) {
        if (node == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)text)) {
            return true;
        }
        boolean isMatch = node.getText().toLowerCase().contains(text.toLowerCase());
        if (!isMatch && isQueryNumber) {
            String number = TreeSearchUtil.getNumber(node);
            isMatch = number != null && number.toLowerCase().contains(text.toLowerCase());
        }
        return isMatch;
    }

    private static String getNumber(TreeNode node) {
        Object obj;
        if (node.getData() instanceof Map && (obj = ((Map)node.getData()).get("number")) instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public static void clearSearchPageCache(IPageCache cache, TreeSearchParam param) {
        cache.put(param.getResultList(), null);
        cache.put(param.getFocus(), null);
        cache.put(param.getOldNodeCacheName(), null);
    }

    private static void selectNode(TreeNode fnode, TreeView tree, TreeNode root, IPageCache pageCache, String oldNodeCacheName) {
        if (fnode == null || tree == null) {
            return;
        }
        tree.focusNode(TreeNodeUtils.getBaseClone((TreeNode)fnode));
        TreeSearchUtil.expand(fnode.getParentid(), tree, root);
    }

    public static void getLeftOrRight(IPageCache pageCache, IFormView view, TreeSearchParam param) {
        String rowcache = pageCache.get(param.getResultList());
        if (rowcache == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"TreeSearchUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List rowList = (List)SerializationUtils.deSerializeFromBase64((String)rowcache);
        int rowCount = Integer.parseInt(pageCache.get(param.getFocus()));
        if (SearchBtnStatus.LEFT == param.getStatus()) {
            if (0 == rowCount) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TreeSearchUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            --rowCount;
        } else if (SearchBtnStatus.RIGHT == param.getStatus()) {
            if (rowList.size() - 1 == rowCount) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TreeSearchUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ++rowCount;
        } else {
            return;
        }
        pageCache.put(param.getFocus(), String.valueOf(rowCount));
        TreeNode focusNode = (TreeNode)rowList.get(rowCount);
        TreeNode root = param.isNodeCompress() ? TreeSearchUtil.getCompressTreeNode(pageCache.get(param.getTreeCacheName())) : TreeSearchUtil.getTreeNode(pageCache.get(param.getTreeCacheName()));
        TreeSearchUtil.selectNode(focusNode, TreeSearchUtil.getControl(view, param.getTreeKey()), root, pageCache, param.getOldNodeCacheName());
    }

    private static TreeNode getTreeNode(String treeNodeCache) {
        return F7TreeUtils.getCacheTreeNodeData((String)treeNodeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeNode getCompressTreeNode(String treeNodeCache) {
        LogStats stats = new LogStats("budget-tree-log : ");
        try {
            String _treeNodeCache = F7TreeUtils.getCacheData((String)treeNodeCache, (LogStats)stats);
            List nodes = SerializationUtils.fromJsonStringToList((String)_treeNodeCache, Object[].class);
            TreeNode treeNode = Node2Array.get().fromArray(nodes);
            return treeNode;
        }
        finally {
            log.info(stats.toString());
        }
    }

    private static TreeView getControl(IFormView view, String treeKey) {
        return (TreeView)view.getControl(treeKey);
    }

    public static List<TreeNode> seekChildrenIf(TreeNode root, Predicate<TreeNode> p) {
        if (root == null) {
            return new ArrayList<TreeNode>(1);
        }
        Recorder r = new Recorder(new ArrayList(16));
        if (p.test(root)) {
            ((List)r.getRecord()).add(root);
        }
        if (root.getChildren() != null) {
            TreeSearchUtil.cycleSeekNodes(root, p, (Recorder<List<TreeNode>>)r);
        }
        return (List)r.getRecord();
    }

    private static void cycleSeekNodes(TreeNode node, Predicate<TreeNode> p, Recorder<List<TreeNode>> r) {
        node.getChildren().forEach(t -> {
            if (p.test((TreeNode)t)) {
                ((List)r.getRecord()).add(t);
            }
            if (t.getChildren() != null) {
                TreeSearchUtil.cycleSeekNodes(t, p, r);
            }
        });
    }

    public static void getNode2Map(TreeNode root, Map<String, TreeNode> outRefMap) {
        outRefMap.put(root.getId(), root);
        if (root.getChildren() != null) {
            for (TreeNode treeNode : root.getChildren()) {
                TreeSearchUtil.getNode2Map(treeNode, outRefMap);
            }
        }
    }

    public static List<TreeNode> getNodeList(TreeNode root) {
        Recorder r = new Recorder(new ArrayList(16));
        ((List)r.getRecord()).add(root);
        if (root.getChildren() != null) {
            TreeSearchUtil.addChildren2List(root, (Recorder<List<TreeNode>>)r);
        }
        return (List)r.getRecord();
    }

    private static void addChildren2List(TreeNode node, Recorder<List<TreeNode>> r) {
        node.getChildren().forEach(t -> {
            ((List)r.getRecord()).add(node);
            if (t.getChildren() != null) {
                TreeSearchUtil.addChildren2List(t, r);
            } else if (t != null) {
                ((List)r.getRecord()).add(t);
            }
        });
    }

    public static Queue<TreeNode> getQueue(TreeNode root) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        LinkedList<TreeNode> result = new LinkedList<TreeNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            result.add(node);
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                queue.add(child);
            }
        }
        return result;
    }

    public static enum SearchBtnStatus {
        LEFT,
        RIGHT;

    }

    public static class TreeSearchParam {
        private String treeKey;
        private String treeCacheName;
        private String resultList;
        private String focus;
        private String oldNodeCacheName;
        private boolean skipRoot;
        private SearchBtnStatus status = SearchBtnStatus.LEFT;
        private boolean nodeCompress = false;

        public TreeSearchParam() {
            this(TreeSearchUtil.TREE_KEY, TreeSearchUtil.TREE_CACHE_NAME, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME);
        }

        @Deprecated
        public TreeSearchParam(String treeKey) {
            this(treeKey, TreeSearchUtil.TREE_CACHE_NAME, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME);
        }

        public TreeSearchParam(String treeKey, String treeCacheName) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME);
        }

        public TreeSearchParam(String treeKey, SearchBtnStatus status) {
            this(treeKey, TreeSearchUtil.TREE_CACHE_NAME, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME, status);
        }

        public TreeSearchParam(String treeKey, String treeCacheName, String suffix) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST + suffix, TreeSearchUtil.FOCUS + suffix, TreeSearchUtil.OLD_NODE_CACHE_NAME + suffix);
        }

        public TreeSearchParam(String treeKey, String treeCacheName, String suffix, SearchBtnStatus status) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST + suffix, TreeSearchUtil.FOCUS + suffix, TreeSearchUtil.OLD_NODE_CACHE_NAME + suffix, status);
        }

        @Deprecated
        public TreeSearchParam(String treeKey, String treeCacheName, SearchBtnStatus status) {
            this(treeKey, treeCacheName, TreeSearchUtil.RESULT_LIST, TreeSearchUtil.FOCUS, TreeSearchUtil.OLD_NODE_CACHE_NAME, status);
        }

        @Deprecated
        public TreeSearchParam(String treeKey, String treeCacheName, String resultList, String focus, String oldNodeCacheName) {
            this.treeKey = treeKey;
            this.treeCacheName = treeCacheName;
            this.resultList = resultList;
            this.focus = focus;
            this.oldNodeCacheName = oldNodeCacheName;
        }

        @Deprecated
        public TreeSearchParam(String treeKey, String treeCacheName, String resultList, String focus, String oldNodeCacheName, SearchBtnStatus status) {
            this(treeKey, treeCacheName, resultList, focus, oldNodeCacheName);
            this.status = status;
        }

        public String getTreeKey() {
            return this.treeKey;
        }

        public SearchBtnStatus getStatus() {
            return this.status;
        }

        public String getTreeCacheName() {
            return this.treeCacheName;
        }

        public String getResultList() {
            return this.resultList;
        }

        public String getFocus() {
            return this.focus;
        }

        public boolean isSkipRoot() {
            return this.skipRoot;
        }

        public void setSkipRoot(boolean skipRoot) {
            this.skipRoot = skipRoot;
        }

        public String getOldNodeCacheName() {
            return this.oldNodeCacheName;
        }

        public void setNodeCompress(boolean nodeCompress) {
            this.nodeCompress = nodeCompress;
        }

        protected boolean isNodeCompress() {
            return this.nodeCompress;
        }
    }
}

