/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versionconstrast;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.VersionConstrastConstants;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.gpt.GptCommonServerHelper;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.parser.Parser;
import kd.epm.eb.common.markdown.renderer.Renderer;
import kd.epm.eb.common.markdown.renderer.html.HtmlRenderer;
import kd.epm.eb.common.markdown.renderer.text.TextContentRenderer;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.versionconstrast.VersionConstrastCheckDto;
import kd.epm.eb.common.versionconstrast.VersionConstrastNode;
import kd.epm.eb.common.versionconstrast.VersionConstrastParam;
import kd.epm.eb.common.versionconstrast.VersionConstrastSimpleData;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.formplugin.versionconstrast.GaiInitConfig;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastExportHelper;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastPlugin;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastPojo;
import org.jetbrains.annotations.NotNull;

public class VersionConstractGptHelper
implements VersionConstrastConstants {
    private static final Log log = LogFactory.getLog(VersionConstractGptHelper.class);
    private static Long propmtId = 1970392733545786368L;

    public static void openGptByToken(VersionConstrastPlugin versionConsPlugin) {
        VersionConstractGptHelper.setVisableGpt(versionConsPlugin, true);
        try {
            LinkedList<String> datas;
            VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion();
            if (pojo == null) {
                log.info("versionconstrast-gpt-openGpt-pojo-null");
                return;
            }
            DynamicObject prompt = VersionConstractGptHelper.queryPrompt();
            if (prompt == null) {
                log.info("versionconstrast-gpt-propmt-no-exists");
                return;
            }
            int promptcount = 0;
            if (StringUtils.isNotEmpty((String)prompt.getString("prompt"))) {
                promptcount = VersionConstractGptHelper.calcToken(prompt.getString("prompt"));
            }
            if ((datas = VersionConstractGptHelper.buildVcDataByToken(versionConsPlugin, promptcount)) == null || datas.isEmpty()) {
                log.info("versionconstrast-gpt-openGpt-datas-null");
                return;
            }
            Map<String, LinkedList<String>> gptTokens = VersionConstractGptHelper.getGptTokens(versionConsPlugin);
            Long processId = new VersionConstrastHelper().getProcessId(versionConsPlugin.getView());
            gptTokens.put(String.valueOf(processId), datas);
            VersionConstractGptHelper.setGptState(versionConsPlugin, processId, false);
            pojo.setGptResult(null);
            versionConsPlugin.cacheVersionConstrast(pojo);
            VersionConstractGptHelper.cacheGptTokens(versionConsPlugin, gptTokens);
            VersionConstractGptHelper.oneGptByToken(versionConsPlugin, processId);
        }
        catch (Throwable e) {
            log.error("openGpt", e);
            CommonServiceHelper.dealExceptionNoShowForm((IFormView)versionConsPlugin.getView(), (String)"openGpt", (Throwable)e);
        }
    }

    public static DynamicObject queryPrompt() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)propmtId, (String)"gai_prompt", (String)"id,prompt");
    }

    public static void oneGptByToken(VersionConstrastPlugin versionConsPlugin, Object processId) {
        try {
            Map<String, LinkedList<String>> gptTokens = VersionConstractGptHelper.getGptTokens(versionConsPlugin);
            if (gptTokens == null || gptTokens.isEmpty() || gptTokens.get(String.valueOf(processId)) == null) {
                log.info("versionconstrast-gpt-oneGptByToken-gptTokens-null");
                VersionConstractGptHelper.setGptState(versionConsPlugin, processId, true);
                return;
            }
            LinkedList<String> thisTokens = gptTokens.get(String.valueOf(processId));
            if (thisTokens.isEmpty()) {
                log.info("versionconstrast-gpt-oneGptByToken-thisTokens-null");
                VersionConstractGptHelper.setGptState(versionConsPlugin, processId, true);
                return;
            }
            Map<String, String> varParams = VersionConstractGptHelper.buildGptParam(versionConsPlugin);
            if (varParams == null || varParams.isEmpty()) {
                log.info("versionconstrast-gpt-oneGptByToken-varParams-null");
                return;
            }
            String data = thisTokens.pop();
            VersionConstractGptHelper.cacheGptTokens(versionConsPlugin, gptTokens);
            varParams.put("DATA1", data);
            HashMap<String, String> callbackinfo = new HashMap<String, String>();
            callbackinfo.put("cloudId", "epm");
            callbackinfo.put("appId", "eb");
            callbackinfo.put("serviceName", "GPTCallBackService");
            callbackinfo.put("methodName", "versionConstrast");
            String input = ResManager.loadKDString((String)"\u5173\u952e\u5dee\u5f02\u5206\u6790", (String)"VersionConstrastPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            Object obj = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"asyncCall", (Object[])new Object[]{callbackinfo, true, propmtId, input, varParams});
            VersionConstractGptHelper.startGptResultStream(versionConsPlugin, versionConsPlugin.getConstrastVersion(processId), processId, obj);
        }
        catch (Throwable e) {
            log.error("openGpt", e);
            CommonServiceHelper.dealExceptionNoShowForm((IFormView)versionConsPlugin.getView(), (String)"openGpt", (Throwable)e);
        }
    }

    private static void setGptState(VersionConstrastPlugin versionConsPlugin, Object processId, boolean isEnd) {
        VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion(processId);
        if (pojo == null) {
            log.info("versionconstrast-gpt-oneGptByToken-pojo-null");
            return;
        }
        pojo.setGptEnd(isEnd);
        versionConsPlugin.cacheVersionConstrast(pojo, processId);
    }

    private static int calcToken(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static void openGpt(VersionConstrastPlugin versionConsPlugin, boolean isStream) {
        try {
            Long currUserId;
            LicenseCheckResult r;
            String groupnumber = "PRO_GPTFAS";
            List prods = LicenseServiceHelper.getProdInfosByGroup((String)groupnumber);
            if (prods != null && !prods.isEmpty() && (r = LicenseServiceHelper.checkUserInGroup((Long)(currUserId = Long.valueOf(RequestContext.get().getCurrUserId())), (Long)618L)) != null && !r.getHasLicense().booleanValue()) {
                if (versionConsPlugin != null) {
                    versionConsPlugin.getView().showTipNotification(r.getMsg());
                }
                return;
            }
        }
        catch (Throwable e) {
            log.error(e);
        }
        if (isStream) {
            VersionConstractGptHelper.openGptByToken(versionConsPlugin);
            return;
        }
    }

    private static Map<String, String> buildGptParam(VersionConstrastPlugin versionConsPlugin) {
        HashMap<String, String> varParams = new HashMap<String, String>();
        VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion();
        if (pojo == null) {
            log.info("versionconstrast-gpt-openGpt-pojo-null");
            return varParams;
        }
        varParams.put("CURRENTVERSION", pojo.getCurVersion().getName());
        varParams.put("CURRENTDATATYPE", pojo.getCurDataType().getName());
        varParams.put("TARGETVERSION", pojo.getTargetVersion().getName());
        varParams.put("TARGETDATATYPE", pojo.getTargetDataType().getName());
        DynamicObject report = BusinessDataServiceHelper.loadSingleFromCache((Object)new VersionConstrastHelper().getProcessId(versionConsPlugin.getView()), (String)"eb_reportprocess", (String)"template.name");
        if (report != null) {
            varParams.put("REPORTNAME", report.getString("template.name"));
        }
        return varParams;
    }

    public static void appendGptResultStream(VersionConstrastPlugin versionConsPlugin, Object gptResult) {
        String requestId = GptCommonServerHelper.getTaskId((Object)gptResult);
        if (StringUtils.isEmpty((String)requestId)) {
            return;
        }
        Map<String, String> gptRequestMap = VersionConstractGptHelper.getGptRequestMap(versionConsPlugin);
        String processId = gptRequestMap.get(requestId);
        if (StringUtils.isEmpty((String)processId)) {
            log.info("versionconstrast-gpt-appendGptResultStream-processid-null");
            return;
        }
        VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion(processId);
        if (pojo == null) {
            log.info("versionconstrast-gpt-appendGptResultStream-pojo-null");
            return;
        }
        String result = null;
        String errMsg = GptCommonServerHelper.getErrorMsg((Object)gptResult);
        result = GptCommonServerHelper.hasErrorMsg((Object)gptResult) ? errMsg : GptCommonServerHelper.getLlmValue((Object)gptResult);
        pojo.appendGptResult(result);
        if (GptCommonServerHelper.isEnd((Object)gptResult)) {
            gptRequestMap.remove(requestId);
            VersionConstractGptHelper.cacheGptReuestMap(versionConsPlugin, gptRequestMap);
            CacheServiceHelper.remove((String)requestId);
            try {
                log.info("versionconstrast-gpt-appendGptResultStream-Base64: " + Base64.getEncoder().encodeToString(pojo.getGptResult().getBytes()));
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        versionConsPlugin.cacheVersionConstrast(pojo, processId);
        DynamicObject dyobj = BusinessDataServiceHelper.loadSingle((Object)pojo.getId(), (String)"bgm_versioncontrast");
        dyobj.set("gptresult", (Object)pojo.getGptResult());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyobj});
        if (processId.equals(String.valueOf(new VersionConstrastHelper().getProcessId(versionConsPlugin.getView())))) {
            VersionConstractGptHelper.loadGptResult(versionConsPlugin);
        }
        if (GptCommonServerHelper.isEnd((Object)gptResult) || GptCommonServerHelper.hasErrorMsg((Object)gptResult)) {
            VersionConstractGptHelper.oneGptByToken(versionConsPlugin, processId);
        }
    }

    private static void startGptResultStream(VersionConstrastPlugin versionConsPlugin, VersionConstrastPojo pojo, Object processId, Object obj) {
        log.info("versionconstrast-gpt-startGptResultStream:" + JSONUtils.toString((Object)obj));
        if (obj instanceof Map) {
            Map gptResult = (Map)obj;
            pojo.newLineGptResult();
            String errMsg = GptCommonServerHelper.getErrorMsg((Object)gptResult);
            if (GptCommonServerHelper.hasErrorMsg((Object)gptResult)) {
                pojo.appendGptResult(errMsg);
                versionConsPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{"gptagain"});
                versionConsPlugin.cacheVersionConstrast(pojo, processId);
                VersionConstractGptHelper.loadGptResult(versionConsPlugin);
                VersionConstractGptHelper.oneGptByToken(versionConsPlugin, processId);
            } else {
                String requestId = GptCommonServerHelper.getTaskId((Object)gptResult);
                String taskId = null;
                if (StringUtils.isNotEmpty((String)requestId)) {
                    Map<String, String> gptRequestMap = VersionConstractGptHelper.getGptRequestMap(versionConsPlugin);
                    gptRequestMap.put(requestId, String.valueOf(new VersionConstrastHelper().getProcessId(versionConsPlugin.getView())));
                    VersionConstractGptHelper.cacheGptReuestMap(versionConsPlugin, gptRequestMap);
                    CacheServiceHelper.put((String)requestId, (Object)versionConsPlugin.getView().getPageId());
                    taskId = GptCommonServerHelper.getTaskId((Object)gptResult);
                    pojo.setGptEnd(false);
                    pojo.setTaskProcessId(taskId);
                }
                if (StringUtils.isEmpty(taskId)) {
                    versionConsPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{"gptagain"});
                } else {
                    versionConsPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{"gptagain"});
                }
                versionConsPlugin.cacheVersionConstrast(pojo, processId);
                VersionConstractGptHelper.loadGptResult(versionConsPlugin);
                versionConsPlugin.getView().addClientCallBack("gptCallBack", Integer.valueOf(1000));
            }
        }
    }

    private static Map<String, String> getGptRequestMap(VersionConstrastPlugin versionConsPlugin) {
        String cache = versionConsPlugin.getPageCache().get("gptRequestMap");
        if (StringUtils.isNotEmpty((String)cache)) {
            return (Map)JSONUtils.parse((String)cache, Map.class);
        }
        return new HashMap<String, String>(16);
    }

    private static void cacheGptReuestMap(VersionConstrastPlugin versionConsPlugin, Map<String, String> gptRequestMap) {
        versionConsPlugin.getPageCache().put("gptRequestMap", JSONUtils.toString(gptRequestMap));
    }

    private static Map<String, LinkedList<String>> getGptTokens(VersionConstrastPlugin versionConsPlugin) {
        String cache = versionConsPlugin.getPageCache().get("gptTokens");
        if (StringUtils.isNotEmpty((String)cache)) {
            MapType javaType = JSONUtils.getMapper().getTypeFactory().constructMapType(HashMap.class, String.class, LinkedList.class);
            return (Map)JSONUtils.parse((String)cache, (JavaType)javaType);
        }
        return new HashMap<String, LinkedList<String>>(16);
    }

    private static void cacheGptTokens(VersionConstrastPlugin versionConsPlugin, Map<String, LinkedList<String>> gptTokens) {
        versionConsPlugin.getPageCache().put("gptTokens", JSONUtils.toString(gptTokens));
    }

    public static void loadGptResult(VersionConstrastPlugin versionConsPlugin) {
        VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion();
        if (pojo == null) {
            log.info("versionconstrast-gpt-loadGptResult-pojo-null");
            return;
        }
        log.debug("versionconstrast-gpt-loadGptResult: GptResult = " + (pojo == null ? "nullpojo" : pojo.getGptResult()));
        Markdown markdown = (Markdown)versionConsPlugin.getControl("markdowngptresult");
        if (pojo != null && pojo.getGptResult() != null) {
            versionConsPlugin.getModel().setValue("textgptreslut", (Object)VersionConstractGptHelper.convertToText(pojo.getGptResult()));
            Html html = (Html)versionConsPlugin.getControl("htmlgptresult");
            html.setConent(VersionConstractGptHelper.convertToHtml(pojo.getGptResult()));
            markdown.setText(pojo.getGptResult());
        } else {
            versionConsPlugin.getModel().setValue("textgptreslut", (Object)"");
            Html html = (Html)versionConsPlugin.getControl("htmlgptresult");
            html.setConent("");
            markdown.setText(" ");
        }
    }

    public static void setVisableGpt(VersionConstrastPlugin versionConsPlugin, boolean isStart) {
        boolean isshow = false;
        boolean hasGpt = false;
        if (isStart) {
            isshow = true;
            hasGpt = true;
        } else {
            isshow = new VersionConstrastHelper().isShowGptStats(versionConsPlugin);
            VersionConstrastPojo dto = versionConsPlugin.getConstrastVersion();
            if (dto != null && StringUtils.isNotEmpty((String)dto.getGptResult())) {
                hasGpt = true;
            } else {
                hasGpt = false;
                isshow = false;
            }
        }
        versionConsPlugin.getView().setVisible(Boolean.valueOf(isshow), new String[]{"gptdetail"});
        versionConsPlugin.getView().setVisible(Boolean.valueOf(isshow), new String[]{"gptbottom"});
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        if (isshow) {
            if (!VersionConstrastExportHelper.isExport(versionConsPlugin.getView())) {
                fieldMap.put("h", "299px");
            }
        } else {
            fieldMap.put("h", "40px");
        }
        versionConsPlugin.getView().updateControlMetadata("gptpanelap", fieldMap);
        versionConsPlugin.getView().updateView("gptdetail");
        versionConsPlugin.getView().updateView("gptbottom");
        versionConsPlugin.getView().updateView("gptpanelap");
        if (!hasGpt) {
            versionConsPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"vectoraphide"});
            versionConsPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"vectorapshowgpt"});
        } else {
            versionConsPlugin.getView().setVisible(Boolean.valueOf(isshow), new String[]{"vectoraphide"});
            versionConsPlugin.getView().setVisible(Boolean.valueOf(!isshow), new String[]{"vectorapshowgpt"});
        }
        versionConsPlugin.getView().setVisible(Boolean.valueOf(!hasGpt), new String[]{"btnstartgpt"});
    }

    public static void gptagain(VersionConstrastPlugin versionConsPlugin) {
        IFormView iFormView = versionConsPlugin.getView().getMainView();
        if (iFormView == null) {
            iFormView = versionConsPlugin.getView().getParentView();
        }
        if (iFormView == null) {
            log.info("versionconstrast-gpt-gptagain-iFormView-null");
            return;
        }
        VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion();
        if (pojo == null) {
            log.info("versionconstrast-gpt-gptagain-pojo-null");
            return;
        }
        String rootPageId = iFormView.getPageId();
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        gaiInitConfig.setSwitchSide(true);
        gaiInitConfig.setLockSide(true);
        gaiInitConfig.setStartProcessId("1970413283714519040");
        Map<String, String> varparams = VersionConstractGptHelper.buildGptParam(versionConsPlugin);
        if (varparams == null || varparams.isEmpty()) {
            return;
        }
        varparams.put("GPTRESULT", VersionConstractGptHelper.convertToText(pojo.getGptResult()));
        varparams.put("GPTRESULT_MARKDOWN", pojo.getGptResult());
        gaiInitConfig.setStartParams(varparams);
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSONUtils.toString((Object)gaiInitConfig)});
        new VersionConstrastHelper().setShowGptStats(versionConsPlugin, false);
        VersionConstractGptHelper.setVisableGpt(versionConsPlugin, false);
    }

    private static LinkedList<String> buildVcDataByToken(VersionConstrastPlugin versionConsPlugin, int propmtLength) {
        VersionConstrastParam param = versionConsPlugin.getParam();
        int maxloop = CommonUtils.getVersionContrastLoog();
        int maxtoken = CommonUtils.getVersionContrastMaxToken();
        LinkedList<String> result = new LinkedList<String>();
        if (param == null) {
            return result;
        }
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)param.getModelId());
        int maxCount = BgControlLogUtils.getVersionConstrastGptSize();
        List<VersionConstrastSimpleData> datas = new VersionConstrastHelper().queryVersionConstrastDatas(versionConsPlugin, versionConsPlugin.getVersionConstastDto(), modelcache, param, maxCount, 1, false, new VersionConstrastSimpleData());
        if (datas == null || datas.isEmpty()) {
            return result;
        }
        VersionConstrastCheckDto dto = versionConsPlugin.getVersionConstastDto();
        HashMap<Long, List<String[]>> memberMap = new HashMap<Long, List<String[]>>();
        VersionConstrastPojo pojo = versionConsPlugin.getConstrastVersion();
        new VersionConstrastHelper().buildDtoMember(dto, pojo, modelcache, new BuildMembers(memberMap));
        ArrayList<HashMap<String, Object>> results = new ArrayList<HashMap<String, Object>>(datas.size());
        String curvaluealias = ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u6570", (String)"VersionConstractGptHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String targetvaluealias = ResManager.loadKDString((String)"\u5bf9\u6bd4\u7248\u672c\u6570", (String)"VersionConstractGptHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        VersionConstrastHelper helper = new VersionConstrastHelper();
        int versionlength = VersionConstractGptHelper.calcToken(pojo.getCurVersion().getName()) + VersionConstractGptHelper.calcToken(pojo.getCurDataType().getName()) + VersionConstractGptHelper.calcToken(pojo.getTargetVersion().getName()) + VersionConstractGptHelper.calcToken(pojo.getTargetDataType().getName());
        int tokenlength = 0;
        int thistokenlength = 0;
        for (VersionConstrastSimpleData data : datas) {
            HashMap<String, Object> r = new HashMap<String, Object>(10);
            data.setUnit(DataUnitEnum.YUAN);
            if (!data.isDynamicrow()) {
                List members = (List)memberMap.get(data.getId());
                if (members != null) {
                    for (String[] member : members) {
                        VersionConstractGptHelper.addValue(r, member[0], member[1]);
                    }
                }
                VersionConstractGptHelper.addValue(r, curvaluealias, helper.formatValue(data, data.getCurValue(), false));
                VersionConstractGptHelper.addValue(r, targetvaluealias, helper.formatValue(data, data.getTargetValue(), false));
            }
            if (tokenlength + (thistokenlength = VersionConstractGptHelper.calcToken(JSONUtils.toString(r)) + 3) > maxtoken - propmtLength - versionlength) {
                result.add(JSONUtils.toString(results));
                tokenlength = thistokenlength;
                results.clear();
                if (result.size() >= maxloop) {
                    break;
                }
            } else {
                tokenlength += thistokenlength;
            }
            if (r.isEmpty()) continue;
            results.add(r);
        }
        if (result.size() < maxloop && !results.isEmpty()) {
            result.add(JSONUtils.toString(results));
        }
        return result;
    }

    private static void addValue(Map<String, Object> r, String alias, Object value) {
        if (r == null || StringUtils.isEmpty((String)alias) || StringUtils.isEmpty((String)StringUtils.toNoEmptyString((Object)value))) {
            return;
        }
        r.put(alias, value);
    }

    public static void removeRequest(VersionConstrastPlugin versionConsPlugin) {
        if (versionConsPlugin == null) {
            return;
        }
        String procesId = StringUtils.toNoEmptyString((Object)new VersionConstrastHelper().getProcessId(versionConsPlugin.getView()));
        if (StringUtils.isEmpty((String)procesId)) {
            return;
        }
        Map<String, String> gptRequestMap = VersionConstractGptHelper.getGptRequestMap(versionConsPlugin);
        String requestId = null;
        if (gptRequestMap != null) {
            for (Map.Entry<String, String> entry : gptRequestMap.entrySet()) {
                if (!procesId.equals(entry.getValue())) continue;
                requestId = entry.getKey();
                break;
            }
        }
        if (StringUtils.isNotEmpty(requestId) && gptRequestMap != null) {
            gptRequestMap.remove(requestId);
            VersionConstractGptHelper.cacheGptReuestMap(versionConsPlugin, gptRequestMap);
            CacheServiceHelper.remove(requestId);
        }
    }

    public static String convertToHtml(String gptResult) {
        HtmlRenderer render = HtmlRenderer.builder().build();
        return VersionConstractGptHelper.convert(gptResult, (Renderer)render, null);
    }

    public static String convertToText(String gptResult) {
        TextContentRenderer render = TextContentRenderer.builder().build();
        return VersionConstractGptHelper.convert(gptResult, (Renderer)render, null);
    }

    private static String convert(String gptResult, Renderer render, Appendable appendable) {
        if (StringUtils.isEmpty((String)gptResult)) {
            return gptResult;
        }
        Parser parser = Parser.builder().build();
        Node document = parser.parse(gptResult);
        if (appendable == null) {
            return render.render(document);
        }
        render.render(document, appendable);
        return appendable.toString();
    }

    public static boolean checkHasGpt() {
        try {
            DynamicObject prop = VersionConstractGptHelper.queryPrompt();
            return prop != null;
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }

    static class BuildMembers
    implements VersionConstrastHelper.IBuildMember {
        private Map<Long, List<String[]>> membersMap = null;

        public BuildMembers(@NotNull Map<Long, List<String[]>> membersMap) {
            this.membersMap = membersMap;
        }

        @Override
        public void build(VersionConstrastNode node, Map<Long, Long> memberMap, Map<String, String> memberNumberMap, VersionConstrastCheckDto dto, VersionConstrastPojo pojo, IModelCacheHelper modelCache) {
            if (dto.getShowDimensions() == null) {
                return;
            }
            ArrayList<String[]> members = new ArrayList<String[]>(dto.getShowDimensions().size());
            for (Long dimId : dto.getShowDimensions()) {
                if (!memberMap.containsKey(dimId)) continue;
                Dimension dim = modelCache.getDimension(dimId);
                members.add(new String[]{dim.getName(), new VersionConstrastHelper().getMember(dim.getNumber(), memberMap.get(dimId), (Map<String, List<Long>>)dto.getViewGroupViewsMap(), modelCache).getName()});
            }
            this.membersMap.put(node.getId(), members);
        }
    }
}

