/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versionconstrast;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.VersionConstrastConstants;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.versionconstrast.VersionConstrastData;
import kd.epm.eb.common.versionconstrast.VersionConstrastSimpleData;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.approveBill.ApproveBillEditPlugin;
import kd.epm.eb.formplugin.report.query.ReportQueryListPagePlugin;
import kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import kd.epm.eb.formplugin.versionconstrast.VersionConstractGptHelper;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import kd.epm.eb.spread.report.excel.util.FileUtil;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class VersionConstrastExportHelper
implements VersionConstrastConstants {
    private static final Log log = LogFactory.getLog(VersionConstrastExportHelper.class);
    private int batchSize = 100;
    public static final String EXCEL = "0";
    public static final String WORD = "1";
    public static final String PDF = "2";
    private String exportType = null;
    private boolean isBatch = false;
    private boolean isShowGpt = false;
    private String orgViewId = null;
    private List<String> showColumns = null;
    Map<String, String> metricDataTypes = null;
    private XSSFCellStyle textStyle = null;
    private XSSFCellStyle headerStyle = null;
    private XSSFCellStyle dateStyle = null;
    private Map<String, XSSFCellStyle> numberStyles = new HashMap<String, XSSFCellStyle>(16);

    public VersionConstrastExportHelper(@NotNull String exportType, boolean isBatch, boolean isShowGpt, Object orgViewId) {
        this.exportType = exportType;
        this.isBatch = isBatch;
        this.isShowGpt = isShowGpt;
        this.orgViewId = kd.epm.eb.common.utils.StringUtils.toNoEmptyString((Object)orgViewId);
    }

    private List<String> getShowColumns(kd.bos.form.plugin.AbstractFormPlugin formPlugin) {
        if (this.showColumns == null) {
            this.showColumns = new VersionConstrastHelper().getShowColumns(formPlugin);
        }
        return this.showColumns;
    }

    public Map<String, String> getMetricDataTypes(IModelCacheHelper cacheHelper) {
        if (this.metricDataTypes == null) {
            HashMap<String, Integer> decimalnums = new HashMap<String, Integer>(10);
            this.metricDataTypes = new HashMap<String, String>(10);
            new VersionConstrastHelper().queryDecimalnums(cacheHelper, this.metricDataTypes, decimalnums);
        }
        return this.metricDataTypes;
    }

    public String export(kd.bos.form.plugin.AbstractFormPlugin formPlugin, Long reportId) {
        if (IDUtils.isNull((Long)reportId)) {
            return null;
        }
        ArrayList<Long> reportIds = new ArrayList<Long>(1);
        reportIds.add(reportId);
        return this.export(formPlugin, reportIds);
    }

    public String export(kd.bos.form.plugin.AbstractFormPlugin formPlugin, List<Long> reportIds) {
        if (formPlugin == null || reportIds == null || reportIds.isEmpty() || kd.epm.eb.common.utils.StringUtils.isEmpty((String)this.exportType)) {
            return null;
        }
        ArrayList<Long> runIds = new ArrayList<Long>();
        LinkedList<Long> allReportIds = new LinkedList<Long>(reportIds);
        String filename = ResManager.loadKDString((String)"\u7248\u672c\u5dee\u5f02\u62a5\u544a\u5bfc\u51fa", (String)"VersionConstrastExportHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Object exportObj = null;
        ArrayList<String> errorDetail = new ArrayList<String>(16);
        while (!allReportIds.isEmpty()) {
            runIds.clear();
            while (!allReportIds.isEmpty() && runIds.size() < this.batchSize) {
                runIds.add(allReportIds.pop());
            }
            exportObj = this.innerExport((IFormPlugin)formPlugin, exportObj, runIds, errorDetail);
        }
        if (errorDetail != null && !errorDetail.isEmpty()) {
            String messgae = ResManager.loadResFormat((String)"%1\u5f20\u62a5\u8868\u6ca1\u6709\u7248\u672c\u5dee\u5f02\u62a5\u544a\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"VersionConstrastExportHelper_7", (String)"epm-eb-formplugin", (Object[])new Object[]{errorDetail.size()});
            CommonServiceHelper.showErrorInfoFormWithTitle((IFormView)formPlugin.getView(), errorDetail, (String)filename, (String)messgae, (boolean)true, (boolean)false);
        }
        if (exportObj != null && EXCEL.equals(this.exportType)) {
            XSSFWorkbook workBook = (XSSFWorkbook)exportObj;
            if (!this.isBatch && workBook.getSheetAt(0) != null) {
                filename = workBook.getSheetAt(0).getSheetName();
            }
            String url = null;
            try {
                url = ImportAndExportUtil.writeFile((Workbook)workBook, (String)filename);
            }
            catch (IOException ex) {
                log.error("writeFile", (Throwable)ex);
                CommonServiceHelper.dealExceptionNoShowForm((IFormView)formPlugin.getView(), (String)"writeFile", (Throwable)ex);
            }
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)formPlugin.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
            if (formPlugin instanceof AbstractFormPlugin) {
                ((AbstractFormPlugin)formPlugin).writeLog("export", new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "DimMemberMappingListPlugin_35", "epm-eb-formplugin"), null);
            }
        }
        return null;
    }

    private Object innerExport(@NotNull IFormPlugin formPlugin, Object exportObj, @NotNull List<Long> runIds, @NotNull List<String> errorDetail) {
        if (runIds.isEmpty()) {
            return exportObj;
        }
        QFilter filter = new QFilter("id", "in", runIds);
        DynamicObjectCollection dobjs = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template.number,template.id,template.name,entity.number,entity.name,template.dataset.id,model.id", (QFilter[])filter.toArray());
        if (dobjs == null || dobjs.isEmpty()) {
            return exportObj;
        }
        HashMap<Long, DynamicObject> reportMap = new HashMap<Long, DynamicObject>(runIds.size());
        for (Object obj : dobjs) {
            reportMap.put(obj.getLong("id"), (DynamicObject)obj);
        }
        filter = new QFilter("report.id", "in", runIds);
        dobjs = QueryServiceHelper.query((String)"bgm_versioncontrast", (String)"id,report.id,unit,curversion.name,curdatatype.name,targetversion.name,targetdatatype.name,gptresult,sorttype", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> vcmainMap = new HashMap<Long, DynamicObject>(runIds.size());
        if (dobjs != null) {
            for (DynamicObject obj : dobjs) {
                vcmainMap.put(obj.getLong("report.id"), obj);
            }
        }
        filter = new QFilter("verconstrast.report.id", "in", runIds);
        String fields = new VersionConstrastHelper().getReportFields();
        dobjs = QueryServiceHelper.query((String)"bgm_versioncontrastreport", (String)fields, (QFilter[])filter.toArray(), (String)"dynamicrow,verconstrast.id,rowseq");
        HashMap<Long, List<DynamicObject>> vcreprtMap = new HashMap<Long, List<DynamicObject>>(runIds.size());
        if (dobjs != null) {
            for (Object obj : dobjs) {
                vcreprtMap.computeIfAbsent(obj.getLong("verconstrast.report.id"), f -> new ArrayList(16)).add(obj);
            }
        }
        HashMap<Long, Map<Long, Long>> vcuserdefinedMap = new HashMap<Long, Map<Long, Long>>(16);
        dobjs = QueryServiceHelper.query((String)"bgm_versioncontrastreport", (String)"id,userdefined.fbasedata_id,userdefined.fbasedataid,userdefined.fbasedataid.dimension.id", (QFilter[])filter.toArray());
        if (dobjs != null) {
            for (DynamicObject obj : dobjs) {
                vcuserdefinedMap.computeIfAbsent(obj.getLong("id"), f -> new HashMap(10)).put(obj.getLong("userdefined.fbasedataid.dimension.id"), obj.getLong("userdefined.fbasedataid"));
            }
        }
        dobjs = null;
        HashMap<Long, Map<String, List<Long>>> templateViews = new HashMap<Long, Map<String, List<Long>>>(16);
        HashSet<Long> templateIds = new HashSet<Long>(10);
        for (DynamicObject report : reportMap.values()) {
            templateIds.add(report.getLong("template.id"));
        }
        if (!templateIds.isEmpty() && (dobjs = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,data,dataset.id,model.id", (QFilter[])(filter = new QFilter("id", "in", templateIds)).toArray())) != null) {
            for (DynamicObject template : dobjs) {
                String data = template.getString("data");
                IModelCacheHelper cachehelper = ModelCacheContext.getOrCreate((Long)template.getLong("model.id"));
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)data)) continue;
                ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)data);
                templateViews.put(template.getLong("id"), new VersionConstrastHelper().buildViewGroupViewsMap(templateModel, template.getLong("dataset.id"), cachehelper, this.orgViewId));
            }
        }
        HashSet<String> sheetNames = new HashSet<String>();
        for (Long reportId : runIds) {
            try {
                exportObj = this.innerOneExport(formPlugin, exportObj, reportId, reportMap, vcmainMap, vcreprtMap, vcuserdefinedMap, errorDetail, sheetNames, templateViews);
            }
            catch (Throwable ex) {
                log.error("innerOneExport-error:" + reportId, ex);
            }
        }
        return exportObj;
    }

    private Object innerOneExport(@NotNull IFormPlugin formPlugin, Object exportObj, Long reportId, @NotNull Map<Long, DynamicObject> reportMap, @NotNull Map<Long, DynamicObject> vcmainMap, @NotNull Map<Long, List<DynamicObject>> vcreprtMap, @NotNull Map<Long, Map<Long, Long>> vcuserdefinedMap, @NotNull List<String> errorDetail, @NotNull Set<String> sheetNames, Map<Long, Map<String, List<Long>>> templateViews) {
        DynamicObject report = reportMap.get(reportId);
        if (report == null) {
            log.info("innerOneExport-report-null:" + reportId);
            return exportObj;
        }
        List<DynamicObject> vcreports = vcreprtMap.get(reportId);
        DynamicObject vcmain = vcmainMap.get(reportId);
        if (vcmain == null || vcreports == null || vcreports.isEmpty()) {
            errorDetail.add(ResManager.loadResFormat((String)"%1\u3001%2\uff08%3\uff09\u7684%4\uff08%5\uff09\u62a5\u8868", (String)"VersionConstrastExportHelper_8", (String)"epm-eb-formplugin", (Object[])new Object[]{errorDetail.size() + 1, report.getString("entity.name"), report.getString("entity.number"), report.getString("template.name"), report.getString("template.number")}));
            return exportObj;
        }
        switch (this.exportType) {
            case "0": {
                return this.innerOneExportExcel(formPlugin, exportObj, report, vcmain, vcreports, vcuserdefinedMap, sheetNames, templateViews);
            }
        }
        return exportObj;
    }

    private XSSFCellStyle getTextStyle(@NotNull XSSFWorkbook workBook) {
        if (this.textStyle == null) {
            this.textStyle = workBook.createCellStyle();
            this.textStyle.setAlignment(HorizontalAlignment.LEFT);
            this.textStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            this.setBorder(this.textStyle);
            this.textStyle.setDataFormat(workBook.getCreationHelper().createDataFormat().getFormat("@"));
        }
        return this.textStyle;
    }

    private XSSFCellStyle getHeaderStyle(@NotNull XSSFWorkbook workBook) {
        if (this.headerStyle == null) {
            this.headerStyle = workBook.createCellStyle();
            this.headerStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFColor color = workBook.getCreationHelper().createExtendedColor();
            color.setARGBHex("#F2F2F2".substring(1));
            this.headerStyle.setFillForegroundColor(color);
            this.headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headerStyle.setDataFormat(workBook.getCreationHelper().createDataFormat().getFormat("@"));
            this.setBorder(this.headerStyle);
        }
        return this.headerStyle;
    }

    private XSSFCellStyle getDateStyle(@NotNull XSSFWorkbook workBook) {
        if (this.dateStyle == null) {
            this.dateStyle = workBook.createCellStyle();
            this.dateStyle.setAlignment(HorizontalAlignment.LEFT);
            this.dateStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            this.setBorder(this.dateStyle);
            this.dateStyle.setDataFormat(workBook.getCreationHelper().createDataFormat().getFormat("yyyy-MM-dd"));
        }
        return this.dateStyle;
    }

    private XSSFCellStyle getNumberStyles(@NotNull XSSFWorkbook workBook, String format) {
        XSSFCellStyle style;
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)format)) {
            log.info("getNumberStyles-format-null");
            format = "#,##0.00";
        }
        if ((style = this.numberStyles.get(format)) == null) {
            style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            this.setBorder(style);
            style.setDataFormat(workBook.getCreationHelper().createDataFormat().getFormat(format));
            this.numberStyles.put(format, style);
        }
        return style;
    }

    private void setBorder(@NotNull XSSFCellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    private Object innerOneExportExcel(@NotNull IFormPlugin formPlugin, Object exportObj, @NotNull DynamicObject report, @NotNull DynamicObject vcmain, @NotNull List<DynamicObject> vcreports, @NotNull Map<Long, Map<Long, Long>> vcuserdefinedMap, @NotNull Set<String> sheetNames, Map<Long, Map<String, List<Long>>> templateViews) {
        XSSFWorkbook workBook = (XSSFWorkbook)exportObj;
        if (workBook == null) {
            workBook = new XSSFWorkbook();
            exportObj = workBook;
        }
        XSSFCellStyle style = this.getTextStyle(workBook);
        XSSFCellStyle headerStyle = this.getHeaderStyle(workBook);
        XSSFCellStyle dateStyle = this.getDateStyle(workBook);
        String baseSheetName = ResManager.loadResFormat((String)"%1-%2-\u7248\u672c\u5dee\u5f02\u62a5\u544a", (String)"VersionConstrastExportHelper_2", (String)"epm-eb-formplugin", (Object[])new Object[]{report.getString("template.name"), report.getString("entity.name")});
        String sheetName = baseSheetName = FileUtil.filterSpecialCharacter((String)baseSheetName, (String)"-");
        int index = 1;
        while (sheetNames.contains(sheetName)) {
            String sheetidx = " (" + index + ")";
            sheetName = baseSheetName.substring(0, 30 - sheetidx.length()) + sheetidx;
        }
        XSSFSheet sheet = workBook.createSheet(sheetName);
        Long datasetId = report.getLong("template.dataset.id");
        IModelCacheHelper cachehelper = ModelCacheContext.getOrCreate((Long)report.getLong("model.id"));
        ArrayList dimensions = cachehelper.getDimensionList(datasetId);
        dimensions = new ArrayList(dimensions);
        Iterator it = dimensions.iterator();
        while (it.hasNext()) {
            Dimension d = (Dimension)it.next();
            if (!SysDimensionEnum.Version.getNumber().equals(d.getNumber()) && !SysDimensionEnum.DataType.getNumber().equals(d.getNumber())) continue;
            it.remove();
        }
        List<String> showColumns = this.getShowColumns((kd.bos.form.plugin.AbstractFormPlugin)formPlugin);
        int dimsize = dimensions.size();
        int startRowIndex = 2;
        int unitRow = 1;
        if (this.isShowGpt && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)vcmain.getString("gptresult"))) {
            startRowIndex = 3;
            unitRow = 2;
            XSSFRow gptrow = sheet.createRow(0);
            for (int c = 0; c <= dimsize + showColumns.size() - 2; ++c) {
                gptrow.createCell(c);
            }
            gptrow.getCell(0).setCellValue(VersionConstractGptHelper.convertToText(vcmain.getString("gptresult")));
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, dimsize + showColumns.size() - 2));
        }
        DataUnitEnum unit = DataUnitEnum.YUAN;
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)vcmain.getString("unit"))) {
            unit = DataUnitEnum.getEnumByIndex((int)Integer.parseInt(vcmain.getString("unit")));
        }
        sheet.createRow(unitRow).createCell(0).setCellValue(ResManager.loadResFormat((String)"\u5355\u4f4d\uff1a%1", (String)"VersionConstrastExportHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[]{DataUnitEnum.YUAN == unit ? "--" : unit.getName()}));
        showColumns.remove("member");
        XSSFRow head1 = sheet.createRow(startRowIndex);
        XSSFRow head2 = sheet.createRow(startRowIndex + 1);
        XSSFRow head3 = sheet.createRow(startRowIndex + 2);
        for (int r = startRowIndex; r <= startRowIndex + 2; ++r) {
            for (int c = 0; c <= dimsize + showColumns.size() - 1; ++c) {
                sheet.getRow(r).createCell(c).setCellStyle((CellStyle)headerStyle);
            }
        }
        sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex + 1, 0, dimensions.size() - 1));
        int index1 = showColumns.indexOf("curvalue");
        int index2 = showColumns.indexOf("curnote");
        if (index1 >= 0 && index2 >= 0) {
            sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex, dimensions.size() + index1, dimensions.size() + index2));
        }
        if (index1 >= 0 && index2 >= 0) {
            sheet.addMergedRegion(new CellRangeAddress(startRowIndex + 1, startRowIndex + 1, dimensions.size() + index1, dimensions.size() + index2));
        }
        index1 = showColumns.indexOf("targetvalue");
        index2 = showColumns.indexOf("targetnote");
        if (index1 >= 0 && index2 >= 0) {
            sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex, dimensions.size() + index1, dimensions.size() + index2));
        }
        if (index1 >= 0 && index2 >= 0) {
            sheet.addMergedRegion(new CellRangeAddress(startRowIndex + 1, startRowIndex + 1, dimensions.size() + index1, dimensions.size() + index2));
        }
        if ((index1 = showColumns.indexOf("diffvalue")) > 0) {
            sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex + 2, dimensions.size() + index1, dimensions.size() + index1));
        }
        if ((index1 = showColumns.indexOf("diffrate")) > 0) {
            sheet.addMergedRegion(new CellRangeAddress(startRowIndex, startRowIndex + 2, dimensions.size() + index1, dimensions.size() + index1));
        }
        head1.getCell(0).setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u4fe1\u606f", (String)"VersionConstrastExportHelper_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        for (int c = 0; c < showColumns.size(); ++c) {
            String column = showColumns.get(c);
            if ("curvalue".equals(column) || "curnote".equals(column)) {
                head1.getCell(dimsize + c).setCellValue(ResManager.loadResFormat((String)"\u5f53\u524d\uff1a%1", (String)"VersionConstrastExportHelper_5", (String)"epm-eb-formplugin", (Object[])new Object[]{vcmain.getString("curversion.name")}));
                head2.getCell(dimsize + c).setCellValue(vcmain.getString("curdatatype.name"));
                if ("curvalue".equals(column)) {
                    head3.getCell(dimsize + c).setCellValue(ResManager.loadKDString((String)"\u503c", (String)"VersionConstrastPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                head3.getCell(dimsize + c).setCellValue(ResManager.loadKDString((String)"\u6279\u6ce8", (String)"VersionConstrastPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("targetvalue".equals(column) || "targetnote".equals(column)) {
                head1.getCell(dimsize + c).setCellValue(vcmain.getString("targetversion.name"));
                head2.getCell(dimsize + c).setCellValue(vcmain.getString("targetdatatype.name"));
                if ("targetvalue".equals(column)) {
                    head3.getCell(dimsize + c).setCellValue(ResManager.loadKDString((String)"\u503c", (String)"VersionConstrastPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                head3.getCell(dimsize + c).setCellValue(ResManager.loadKDString((String)"\u6279\u6ce8", (String)"VersionConstrastPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("diffvalue".equals(column)) {
                head1.getCell(dimsize + c).setCellValue(ResManager.loadKDString((String)"\u5dee\u5f02", (String)"VersionConstrastPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"diffrate".equals(column)) continue;
            head1.getCell(dimsize + c).setCellValue(ResManager.loadKDString((String)"\u5dee\u5f02\u7387", (String)"VersionConstrastPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (int d = 0; d < dimensions.size(); ++d) {
            head3.getCell(d).setCellValue(((Dimension)dimensions.get(d)).getName());
        }
        VersionConstrastHelper helper = new VersionConstrastHelper();
        VersionConstrastData data = new VersionConstrastData();
        if (vcreports != null && WORD.equals(vcmain.getString("sorttype"))) {
            vcreports.sort((f1, f2) -> {
                if (f1.getBoolean("dynamicrow")) {
                    return -1;
                }
                if (f2.getBoolean("dynamicrow")) {
                    return 1;
                }
                return Integer.compare(f1.getInt("colseq"), f2.getInt("colseq"));
            });
        }
        int rowindex = startRowIndex + 3;
        for (DynamicObject vcreport : vcreports) {
            XSSFRow row = sheet.createRow(rowindex++);
            if (vcreport.getBoolean("dynamicrow")) {
                XSSFCellStyle floatstyle = style.copy();
                floatstyle.setAlignment(HorizontalAlignment.CENTER);
                for (int d = 0; d <= dimsize + showColumns.size() - 1; ++d) {
                    row.createCell(d).setCellStyle((CellStyle)floatstyle);
                }
                row.getCell(0).setCellValue(ResManager.loadKDString((String)"\u5dee\u5f02\u7684\u6d6e\u52a8\u884c", (String)"VersionConstrastHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                String tips = ResManager.loadResFormat((String)"%1%2\u6bd4%3%4\u591a%5\u884c\u5185\u5bb9\u3002", (String)"VersionConstrastHelper_4", (String)"epm-eb-formplugin", (Object[])new Object[]{vcmain.getString("targetversion.name"), vcmain.getString("targetdatatype.name"), vcmain.getString("curversion.name"), vcmain.getString("curdatatype.name"), vcreport.getString("diffvalue")});
                row.getCell(dimsize).setCellValue(tips);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, dimensions.size() - 1));
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), dimensions.size(), dimensions.size() + showColumns.size() - 1));
                continue;
            }
            for (int d = 0; d < dimsize; ++d) {
                Member m;
                Dimension dim = (Dimension)dimensions.get(d);
                row.createCell(d).setCellStyle((CellStyle)style);
                Long memberid = null;
                Map<Long, Long> userdefineds = vcuserdefinedMap.get(vcreport.getLong("id"));
                memberid = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim) ? (userdefineds == null ? null : userdefineds.get(dim.getId())) : Long.valueOf(vcreport.getLong(dim.getNumber().toLowerCase() + ".id"));
                if (!IDUtils.isNotNull((Long)memberid) || (m = new VersionConstrastHelper().getMember(dim.getNumber(), memberid, templateViews.get(report.getLong("template.id")), cachehelper)) == null) continue;
                row.getCell(d).setCellValue(m.getName());
            }
            data.build(vcreport);
            helper.setMetricDataType(cachehelper, this.getMetricDataTypes(cachehelper), (VersionConstrastSimpleData)data);
            boolean isNumber = MetricDataTypeEnum.isNumber((String)data.getMetricDataType().getIndex());
            boolean isDate = MetricDataTypeEnum.isDate((String)data.getMetricDataType().getIndex());
            for (int c = 0; c < showColumns.size(); ++c) {
                String column = showColumns.get(c);
                String value = vcreport.getString(showColumns.get(c).toLowerCase());
                if ("targetnote".equalsIgnoreCase(column) || "curnote".equalsIgnoreCase(column)) {
                    row.createCell(dimsize + c).setCellValue(this.checkExcelLength(value));
                    row.getCell(dimsize + c).setCellStyle((CellStyle)style);
                    continue;
                }
                if (isNumber) {
                    boolean isRate = "diffrate".equalsIgnoreCase(column);
                    row.createCell(dimsize + c).setCellStyle((CellStyle)this.getNumberStyles(workBook, helper.getNumberFormat((VersionConstrastSimpleData)data, isRate)));
                    try {
                        BigDecimal v = helper.getNumberValue((VersionConstrastSimpleData)data, value, isRate);
                        if (v == null) continue;
                        row.getCell(dimsize + c).setCellValue(v.doubleValue());
                    }
                    catch (Throwable ex) {
                        log.error(ex);
                        row.getCell(dimsize + c).setCellValue(value);
                    }
                    continue;
                }
                if (isDate) {
                    row.createCell(dimsize + c).setCellValue("diffvalue".equals(column) || "diffrate".equals(column) ? null : helper.getDateValue(value));
                    row.getCell(dimsize + c).setCellStyle((CellStyle)dateStyle);
                    continue;
                }
                row.createCell(dimsize + c).setCellValue("diffvalue".equals(column) || "diffrate".equals(column) ? null : this.checkExcelLength(value));
                row.getCell(dimsize + c).setCellStyle((CellStyle)style);
            }
        }
        return workBook;
    }

    private String checkExcelLength(String string) {
        if (string == null || string.length() < 32700) {
            return string;
        }
        return string.substring(0, 32700);
    }

    public void exportBatch(kd.bos.form.plugin.AbstractFormPlugin listPlugin, IDataModel dataModel) {
        ApproveBillEditPlugin editPlugin;
        IFormView tplReportView;
        ArrayList<Long> reportIds = new ArrayList<Long>();
        if (listPlugin instanceof ReportPreparationListPlugin) {
            EntryGrid control = (EntryGrid)listPlugin.getView().getControl("billlist_entity");
            int[] selectRows = control.getSelectRows();
            if (selectRows != null && selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    DynamicObject entryRowEntity = dataModel.getEntryRowEntity("billlist_entity", selectRow);
                    long reportProcessId = entryRowEntity.getLong("process.id");
                    if (IDUtils.isEmptyLong((Long)reportProcessId).booleanValue()) {
                        log.info("reportid-is-null");
                        continue;
                    }
                    reportIds.add(reportProcessId);
                }
            }
        } else if (listPlugin instanceof ReportQueryListPagePlugin) {
            ReportList reportList1 = (ReportList)listPlugin.getView().getControl("reportlistap");
            int[] selectedRows = reportList1.getEntryState().getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                for (int rowIndex : selectedRows) {
                    DynamicObject rowData = reportList1.getReportModel().getRowData(rowIndex);
                    if (rowData == null) {
                        log.error("rowdata-is-null");
                        continue;
                    }
                    Long repid = rowData.getLong("repid");
                    if (IDUtils.isNotNull((Long)repid)) {
                        reportIds.add(repid);
                        continue;
                    }
                    log.info("reportid-is-null");
                }
            }
        } else if (listPlugin instanceof BgTaskExecutePlugin) {
            EntryGrid entryGrid = (EntryGrid)listPlugin.getView().getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            if (rows != null && rows.length > 0) {
                for (int rowIndex : rows) {
                    DynamicObject entryRowEntity = dataModel.getEntryRowEntity("entryentity", rowIndex);
                    if (entryRowEntity == null) {
                        log.error("rowdata-is-null");
                        continue;
                    }
                    Long repid = entryRowEntity.getLong("reportprocess.id");
                    if (IDUtils.isNotNull((Long)repid)) {
                        reportIds.add(repid);
                        continue;
                    }
                    log.info("reportid-is-null");
                }
            }
        } else if (listPlugin instanceof ApproveBillEditPlugin && (tplReportView = (editPlugin = (ApproveBillEditPlugin)listPlugin).getTplReportView()) != null) {
            String reportField;
            String entityKey;
            String formId = tplReportView.getEntityId();
            if ("bgm_rptpreparation".equals(formId)) {
                entityKey = "billlist_entity";
                reportField = "process.id";
            } else {
                entityKey = "entryentity";
                reportField = "reportprocess.id";
            }
            EntryGrid control = (EntryGrid)tplReportView.getControl(entityKey);
            int[] selectRows = control.getSelectRows();
            if (selectRows != null && selectRows.length > 0) {
                for (int rowIndex : selectRows) {
                    DynamicObject entryRowEntity = tplReportView.getModel().getEntryRowEntity(entityKey, rowIndex);
                    Long reportId = entryRowEntity.getLong(reportField);
                    if (IDUtils.isNotNull((Long)reportId)) {
                        reportIds.add(reportId);
                        continue;
                    }
                    log.info("reportid-is-null");
                }
            }
        }
        if (reportIds.isEmpty()) {
            listPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u884c\u3002", (String)"VersionConstrastExportHelper_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.export(listPlugin, reportIds);
    }

    public static boolean isExport(IFormView view) {
        return view != null && view.getFormShowParameter() != null && view.getFormShowParameter().getCustomParam("exportflag") != null;
    }
}

