/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versionconstrast;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.VersionConstrastConstants;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.versionconstrast.VersionConstrastSimpleData;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastDetailParam;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import kd.epm.eb.olap.service.AlgoCalcUtils;

public class VersionConstrastViewDetailPlugin
extends AbstractFormPlugin
implements VersionConstrastConstants,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(VersionConstrastViewDetailPlugin.class);
    private static final int MAX_USERDEFINED = 12;
    private static final String USERDEFINED = "customize";
    private static final String USERDEFINED_COL = "col_";
    private static final int CURVALUE = 0;
    private static final int TARGERVALUE = 1;
    private static final int DIFFVALUE = 2;
    private VersionConstrastDetailParam param = null;

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"viewdiff", "viewall"});
        Container con = (Container)this.getControl("flexpaneldimension");
        if (con != null && con.getItems() != null) {
            for (Control ctrl : con.getItems()) {
                if (!(ctrl instanceof BasedataEdit)) continue;
                ((BasedataEdit)ctrl).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    private Map<String, String> getUserdefinedIndex() {
        String json = this.getPageCache().get("userdefinedindex");
        if (StringUtils.isEmpty((String)json)) {
            return new HashMap<String, String>(10);
        }
        return (Map)JSONUtils.parse((String)json, Map.class);
    }

    private void cacheUserdefinedIndex(Map<String, String> userdefinedIndex) {
        if (userdefinedIndex == null || userdefinedIndex.isEmpty()) {
            this.getPageCache().remove("userdefinedindex");
        } else {
            this.getPageCache().put("userdefinedindex", JSONUtils.toString(userdefinedIndex));
        }
    }

    public void afterCreateNewData(EventObject e) {
        VersionConstrastDetailParam param = this.getParam();
        if (param == null || param.isEmpty()) {
            return;
        }
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)param.getModelId());
        List dimensions = cacheHelper.getDimensionList(param.getDatasetid());
        int userIndex = 1;
        HashMap<String, String> userdefinIndex = new HashMap<String, String>();
        HashSet<String> displayFields = new HashSet<String>();
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        for (Object dim : dimensions) {
            String field = dim.getNumber().toLowerCase();
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim)) {
                field = USERDEFINED + userIndex++;
                userdefinIndex.put(dim.getNumber(), field);
                ((BasedataEdit)this.getControl(field)).setCaption(new LocaleString(dim.getName()));
                grid.setColumnProperty(USERDEFINED_COL + field, "header", (Object)dim.getName());
            }
            if (!param.getNoDetailMemberMap().containsKey(dim.getNumber())) continue;
            displayFields.add(field);
        }
        this.cacheUserdefinedIndex(userdefinIndex);
        Container con = (Container)this.getControl("flexpaneldimension");
        if (con != null && con.getItems() != null) {
            for (Control ctrl : con.getItems()) {
                if (displayFields.contains(ctrl.getKey())) continue;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ctrl.getKey()});
            }
        }
        String formatString = new VersionConstrastHelper().getNumberFormat((VersionConstrastSimpleData)param.getData(), MetricDataTypeEnum.RATE.getIndex().equals(param.getData().getMetricDataType().getIndex()));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"curvalue", "sc", param.getData().getPrecision()});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"targetvalue", "sc", param.getData().getPrecision()});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"diffvalue", "sc", param.getData().getPrecision()});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"curvalue", "df", formatString});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"targetvalue", "df", formatString});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"diffvalue", "df", formatString});
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", cacheHelper.getMember(SysDimensionEnum.Version.getNumber(), null, param.getCurVersion()).getName() + "\\r\\n" + cacheHelper.getMember(SysDimensionEnum.DataType.getNumber(), null, param.getCurDataType()).getName());
        data.put("type", "text");
        data.put("triggerType", "hover");
        data.put("showIcon", Boolean.TRUE);
        clientViewProxy.invokeControlMethod("entryentity", "setColProp", new Object[]{"curvalue", "tips", data});
        data = new HashMap();
        data.put("content", cacheHelper.getMember(SysDimensionEnum.Version.getNumber(), null, param.getTargetVersion()).getName() + "\\r\\n" + cacheHelper.getMember(SysDimensionEnum.DataType.getNumber(), null, param.getTargetDataType()).getName());
        data.put("type", "text");
        data.put("triggerType", "hover");
        data.put("showIcon", Boolean.TRUE);
        clientViewProxy.invokeControlMethod("entryentity", "setColProp", new Object[]{"targetvalue", "tips", data});
        this.getView().updateView("entryentity");
        this.setViewTypeState();
        this.queryDetailData();
    }

    private void setViewTypeState() {
        boolean isViewAll = this.isViewAll();
        this.getView().setVisible(Boolean.valueOf(isViewAll), new String[]{"viewdiff"});
        this.getView().setVisible(Boolean.valueOf(!isViewAll), new String[]{"viewall"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "viewdiff": {
                this.setViewAll(false);
                this.setViewTypeState();
                this.queryDetailData();
                break;
            }
            case "viewall": {
                this.setViewAll(true);
                this.setViewTypeState();
                this.queryDetailData();
                break;
            }
        }
    }

    private boolean isViewAll() {
        return Convert.toBool((Object)this.getPageCache().get("viewtype"), (Boolean)false);
    }

    private void setViewAll(boolean isViewAll) {
        this.getPageCache().put("viewtype", String.valueOf(isViewAll));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String oldValue;
        super.propertyChanged(e);
        if (e == null || e.getProperty() == null || e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        String newValue = StringUtils.toNoEmptyString((Object)e.getChangeSet()[0].getNewValue());
        if (newValue.equals(oldValue = StringUtils.toNoEmptyString((Object)e.getChangeSet()[0].getOldValue()))) {
            return;
        }
        this.queryDetailData();
    }

    private void queryDetailData() {
        try {
            VersionConstrastDetailParam param = this.getParam();
            if (param == null || param.isEmpty()) {
                return;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)param.getModelId());
            String cubeNumber = AlgoCalcUtils.getCubeNumber((Long)param.getDatasetid());
            HashMap<String, Set> memberInfo = new HashMap<String, Set>(16);
            ArrayList<String> selectDims = new ArrayList<String>();
            param.getDetailMemberMap().entrySet().forEach(f -> memberInfo.computeIfAbsent((String)f.getKey(), s -> new HashSet()).add(f.getValue()));
            Map<String, String> userDefinedIndex = this.getUserdefinedIndex();
            for (Map.Entry<String, Set<String>> entry : param.getNoDetailMemberMap().entrySet()) {
                Object f7value;
                Dimension dim = modelCache.getDimension(entry.getKey());
                String field = dim.getNumber().toLowerCase();
                if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim)) {
                    if (!userDefinedIndex.containsKey(dim.getNumber())) {
                        log.info("queryDetailData-no-userDefinedIndex dimNumber = " + dim.getNumber() + " userDefinedIndex : " + JSONUtils.toString(userDefinedIndex));
                        return;
                    }
                    field = userDefinedIndex.get(dim.getNumber());
                }
                if ((f7value = this.getModel().getValue(field)) instanceof DynamicObjectCollection) {
                    DynamicObjectCollection col = (DynamicObjectCollection)f7value;
                    if (col.isEmpty()) {
                        memberInfo.put(entry.getKey(), entry.getValue());
                        selectDims.add(entry.getKey());
                        continue;
                    }
                    for (DynamicObject obj : col) {
                        memberInfo.computeIfAbsent(entry.getKey(), f -> new HashSet(10)).add(obj.getDynamicObject("fbasedataid").getString("number"));
                    }
                    if (col.size() <= 1) continue;
                    selectDims.add(entry.getKey());
                    continue;
                }
                if (f7value instanceof DynamicObject) {
                    memberInfo.computeIfAbsent(entry.getKey(), f -> new HashSet(10)).add(((DynamicObject)f7value).getString("number"));
                    continue;
                }
                memberInfo.put(entry.getKey(), entry.getValue());
                selectDims.add(entry.getKey());
            }
            EntryGrid table = (EntryGrid)this.getControl("entryentity");
            int totalCols = table.getItems().size();
            for (int c = 0; c < totalCols; ++c) {
                String field;
                Control control = (Control)table.getItems().get(c);
                if (!(control instanceof FieldEdit) || !(field = control.getKey()).substring(0, USERDEFINED_COL.length()).equals(USERDEFINED_COL)) continue;
                table.setColumnProperty(field, "vi", (Object)false);
            }
            for (String dimNumber : selectDims) {
                Dimension dim = modelCache.getDimension(dimNumber);
                if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim)) {
                    if (!userDefinedIndex.containsKey(dim.getNumber())) continue;
                    table.setColumnProperty(USERDEFINED_COL + userDefinedIndex.get(dimNumber), "vi", (Object)true);
                    continue;
                }
                table.setColumnProperty(USERDEFINED_COL + dimNumber.toLowerCase(), "vi", (Object)true);
            }
            selectDims.add(SysDimensionEnum.Version.getNumber());
            selectDims.add(SysDimensionEnum.DataType.getNumber());
            memberInfo.computeIfAbsent(SysDimensionEnum.Version.getNumber(), f -> new HashSet(2)).add(param.getCurVersion());
            memberInfo.computeIfAbsent(SysDimensionEnum.Version.getNumber(), f -> new HashSet(2)).add(param.getTargetVersion());
            memberInfo.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), f -> new HashSet(2)).add(param.getCurDataType());
            memberInfo.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), f -> new HashSet(2)).add(param.getTargetDataType());
            HashMap<String, Pair> dataMap = new HashMap<String, Pair>(160);
            HashMap<String, String[]> memberNames = new HashMap<String, String[]>(16);
            StringBuilder memberKey = new StringBuilder();
            BgmdOlapReader reader = BgmdShrekDao.getInstance().read(modelCache.getModelobj(), cubeNumber, memberInfo, selectDims, null);
            Object object = null;
            try {
                while (reader.hasNext()) {
                    Object[] datas = reader.next();
                    BGCell cell = BGCells.of((Object[])datas, selectDims);
                    boolean isCurValue = true;
                    boolean isTargetValue = true;
                    String number = (String)cell.getMemberMap().get(SysDimensionEnum.Version.getNumber());
                    if (!number.equals(param.getCurVersion())) {
                        isCurValue = false;
                    } else if (!number.equals(param.getTargetVersion())) {
                        isTargetValue = false;
                    }
                    number = (String)cell.getMemberMap().get(SysDimensionEnum.DataType.getNumber());
                    if (!number.equals(param.getCurDataType())) {
                        isCurValue = false;
                    } else if (!number.equals(param.getTargetDataType())) {
                        isTargetValue = false;
                    }
                    if (!isCurValue && !isTargetValue) continue;
                    memberNames.clear();
                    memberKey.setLength(0);
                    for (int d = 0; d < selectDims.size(); ++d) {
                        String dimNumber = (String)selectDims.get(d);
                        if (SysDimensionEnum.DataType.getNumber().equals(dimNumber) || SysDimensionEnum.Version.getNumber().equals(dimNumber) || StringUtils.isEmpty((String)(number = (String)cell.getMemberMap().get(dimNumber)))) continue;
                        memberNames.put(dimNumber, new String[]{new VersionConstrastHelper().getMember(dimNumber, number, param.getViewGroupViewsMap(), modelCache).getName(), number});
                        if (memberKey.length() > 0) {
                            memberKey.append(",");
                        }
                        memberKey.append(dimNumber).append("!").append(number);
                    }
                    Pair data = (Pair)dataMap.get(memberKey.toString());
                    if (data == null) {
                        data = Pair.onePair((Object)new BigDecimal[3], new HashMap(memberNames));
                        dataMap.put(memberKey.toString(), data);
                    }
                    ((BigDecimal[])data.p1)[isCurValue ? 0 : 1] = new VersionConstrastHelper().getNumberValue((VersionConstrastSimpleData)param.getData(), String.valueOf(datas[0]), MetricDataTypeEnum.RATE.getIndex().equals(param.getData().getMetricDataType().getIndex()));
                }
            }
            catch (Throwable datas) {
                object = datas;
                throw datas;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable datas) {
                            ((Throwable)object).addSuppressed(datas);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            ArrayList dataList = new ArrayList(dataMap.values());
            dataMap = null;
            boolean isViewAll = this.isViewAll();
            Iterator it = dataList.iterator();
            while (it.hasNext()) {
                Pair data = (Pair)it.next();
                BigDecimal curValue = ((BigDecimal[])data.p1)[0];
                BigDecimal targetValue = ((BigDecimal[])data.p1)[1];
                BigDecimal diffValue = null;
                if (curValue != null || targetValue != null) {
                    diffValue = curValue == null ? targetValue.negate() : (targetValue == null ? curValue : curValue.subtract(targetValue));
                }
                ((BigDecimal[])data.p1)[2] = diffValue;
                if (isViewAll || diffValue != null && BigDecimal.ZERO.compareTo(diffValue) != 0) continue;
                it.remove();
            }
            dataList.sort(new DataCompartor(selectDims));
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity");
            if (!dataList.isEmpty()) {
                this.getModel().batchCreateNewEntryRow("entryentity", dataList.size());
                int index = 0;
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
                for (Pair data : dataList) {
                    DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index++);
                    row.set("curvalue", (Object)((BigDecimal[])data.p1)[0]);
                    row.set("targetvalue", (Object)((BigDecimal[])data.p1)[1]);
                    row.set("diffvalue", (Object)((BigDecimal[])data.p1)[2]);
                    if (((BigDecimal[])data.p1)[2] != null && BigDecimal.ZERO.compareTo(((BigDecimal[])data.p1)[2]) != 0) {
                        CellStyle style = new CellStyle();
                        style.setRow(index - 1);
                        style.setFieldKey("curvalue");
                        style.setForeColor("#FF0000");
                        cellStyles.add(style);
                        style = new CellStyle();
                        style.setRow(index - 1);
                        style.setFieldKey("targetvalue");
                        style.setForeColor("#FF0000");
                        cellStyles.add(style);
                        style = new CellStyle();
                        style.setRow(index - 1);
                        style.setFieldKey("diffvalue");
                        style.setForeColor("#FF0000");
                        cellStyles.add(style);
                    }
                    for (Map.Entry entry : ((Map)data.p2).entrySet()) {
                        Dimension dim = modelCache.getDimension((String)entry.getKey());
                        String field = dim.getNumber().toLowerCase();
                        if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim)) {
                            field = userDefinedIndex.get(dim.getNumber());
                        }
                        if (field == null) continue;
                        row.set(USERDEFINED_COL + field, (Object)((String[])entry.getValue())[0]);
                    }
                }
                table.setCellStyle(cellStyles);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        catch (Throwable e) {
            log.error(e);
            CommonServiceHelper.dealExceptionNoShowForm((IFormView)this.getView(), (String)"queryDetail", (Throwable)e);
        }
    }

    private VersionConstrastDetailParam getParam() {
        String jsonstr;
        if (this.param == null && StringUtils.isNotEmpty((String)(jsonstr = (String)this.getView().getFormShowParameter().getCustomParam("viewdetailparam")))) {
            this.param = (VersionConstrastDetailParam)JSONUtils.parse((String)jsonstr, VersionConstrastDetailParam.class);
        }
        return this.param;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent == null) {
            return;
        }
        if (beforeF7SelectEvent.getProperty() == null) {
            log.info("beforeF7Select-getProperty-null");
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        VersionConstrastDetailParam param = this.getParam();
        if (param == null || param.isEmpty()) {
            log.info("beforeF7Select-param-null");
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String key = beforeF7SelectEvent.getProperty().getName();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)param.getModelId());
        List dimensions = modelCache.getDimensionList();
        if (dimensions == null || dimensions.isEmpty()) {
            log.info("beforeF7Select-dimensions-null");
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        Dimension dim = null;
        Map<String, String> userdefinedIndex = this.getUserdefinedIndex();
        if (userdefinedIndex != null) {
            for (Map.Entry entry : userdefinedIndex.entrySet()) {
                if (!key.equals(entry.getValue())) continue;
                key = (String)entry.getKey();
            }
        }
        for (Dimension dimension : dimensions) {
            if (!dimension.getNumber().equalsIgnoreCase(key)) continue;
            dim = dimension;
            break;
        }
        if (dim == null) {
            log.info("beforeF7Select-dim-null:" + key);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)param.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)param.getModelId(), (String)dim.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(param.getBussModelId());
        f7Param.setViewId(modelCache.getViewByDataSetAndDimNumber(param.getDatasetid(), dim.getNumber()));
        if (param.getViewGroupViewsMap() != null && param.getViewGroupViewsMap().get(dim.getNumber()) != null && param.getNoDetailMemberMap().get(dim.getNumber()) != null) {
            Set<String> set = param.getNoDetailMemberMap().get(dim.getNumber());
            block2: for (String number : set) {
                for (Long viewId : param.getViewGroupViewsMap().get(dim.getNumber())) {
                    if (dim.getMember(viewId, number) == null) continue;
                    f7Param.setViewId(viewId);
                    break block2;
                }
            }
        }
        f7Param.setDatasetId(param.getDatasetid());
        f7Param.setShowDisable(true);
        f7Param.setOnlySelLeaf(true);
        f7Param.setMultiSelect(true);
        f7Param.setMustSelected(false);
        Set<String> set = param.getNoDetailMemberMap().get(dim.getNumber());
        QFilter filter = null;
        filter = set != null && !set.isEmpty() ? new QFilter("number", "in", set) : new QFilter("id", "=", (Object)0L);
        f7Param.setCustomFilters(filter.toSerializedString());
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    static class DataCompartor
    implements Comparator<Pair<BigDecimal[], Map<String, String[]>>> {
        List<String> selectDim = null;

        public DataCompartor(List<String> selectDim) {
            this.selectDim = selectDim;
        }

        @Override
        public int compare(Pair<BigDecimal[], Map<String, String[]>> param1, Pair<BigDecimal[], Map<String, String[]>> param2) {
            int r = 0;
            for (String dimNumber : this.selectDim) {
                r = this.compare(((String[])((Map)param1.p2).get(dimNumber))[1], ((String[])((Map)param2.p2).get(dimNumber))[1]);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }

        @Override
        private int compare(String str1, String str2) {
            if (str1 == null && str2 == null) {
                return 0;
            }
            if (str1 == null) {
                return -1;
            }
            if (str2 == null) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }
}

