/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.versioncopy.VersionCopySchemeExecuteEntity;
import org.apache.commons.collections4.CollectionUtils;

public class VersionCopyApiUtils {
    public static final List<String> CHECK_LOCK_DIM = Arrays.asList(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.Entity.getNumber());

    public static Map<Long, Map<String, Set<Member>>> getDatasetDimAndMem(IModelCacheHelper modelCache, VersionCopySchemeExecuteEntity versionCopyEntity, boolean isSrcVision, boolean isValidation, Set<Member> validationEntity) {
        HashMap<Long, Map<String, Set<Member>>> map = new HashMap<Long, Map<String, Set<Member>>>(16);
        if (CollectionUtils.isEmpty(versionCopyEntity.getDateSetList())) {
            return map;
        }
        for (Dataset dataset : versionCopyEntity.getDateSetList()) {
            List dimensionList = modelCache.getDimensionList(dataset.getId());
            HashMap<String, Set<Member>> dimMap = new HashMap<String, Set<Member>>();
            for (Dimension dimension : dimensionList) {
                String dimNumber = dimension.getNumber();
                if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
                    HashSet<Member> versions = new HashSet<Member>(16);
                    if (isSrcVision) {
                        versions.add(modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, versionCopyEntity.getVersion_1()));
                    } else {
                        versions.add(modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, versionCopyEntity.getVersion_2()));
                    }
                    dimMap.put(dimension.getNumber(), versions);
                    continue;
                }
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                    Member member;
                    HashSet<Member> trialList = new HashSet<Member>(16);
                    if (isSrcVision) {
                        for (String s : versionCopyEntity.getTrial_1()) {
                            member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, s);
                            if (member == null) continue;
                            trialList.add(member);
                        }
                        dimMap.put(dimension.getNumber(), trialList);
                    } else {
                        for (String s : versionCopyEntity.getTrial_2()) {
                            member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, s);
                            if (member == null) continue;
                            trialList.add(member);
                        }
                    }
                    List members = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, SysDimensionEnum.AuditTrail.getNumber(), RangeEnum.ALL.getIndex());
                    if (CollectionUtils.isNotEmpty(trialList) && trialList.containsAll(members)) {
                        dimMap.put(dimension.getNumber(), null);
                        continue;
                    }
                    dimMap.put(dimension.getNumber(), trialList);
                    continue;
                }
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    VersionCopyApiUtils.resolveComditionMember(modelCache, versionCopyEntity, dimMap, dimension, dimNumber, dataset);
                    continue;
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                    if (isValidation) {
                        dimMap.put(dimNumber, validationEntity);
                        continue;
                    }
                    VersionCopyApiUtils.resolveComditionMember(modelCache, versionCopyEntity, dimMap, dimension, dimNumber, dataset);
                    continue;
                }
                VersionCopyApiUtils.resolveComditionMember(modelCache, versionCopyEntity, dimMap, dimension, dimNumber, dataset);
            }
            map.put(dataset.getId(), dimMap);
        }
        return map;
    }

    public static void resolveComditionMember(IModelCacheHelper modelCache, VersionCopySchemeExecuteEntity versionCopyEntity, Map<String, Set<Member>> dimMap, Dimension dimension, String dimNumber, Dataset dataset) {
        Optional<VersionCopyConditionDto> first = versionCopyEntity.getVersionCopyConditionDtoList().stream().filter(x -> x.getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            VersionCopyConditionDto versionCopyConditionDto = first.get();
            Long viewId = versionCopyConditionDto.getViewId();
            HashSet list = new HashSet(16);
            List dataSetAccount = new ArrayList(16);
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                dataSetAccount = dimension.getAllMembersByDataSetId(dataset.getId());
            }
            for (MemberCondition condition : versionCopyConditionDto.getConditions()) {
                List member = modelCache.getMember(dimNumber, viewId, condition.getNumber(), Integer.parseInt(condition.getRange()));
                if (!CollectionUtils.isNotEmpty((Collection)member)) continue;
                list.addAll(member);
            }
            if (CollectionUtils.isNotEmpty(dataSetAccount)) {
                list.retainAll(dataSetAccount);
            }
            dimMap.put(dimension.getNumber(), list);
        } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            List viewGroupViewsByDataSetAndDimNumber = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), dimNumber);
            HashSet allMembers = new HashSet(16);
            if (CollectionUtils.isNotEmpty((Collection)viewGroupViewsByDataSetAndDimNumber)) {
                for (Long aLong : viewGroupViewsByDataSetAndDimNumber) {
                    allMembers.addAll(modelCache.getMembers(aLong, dimNumber));
                }
                dimMap.put(dimension.getNumber(), allMembers);
            }
        } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            List allMembers = dimension.getAllMembersByDataSetId(dataset.getId());
            dimMap.put(dimension.getNumber(), Sets.newHashSet((Iterable)allMembers));
        }
    }
}

