/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.business.userremember.service.UserRememberService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class VersionCopyMsgListPlugin
extends AbstractFormPlugin
implements CommonMethod {
    private static final Log log = LogFactory.getLog(VersionCopyMsgListPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String USER_PAGE_REMEMBER = "userPageRowRemember";

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] ids;
        UserRememberEntity userRemember;
        Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
        EntryGrid billList = (EntryGrid)this.getControl(ENTRYENTITY);
        if (billList != null && (userRemember = UserRememberService.getInstance().getUserRemember(USER_PAGE_REMEMBER, this.getKeyGroup())) != null) {
            String pageRow = userRemember.getValue();
            try {
                billList.setPageRow(Integer.parseInt(pageRow));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((ids = BusinessDataServiceHelper.load((String)"eb_copyrecord_entity", (String)"bizmodel,model,dataset,entity,account,dimmemberjson,failmsg", (QFilter[])new QFilter[]{new QFilter("recordid", "=", (Object)IDUtils.toLong((Object)pkid))}, (String)" createdate desc")) != null && ids.length > 0) {
            this.handleEntry(ids);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        EntryGrid billList = (EntryGrid)this.getControl(ENTRYENTITY);
        if (billList != null) {
            int pageRow = billList.getPageRow();
            UserRememberService.getInstance().saveRemember(USER_PAGE_REMEMBER, (Object)pageRow, this.getKeyGroup());
        }
        super.beforeClosed(e);
    }

    public String getKeyGroup() {
        ApplicationTypeEnum app = ModelUtil.queryApp((IFormView)this.getView());
        String formId = this.getView().getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum((IFormView)this.getView()) : app.getIndex();
        return appIndex + '`' + formId + "`" + this.getModelId();
    }

    private void handleEntry(DynamicObject[] dynamicObjects) {
        List temp;
        String dimmemberjson1;
        DynamicObject dynamicObject = dynamicObjects[0];
        DynamicObject model = dynamicObject.getDynamicObject("model");
        DynamicObject bizmodel = dynamicObject.getDynamicObject("bizmodel");
        if (model == null) {
            log.info("model is null");
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
        if (modelCacheHelper == null) {
            log.info("modelCacheHelper is null");
            return;
        }
        List dimensionList = new ArrayList(16);
        dimensionList = this.isNewEbForm() ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionListByBusModel(Long.valueOf(bizmodel.getLong("id")));
        if (CollectionUtils.isEmpty(dimensionList)) {
            log.info(" dimensionList is null");
        }
        List epm_userdefinedmembertree = dimensionList.stream().filter(x -> x.getMemberModel().equals("epm_userdefinedmembertree")).collect(Collectors.toList());
        HashMap<String, String> fieldKeys = new HashMap<String, String>(16);
        if (CollectionUtils.isNotEmpty(epm_userdefinedmembertree)) {
            int seq = 1;
            for (Dimension dim : epm_userdefinedmembertree) {
                log.info("add textEdit:{}", (Object)("dim" + seq));
                TextEdit textEdit = (TextEdit)this.getControl("dim" + seq++);
                textEdit.setCaption(new LocaleString(dim.getName()));
                textEdit.setVisible(null, true);
                fieldKeys.put(dim.getNumber(), textEdit.getKey());
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        String dimmemberjson = dynamicObject.getString("dimmemberjson");
        List dimmemberjsonList = new ArrayList(16);
        if (StringUtils.isNotEmpty((String)dimmemberjson)) {
            dimmemberjsonList = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class);
        }
        if (StringUtils.isNotEmpty((String)(dimmemberjson1 = (String)this.getView().getFormShowParameter().getCustomParam("dimmemberjson"))) && CollectionUtils.isNotEmpty((Collection)(temp = SerializationUtils.fromJsonStringToList((String)dimmemberjson1, VersionCopyConditionDto.class)))) {
            if (CollectionUtils.isNotEmpty(dimmemberjsonList)) {
                dimmemberjsonList.addAll(temp.stream().filter(x -> !x.getDimNumber().equals(SysDimensionEnum.Entity.getNumber()) && !x.getDimNumber().equals(SysDimensionEnum.DataType.getNumber()) && !x.getDimNumber().equals(SysDimensionEnum.Metric.getNumber())).collect(Collectors.toList()));
            } else {
                dimmemberjsonList.addAll(temp.stream().filter(x -> !x.getDimNumber().equals(SysDimensionEnum.Entity.getNumber()) && !x.getDimNumber().equals(SysDimensionEnum.DataType.getNumber())).collect(Collectors.toList()));
            }
        }
        HashMap<String, String> commonDimInfoMap = new HashMap<String, String>(16);
        ArrayList<String> name = new ArrayList<String>(16);
        for (Dimension dimension : dimensionList) {
            name.clear();
            if (dimension.getNumber().equals(SysDimensionEnum.Entity.getNumber()) || dimension.getNumber().equals(SysDimensionEnum.Account.getNumber())) continue;
            if (CollectionUtils.isNotEmpty(dimmemberjsonList)) {
                VersionCopyConditionDto versionCopyConditionDto;
                List conditions;
                Optional<VersionCopyConditionDto> first = dimmemberjsonList.stream().filter(x -> x.getDimNumber().equals(dimension.getNumber())).findFirst();
                if (first.isPresent() && CollectionUtils.isNotEmpty((Collection)(conditions = (versionCopyConditionDto = first.get()).getConditions()))) {
                    for (MemberCondition condition : conditions) {
                        RangeEnum rangeByVal = RangeEnum.getRangeByVal((String)condition.getRange());
                        if (rangeByVal != null) {
                            name.add(condition.getNumber() + " " + condition.getName() + rangeByVal.getName());
                            continue;
                        }
                        name.add(condition.getNumber() + " " + condition.getName());
                    }
                }
                if (CollectionUtils.isNotEmpty(name)) {
                    commonDimInfoMap.put(dimension.getNumber(), String.join((CharSequence)";", name));
                    continue;
                }
                commonDimInfoMap.put(dimension.getNumber(), dimension.getNumber() + " " + dimension.getName() + RangeEnum.ALL.getName());
                continue;
            }
            commonDimInfoMap.put(dimension.getNumber(), dimension.getNumber() + " " + dimension.getName() + RangeEnum.ALL.getName());
        }
        this.getModel().beginInit();
        for (DynamicObject object : dynamicObjects) {
            String entity = object.getString("entity");
            String account = object.getString("account");
            vs.set("entity", (Object)entity, index);
            vs.set("account", (Object)account, index);
            vs.set("period", commonDimInfoMap.get(SysDimensionEnum.BudgetPeriod.getNumber()), index);
            vs.set("curency", commonDimInfoMap.get(SysDimensionEnum.Currency.getNumber()), index);
            vs.set("datatype", commonDimInfoMap.get(SysDimensionEnum.DataType.getNumber()), index);
            vs.set("changetype", commonDimInfoMap.get(SysDimensionEnum.ChangeType.getNumber()), index);
            vs.set("metric", commonDimInfoMap.get(SysDimensionEnum.Metric.getNumber()), index);
            vs.set("incompany", commonDimInfoMap.get(SysDimensionEnum.InternalCompany.getNumber()), index);
            if (CollectionUtils.isNotEmpty(fieldKeys)) {
                for (Map.Entry entry : fieldKeys.entrySet()) {
                    vs.set((String)entry.getValue(), commonDimInfoMap.get(entry.getKey()), index);
                }
            }
            vs.set("msg", (Object)object.getString("failmsg"), index);
            ++index;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRYENTITY, vs);
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }
}

