/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.CopyDataEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SchemeTypeEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class VersionCopyRecordListPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CreateListColumnsListener,
CreateListDataProviderListener {
    private static final String TOOLBARAP = "toolbarap";
    private static final String MODEL = "model";
    private static final String BILLLIST = "billlistap";
    private static final String REFRESH = "refresh";
    private static final String CANCEL = "cancel";

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addRegisterListener();
    }

    private void addRegisterListener() {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(MODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addPackageDataListener(this::packageData);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter qFilter1 = VersionCopyRecordListPlugin.this.getqFilter();
                setFilterEvent.getQFilters().add(qFilter1);
            }
        });
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void packageData(PackageDataEvent packageDataEvent) {
        DynamicObject rowData = packageDataEvent.getRowData();
        String status = rowData.getString("status");
        if (!CopyDataEnum.FAILED.getIndex().equals(status)) {
            packageDataEvent.getNoLinkKey().add("msg");
        }
    }

    protected QFilter getqFilter() {
        Long modelIdLong = -1L;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(MODEL))) {
            modelIdLong = this.getModelId();
        }
        return new QFilter(MODEL, "=", (Object)modelIdLong);
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(MODEL));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView().getParentView());
        }
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
            this.updateStatus();
            this.modelChanged(modelId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VersionCopyRecordListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.addRegisterListener();
        this.refreshBillList();
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.updateStatus();
        this.refreshBillList();
    }

    private void updateStatus() {
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"query_top1", (String)"eb_versioncopyrecord", (String)"id,lasttime,status", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())}, (String)"executetime desc", (int)1);
        if (ds != null && ds.size() > 0) {
            DynamicObject d = (DynamicObject)ds.get(0);
            if (CopyDataEnum.EXECUTING.getIndex().equals(d.getString("status"))) {
                Date now = TimeServiceHelper.now();
                if (d.getDate("lasttime") == null) {
                    Long id = d.getLong("id");
                    DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_versioncopyrecord");
                    record.set("msg", (Object)ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25\u3002", (String)"VersionCopyRecordListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    record.set("lasttime", (Object)TimeServiceHelper.now());
                    record.set("status", (Object)CopyDataEnum.FAILED.getIndex());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                    return;
                }
                Date begin = d.getDate("lasttime");
                long second = (now.getTime() - begin.getTime()) / 1000L;
                if (second >= 1200L) {
                    Long id = d.getLong("id");
                    DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_versioncopyrecord");
                    record.set("msg", (Object)ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25\u3002", (String)"VersionCopyRecordListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    record.set("status", (Object)CopyDataEnum.FAILED.getIndex());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                }
            }
        }
    }

    private void refreshBillList() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLIST);
        billList.setFilter(qFilter1);
        billList.setClearSelection(true);
        billList.refresh();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView().getParentView(), (long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.refreshBillList();
            }
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.valueOf(modelId);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (CANCEL.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            Object pkid = billList.getFocusRowPkId();
            if (pkid == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"VersionCopyRecordListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)pkid;
            DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_versioncopyrecord");
            if (record != null) {
                if (!CopyDataEnum.EXECUTING.getIndex().equals(record.getString("status"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u7684\u4efb\u52a1\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"VersionCopyRecordListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                record.set("status", (Object)CopyDataEnum.CANCEL.getIndex());
                record.set("msg", (Object)ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c", (String)"VersionCopyRecordListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                record.set("iscancel", (Object)true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7248\u672c\u590d\u5236\u53d6\u6d88", "VersionCopyRecordListPlugin_6", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c\u6210\u529f", "VersionCopyRecordListPlugin_7", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
            this.refreshBillList();
        } else if (REFRESH.equals(key)) {
            this.updateStatus();
            this.refreshBillList();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            PluginUtils.setModelFilter(e, this.getView().getParentView());
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isNewEbForm() || ModelUtil.isBGModel((Long)this.getModelId())) {
            List listColumns = args.getListColumns();
            listColumns.removeIf(iListColumn -> "businessmodel.name".equals(iListColumn.getListFieldKey()));
            listColumns.removeIf(iListColumn -> "orgview.name".equals(iListColumn.getListFieldKey()));
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        boolean newEbOrBG;
        boolean bl = newEbOrBG = this.isNewEbForm() || ModelUtil.isBGModel((Long)this.getModelId());
        if (IDUtils.isNull((Long)this.getModelId())) {
            return;
        }
        final IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                List ids = allRows.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                DynamicObject[] entValueByIds = VersionCopyRecordListPlugin.this.getEntityInfoByIds(ids);
                for (DynamicObject allRow : allRows) {
                    List versionCopyConditionDtos;
                    String dimmemberjson;
                    for (DynamicObject entValueById : entValueByIds) {
                        if (allRow.getLong("id") != entValueById.getLong("id")) continue;
                        List ent_entity = entValueById.getDynamicObjectCollection("ent_entity").stream().map(x -> x.getString("entity.name")).collect(Collectors.toList());
                        allRow.set("entitytext", (Object)String.join((CharSequence)",", ent_entity));
                    }
                    if (!newEbOrBG && SchemeTypeEnum.COPY_SCHEME.getValue().equals(allRow.getString("schemetype"))) {
                        allRow.set("orgview", null);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(dimmemberjson = (String)allRow.get("dimmemberjson"))) || !CollectionUtils.isNotEmpty((Collection)(versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class)))) continue;
                    ArrayList<String> infoList = new ArrayList<String>(16);
                    List viewIDs = versionCopyConditionDtos.stream().map(x -> x.getViewId()).collect(Collectors.toList());
                    Map viewInfoById = DimensionViewServiceHelper.getInstance().getViewInfoById(viewIDs);
                    for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                        DynamicObject dynamicObject;
                        StringBuilder stringBuilder = new StringBuilder();
                        Dimension dimension = orCreate.getDimension(versionCopyConditionDto.getDimNumber());
                        stringBuilder.append(dimension.getName());
                        Long viewId = versionCopyConditionDto.getViewId();
                        if (IDUtils.isNotNull((Long)viewId) && (dynamicObject = (DynamicObject)viewInfoById.get(viewId)) != null) {
                            String name = dynamicObject.getString("name");
                            stringBuilder.append(name);
                        }
                        stringBuilder.append(":");
                        List conditions = versionCopyConditionDto.getConditions();
                        if (CollectionUtils.isNotEmpty((Collection)conditions)) {
                            ArrayList<String> memberInfo = new ArrayList<String>(16);
                            for (MemberCondition condition : conditions) {
                                RangeEnum rangeByVal = RangeEnum.getRangeByVal((String)condition.getRange());
                                if (rangeByVal != null) {
                                    memberInfo.add(condition.getName() + rangeByVal.getName());
                                    continue;
                                }
                                memberInfo.add(condition.getName());
                            }
                            stringBuilder.append(String.join((CharSequence)",", memberInfo));
                        }
                        infoList.add(stringBuilder.toString());
                    }
                    allRow.set("dimmemberjson", (Object)String.join((CharSequence)";", infoList));
                }
                return allRows;
            }
        });
    }

    private DynamicObject[] getEntityInfoByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_versioncopyrecord", (String)"id,ent_entity,ent_entity.entity", (QFilter[])qFilter.toArray());
        return dynamicObjects;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        BillList billList = (BillList)this.getControl(BILLLIST);
        DynamicObject dyna = billList.getModel().loadReferenceData((DynamicObjectType)billList.getEntityType(), billList.getFocusRowPkId());
        if (fieldName.equals("dimmemberjson")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_copyscheme_membinfo");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(true);
            showParameter.setCustomParam(MODEL, (Object)IDUtils.toString((Object)this.getModelId()));
            showParameter.setCustomParam("dimmemberjson", (Object)dyna.getString("dimmemberjson"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_copymsg_info");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam(MODEL, (Object)String.valueOf(this.getModelId()));
            showParameter.setShowTitle(true);
            Long pkid = dyna.getLong("id");
            showParameter.setCustomParam("pkid", (Object)pkid);
            showParameter.setCustomParam("dimmemberjson", (Object)dyna.getString("dimmemberjson"));
            this.getView().showForm(showParameter);
        }
    }
}

