/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class VersionCopySchemeListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
SetFilterListener,
CreateListDataProviderListener,
CreateListColumnsListener {
    private static final String SELECT_FILEDS = "id,schemetype,schemename,businessmodel,srcversion,tarversion,schemenum,model,ent_srctrial,ent_srctrial.srctrial,ent_tartrial,ent_tartrial.tartrial,ent_period,ent_period.period,ent_datatype,ent_datatype.datatype,dimmemberjson";
    private static final String ADD = "btn_add";
    private static final String EXECUTE_COPY = "btn_execute";
    private static final String COPY_RECORD = "btn_copyrecord";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_DELETE = "btn_delete";
    private static final String SCHEME_ID = "pkid";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        String fieldName = hyperLinkClickEvent.getFieldName();
        super.hyperLinkClick(hyperLinkClickEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject dyna = billList.getModel().loadReferenceData((DynamicObjectType)billList.getEntityType(), billList.getFocusRowPkId());
        if (fieldName.equals("dimmemberjson")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_copyscheme_membinfo");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(true);
            Long pkid = dyna.getLong("id");
            showParameter.setCustomParam(SCHEME_ID, (Object)pkid);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_versioncopyscheme");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u65b9\u6848", (String)"VersionCopySchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
            showParameter.setShowTitle(true);
            Long pkid = dyna.getLong("id");
            showParameter.setCustomParam(SCHEME_ID, (Object)pkid);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue("model");
            if (obj instanceof DynamicObject) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
            this.reFreshBillList();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VersionCopySchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.reFreshBillList();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (ADD.equals(itemKey) || EXECUTE_COPY.equals(itemKey) || COPY_RECORD.equals(itemKey)) {
            this.openCopyPage(itemKey);
        } else if (BTN_REFRESH.equals(itemKey)) {
            this.reFreshBillList();
        } else if (BTN_DELETE.equals(itemKey)) {
            this.deleteData();
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
        String itemKey = evt.getItemKey();
        if (EXECUTE_COPY.equals(itemKey)) {
            this.checkExecuteRule(evt);
        }
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        if (e.getSource() instanceof BillList && "billlistap".equals((billList = (BillList)e.getSource()).getKey())) {
            e.getCustomQFilters().add(this.getFilter());
            e.setOrderBy("id desc");
        }
    }

    private QFilter getFilter() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        return qFilter;
    }

    private void reFreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilter(this.getFilter());
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.getView().updateView(e.getEntryProp().getName());
    }

    private void deleteData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"VersionCopySchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List collect = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", collect);
        qFilter.and("billstatus", "=", (Object)"1");
        DynamicObjectCollection shemenames = QueryServiceHelper.query((String)"eb_versioncopyscheme", (String)"schemename", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isNotEmpty((Collection)shemenames)) {
            List schemename = shemenames.stream().map(x -> x.getString("schemename")).collect(Collectors.toList());
            throw new KDBizException(ResManager.loadResFormat((String)"\u65b9\u6848\uff1a%1\u5df2\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VersionCopySchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", schemename)}));
        }
        this.getPageCache().put("select", SerializationUtils.serializeToBase64(collect));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u6240\u9009\u65b9\u6848\u5417\uff1f", (String)"VersionCopySchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String select;
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("delete_comfirm".equals(key) && e.getResult().equals((Object)MessageBoxResult.Yes) && StringUtils.isNotEmpty((String)(select = this.getPageCache().get("select")))) {
            List collect = (List)SerializationUtils.deSerializeFromBase64((String)select);
            QFilter qFilter = new QFilter("id", "in", (Object)collect);
            DynamicObjectCollection shemenames = QueryServiceHelper.query((String)"eb_versioncopyscheme", (String)"schemename", (QFilter[])new QFilter[]{qFilter});
            DeleteServiceHelper.delete((String)"eb_versioncopyscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)collect)});
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.VersionCopy.getType(), new HashSet(collect)});
            this.getPageCache().put("select", null);
            this.reFreshBillList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "VersionCopySchemeListPlugin_11", "epm-eb-formplugin");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"VersionCopySchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (CollectionUtils.isNotEmpty((Collection)shemenames)) {
                List schenename = shemenames.stream().map(x -> x.getString("schemename")).collect(Collectors.toList());
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u65b9\u6848\u540d\u79f0\uff1a%1$s\u3002", "VersionCopySchemeListPlugin_12", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", schenename)});
            }
        }
    }

    private void openCopyPage(String key) {
        FormShowParameter showParameter = new FormShowParameter();
        if (ADD.equals(key)) {
            showParameter.setFormId("eb_versioncopyscheme");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u65b9\u6848", (String)"VersionCopySchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (EXECUTE_COPY.equals(key)) {
            showParameter.setFormId("eb_executeversioncopy");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236", (String)"VersionCopySchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam(SCHEME_ID, (Object)Long.valueOf(this.getPageCache().get(SCHEME_ID)));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            StyleCss css = new StyleCss();
            css.setWidth("840px");
            css.setHeight("565px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            this.getPageCache().put(SCHEME_ID, null);
        } else if (COPY_RECORD.equals(key)) {
            showParameter.setFormId("eb_copyrecordlist");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u8bb0\u5f55", (String)"VersionCopySchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private void checkExecuteRule(BeforeItemClickEvent evt) {
        Object[] primaryKeyValues;
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 0) {
            primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            qFilter.and("schemetype", "=", (Object)"1");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_versioncopyscheme", (String)"id", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                evt.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u751f\u6548\u7c7b\u578b\u7684\u65b9\u6848\u8bf7\u5728\u7248\u672c\u6570\u636e\u751f\u6548\u754c\u9762\u6267\u884c\u590d\u5236\u3002", (String)"VersionCopySchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (selectedRows.size() > 1) {
                evt.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7248\u672c\u590d\u5236\u65b9\u6848\uff0c\u6267\u884c\u590d\u5236\u3002", (String)"VersionCopySchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            evt.setCancel(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u65b9\u6848\u3002", (String)"VersionCopySchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(SCHEME_ID, String.valueOf(primaryKeyValues[0]));
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                List ids = allRows.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                DynamicObject[] entValueByIds = VersionCopySchemeListPlugin.this.getEntValueByIds(ids);
                if (IDUtils.isNull((Long)VersionCopySchemeListPlugin.this.getModelId()) || CollectionUtils.isEmpty((Collection)allRows)) {
                    return allRows;
                }
                IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)VersionCopySchemeListPlugin.this.getModelId());
                for (DynamicObject allRow : allRows) {
                    for (DynamicObject entValueById : entValueByIds) {
                        String dimmemberjson;
                        if (allRow.getLong("id") != entValueById.getLong("id")) continue;
                        List ent_datatype = entValueById.getDynamicObjectCollection("ent_datatype").stream().map(x -> x.getString("datatype.name")).collect(Collectors.toList());
                        allRow.set("datatypeshow", (Object)String.join((CharSequence)",", ent_datatype));
                        List ent_periodtype = entValueById.getDynamicObjectCollection("ent_period").stream().map(x -> x.getString("period.name")).collect(Collectors.toList());
                        allRow.set("periodshow", (Object)String.join((CharSequence)",", ent_periodtype));
                        String schemetype = entValueById.getString("schemetype");
                        if (StringUtils.equals((String)schemetype, (String)"0")) {
                            allRow.set("effectivedate", null);
                            allRow.set("expirationdate", null);
                        }
                        if (StringUtils.isNotEmpty((String)(dimmemberjson = entValueById.getString("dimmemberjson")))) {
                            List versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class);
                            if (!CollectionUtils.isNotEmpty((Collection)versionCopyConditionDtos)) continue;
                            ArrayList<String> infoList = new ArrayList<String>(16);
                            List viewIDs = versionCopyConditionDtos.stream().map(x -> x.getViewId()).collect(Collectors.toList());
                            Map viewInfoById = DimensionViewServiceHelper.getInstance().getViewInfoById(viewIDs);
                            for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                                DynamicObject dynamicObject;
                                StringBuilder stringBuilder = new StringBuilder();
                                Dimension dimension = orCreate.getDimension(versionCopyConditionDto.getDimNumber());
                                stringBuilder.append(dimension.getName());
                                Long viewId = versionCopyConditionDto.getViewId();
                                if (IDUtils.isNotNull((Long)viewId) && (dynamicObject = (DynamicObject)viewInfoById.get(viewId)) != null) {
                                    String name = dynamicObject.getString("name");
                                    stringBuilder.append(name);
                                }
                                stringBuilder.append(":");
                                List conditions = versionCopyConditionDto.getConditions();
                                if (CollectionUtils.isNotEmpty((Collection)conditions)) {
                                    ArrayList<String> memberInfo = new ArrayList<String>(16);
                                    for (MemberCondition condition : conditions) {
                                        RangeEnum rangeByVal = RangeEnum.getRangeByVal((String)condition.getRange());
                                        if (rangeByVal != null) {
                                            memberInfo.add(condition.getName() + rangeByVal.getName());
                                            continue;
                                        }
                                        memberInfo.add(condition.getName());
                                    }
                                    stringBuilder.append(String.join((CharSequence)",", memberInfo));
                                }
                                infoList.add(stringBuilder.toString());
                            }
                            allRow.set("dimmemberjson", (Object)String.join((CharSequence)";", infoList));
                            continue;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        Dimension dataDimension = orCreate.getDimension(SysDimensionEnum.DataType.getNumber());
                        stringBuilder.append(dataDimension.getName()).append(":");
                        stringBuilder.append(String.join((CharSequence)(RangeEnum.ONLY.getName() + ","), ent_datatype)).append(";");
                        Dimension periodDimension = orCreate.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                        stringBuilder.append(periodDimension.getName()).append(":");
                        stringBuilder.append(String.join((CharSequence)(RangeEnum.ONLY.getName() + ","), ent_periodtype));
                        allRow.set("dimmemberjson", (Object)stringBuilder.toString());
                    }
                }
                return allRows;
            }
        });
    }

    public DynamicObject[] getEntValueByIds(List ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_versioncopyscheme", (String)SELECT_FILEDS, (QFilter[])qFilter.toArray());
        return dynamicObjects;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (EXECUTE_COPY.equals(actionId) && (returnData = e.getReturnData()) != null) {
            String returnMsg = returnData.toString();
            if ("executesuccess".equals(returnMsg)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6210\u529f\u3002", (String)"VersionCopyExecutePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            } else {
                this.getView().showErrorNotification(returnMsg);
            }
        }
        this.reFreshBillList();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isNewEbForm() || ModelUtil.isBGModel((Long)this.getModelId())) {
            List listColumns = args.getListColumns();
            listColumns.removeIf(iListColumn -> "businessmodel.name".equals(iListColumn.getListFieldKey()));
            listColumns.removeIf(iListColumn -> "orgview.name".equals(iListColumn.getListFieldKey()));
        }
    }
}

