/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class VersionCopySchemeMemberInfoPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final Log log = LogFactory.getLog(VersionCopySchemeMemberInfoPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillEntry();
    }

    private void fillEntry() {
        Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
        if (pkid == null) {
            String model = (String)this.getView().getFormShowParameter().getCustomParam("model");
            String dimmemberjson = (String)this.getView().getFormShowParameter().getCustomParam("dimmemberjson");
            if (StringUtils.isEmpty((String)model) || StringUtils.isEmpty((String)dimmemberjson)) {
                log.info("model:{} dimmemberjson:{}", (Object)model, (Object)dimmemberjson);
                return;
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)model));
            if (modelCacheHelper == null) {
                log.info("modelcachehelper is null");
                return;
            }
            this.fillBillList(dimmemberjson, modelCacheHelper);
            return;
        }
        Long schemeId = IDUtils.toLong((Object)pkid);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_versioncopyscheme");
        if (dynamicObject == null) {
            log.info("scheme is null");
            return;
        }
        String dimmemberjson = dynamicObject.getString("dimmemberjson");
        DynamicObject model = dynamicObject.getDynamicObject("model");
        if (model == null) {
            log.info("model is null");
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
        if (modelCacheHelper == null) {
            log.info("modelcachehelper is null");
            return;
        }
        int index = -1;
        if (StringUtils.isNotEmpty((String)dimmemberjson)) {
            List versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class);
            if (CollectionUtils.isNotEmpty((Collection)versionCopyConditionDtos)) {
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, versionCopyConditionDtos.size());
                this.getModel().beginInit();
                for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                    List conditions;
                    ++index;
                    Dimension dimension = modelCacheHelper.getDimension(versionCopyConditionDto.getDimNumber());
                    if (dimension == null) {
                        log.info("dimension is null :{}", (Object)versionCopyConditionDto.getDimNumber());
                        continue;
                    }
                    this.getModel().setValue("dim", (Object)dimension.getId(), index);
                    Long viewId = versionCopyConditionDto.getViewId();
                    if (IDUtils.isNotNull((Long)viewId)) {
                        this.getModel().setValue("dimview", (Object)viewId, index);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(conditions = versionCopyConditionDto.getConditions()))) continue;
                    ArrayList<String> memberInfo = new ArrayList<String>(16);
                    for (MemberCondition condition : conditions) {
                        RangeEnum rangeByVal = RangeEnum.getRangeByVal((String)condition.getRange());
                        if (rangeByVal != null) {
                            memberInfo.add(condition.getName() + rangeByVal.getName());
                            continue;
                        }
                        memberInfo.add(condition.getName());
                    }
                    this.getModel().setValue("member", (Object)String.join((CharSequence)",", memberInfo), index);
                }
                this.getModel().endInit();
            }
        } else {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 2);
            List ent_datatype = dynamicObject.getDynamicObjectCollection("ent_datatype").stream().map(x -> x.getString("datatype.name")).collect(Collectors.toList());
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.DataType.getNumber());
            this.getModel().beginInit();
            this.getModel().setValue("dim", (Object)dimension.getId(), 0);
            this.getModel().setValue("member", (Object)String.join((CharSequence)(RangeEnum.ONLY.getName() + ","), ent_datatype), 0);
            Dimension periodDim = modelCacheHelper.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
            this.getModel().setValue("dim", (Object)periodDim.getId(), 1);
            List ent_periodtype = dynamicObject.getDynamicObjectCollection("ent_period").stream().map(x -> x.getString("period.name")).collect(Collectors.toList());
            this.getModel().setValue("member", (Object)String.join((CharSequence)(RangeEnum.ONLY.getName() + ","), ent_periodtype), 1);
            this.getModel().endInit();
        }
    }

    private void fillBillList(String dimmemberjson, IModelCacheHelper modelCacheHelper) {
        List versionCopyConditionDtos;
        int index = -1;
        if (StringUtils.isNotEmpty((String)dimmemberjson) && CollectionUtils.isNotEmpty((Collection)(versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class)))) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, versionCopyConditionDtos.size());
            this.getModel().beginInit();
            for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                List conditions;
                ++index;
                Dimension dimension = modelCacheHelper.getDimension(versionCopyConditionDto.getDimNumber());
                if (dimension == null) {
                    log.info("dimension is null :{}", (Object)versionCopyConditionDto.getDimNumber());
                    continue;
                }
                this.getModel().setValue("dim", (Object)dimension.getId(), index);
                Long viewId = versionCopyConditionDto.getViewId();
                if (IDUtils.isNotNull((Long)viewId)) {
                    this.getModel().setValue("dimview", (Object)viewId, index);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(conditions = versionCopyConditionDto.getConditions()))) continue;
                ArrayList<String> memberInfo = new ArrayList<String>(16);
                for (MemberCondition condition : conditions) {
                    RangeEnum rangeByVal = RangeEnum.getRangeByVal((String)condition.getRange());
                    if (rangeByVal != null) {
                        memberInfo.add(condition.getName() + rangeByVal.getName());
                        continue;
                    }
                    memberInfo.add(condition.getName());
                }
                this.getModel().setValue("member", (Object)String.join((CharSequence)",", memberInfo), index);
            }
            this.getModel().endInit();
        }
    }
}

