/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.versioncopy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.quote.utils.VersionCopyQuoteUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SchemeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class VersionCopySchemePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(VersionCopySchemePlugin.class);
    private static final String SELECT_FILEDS = "id,schemetype,schemename,effectivedate,expirationdate,businessmodel,srcversion,tarversion,datalock,schemenum,billstatus,model,ent_period,ent_period.period,ent_datatype,ent_datatype.datatype,ent_srctrial,ent_srctrial.srctrial,ent_tartrial,ent_tartrial.tartrial,orgview,dimmemberjson";
    private static final List<String> EXCLUDING_DIM = Arrays.asList(SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Project.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber());
    private static final List<String> EXCLUDING_DIM_VALIDATION = Arrays.asList(SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Project.getNumber(), SysDimensionEnum.Entity.getNumber());
    private static final List<String> DEFAULT_DIM = Arrays.asList(SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber());
    private static final String SCHEME_TYPE = "schemetype";
    private static final String SCHEME_NAME = "schemename";
    private static final String EFFECTIVE_DATE = "effectivedate";
    private static final String EXPRIATION_DATE = "expirationdate";
    private static final String BUSINESS_MODEL = "businessmodel";
    private static final String SRC_VERSION = "srcversion";
    private static final String TAR_VERSION = "tarversion";
    private static final String DATA_LOCK = "datalock";
    private static final String SCHEME_NUM = "schemenum";
    private static final String ENT_PERIOD = "ent_period";
    private static final String PERIOD = "period";
    private static final String PERIOD_NAME = "periodname";
    private static final String ENT_SRC_TRIAL = "ent_srctrial";
    private static final String SRC_TRIAL = "srctrial";
    private static final String SRC_TRIAL_NAME = "srctrialname";
    private static final String ENT_TAR_TRIAL = "ent_tartrial";
    private static final String TAR_TRIAL = "tartrial";
    private static final String TAR_TRIAL_NAME = "tartrialname";
    private static final String ENT_DATATYPE = "ent_datatype";
    private static final String DATATYPE = "datatype";
    private static final String DATATYPE_NAME = "datatypename";
    private static final String BILL_STATUS = "billstatus";
    private static final String MODEL = "model";
    private static final String SAVE_BTN = "savebtn";
    private static final String MODIFIER = "modifier";
    private static final String MODIFY_TIME = "modifytime";
    private static final String ORG_VIEW = "orgview";
    private boolean flag = true;
    private static final String DIMMEMBERJSON = "dimmemberjson";
    private static final String DIM = "dim";
    private static final String MEMBER = "member";
    private static final String DIMVIEW = "dimview";
    private static final String ENTRYENTITY = "entryentity";
    private static List<VersionCopyConditionDto> versionCopyConditionDtos = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizmodel = (BasedataEdit)this.getControl(BUSINESS_MODEL);
        bizmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{MEMBER, SRC_TRIAL_NAME, TAR_TRIAL_NAME, SAVE_BTN});
        this.addF7SelectListener(this, new String[]{SRC_VERSION, TAR_VERSION, ORG_VIEW, DIM});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        try {
            String key = e.getProperty().getName();
            if (BUSINESS_MODEL.equals(key)) {
                this.bizmoelSelect(e);
            } else if (SRC_VERSION.equals(key) || TAR_VERSION.equals(key)) {
                Long modelId = this.getModelId();
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Version.getNumber()), (String)ListSelectedRow.class.getName());
                DynamicObject businessModelDyn = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL);
                if (businessModelDyn == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"VersionCopySchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                } else {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessModelDyn.getLong("id"), (String)"eb_businessmodel");
                    f7Param.setBusModelId(Long.valueOf(dynamicObject.getLong("id")));
                }
                f7Param.setOnlySelLeaf(true);
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
            } else if (ORG_VIEW.equals(key)) {
                DynamicObject businessModelDyn = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL);
                if (businessModelDyn == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"VersionCopySchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                } else {
                    List number = this.getIModelCacheHelper().getViewGroupViewsByBusModelAndDimNumber(Long.valueOf(businessModelDyn.getLong("id")), SysDimensionEnum.Entity.getNumber());
                    ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                    ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
                    List dimensionListByBusModel = this.getIModelCacheHelper().getDimensionListByBusModel(Long.valueOf(businessModelDyn.getLong("id")));
                    Optional<Dimension> first = dimensionListByBusModel.stream().filter(x -> x.getNumber().equals(SysDimensionEnum.Entity.getNumber())).findFirst();
                    if (!first.isPresent()) {
                        return;
                    }
                    Dimension dimension = first.get();
                    qFilterList.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
                    qFilterList.add(new QFilter("dimension", "=", (Object)dimension.getId()));
                    qFilterList.add(new QFilter("id", "in", (Object)number));
                    showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                }
            } else if (DIM.equals(key)) {
                DynamicObject businessModelDyn = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL);
                if (businessModelDyn == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"VersionCopySchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List dimensionListByBusModel = this.getModelCacheHelper().getDimensionListByBusModel(this.getBizModel());
                List allDimNumber = dimensionListByBusModel.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                Object value = this.getModel().getValue(SCHEME_TYPE);
                if (value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u7c7b\u578b\u3002", (String)"VersionCopySchemePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                String schemeType = (String)value;
                if (SchemeTypeEnum.COPY_SCHEME.getValue().equals(schemeType)) {
                    allDimNumber.removeAll(EXCLUDING_DIM);
                } else if (SchemeTypeEnum.DATA_VALIDATION.getValue().equals(schemeType)) {
                    allDimNumber.removeAll(EXCLUDING_DIM_VALIDATION);
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                    for (DynamicObject dynamicObject : entryEntity) {
                        DynamicObject dynamicObject1 = dynamicObject.getDynamicObject(DIM);
                        if (dynamicObject1 == null || !StringUtils.isNotEmpty((String)dynamicObject1.getString("number"))) continue;
                        allDimNumber.remove(dynamicObject1.getString("number"));
                    }
                }
                if (CollectionUtils.isEmpty(allDimNumber)) {
                    e.setCancel(true);
                    return;
                }
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                QFilter qFilter = new QFilter("number", "in", allDimNumber);
                qFilter.and(MODEL, "=", (Object)this.getModelId());
                showParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(qFilter), null));
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#beforeF7Select", (Throwable)ex);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        if (SRC_VERSION.equals(controlKey) || TAR_VERSION.equals(controlKey)) {
            return SysDimensionEnum.Version.getNumber();
        }
        return null;
    }

    public void click(EventObject evt) {
        try {
            String key;
            super.click(evt);
            Control source = (Control)evt.getSource();
            switch (key = source.getKey()) {
                case "srctrialname": {
                    this.openF7Page(SysDimensionEnum.AuditTrail.getNumber(), key, false);
                    break;
                }
                case "tartrialname": {
                    this.openF7Page(SysDimensionEnum.AuditTrail.getNumber(), key, true);
                    break;
                }
                case "member": {
                    String dimNumber = this.getCurrentDimNumber();
                    if (dimNumber == null) {
                        return;
                    }
                    this.openMulSelectPage(dimNumber);
                    break;
                }
                case "savebtn": {
                    DynamicObjectCollection entryEntity;
                    boolean c;
                    boolean b;
                    DynamicObject orgViewDyn;
                    String schemename;
                    Object value = this.getModel().getValue(SCHEME_TYPE);
                    Object fid = this.getView().getFormShowParameter().getCustomParam("pkid");
                    OrmLocaleValue nameObj = (OrmLocaleValue)this.getModel().getValue(SCHEME_NAME);
                    if (nameObj != null && (StringUtils.isEmpty((String)(schemename = nameObj.getLocaleValue())) || StringUtils.isEmpty((String)schemename.replace(" ", "")))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65b9\u6848\u540d\u79f0\u3002", (String)"VersionCopySchemePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        return;
                    }
                    if (value == null) break;
                    String srcTrialObj = (String)this.getModel().getValue(SRC_TRIAL_NAME);
                    String tarTrialObj = (String)this.getModel().getValue(TAR_TRIAL_NAME);
                    if (StringUtils.isNotEmpty((String)tarTrialObj) && StringUtils.isEmpty((String)srcTrialObj)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u7ebf\u7d22\u4e3a\u7a7a\u65f6\uff0c\u76ee\u6807\u7ebf\u7d22\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"VersionCopySchemePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        return;
                    }
                    String schemeTypeValue = (String)value;
                    if (SchemeTypeEnum.DATA_VALIDATION.getValue().equals(schemeTypeValue)) {
                        this.flag = this.checkDateRule(fid);
                    }
                    if ((orgViewDyn = (DynamicObject)this.getModel().getValue(ORG_VIEW)) == null && SchemeTypeEnum.DATA_VALIDATION.getValue().equals(schemeTypeValue)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7c7b\u578b\u4e3a\u6570\u636e\u751f\u6548\u65f6\uff0c\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionCopySchemePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.flag = false;
                    }
                    if (!(b = this.checkVersionDiff())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u548c\u6e90\u7248\u672c\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"VersionCopySchemePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.flag = b;
                    }
                    if (!(c = this.checkTrialRule())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"VersionCopySchemePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.flag = c;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(entryEntity = this.getModel().getEntryEntity(ENTRYENTITY)))) {
                        ArrayList<String> defaultDim = new ArrayList<String>(2);
                        for (DynamicObject dynamicObject : entryEntity) {
                            DynamicObject dimNumberDyna = dynamicObject.getDynamicObject(DIM);
                            if (dimNumberDyna == null) continue;
                            String memberInfo = dynamicObject.getString(MEMBER);
                            if (StringUtils.isEmpty((String)memberInfo)) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionCopySchemePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                this.flag = false;
                            }
                            if (!DEFAULT_DIM.contains(dimNumberDyna.getString("number"))) continue;
                            defaultDim.add(dimNumberDyna.getString("number"));
                        }
                        if (!DEFAULT_DIM.containsAll(defaultDim) || CollectionUtils.isEmpty(defaultDim) || DEFAULT_DIM.size() != defaultDim.size()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u548c\u6570\u636e\u7c7b\u578b\u5fc5\u5f55", (String)"VersionCopySchemePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.flag = false;
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u548c\u6570\u636e\u7c7b\u578b\u5fc5\u5f55", (String)"VersionCopySchemePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.flag = false;
                    }
                    this.getView().setEnable(Boolean.valueOf(!this.flag), new String[]{SAVE_BTN});
                    if (!this.flag) break;
                    this.buildUpdateData(fid, schemeTypeValue);
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"VersionCopySchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.writeLog();
                    this.getView().close();
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#click", (Throwable)ex);
        }
    }

    @Nullable
    private String getCurrentDimNumber() {
        int currentIndex = this.getCurrentIndex();
        if (currentIndex < 0) {
            log.info("currentIndexRow is null");
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(DIM, currentIndex);
        if (dynamicObject == null) {
            log.info("dimNumber is null");
            return null;
        }
        return dynamicObject.getString("number");
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (StringUtils.isNotEmpty((String)modelId)) {
            return Long.valueOf(modelId);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VersionCopySchemePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        try {
            super.closedCallBack(evt);
            String key = evt.getActionId();
            ListSelectedRowCollection list = null;
            switch (key) {
                case "tartrialname": 
                case "srctrialname": {
                    if (evt.getReturnData() == null) {
                        return;
                    }
                    list = (ListSelectedRowCollection)evt.getReturnData();
                    if (list.size() == 0) {
                        return;
                    }
                    if (list.size() > 1) {
                        if (!this.checkReturnData(list)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u591a\u4e2a\u6210\u5458\u65f6\uff0c\u4e0d\u5141\u8bb8\u5305\u542b\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"VersionCopySchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            return;
                        }
                        this.fillEntryEntity(list, SRC_TRIAL_NAME);
                        this.fillEntryEntity(list, TAR_TRIAL_NAME);
                        return;
                    }
                    if (TAR_TRIAL_NAME.equals(key)) {
                        ListSelectedRow listSelectedRow = list.get(0);
                        Map dataMap = listSelectedRow.getDataMap();
                        if (dataMap == null || dataMap.get("isleaf") == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u5458\u201cisleaf\u201d\u7684\u5c5e\u6027\u4e3a\u7a7a\u3002", (String)"VersionCopySchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            return;
                        }
                        boolean isleaf = (Boolean)dataMap.get("isleaf");
                        if (!isleaf) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7ebf\u7d22\u5fc5\u987b\u4e3a\u660e\u7ec6\u6210\u5458\u3002", (String)"VersionCopySchemePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            return;
                        }
                        String srcTrialObj = (String)this.getModel().getValue(SRC_TRIAL_NAME);
                        if (StringUtils.isEmpty((String)srcTrialObj)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u7ebf\u7d22\u4e3a\u7a7a\u65f6\uff0c\u76ee\u6807\u7ebf\u7d22\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"VersionCopySchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            return;
                        }
                    }
                    this.fillEntryEntity(list, key);
                    break;
                }
                case "member": {
                    Object returnData = evt.getReturnData();
                    String currentDimNumber = this.getCurrentDimNumber();
                    if (StringUtils.isEmpty((String)currentDimNumber)) {
                        return;
                    }
                    if (returnData == null) {
                        // empty if block
                    }
                    if (!(returnData instanceof ListSelectedRowCollection)) break;
                    ListSelectedRowCollection result = (ListSelectedRowCollection)returnData;
                    int currentIndex = this.getCurrentIndex();
                    if (currentIndex < 0) {
                        log.info("index is null");
                        return;
                    }
                    if (CollectionUtils.isEmpty((Collection)result)) {
                        List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
                        String dimNumber = this.getCurrentDimNumber();
                        if (DEFAULT_DIM.contains(dimNumber)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7ef4\u5ea6\u5206\u5f55\u4e0d\u80fd\u5220\u9664\u3002", (String)"VersionCopySchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (CollectionUtils.isNotEmpty(versionCopyConditionDtos) && StringUtils.isNotEmpty((String)dimNumber)) {
                            VersionCopyConditionDto needRemove = null;
                            for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                                if (!versionCopyConditionDto.getDimNumber().equals(dimNumber)) continue;
                                needRemove = versionCopyConditionDto;
                                break;
                            }
                            if (needRemove != null) {
                                versionCopyConditionDtos.remove(needRemove);
                                this.cacheVersionCopyConditions(versionCopyConditionDtos);
                            }
                            this.getModel().setValue(MEMBER, null, currentIndex);
                            this.getModel().setValue(DIMVIEW, null, currentIndex);
                        }
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    Long viewId = 0L;
                    List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
                    String dimNumber = this.getCurrentDimNumber();
                    VersionCopyConditionDto history = null;
                    if (CollectionUtils.isNotEmpty(versionCopyConditionDtos) && StringUtils.isNotEmpty((String)dimNumber)) {
                        for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                            if (!versionCopyConditionDto.getDimNumber().equals(dimNumber)) continue;
                            history = versionCopyConditionDto;
                            break;
                        }
                    }
                    ArrayList<MemberCondition> conditions = new ArrayList<MemberCondition>(result.size());
                    IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
                    for (ListSelectedRow listSelectedRow : result) {
                        Map dataMap = listSelectedRow.getDataMap();
                        RangeEnum scope = RangeEnum.getRangeByVal((String)((String)dataMap.get("scope")));
                        stringBuilder.append(dataMap.get("name"));
                        if (scope != null) {
                            stringBuilder.append(scope.getName());
                        }
                        stringBuilder.append(";");
                        viewId = IDUtils.toLong(dataMap.get("viewid"));
                        if (history == null) {
                            Dimension dimension;
                            history = new VersionCopyConditionDto();
                            history.setDimNumber((String)dataMap.get("dimNumber"));
                            if (modelCacheHelper != null && (dimension = modelCacheHelper.getDimension(history.getDimNumber())) != null) {
                                history.setDimId(dimension.getId());
                            }
                            versionCopyConditionDtos.add(history);
                        }
                        history.setViewId(viewId);
                        conditions.add(new MemberCondition(IDUtils.toLong(dataMap.get("memberid")), String.valueOf(dataMap.get("number")), String.valueOf(dataMap.get("name")), null, (String)dataMap.get("scope")));
                    }
                    if (history != null) {
                        history.setConditions(conditions);
                    }
                    this.cacheVersionCopyConditions(versionCopyConditionDtos);
                    String string = stringBuilder.toString();
                    String substring = string.substring(0, string.length() - 1);
                    this.getModel().setValue(MEMBER, (Object)substring, currentIndex);
                    this.getModel().setValue(DIMVIEW, (Object)viewId, currentIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#closedCallBack", (Throwable)ex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setViewEnable(MODEL);
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"VersionCopySchemePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getPageCache().put(MODEL, modelId.toString());
        this.setSchemeDefaultValue();
        boolean isBGModel = ModelUtil.isBGModel((Long)this.getModelId());
        if (isBGModel) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BUSINESS_MODEL});
        }
    }

    private void setSchemeDefaultValue() {
        Object fid = this.getView().getFormShowParameter().getCustomParam("pkid");
        if (fid != null) {
            QFilter qFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)fid));
            DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"eb_versioncopyscheme", (String)SELECT_FILEDS, (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                this.setDefaultValue(dynamicObject[0]);
            } else {
                this.setDefaultValue(null);
            }
        } else {
            this.setDefaultValue(null);
        }
    }

    private IModelCacheHelper getModelCacheHelper() {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        return orCreate;
    }

    private Long getBizModel() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL);
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String name = e.getProperty().getName();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (SRC_VERSION.equals(name) || TAR_VERSION.equals(name)) {
                DynamicObject srcVersion = (DynamicObject)this.getModel().getValue(SRC_VERSION);
                DynamicObject tarVersion = (DynamicObject)this.getModel().getValue(TAR_VERSION);
                if (srcVersion != null && tarVersion != null) {
                    if (tarVersion.getLong("id") == srcVersion.getLong("id")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u548c\u6e90\u7248\u672c\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"VersionCopySchemePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        this.setNumberAndName();
                    }
                }
            } else if (EFFECTIVE_DATE.equals(name) || EXPRIATION_DATE.equals(name)) {
                if (this.getModel().getValue(EXPRIATION_DATE) != null) {
                    Calendar endTime = Calendar.getInstance();
                    endTime.setTime((Date)this.getModel().getValue(EXPRIATION_DATE));
                    endTime.set(11, 23);
                    endTime.set(12, 59);
                    endTime.set(13, 59);
                    this.getModel().setValue(EXPRIATION_DATE, (Object)endTime.getTime());
                } else if (this.getModel().getValue(EFFECTIVE_DATE) != null) {
                    Calendar endTime = Calendar.getInstance();
                    endTime.setTime((Date)this.getModel().getValue(EFFECTIVE_DATE));
                    endTime.set(11, 0);
                    endTime.set(12, 0);
                    endTime.set(13, 0);
                    this.getModel().setValue(EFFECTIVE_DATE, (Object)endTime.getTime());
                }
            } else if (SCHEME_TYPE.equals(name)) {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                if ("0".equals(newValue)) {
                    this.getModel().setValue(EFFECTIVE_DATE, null);
                    this.getModel().setValue(EXPRIATION_DATE, null);
                    this.getView().updateView(EFFECTIVE_DATE);
                }
                if ("1".equals(newValue)) {
                    List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
                    if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                        Optional<VersionCopyConditionDto> first;
                        int index = 0;
                        for (DynamicObject dynamicObject : entryEntity) {
                            DynamicObject dimDyn = dynamicObject.getDynamicObject(DIM);
                            if (dimDyn != null && SysDimensionEnum.Entity.getNumber().equals(dimDyn.getString("number"))) {
                                this.getModel().setValue(DIM, null, index);
                                this.getModel().setValue(MEMBER, null, index);
                                this.getModel().setValue(DIMVIEW, null, index);
                                break;
                            }
                            ++index;
                        }
                        if (CollectionUtils.isNotEmpty(versionCopyConditionDtos) && (first = versionCopyConditionDtos.stream().filter(x -> x.getDimNumber().equals(SysDimensionEnum.Entity.getNumber())).findFirst()).isPresent()) {
                            versionCopyConditionDtos.remove(first.get());
                            this.cacheVersionCopyConditions(versionCopyConditionDtos);
                        }
                    }
                }
            } else if (BUSINESS_MODEL.equals(name)) {
                this.getModel().setValue(ORG_VIEW, null);
                this.getView().updateView(ORG_VIEW);
                this.fillEntryByScheme(null);
                this.fillEntryEntity(new ListSelectedRowCollection(), SRC_TRIAL_NAME);
                this.fillEntryEntity(new ListSelectedRowCollection(), TAR_TRIAL_NAME);
                this.getModel().setValue(SRC_VERSION, null);
                this.getModel().setValue(TAR_VERSION, null);
                this.cacheVersionCopyConditions(null);
            } else if (name.equals(DATATYPE_NAME) || name.equals(PERIOD_NAME) || name.equals(TAR_TRIAL_NAME) || name.equals(SRC_TRIAL_NAME)) {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue == null || "".equals(newValue)) {
                    this.getModel().setValue(name, null);
                    String entKey = ENT_SRC_TRIAL;
                    if (name.equals(DATATYPE_NAME)) {
                        entKey = ENT_DATATYPE;
                    } else if (name.equals(PERIOD_NAME)) {
                        entKey = ENT_PERIOD;
                    } else if (name.equals(TAR_TRIAL_NAME)) {
                        entKey = ENT_TAR_TRIAL;
                    }
                    this.getModel().deleteEntryData(entKey);
                }
            } else if (MEMBER.equals(name)) {
                String dimNumber = this.getCurrentDimNumber();
                if (StringUtils.isNotEmpty((String)dimNumber)) {
                    String newValue = (String)e.getChangeSet()[0].getNewValue();
                    if (StringUtils.isNotEmpty((String)newValue)) {
                        return;
                    }
                    if (DEFAULT_DIM.contains(dimNumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7ef4\u5ea6\u5206\u5f55\u4e0d\u80fd\u5220\u9664\u3002", (String)"VersionCopySchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue(MEMBER, (Object)((String)e.getChangeSet()[0].getOldValue()), this.getCurrentIndex());
                        return;
                    }
                    List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
                    if (CollectionUtils.isEmpty(versionCopyConditionDtos)) {
                        return;
                    }
                    Optional<VersionCopyConditionDto> first = versionCopyConditionDtos.stream().filter(x -> x.getDimNumber().equals(dimNumber)).findFirst();
                    if (first.isPresent()) {
                        VersionCopyConditionDto versionCopyConditionDto = first.get();
                        versionCopyConditionDto.setViewId(null);
                        versionCopyConditionDto.setConditions(null);
                        this.cacheVersionCopyConditions(versionCopyConditionDtos);
                        this.getModel().setValue(DIMVIEW, null, this.getCurrentIndex());
                    }
                }
            } else if (DIM.equals(name)) {
                Optional<VersionCopyConditionDto> first;
                List<VersionCopyConditionDto> versionCopyConditionDtos;
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (newValue != null && oldValue != null && !newValue.getString("number").equals(oldValue.getString("number")) && CollectionUtils.isNotEmpty(versionCopyConditionDtos = this.getVersionCopyConditionDtos()) && (first = versionCopyConditionDtos.stream().filter(x -> x.getDimNumber().equals(oldValue.getString("number"))).findFirst()).isPresent()) {
                    VersionCopyConditionDto versionCopyConditionDto = first.get();
                    versionCopyConditionDtos.remove(versionCopyConditionDto);
                    this.cacheVersionCopyConditions(versionCopyConditionDtos);
                    this.getModel().setValue(MEMBER, null, this.getCurrentIndex());
                    this.getModel().setValue(DIMVIEW, null, this.getCurrentIndex());
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#propertyChanged", (Throwable)ex);
        }
    }

    private int getCurrentIndex() {
        int[] selectRows;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid != null && (selectRows = entryGrid.getSelectRows()) != null && selectRows.length > 0) {
            return selectRows[0];
        }
        log.info("currentIndexRow is null");
        return -1;
    }

    public void bizmoelSelect(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)this.getControl(BUSINESS_MODEL)).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
        showParameter.getListFilterParameter().getQFilters().addAll(filters);
    }

    private void setNumberAndName() {
        DynamicObject srcVersion = (DynamicObject)this.getModel().getValue(SRC_VERSION);
        DynamicObject tarVersion = (DynamicObject)this.getModel().getValue(TAR_VERSION);
        this.getModel().setValue(SCHEME_NUM, (Object)this.getOnlyNumber(srcVersion, tarVersion));
    }

    private String getOnlyNumber(DynamicObject srcVersion, DynamicObject tarVersion) {
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter(SRC_VERSION, "=", (Object)srcVersion.getLong("id")));
            qFilters.add(new QFilter(TAR_VERSION, "=", (Object)tarVersion.getLong("id")));
            StringBuilder startNumber = new StringBuilder(srcVersion.getString("number"));
            startNumber.append("-").append("copy").append("-").append(tarVersion.getString("number")).append("-");
            String numberIndex = "001";
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_versioncopyscheme", (String)SCHEME_NUM, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createdate desc", (int)1);
            if (query.size() > 0) {
                String preNumber = ((DynamicObject)query.get(0)).getString(SCHEME_NUM);
                int startIndex = startNumber.toString().length() + 1;
                numberIndex = String.valueOf(Integer.parseInt(preNumber.substring(startIndex)) + 1);
            }
            StringBuilder midNumber = new StringBuilder();
            for (int i = 0; i < 3 - numberIndex.length(); ++i) {
                midNumber.append(0);
            }
            midNumber.append(numberIndex);
            startNumber.append((CharSequence)midNumber);
            return startNumber.toString();
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#getOnlyNumber", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            String dimNumber = this.getCurrentDimNumber();
            if (DEFAULT_DIM.contains(dimNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7ef4\u5ea6\u5206\u5f55\u4e0d\u80fd\u5220\u9664\u3002", (String)"VersionCopySchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            this.getPageCache().put("deleteDim", dimNumber);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String deleteDim;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey) && !DEFAULT_DIM.contains(deleteDim = this.getPageCache().get("deleteDim"))) {
            Optional<VersionCopyConditionDto> first;
            List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
            if (CollectionUtils.isNotEmpty(versionCopyConditionDtos) && (first = versionCopyConditionDtos.stream().filter(x -> x.getDimNumber().equals(deleteDim)).findFirst()).isPresent()) {
                versionCopyConditionDtos.remove(first.get());
                this.cacheVersionCopyConditions(versionCopyConditionDtos);
            }
            this.getPageCache().remove("deleteDim");
        }
    }

    private void writeLog() {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "VersionCopySchemePlugin_17", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u65b9\u6848\u540d\u79f0\uff1a%1$s\u5df2\u4fdd\u5b58\u3002", "VersionCopySchemePlugin_18", "epm-eb-formplugin");
        OrmLocaleValue value = (OrmLocaleValue)this.getModel().getValue(SCHEME_NAME);
        OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{value.getLocaleValue()});
    }

    private void buildUpdateData(Object fid, String schemeType) {
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_versioncopyscheme");
            if (fid != null) {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"eb_versioncopyscheme");
            }
            dynamicObject.set(BUSINESS_MODEL, this.getModel().getValue(BUSINESS_MODEL));
            dynamicObject.set(MODEL, this.getModel().getValue(MODEL));
            dynamicObject.set(SCHEME_NAME, this.getModel().getValue(SCHEME_NAME));
            dynamicObject.set(SCHEME_TYPE, this.getModel().getValue(SCHEME_TYPE));
            dynamicObject.set(SCHEME_NUM, this.getModel().getValue(SCHEME_NUM));
            dynamicObject.set(EFFECTIVE_DATE, this.getModel().getValue(EFFECTIVE_DATE));
            dynamicObject.set(EXPRIATION_DATE, this.getModel().getValue(EXPRIATION_DATE));
            dynamicObject.set(DATA_LOCK, this.getModel().getValue(DATA_LOCK));
            dynamicObject.set(SRC_VERSION, this.getModel().getValue(SRC_VERSION));
            dynamicObject.set(TAR_VERSION, this.getModel().getValue(TAR_VERSION));
            dynamicObject.set(MODIFIER, (Object)UserUtils.getUserId());
            dynamicObject.set(MODIFY_TIME, (Object)new Date());
            dynamicObject.set(ORG_VIEW, this.getModel().getValue(ORG_VIEW));
            if (SchemeTypeEnum.COPY_SCHEME.getValue().equals(schemeType)) {
                dynamicObject.set(EFFECTIVE_DATE, null);
                dynamicObject.set(EXPRIATION_DATE, null);
                dynamicObject.set(ORG_VIEW, null);
            }
            DynamicObjectCollection ent_srctrial = new DynamicObjectCollection();
            this.fillSrcTrialEntity(ent_srctrial);
            dynamicObject.set(ENT_SRC_TRIAL, (Object)ent_srctrial);
            DynamicObjectCollection ent_tartrial = new DynamicObjectCollection();
            this.fillTarTrialEntity(ent_tartrial);
            dynamicObject.set(ENT_TAR_TRIAL, (Object)ent_tartrial);
            List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
            if (CollectionUtils.isNotEmpty(versionCopyConditionDtos)) {
                dynamicObject.set(DIMMEMBERJSON, (Object)SerializationUtils.toJsonString(versionCopyConditionDtos));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.saveMemberQuote(dynamicObject);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#buildUpdateData", (Throwable)ex);
        }
    }

    private void saveMemberQuote(DynamicObject versionCopy) {
        VersionCopyQuoteUtils.get().saveMemberQuote(new DynamicObject[]{versionCopy});
    }

    private void fillTarTrialEntity(DynamicObjectCollection ent_tartrial) {
        DynamicObjectCollection tartrialObj = this.getModel().getEntryEntity(ENT_TAR_TRIAL);
        if (CollectionUtils.isEmpty((Collection)tartrialObj)) {
            return;
        }
        for (DynamicObject dynamicObject : tartrialObj) {
            DynamicObject row = new DynamicObject(tartrialObj.getDynamicObjectType());
            long aLong = dynamicObject.getLong("tartrial.id");
            if (aLong == 0L) continue;
            row.set(TAR_TRIAL, (Object)aLong);
            ent_tartrial.add((Object)row);
        }
    }

    private void fillSrcTrialEntity(DynamicObjectCollection ent_srctrial) {
        DynamicObjectCollection srctrialObj = this.getModel().getEntryEntity(ENT_SRC_TRIAL);
        if (CollectionUtils.isEmpty((Collection)srctrialObj)) {
            return;
        }
        for (DynamicObject dynamicObject : srctrialObj) {
            DynamicObject row = new DynamicObject(srctrialObj.getDynamicObjectType());
            long aLong = dynamicObject.getLong("srctrial.id");
            if (aLong == 0L) continue;
            row.set(SRC_TRIAL, (Object)aLong);
            ent_srctrial.add((Object)row);
        }
    }

    private void openMulSelectPage(String dimNumber) {
        Optional<VersionCopyConditionDto> first;
        List<VersionCopyConditionDto> versionCopyConditionDtos = this.getVersionCopyConditionDtos();
        HashMap<Long, Integer> selectIds = new HashMap<Long, Integer>(16);
        Long viewId = 0L;
        if (CollectionUtils.isNotEmpty(versionCopyConditionDtos) && (first = versionCopyConditionDtos.stream().filter(x -> x.getDimNumber().equals(dimNumber)).findFirst()).isPresent()) {
            VersionCopyConditionDto versionCopyConditionDto = first.get();
            viewId = versionCopyConditionDto.getViewId();
            List conditions = versionCopyConditionDto.getConditions();
            if (CollectionUtils.isNotEmpty((Collection)conditions)) {
                for (MemberCondition condition : conditions) {
                    selectIds.put(IDUtils.toLong((Object)condition.getId()), Integer.parseInt(condition.getRange()));
                }
            }
        }
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        DynamicObject businessModelDyn = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL);
        if (businessModelDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"VersionCopySchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessModelDyn.getLong("id"), (String)"eb_businessmodel");
        f7Param.setBusModelId(Long.valueOf(dynamicObject.getLong("id")));
        f7Param.setSelectIds(selectIds);
        f7Param.setCanSelectRoot(false);
        f7Param.setReturnAllData(true);
        f7Param.setMustSelected(true);
        f7Param.setCanSelectBudgetPeriodRoot(false);
        f7Param.setVerifyPermission(true);
        f7Param.setEnableView(true);
        f7Param.setViewId(viewId);
        f7Param.setRangeType(F7RangeTypeEnum.ALL);
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, MEMBER));
    }

    private void openF7Page(String dimNumber, String key, boolean isLeaf) {
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        DynamicObject businessModelDyn = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL);
        if (businessModelDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"VersionCopySchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessModelDyn.getLong("id"), (String)"eb_businessmodel");
        f7Param.setBusModelId(Long.valueOf(dynamicObject.getLong("id")));
        f7Param.setSelectIds(this.getEchoIds(key));
        f7Param.setOnlySelLeaf(isLeaf);
        f7Param.setCanSelectRoot(false);
        f7Param.setReturnAllData(true);
        f7Param.setCanSelectBudgetPeriodRoot(false);
        if (dimNumber.equals(SysDimensionEnum.AuditTrail.getNumber())) {
            f7Param.setShowNotEnable(true);
            f7Param.setHideDecompose(false);
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
    }

    private Set<Long> getEchoIds(String key) {
        LinkedHashSet<Long> list = new LinkedHashSet<Long>();
        DynamicObjectCollection values = null;
        String field = null;
        if (DATATYPE_NAME.equals(key)) {
            field = "datatype.id";
            values = this.getModel().getEntryEntity(ENT_DATATYPE);
        } else if (PERIOD_NAME.equals(key)) {
            field = "period.id";
            values = this.getModel().getEntryEntity(ENT_PERIOD);
        } else if (SRC_TRIAL_NAME.equals(key)) {
            field = "srctrial.id";
            values = this.getModel().getEntryEntity(ENT_SRC_TRIAL);
        } else if (TAR_TRIAL_NAME.equals(key)) {
            field = "tartrial.id";
            values = this.getModel().getEntryEntity(ENT_TAR_TRIAL);
        }
        if (values == null || values.size() == 0) {
            return list;
        }
        for (DynamicObject value : values) {
            list.add(IDUtils.toLong((Object)value.get(field)));
        }
        list.remove(null);
        return list;
    }

    private boolean checkReturnData(ListSelectedRowCollection list) {
        for (ListSelectedRow listSelectedRow : list) {
            Map dataMap = listSelectedRow.getDataMap();
            if (dataMap == null || dataMap.get("isleaf") == null) {
                return false;
            }
            boolean isleaf = (Boolean)dataMap.get("isleaf");
            if (isleaf) continue;
            return false;
        }
        return true;
    }

    private void fillEntryEntity(ListSelectedRowCollection list, String key) {
        ArrayList<String> name = new ArrayList<String>(16);
        int rowIndex = 0;
        String entity = null;
        String property = null;
        switch (key) {
            case "datatypename": {
                entity = ENT_DATATYPE;
                property = DATATYPE;
                break;
            }
            case "periodname": {
                entity = ENT_PERIOD;
                property = PERIOD;
                break;
            }
            case "srctrialname": {
                entity = ENT_SRC_TRIAL;
                property = SRC_TRIAL;
                break;
            }
            case "tartrialname": {
                entity = ENT_TAR_TRIAL;
                property = TAR_TRIAL;
                break;
            }
        }
        this.getModel().deleteEntryData(entity);
        if (list.size() == 0) {
            this.getModel().setValue(key, null);
            return;
        }
        int[] index = this.getModel().batchCreateNewEntryRow(entity, list.size());
        this.getModel().beginInit();
        for (ListSelectedRow row : list) {
            name.add(row.getName());
            this.getModel().setValue(property, row.getPrimaryKeyValue(), index[rowIndex]);
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getModel().setValue(key, (Object)String.join((CharSequence)",", name));
    }

    private void setDefaultValue(DynamicObject dynamicObject) {
        try {
            if (dynamicObject != null) {
                Object fid;
                this.getModel().setValue(MODEL, (Object)dynamicObject.getDynamicObject(MODEL).getLong("id"));
                this.getModel().setValue(BUSINESS_MODEL, (Object)dynamicObject.getDynamicObject(BUSINESS_MODEL).getLong("id"));
                this.getModel().setValue(SCHEME_NAME, (Object)dynamicObject.getLocaleString(SCHEME_NAME));
                this.getModel().setValue(SCHEME_NUM, (Object)dynamicObject.getString(SCHEME_NUM));
                this.getModel().setValue(SCHEME_TYPE, (Object)dynamicObject.getInt(SCHEME_TYPE));
                this.getModel().setValue(DATA_LOCK, (Object)dynamicObject.getBoolean(DATA_LOCK));
                this.fillEntryByScheme(dynamicObject);
                this.setTextValue(dynamicObject, ENT_SRC_TRIAL, SRC_TRIAL_NAME, SRC_TRIAL, "srctrial.name", "srctrial.id");
                this.setTextValue(dynamicObject, ENT_TAR_TRIAL, TAR_TRIAL_NAME, TAR_TRIAL, "tartrial.name", "tartrial.id");
                this.getModel().setValue(TAR_VERSION, (Object)dynamicObject.getDynamicObject(TAR_VERSION).getLong("id"));
                this.getModel().setValue(SRC_VERSION, (Object)dynamicObject.getDynamicObject(SRC_VERSION).getLong("id"));
                this.getModel().setValue(EFFECTIVE_DATE, (Object)dynamicObject.getDate(EFFECTIVE_DATE));
                this.getModel().setValue(EXPRIATION_DATE, (Object)dynamicObject.getDate(EXPRIATION_DATE));
                this.getModel().setValue(BILL_STATUS, (Object)dynamicObject.getInt(BILL_STATUS));
                DynamicObject orgViewDyn = dynamicObject.getDynamicObject(ORG_VIEW);
                if (orgViewDyn != null) {
                    this.getModel().setValue(ORG_VIEW, (Object)dynamicObject.getDynamicObject(ORG_VIEW).getLong("id"));
                } else if (orgViewDyn == null && SchemeTypeEnum.DATA_VALIDATION.getValue().equals(dynamicObject.getString(SCHEME_TYPE))) {
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)dynamicObject.getDynamicObject(MODEL).getLong("id"));
                    Long id = modelCacheHelper.getViewByBusModelAndDimNumber(Long.valueOf(dynamicObject.getDynamicObject(BUSINESS_MODEL).getLong("id")), SysDimensionEnum.Entity.getNumber());
                    this.getModel().setValue(ORG_VIEW, (Object)id);
                }
                int billStatus = dynamicObject.getInt(BILL_STATUS);
                if (billStatus == 1) {
                    this.setViewEnable(SRC_VERSION);
                    this.setViewEnable(TAR_VERSION);
                    this.setViewEnable(ORG_VIEW);
                }
                if ((fid = this.getView().getFormShowParameter().getCustomParam("pkid")) != null) {
                    this.setViewEnable(BUSINESS_MODEL);
                    this.setViewEnable(SCHEME_TYPE);
                }
            } else {
                this.fillEntryByScheme(null);
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#setDefaultValue", (Throwable)ex);
        }
    }

    private void fillEntryByScheme(DynamicObject dynamicObject) {
        try {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            if (entryGrid == null) {
                return;
            }
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData(ENTRYENTITY);
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            int index = 0;
            if (dynamicObject == null) {
                dataModel.batchCreateNewEntryRow(ENTRYENTITY, 2);
                for (String dimNumber : DEFAULT_DIM) {
                    Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                    this.getModel().setValue(DIM, (Object)dimension.getId(), index);
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{DIM});
                    ++index;
                }
            } else {
                String dimJson = dynamicObject.getString(DIMMEMBERJSON);
                if (StringUtils.isEmpty((String)dimJson)) {
                    dataModel.batchCreateNewEntryRow(ENTRYENTITY, 2);
                    versionCopyConditionDtos = new ArrayList<VersionCopyConditionDto>(2);
                    for (String dimNumber : DEFAULT_DIM) {
                        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                        this.getModel().setValue(DIM, (Object)dimension.getId(), index);
                        this.getView().setEnable(Boolean.valueOf(false), index, new String[]{DIM});
                        String entityName = SysDimensionEnum.DataType.getNumber().equals(dimNumber) ? ENT_DATATYPE : ENT_PERIOD;
                        String idKey = SysDimensionEnum.DataType.getNumber().equals(dimNumber) ? "datatype.id" : "period.id";
                        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entityName);
                        if (!dynamicObjectCollection.isEmpty()) {
                            VersionCopyConditionDto versionCopyConditionDto = new VersionCopyConditionDto();
                            versionCopyConditionDto.setDimId(dimension.getId());
                            versionCopyConditionDto.setViewId(Long.valueOf(0L));
                            versionCopyConditionDto.setDimNumber(dimNumber);
                            ArrayList<MemberCondition> conditions = new ArrayList<MemberCondition>(16);
                            ArrayList<String> names = new ArrayList<String>(16);
                            for (DynamicObject object : dynamicObjectCollection) {
                                Member member = modelCacheHelper.getMember(dimNumber, null, Long.valueOf(object.getLong(idKey)));
                                if (member == null) continue;
                                conditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
                                names.add(member.getName() + RangeEnum.ONLY.getName());
                            }
                            versionCopyConditionDto.setConditions(conditions);
                            versionCopyConditionDtos.add(versionCopyConditionDto);
                            if (CollectionUtils.isNotEmpty(names)) {
                                this.getModel().setValue(MEMBER, (Object)String.join((CharSequence)";", names), index);
                            }
                        }
                        ++index;
                    }
                    this.cacheVersionCopyConditions(versionCopyConditionDtos);
                } else {
                    List versionCopyConditionDtos;
                    String json = dynamicObject.getString(DIMMEMBERJSON);
                    if (StringUtils.isNotEmpty((String)json) && CollectionUtils.isNotEmpty((Collection)(versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)json, VersionCopyConditionDto.class)))) {
                        dataModel.batchCreateNewEntryRow(ENTRYENTITY, versionCopyConditionDtos.size());
                        for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                            Dimension dimension = modelCacheHelper.getDimension(versionCopyConditionDto.getDimNumber());
                            if (dimension == null) continue;
                            this.getModel().setValue(DIM, (Object)dimension.getId(), index);
                            this.getView().setEnable(Boolean.valueOf(!DEFAULT_DIM.contains(dimension.getNumber())), index, new String[]{DIM});
                            List conditions = versionCopyConditionDto.getConditions();
                            ArrayList<String> names = new ArrayList<String>(16);
                            Long viewId = versionCopyConditionDto.getViewId();
                            for (MemberCondition condition : conditions) {
                                RangeEnum rangeByNumber;
                                Member member = modelCacheHelper.getMember(dimension.getNumber(), viewId, condition.getNumber());
                                if (member == null || (rangeByNumber = RangeEnum.getRangeByVal((String)condition.getRange())) == null) continue;
                                names.add(member.getName() + rangeByNumber.getName());
                            }
                            this.getModel().setValue(DIMVIEW, (Object)viewId, index);
                            if (CollectionUtils.isNotEmpty(names)) {
                                this.getModel().setValue(MEMBER, (Object)String.join((CharSequence)";", names), index);
                            }
                            ++index;
                        }
                        this.cacheVersionCopyConditions(versionCopyConditionDtos);
                    }
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"VersionCopySchemePlugin#fillEntryByScheme", (Throwable)ex);
        }
    }

    private void cacheVersionCopyConditions(List<VersionCopyConditionDto> versionCopyConditionDtos) {
        if (CollectionUtils.isEmpty(versionCopyConditionDtos)) {
            this.getPageCache().remove("versionCopyCondition");
            return;
        }
        this.getPageCache().put("versionCopyCondition", SerializationUtils.toJsonString(versionCopyConditionDtos));
    }

    private List<VersionCopyConditionDto> getVersionCopyConditionDtos() {
        String versionCopyCondition = this.getPageCache().get("versionCopyCondition");
        if (StringUtils.isNotEmpty((String)versionCopyCondition)) {
            return SerializationUtils.fromJsonStringToList((String)versionCopyCondition, VersionCopyConditionDto.class);
        }
        return new ArrayList<VersionCopyConditionDto>(16);
    }

    private void setTextValue(DynamicObject dynamicObject, String entName, String textKey, String property, String namePros, String idPros) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entName);
        if (!dynamicObjectCollection.isEmpty()) {
            ArrayList<String> name = new ArrayList<String>(16);
            this.getModel().deleteEntryData(entName);
            if (dynamicObjectCollection.size() == 0) {
                this.getModel().setValue(textKey, null);
                return;
            }
            int rowIndex = 0;
            int[] index = this.getModel().batchCreateNewEntryRow(entName, dynamicObjectCollection.size());
            this.getModel().beginInit();
            for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                if (StringUtils.isNotEmpty((String)dynamicObject1.getString(namePros))) {
                    name.add(dynamicObject1.getString(namePros));
                    this.getModel().setValue(property, (Object)dynamicObject1.getLong(idPros), index[rowIndex]);
                }
                ++rowIndex;
            }
            this.getModel().endInit();
            if (CollectionUtils.isNotEmpty(name)) {
                this.getModel().setValue(textKey, (Object)String.join((CharSequence)",", name));
            }
        }
    }

    private void setViewEnable(String propertyName) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{propertyName});
    }

    private boolean checkDateRule(Object fid) {
        Date expriationDate = (Date)this.getModel().getValue(EXPRIATION_DATE);
        Date effectiveDate = (Date)this.getModel().getValue(EFFECTIVE_DATE);
        if (effectiveDate != null && expriationDate != null && effectiveDate.compareTo(expriationDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"VersionCopySchemePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkVersionDiff() {
        DynamicObject srcVersion = (DynamicObject)this.getModel().getValue(SRC_VERSION);
        DynamicObject tarVersion = (DynamicObject)this.getModel().getValue(TAR_VERSION);
        return srcVersion.getLong("id") != tarVersion.getLong("id");
    }

    private boolean checkTrialRule() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENT_TAR_TRIAL);
        DynamicObjectCollection entryEntity1 = this.getModel().getEntryEntity(ENT_SRC_TRIAL);
        if (entryEntity.size() != entryEntity1.size()) {
            return false;
        }
        String src_trial_name = (String)this.getModel().getValue(SRC_TRIAL_NAME);
        String tar_trial_name = (String)this.getModel().getValue(TAR_TRIAL_NAME);
        if (src_trial_name.split(",").length != tar_trial_name.split(",").length) {
            return false;
        }
        Set collect = entryEntity.stream().map(x -> x.getLong("tartrial.id")).collect(Collectors.toSet());
        Set collect1 = entryEntity1.stream().map(x -> x.getLong("srctrial.id")).collect(Collectors.toSet());
        if (collect.size() != collect1.size()) {
            return false;
        }
        collect.remove(0L);
        collect1.remove(0L);
        return collect.size() == collect1.size();
    }

    public String getBizCtrlRangeKey() {
        return BUSINESS_MODEL;
    }
}

