/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.workflow;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgs;

public class ApprovalPagePlugin
extends AbstractWorkflowPlugin {
    private static final Log log = LogFactory.getLog(ApprovalPagePlugin.class);

    public void initialize() {
        super.initialize();
        if (this.isApproveBill()) {
            this.getPageCache().put("isNewApprovePage", "true");
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isApproveBill()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("closeApproveBill".equals(actionId)) {
            this.getView().close();
        }
    }

    private boolean isApproveBill() {
        String entityNumber = this.getPageCache().get("entitynumber");
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entityNumber");
        }
        return "eb_approvebill".equals(entityNumber);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isApproveBill()) {
            IFormView parentView = this.getView().getParentView();
            parentView.setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            this.getView().sendFormAction(parentView);
        }
    }

    public void customEvent(CustomEventArgs e) {
        if (e == null) {
            return;
        }
        if (!this.isApproveBill()) {
            return;
        }
        if (e instanceof BeforeSubmitCustomEventArgs) {
            long businessKeyId;
            if (!"pagecacheKeyForSubmit".equals(e.getKey())) {
                return;
            }
            String businessKey = this.getView().getPageCache().get("EPM_APPROVEBILL_KEY");
            if (StringUtils.isEmpty((CharSequence)businessKey)) {
                return;
            }
            BeforeSubmitCustomEventArgs args = (BeforeSubmitCustomEventArgs)e;
            Map submitParams = args.getSubmitParams();
            Object auditType = submitParams.get("auditType");
            if (auditType == null) {
                return;
            }
            try {
                businessKeyId = Long.parseLong(businessKey);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636eid\u5931\u8d25\uff1a%s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ApprovalPagePlugin_2", (String)"bos-ext-fi", (Object[])new Object[]{businessKey}));
                return;
            }
            if (!"approve".equals(auditType.toString()) && !"reject".equals(auditType.toString())) {
                return;
            }
            try {
                Set notDealProcesses = (Set)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"getNotDealProcesses", (Object[])new Object[]{businessKeyId, auditType.toString()});
                if (notDealProcesses.size() != 0) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868: \r\n%s", (String)"ApprovalPagePlugin_0", (String)"bos-ext-fi", (Object[])new Object[]{String.join((CharSequence)"\r\n", notDealProcesses)}));
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u9a73\u56de\u6821\u9a8c\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ApprovalPagePlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]));
                return;
            }
            if ("reject".equals(auditType.toString())) {
                String saveRejectInfo = this.getView().getPageCache().getBigObject("saveRejectInfo");
                String nodeValue = (String)this.getModel().getValue("textfield_nextnodevalue");
                try {
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"saveRejectOpinions", (Object[])new Object[]{businessKeyId, saveRejectInfo, nodeValue});
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                }
            }
        }
    }
}

