/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.entity.BgNumberCell;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.service.AlgoCalcUtils;

public class AdjustDecomposeUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(AdjustDecomposeUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"AdjustDecomposeUpgradeServiceImpl");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)"AdjustDecomposeUp")) {
                    this.excute();
                    UpdateRecordHelper.addRecord((String)"AdjustDecomposeUp", null, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    public void excute() {
        String upSql = " update t_eb_decompose_scheme s set fentityview = (select distinct(fviewid) from t_eb_viewentry where fdimensionid = (select fid from t_eb_dimension where fnumber = 'Entity' and fmodelid = s.fmodel)  and fid = s.fbizmodelid) where fentityview = 0 and fmodel <> 0 and (select distinct(fviewid) from t_eb_viewentry where fdimensionid = (select fid from t_eb_dimension where fnumber = 'Entity' and fmodelid = s.fmodel)  and fid = s.fbizmodelid) is not null ";
        DB.execute((DBRoute)BgBaseConstant.epm, (String)upSql);
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_decomposeadjustsub where fadjusttrial = '0'");
        HashMap<Long, IModelCacheHelper> modelCacheHelperMap = new HashMap<Long, IModelCacheHelper>(16);
        HashMap<Long, List> modelCanAdjustDims = new HashMap<Long, List>(16);
        ArrayList<Object[]> adjustParams = new ArrayList<Object[]>(10);
        try (DataSet ds = DB.queryDataSet((String)"t_eb_decomposeadjustsub", (DBRoute)BgBaseConstant.epm, (String)"select ad.fid,fmodel,fdataset,fdimensionjson,sub.fadjusttrial,sub.fstatus from t_eb_decomposeadjust ad left join t_eb_decomposeadjustsub sub on ad.fid = sub.fid  where  sub.ftype in (1,2) order by fmodel,fbizmodel");){
            while (ds != null && ds.hasNext()) {
                Row adjust = ds.next();
                long modelId = adjust.getLong("fmodel");
                long datasetId = adjust.getLong("fdataset");
                String memberMapStr = adjust.getString("fdimensionjson");
                Map memberMap = (Map)JSON.parseObject((String)memberMapStr, HashMap.class);
                IModelCacheHelper modelCacheHelper = modelCacheHelperMap.computeIfAbsent(modelId, e -> ModelCacheContext.getOrCreate((Long)modelId));
                Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(datasetId));
                List canAdjustDims = modelCanAdjustDims.computeIfAbsent(modelId, e -> new ArrayList(10));
                for (Map.Entry entry : memberMap.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) || SysDimensionEnum.DataType.getNumber().equals(dimNumber) || SysDimensionEnum.Currency.getNumber().equals(dimNumber) || SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) || SysDimensionEnum.Version.getNumber().equals(dimNumber)) continue;
                    String memberNumber = (String)entry.getValue();
                    Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), memberNumber);
                    if (member == null || member.isLeaf() || canAdjustDims.contains(dimNumber)) continue;
                    canAdjustDims.add(dimNumber);
                }
                HashMap<String, Map> cellViewMap = new HashMap<String, Map>(1);
                cellViewMap.put(memberMap.toString(), dimViewMap);
                long status = adjust.getLong("fstatus");
                if ((long)DecomposeStatus.WAIT.getValue().intValue() == status || (long)DecomposeStatus.START.getValue().intValue() == status) {
                    try {
                        BigDecimal adjustTrial = adjust.getBigDecimal("fadjusttrial");
                        this.portionRebackDetailFromEntityInput(modelId, new BgNumberCell(Long.valueOf(datasetId), memberMap, adjustTrial));
                        DataDecomposeService.getInstance().adjustToOlap(modelId, Collections.singletonList(new BgNumberCell(Long.valueOf(datasetId), memberMap, adjustTrial)), cellViewMap);
                    }
                    catch (Exception e2) {
                        log.info("portionRebackDetailFromEntityInput:" + CommonServiceHelper.getStackTraceStr((Throwable)e2));
                    }
                }
                boolean remove = false;
                HashMap newMemberMap = new HashMap(memberMap.size());
                for (Map.Entry entry : memberMap.entrySet()) {
                    Dimension dimension = modelCacheHelper.getDimension((String)entry.getKey());
                    if ((!dimension.isPreset() || SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) && dimension.getNoneNumber().equals(entry.getValue())) {
                        remove = true;
                        continue;
                    }
                    newMemberMap.put(entry.getKey(), entry.getValue());
                }
                if (!remove) continue;
                adjustParams.add(new Object[]{AdjustServiceHelper.toJsonString((Map)AdjustServiceHelper.mapSort(newMemberMap)), newMemberMap.hashCode(), adjust.getLong("fid")});
            }
        }
        if (!adjustParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_decomposeadjust set fdimensionjson = ?,fhashcode = ?  where fid = ?", adjustParams);
        }
        HashMap modelParamMap = new HashMap(16);
        String sql = "select fid,fparams,fmodelid from t_eb_param_setting where fnodeid = 12 or fnodeid = 14";
        try (DataSet ds = DB.queryDataSet((String)"getAdjustParam", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("fmodelid");
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put("fid", row.getLong("fid"));
                data.put("fparams", row.getString("fparams"));
                modelParamMap.put(modelId, data);
            }
        }
        Set hasAdjustModelIds = modelCanAdjustDims.keySet();
        if (!hasAdjustModelIds.isEmpty()) {
            ArrayList<Object[]> addParams = new ArrayList<Object[]>(10);
            ArrayList<Object[]> upParams = new ArrayList<Object[]>(10);
            Date now = TimeServiceHelper.now();
            String modelSql = "select fid,freporttype from t_eb_model where fid in (" + org.apache.commons.lang3.StringUtils.join(hasAdjustModelIds, (String)",") + ")";
            try (DataSet ds = DB.queryDataSet((String)"getAdjustParam", (DBRoute)BgBaseConstant.epm, (String)modelSql);){
                while (ds != null && ds.hasNext()) {
                    StringBuilder adjustnotleaf;
                    List canAdjustDims;
                    Row model = ds.next();
                    long modelId = model.getLong("fid");
                    Map data = (Map)modelParamMap.get(modelId);
                    if (data != null) {
                        Long fid = (Long)data.get("fid");
                        String paramJson = (String)data.get("fparams");
                        HashMap<String, Object> paramMap = StringUtils.isNotEmpty((String)paramJson) ? (HashMap<String, Object>)SerializationUtils.fromJsonString((String)paramJson, Map.class) : new HashMap<String, Object>(16);
                        paramMap.put("adjust", true);
                        canAdjustDims = (List)modelCanAdjustDims.get(modelId);
                        if (canAdjustDims != null) {
                            adjustnotleaf = new StringBuilder();
                            for (String canAdjustDim : canAdjustDims) {
                                adjustnotleaf.append(canAdjustDim).append(",");
                            }
                            paramMap.put("adjustnotleaf", adjustnotleaf.toString());
                        }
                        upParams.add(new Object[]{SerializationUtils.toJsonString(paramMap), fid});
                        continue;
                    }
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                    String reporttype = model.getString("freporttype");
                    int nodeId = ApplicationTypeEnum.isBGMD((String)reporttype) ? 12 : 14;
                    paramMap.put("adjust", true);
                    canAdjustDims = (List)modelCanAdjustDims.get(modelId);
                    if (canAdjustDims != null) {
                        adjustnotleaf = new StringBuilder();
                        for (String canAdjustDim : canAdjustDims) {
                            adjustnotleaf.append(canAdjustDim).append(",");
                        }
                        paramMap.put("adjustnotleaf", adjustnotleaf.toString());
                    }
                    addParams.add(new Object[]{GlobalIdUtil.genGlobalLongId(), nodeId, modelId, SerializationUtils.toJsonString(paramMap), now, now});
                }
            }
            if (!upParams.isEmpty()) {
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_param_setting set fparams = ? where fid = ?", upParams);
            }
            if (!addParams.isEmpty()) {
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_param_setting(fid,fnodeid,fmodelid,fparams,fcreatedate,fmodifydate) values (?,?,?,?,?,?)", addParams);
            }
        }
        this.updateApproveeditnoleafcell();
    }

    public void updateApproveeditnoleafcell() {
        ArrayList<Object[]> upParams = new ArrayList<Object[]>(10);
        String sql = "select fid,fparams,fmodelid from t_eb_param_setting where fnodeid = 12";
        try (DataSet ds = DB.queryDataSet((String)"getAdjustParam", (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                boolean approveeditnoleafcell;
                Row row = ds.next();
                String params = row.getString("fparams");
                if (!StringUtils.isNotEmpty((String)params)) continue;
                boolean update = false;
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
                if (paramMap.get("approveedit") != null && paramMap.get("approveedit") instanceof Boolean) {
                    boolean approveedit = (Boolean)paramMap.get("approveedit");
                    update = true;
                    if (approveedit) {
                        paramMap.put("adjust", true);
                        paramMap.put("approveedit", "1");
                    } else {
                        paramMap.put("approveedit", "0");
                    }
                }
                if (paramMap.get("approveeditnoleafcell") != null && (approveeditnoleafcell = ((Boolean)paramMap.get("approveeditnoleafcell")).booleanValue())) {
                    update = true;
                    paramMap.put("adjust", true);
                    paramMap.put("approveedit", "1");
                }
                if (!update) continue;
                upParams.add(new Object[]{SerializationUtils.toJsonString((Object)paramMap), row.getLong("fid")});
            }
        }
        if (!upParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_param_setting set fparams = ? where fid = ?", upParams);
        }
    }

    public void portionToDetailFromEntityInput(long modelId, List<BgNumberCell> numberCells) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        for (BgNumberCell numberCell : numberCells) {
            List cells = this.queryPortionDetailCell(numberCell, modelCache, true);
            if (cells.isEmpty()) {
                log.warn("\u660e\u7ec6\u6210\u5458\u6570\u636e\u4e3a\u7a7a\uff1a" + JSON.toJSONString((Object)numberCell));
                Map memberMap = numberCell.getMemberMap();
                String memberNumber = (String)memberMap.get(SysDimensionEnum.AuditTrail.getNumber());
                String memberByUse = this.getDirectMemberByUse(modelCache, memberNumber, "40");
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), memberByUse);
                numberCell.setMemberMap(memberMap);
                Long datasetId = numberCell.getDatasetId();
                DataDecomposeService decomposeService = DataDecomposeService.getInstance();
                cells = decomposeService.avgCells(modelCache, numberCell);
                List dimensions = modelCache.getDimensionList(datasetId);
                ArrayList<BGCell> bgCells = new ArrayList<BGCell>(cells.size());
                Map viewMap = modelCache.getViewsByDataSet(datasetId);
                for (IKDCell kdCell : cells) {
                    bgCells.add(AlgoCalcUtils.toBGCell((IKDCell)kdCell, (IModelCacheHelper)modelCache, (List)dimensions, (Map)viewMap));
                }
                decomposeService.saveToOlap(modelCache, datasetId, bgCells, true);
                continue;
            }
            cells = this.portionCells(modelCache, numberCell, cells);
            String auditTrailMember = (String)numberCell.getMemberMap().get(SysDimensionEnum.AuditTrail.getNumber());
            Long datasetId = numberCell.getDatasetId();
            List dimensionList = modelCache.getDimensionList(datasetId);
            Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(datasetId);
            String[] dimensionNums = modelCache.getDimensionNums(datasetId);
            LogStats stats = new LogStats("budget-shrek-log : ");
            stats.addInfo("begin-portionToDetail");
            IShrekSave shrekOlapSave = ShrekOlapServiceHelper.saveDataByIncrement((Model)modelCache.getModelobj(), (Dataset)dataSet, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
            Throwable throwable = null;
            try {
                for (IKDCell cell : cells) {
                    String[] numbers = this.replaceAudit(modelCache, auditTrailMember, cell, dimensionList);
                    shrekOlapSave.add(numbers, (Object)cell.getValue().getDecimal());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (shrekOlapSave == null) continue;
                if (throwable != null) {
                    try {
                        shrekOlapSave.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                shrekOlapSave.close();
            }
        }
    }

    public void portionRebackDetailFromEntityInput(long modelId, BgNumberCell numberCell) {
        numberCell.setValue(numberCell.getValue().negate());
        LinkedList<BgNumberCell> numberCells = new LinkedList<BgNumberCell>();
        numberCells.add(numberCell);
        try {
            this.portionToDetailFromEntityInput(modelId, numberCells);
        }
        catch (Exception e) {
            log.info("portionRebackDetailFromEntityInput:" + CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
    }

    public List<IKDCell> portionCells(IModelCacheHelper modelCache, BgNumberCell numberCell, List<IKDCell> cells) {
        if (cells.size() == 0) {
            return cells;
        }
        BigDecimal value = numberCell.getValue();
        if (cells.size() == 1) {
            cells.get(0).setValue(KDValue.valueOf((BigDecimal)value));
        } else {
            BigDecimal total;
            List<IKDCell> addCells = this.filterAddCell(numberCell, cells, modelCache);
            if (addCells.isEmpty()) {
                total = cells.stream().map(e -> e.getValue().getDecimal().abs()).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                total = addCells.stream().map(e -> e.getValue().getDecimal().abs()).reduce(BigDecimal.ZERO, BigDecimal::add);
                cells = addCells;
            }
            boolean isAvg = total.compareTo(BigDecimal.ZERO) == 0;
            BigDecimal reduce = BigDecimal.ZERO;
            if (isAvg) {
                BigDecimal avgValue = total.divide(new BigDecimal(cells.size()), 2, 4);
                for (IKDCell cell : cells) {
                    cell.setValue(KDValue.valueOf((BigDecimal)avgValue));
                    reduce = reduce.add(avgValue);
                }
            } else {
                for (IKDCell cell : cells) {
                    BigDecimal v = value.multiply(cell.getValue().getDecimal().abs()).divide(total, 2, 4);
                    cell.setValue(KDValue.valueOf((BigDecimal)v));
                    reduce = reduce.add(v);
                }
            }
            cells.sort(Comparator.comparing(e -> e.getValue().getDecimal().abs(), Comparator.reverseOrder()));
            IKDCell diff = cells.get(0);
            BigDecimal oldVal = diff.getValue().getDecimal();
            diff.setValue(KDValue.valueOf((BigDecimal)oldVal.add(value.subtract(reduce))));
        }
        return cells;
    }

    private List<IKDCell> filterAddCell(BgNumberCell numberCell, List<IKDCell> cells, IModelCacheHelper modelCache) {
        ArrayList<IKDCell> addCells = new ArrayList<IKDCell>(cells.size());
        cells.forEach(e -> {
            Map<String, Member> memberMap = this.toMemberMap((IKDCell)e, modelCache, numberCell.getDatasetId());
            Member accMember = memberMap.get(SysDimensionEnum.Account.getNumber());
            if (AggOprtEnum.ADD.getSign().equals(accMember.getAggType())) {
                addCells.add((IKDCell)e);
            }
        });
        return addCells;
    }

    private Map<String, Member> toMemberMap(IKDCell cell, IModelCacheHelper modelCache, Long datasetId) {
        String[] number = cell.getMeta().getNumber();
        List dimensions = modelCache.getDimensionList(datasetId);
        Map viewMap = modelCache.getViewsByDataSet(datasetId);
        LinkedHashMap<String, Member> map = new LinkedHashMap<String, Member>(16);
        for (int i = 0; i < dimensions.size(); ++i) {
            String dimNumber = ((Dimension)dimensions.get(i)).getNumber();
            Member member = modelCache.getMember(dimNumber, (Long)viewMap.get(dimNumber), number[i]);
            map.put(dimNumber, member);
        }
        return map;
    }

    private String[] replaceAudit(IModelCacheHelper modelCache, String auditTrailMember, IKDCell cell, List<Dimension> dimensionList) {
        String[] number = cell.getMeta().getNumber();
        for (int i = 0; i < dimensionList.size(); ++i) {
            Dimension dimension = dimensionList.get(i);
            if (!SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber())) continue;
            number[i] = this.getDirectMemberByUse(modelCache, auditTrailMember, "40");
            break;
        }
        return number;
    }

    public String getDirectMemberByUse(IModelCacheHelper modelCache, String memberNumber, String use) {
        Member member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, memberNumber);
        Member resultMember = null;
        if (member.isLeaf()) {
            resultMember = this.getBrotherMember(modelCache, member, null, use);
        } else {
            List childrens = member.getChildren();
            for (Member children : childrens) {
                if (!StringUtils.equals((String)use, (String)children.getAuditTrailUse())) continue;
                resultMember = children;
                break;
            }
            if (resultMember == null) {
                resultMember = this.getBrotherMember(modelCache, member, null, use);
            }
        }
        if (resultMember == null) {
            if ("40".equals(use)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u65e0\u76f4\u63a5\u4e0b\u7ea7\u6216\u5e73\u7ea7\u8c03\u6574\u5206\u89e3\u7528\u9014\u7684\u6210\u5458\u3002", (String)"BudgetDataDecomposeService_04", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if ("10".equals(use)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u65e0\u76f4\u63a5\u4e0b\u7ea7\u6216\u5e73\u7ea7\u62a5\u8868\u7f16\u5236\u7528\u9014\u7684\u6210\u5458\u3002", (String)"BudgetDataDecomposeService_03", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u65e0\u76f4\u63a5\u4e0b\u7ea7\u6216\u5e73\u7ea7\u7528\u9014\u7684\u6210\u5458\u3002", (String)"BudgetDataDecomposeService_05", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return resultMember.getNumber();
    }

    private Member getBrotherMember(IModelCacheHelper modelCache, Member member, Long viewId, String use) {
        if (StringUtils.equals((String)use, (String)member.getAuditTrailUse())) {
            return member;
        }
        List brothers = modelCache.getBrother(viewId, member, false);
        for (Member brother : brothers) {
            if (!StringUtils.equals((String)use, (String)brother.getAuditTrailUse())) continue;
            return brother;
        }
        return null;
    }

    public List<IKDCell> queryPortionDetailCell(BgNumberCell numberCell, IModelCacheHelper modelCache, boolean isChangeAuditTrail) {
        Long datasetId = numberCell.getDatasetId();
        List dimensions = modelCache.getDimensionList(datasetId);
        Map viewMap = modelCache.getViewsByDataSet(datasetId);
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        for (Dimension dim : dimensions) {
            String[] array;
            String dimNumber = dim.getNumber();
            String memberNumber = AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)dim, (Map)numberCell.getMemberMap(), (Map)viewMap);
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                queryInfo.addFilter(dimNumber, new String[]{memberNumber});
                continue;
            }
            if (isChangeAuditTrail && SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                queryInfo.addFilter(dimNumber, new String[]{this.getDirectMemberByUse(modelCache, memberNumber, "10")});
                continue;
            }
            List details = modelCache.getMember(dimNumber, (Long)viewMap.get(dimNumber), memberNumber, RangeEnum.ALL_DETAIL.getIndex());
            if (SysDimensionEnum.Account.getNumber().endsWith(dimNumber)) {
                array = (String[])details.stream().filter(e -> AggOprtEnum.ADD.getSign().equals(e.getAggType())).map(BaseCache::getNumber).toArray(String[]::new);
                if (array.length < 1) {
                    log.warn("\u6ca1\u6709\u79d1\u76ee\u4e3a\u2018\u52a0\u2019\u7684\u6210\u5458");
                    return Collections.emptyList();
                }
            } else {
                array = (String[])details.stream().map(BaseCache::getNumber).toArray(String[]::new);
            }
            if (array.length == 0) continue;
            queryInfo.addFilter(dimNumber, array);
        }
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(datasetId);
        queryInfo.setDimensions(Arrays.asList(modelCache.getDimensionNums(datasetId)));
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(10);
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)modelCache.getModelobj(), (Dataset)dataSet, (SelectCommandInfo)queryInfo, (LogStats)new LogStats("portionToDetailFromEntityInput"));){
            while (reader.hasNext()) {
                Object[] row = reader.next();
                IKDCell cell = KDCell.of((Object[])row);
                if (cell == null) {
                    row[0] = 0;
                    cell = KDCell.of((Object[])row);
                }
                cells.add(cell);
            }
        }
        catch (Exception e2) {
            log.info(CommonServiceHelper.getStackTraceStr((Throwable)e2));
        }
        return cells;
    }
}

