/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections.CollectionUtils;

public class ApplicationScenarioUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List<Long> needPreSetModeIds;
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block18: {
            UpgradeResult upgradeResult;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    tx = TX.requiresNew((String)"ApplicationScenarioUpgradeService");
                    throwable = null;
                    needPreSetModeIds = this.checkNeedPreSet();
                    if (!CollectionUtils.isEmpty(needPreSetModeIds)) break block18;
                    result.setSuccess(true);
                    result.setLog("all model has Target_sys application scenario, so don't need preset.");
                    upgradeResult = result;
                    if (tx == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.perSetApplicationScenario(needPreSetModeIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private void perSetApplicationScenario(List<Long> needPreSetModeIds) {
        if (CollectionUtils.isEmpty(needPreSetModeIds)) {
            return;
        }
        StringBuilder sql = new StringBuilder("insert into t_eb_applicationscenario (fid,fmodifierid,fcreatorid,fcreatetime,fmodifytime,fmodelid,fname,fnumber,fissyspreset,fdescription)").append(" values ").append("(?,?,?,?,?,?,?,'Target_sys','1','sys')");
        String name = ResManager.loadKDString((String)"\u76ee\u6807\u6d4b\u7b97", (String)"ApplicationScenarioUpgradeServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(needPreSetModeIds.size());
        for (Long modelId : needPreSetModeIds) {
            Object[] param = new Object[7];
            long id = GlobalIdUtil.genGlobalLongId();
            param[0] = id;
            param[1] = UserUtils.getUserId();
            param[2] = UserUtils.getUserId();
            param[3] = TimeServiceHelper.now();
            param[4] = TimeServiceHelper.now();
            param[5] = modelId;
            param[6] = name;
            paramList.add(param);
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)DB_EPM, (String)sql.toString(), paramList);
        }
    }

    private List<Long> checkNeedPreSet() {
        String sql = "select distinct fid from t_eb_model  where freporttype = '7'  and fid not in (select distinct fmodelid from t_eb_applicationscenario where fnumber = 'Target_sys')";
        try (DataSet ds = DB.queryDataSet((String)"queryId", (DBRoute)DB_EPM, (String)sql);){
            ArrayList<Long> modelIds = new ArrayList<Long>(10);
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fid = row.getLong("fid");
                modelIds.add(fid);
            }
            ArrayList<Long> arrayList = modelIds;
            return arrayList;
        }
    }
}

