/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections.CollectionUtils;

public class ApprovePlanTransplantServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "ApprovePlanTransplantService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"ApplicationScenarioUpgradeService");){
            if (this.checkNeedUpgrade()) {
                if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                    this.transplantData();
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                    result.setLog("t_eb_centralappplan transplant success.");
                } else {
                    result.setLog("this script had invoke.");
                }
                result.setSuccess(true);
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
            result.setSuccess(true);
            result.setLog("table t_eb_centralappplan don't need transplant.");
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    private void transplantData() {
        String sql = "select fid,fcentralizedstatus from t_eb_centralappplan";
        ArrayList paramList = new ArrayList(10);
        DB.query((DBRoute)DB_EPM, (String)sql, rs -> {
            while (rs.next()) {
                Object[] param = new Object[]{rs.getString("fcentralizedstatus").trim(), rs.getLong("fid")};
                paramList.add(param);
            }
            return paramList;
        });
        String plantSql = "update t_eb_centralappplan set fcentrastatus = ? where fid = ?";
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)DB_EPM, (String)plantSql, paramList);
        }
    }

    private boolean checkNeedUpgrade() {
        List columns = DB.getColumnNames((DBRoute)DB_EPM, (String)"t_eb_centralappplan");
        for (String columnName : columns) {
            if (!"fcentralizedstatus".equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }
}

