/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class BGRPFuncPermUpServiceImpl
implements IUpgradeService {
    private static final String PLANT_KEY = "BGRPFuncPermUpServiceImpl";
    private final Object[] toUpEntityKeys = new Object[]{"eb_rptpreparation_nbg", "bgm_rptpreparation", "eb_executeanalyselist_nbg", "eb_executeanalyselist", "eb_execanalysereport_nbg", "eb_execanalysereport", "eb_diffanalysis_nbg", "eb_diffanalysis", "eb_relexecuterecord_nbg", "eb_relexecuterecord", "bgm_report_share_list_nbg", "bgm_report_share_list", "eb_executetask", "bgm_adjustbill", "bgm_adjpstbill", "eb_approvebill"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
            try (TXHandle tx = TX.requiresNew((String)PLANT_KEY);){
                try {
                    this.upFunPerm();
                    this.upRolePerm();
                    PermissionServiceHelper.clearAllCache();
                    result.setSuccess(true);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setLog(e.getMessage());
                    result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)e));
                    tx.markRollback();
                    UpgradeResult upgradeResult = result;
                    if (tx != null) {
                        if (var7_7 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return upgradeResult;
                }
            }
            UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
        }
        return result;
    }

    private void upRolePerm() {
        AppInfo bgrpAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGRP.getAppnum());
        AppInfo ebAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        AppInfo bgmAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGM.getAppnum());
        ArrayList<Object[]> newPermRowData = new ArrayList<Object[]>(16);
        ArrayList<Object[]> upPermRowData = new ArrayList<Object[]>(16);
        DBRoute dbRoute = new DBRoute("sys");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fentryid,fseq,fcontrolmode,fpermitemid,finheritmode,fentitytypeid,fbizappid,froleid from t_perm_rolepermdetial where ", new Object[0]);
        sqlBuilder.appendIn(" fbizappid", new Object[]{ebAppInfo.getId(), bgmAppInfo.getId()});
        sqlBuilder.appendIn(" and fentitytypeid ", this.toUpEntityKeys);
        try (DataSet dataSet = DB.queryDataSet((String)"queryuserpermdetail", (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                Object[] newRowData = new Object[9];
                newRowData[0] = row.getString("fid");
                newRowData[1] = null;
                newRowData[2] = row.getInteger("fseq");
                newRowData[3] = row.getString("fcontrolmode");
                newRowData[4] = row.getString("fpermitemid");
                newRowData[5] = row.getString("finheritmode");
                String oldFormKey = row.getString("fentitytypeid");
                String newFormKey = this.matchNewFormKey(oldFormKey);
                if (newFormKey == null) {
                    newRowData[6] = oldFormKey;
                } else {
                    newRowData[6] = newFormKey;
                    upPermRowData.add(new Object[]{newFormKey, row.getString("fentryid")});
                }
                newRowData[7] = bgrpAppInfo.getId();
                newRowData[8] = row.get("froleid");
                newPermRowData.add(newRowData);
            }
        }
        if (newPermRowData.size() > 0) {
            String[] stringIds = GlobalIdUtil.genStringIds((int)newPermRowData.size());
            for (int seq = 0; seq < newPermRowData.size(); ++seq) {
                ((Object[])newPermRowData.get((int)seq))[1] = stringIds[seq];
            }
            String insertSql = "insert into t_perm_rolepermdetial(fid,fentryid,fseq,fcontrolmode,fpermitemid,finheritmode,fentitytypeid,fbizappid,froleid) values(?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, newPermRowData);
        }
        if (upPermRowData.size() > 0) {
            String updateSql = "update t_perm_rolepermdetial set fentitytypeid = ? where fentryid = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, upPermRowData);
        }
    }

    private void upFunPerm() {
        ArrayList<Object[]> newPermRowData = new ArrayList<Object[]>(16);
        ArrayList<Object[]> upPermRowData = new ArrayList<Object[]>(16);
        AppInfo bgrpAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGRP.getAppnum());
        AppInfo ebAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        AppInfo bgmAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGM.getAppnum());
        DBRoute dbRoute = new DBRoute("sys");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fbizappid,fbizroleid,fcontrolmode,fdimid,fdimtype,fentitytypeid,fentryid,fid,fisincludesub,fpermitemid,fseq,fsource,fuserid from t_perm_userpermdetail where ", new Object[0]);
        sqlBuilder.append(" fdimtype = 'epm_model'", new Object[0]);
        sqlBuilder.appendIn(" and fbizappid", new Object[]{ebAppInfo.getId(), bgmAppInfo.getId()});
        sqlBuilder.appendIn(" and fentitytypeid ", this.toUpEntityKeys);
        try (DataSet dataSet = DB.queryDataSet((String)"queryuserpermdetail", (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                Object[] newRowData = new Object[13];
                newRowData[0] = bgrpAppInfo.getId();
                newRowData[1] = row.getLong("fbizroleid");
                newRowData[2] = row.getString("fcontrolmode");
                newRowData[3] = row.getLong("fdimid");
                newRowData[4] = row.getString("fdimtype");
                String oldFormKey = row.getString("fentitytypeid");
                String newFormKey = this.matchNewFormKey(oldFormKey);
                if (newFormKey == null) {
                    newRowData[5] = oldFormKey;
                } else {
                    newRowData[5] = newFormKey;
                    upPermRowData.add(new Object[]{newFormKey, row.getString("fentryid")});
                }
                newRowData[6] = null;
                newRowData[7] = row.getString("fid");
                newRowData[8] = row.get("fisincludesub");
                newRowData[9] = row.getString("fpermitemid");
                newRowData[10] = row.getInteger("fseq");
                newRowData[11] = row.getString("fsource");
                newRowData[12] = row.getLong("fuserid");
                newPermRowData.add(newRowData);
            }
        }
        if (newPermRowData.size() > 0) {
            String[] stringIds = GlobalIdUtil.genStringIds((int)newPermRowData.size());
            for (int seq = 0; seq < newPermRowData.size(); ++seq) {
                ((Object[])newPermRowData.get((int)seq))[6] = stringIds[seq];
            }
            String insertSql = "insert into t_perm_userpermdetail(fbizappid,fbizroleid,fcontrolmode,fdimid,fdimtype,fentitytypeid,fentryid,fid,fisincludesub,fpermitemid,fseq,fsource,fuserid) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, newPermRowData);
        }
        if (upPermRowData.size() > 0) {
            String updateSql = "update t_perm_userpermdetail set fentitytypeid = ? where fentryid = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, upPermRowData);
        }
    }

    private String matchNewFormKey(String oldFormKey) {
        String newFormKey = null;
        switch (oldFormKey) {
            case "eb_rptpreparation_nbg": {
                newFormKey = "bgm_rptpreparation";
                break;
            }
            case "eb_executeanalyselist_nbg": {
                newFormKey = "eb_executeanalyselist";
                break;
            }
            case "bgm_report_share_list_nbg": {
                newFormKey = "bgm_report_share_list";
                break;
            }
            case "eb_diffanalysis_nbg": {
                newFormKey = "eb_diffanalysis";
                break;
            }
            case "eb_relexecuterecord_nbg": {
                newFormKey = "eb_relexecuterecord";
                break;
            }
            case "eb_execanalysereport_nbg": {
                newFormKey = "eb_execanalysereport";
            }
        }
        return newFormKey;
    }
}

