/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class BgControlDimRuleUpServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "BgControlDimRuleUpService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"BgControlDimRuleUpServiceImpl");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                    this.excute();
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void excute() {
        String sql = "select fentryid,fqfilter,fserqfilter from t_eb_dimmaterulebill where fqfilter like '% in%'";
        try (DataSet ds = DB.queryDataSet((String)"queryId", (DBRoute)DB_EPM, (String)sql);){
            String upSql = "update t_eb_dimmaterulebill set fqfilter = ?, fserqfilter = ? where fentryid = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String serqfilter = row.getString("fserqfilter");
                Map map = (Map)SerializationUtils.deSerializeFromBase64((String)serqfilter);
                Map tabpageapQfMap = (Map)map.get("tabpageapQf");
                QFilter fqfilter = QFilter.of((String)row.getString("fqfilter"), (Object[])new Object[0]);
                LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
                qFilterList.add(fqfilter);
                List nests = fqfilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter qFilter = nest.getFilter();
                    qFilterList.add(qFilter);
                }
                for (int i = 0; i < qFilterList.size(); ++i) {
                    QFilter qFilter = (QFilter)qFilterList.get(i);
                    String cp = qFilter.getCP();
                    if (!"in".equals(cp) && !"not in".equals(cp)) continue;
                    Object value = qFilter.getValue();
                    if (value instanceof Collection && ((Collection)value).size() > 1) {
                        String centerKey = "center" + (i + 1);
                        String centerValue = (String)tabpageapQfMap.get(centerKey);
                        if ("9".equals(centerValue)) {
                            tabpageapQfMap.put(centerKey, "11");
                            continue;
                        }
                        if (!"10".equals(centerValue)) continue;
                        tabpageapQfMap.put(centerKey, "12");
                        continue;
                    }
                    qFilter.__setCP("in".equals(cp) ? "LIKE" : "NOT LIKE");
                }
                Object[] param = new Object[]{fqfilter.toString(), SerializationUtils.serializeToBase64((Object)map), row.getLong("fentryid")};
                paramList.add(param);
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DB_EPM, (String)upSql, paramList);
            }
        }
    }
}

