/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.ControlMessageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.OpBizRuleUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.BgContParamUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.eums.ControlCauseEnum;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.ICalcParameter;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IControlResult;
import kd.epm.eb.control.impl.CalcMemberParameter;
import kd.epm.eb.control.impl.ControlParameter;
import kd.epm.eb.control.impl.QueryBalanceImpl;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.QueryFieldByBill;
import kd.epm.eb.service.BgControlService;

public class BgControlServiceImpl
implements BgControlService {
    public Object requestBudget(String entityNumber, String bizId, String operationKey) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        return call.requestBudget(entityNumber, bizId, operationKey);
    }

    public Object requestBudget(String entityNumber, String bizId, String operationKey, boolean isToJson) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        IControlResult iControlResult = call.requestBudget(entityNumber, bizId, operationKey);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", iControlResult.getResult().getNumber());
        map.put("alias", iControlResult.getResult().getAlias());
        String json = null;
        try {
            json = JSONUtils.toString(map);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return json;
    }

    public Object requestBudget(DynamicObject bizObj, String operationKey) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        return call.requestBudget(bizObj, operationKey);
    }

    public Object requestBudget1(DynamicObject bizObj, String operationKey, String upstreamId) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        return call.requestBudget(bizObj, operationKey, upstreamId);
    }

    public Object specialBudget(DynamicObject bizObj, String operation) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        return call.specialBudget(bizObj, operation);
    }

    public Object negativeBudget(DynamicObject bizObj, String operation) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        return call.negativeBudget(bizObj, operation);
    }

    public Object negativeBudget(String entityNumber, String bizId, String operation) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        return call.negativeBudget(entityNumber, bizId, operation);
    }

    public void returnBudget(String entityNumber, String bizId, String operationKey) {
        BgControlCallerImpl call = new BgControlCallerImpl();
        call.returnBudget(entityNumber, bizId, operationKey);
    }

    public String queryBalance(DynamicObject bizObj) {
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            return null;
        }
        BgControlCallerImpl caller = new BgControlCallerImpl();
        Collection balances = caller.queryBalance(bizObj);
        String jsonStr = null;
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(balances.size());
            for (IBudgetBalance balance : balances) {
                tmpColls.add(balance.toMap());
            }
            jsonStr = JSONUtils.toString(tmpColls);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return jsonStr;
    }

    public String queryBalance(String entityNumber, String bizId) {
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)bizId)) {
            return null;
        }
        BgControlCallerImpl caller = new BgControlCallerImpl();
        Collection balances = caller.queryBalance(entityNumber, bizId);
        String jsonStr = null;
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(balances.size());
            for (IBudgetBalance balance : balances) {
                tmpColls.add(balance.toMap());
            }
            jsonStr = JSONUtils.toString(tmpColls);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return jsonStr;
    }

    public String queryMemBalance(Long modelId, List<Map<String, String>> members) {
        ArrayList<String> types = new ArrayList<String>();
        BizModel model = ModelUtils.getBizModel((Long)modelId);
        ArrayList dimensionByModel = new ArrayList(16);
        HashMap allDimensionMem = new HashMap(16);
        QFBuilder builder = new QFBuilder();
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        builder.add(qfModel);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel, issysdimension", (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> {
            Dimension dimension = Dimension.loadFromDynamicobject((DynamicObject)dim);
            dimension.setModelId(modelId);
            dimensionByModel.add(dimension);
        });
        for (Dimension dimension : dimensionByModel) {
            DynamicObjectCollection dimensions = QueryServiceHelper.query((String)dimension.getMemberModel(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimension.getId())});
            ArrayList<String> list = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : dimensions) {
                list.add(dynamicObject.getString("number"));
            }
            allDimensionMem.put(dimension.getNumber(), list);
        }
        for (Map map : members) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) {
                map.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
            }
            if (model.isEBByModel()) {
                map.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
                map.put(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
            }
            for (Map.Entry mapEntry : allDimensionMem.entrySet()) {
                String value = (String)map.get(mapEntry.getKey());
                if (value == null || ((List)mapEntry.getValue()).contains(value)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"BgControlServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{mapEntry.getKey(), value}));
            }
        }
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        return this.queryBalance(modelId, members, types);
    }

    public String queryMemBalance(Long modelId, List<Map<String, String>> members, Long bussinessModelId) {
        ArrayList<String> types = new ArrayList<String>();
        BizModel model = ModelUtils.getBizModel((Long)modelId);
        ArrayList dimensionByModel = new ArrayList(16);
        HashMap allDimensionMem = new HashMap(16);
        QFBuilder builder = new QFBuilder();
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        builder.add(qfModel);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel, issysdimension", (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> {
            Dimension dimension = Dimension.loadFromDynamicobject((DynamicObject)dim);
            dimension.setModelId(modelId);
        });
        for (Dimension dimension : dimensionByModel) {
            DynamicObjectCollection dimensions = QueryServiceHelper.query((String)dimension.getMemberModel(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimension.getId())});
            ArrayList<String> list = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : dimensions) {
                list.add(dynamicObject.getString("number"));
            }
            allDimensionMem.put(dimension.getNumber(), list);
        }
        for (Map map : members) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) {
                map.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
            }
            if (model.isEBByModel()) {
                map.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
                map.put(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
            }
            for (Map.Entry mapEntry : allDimensionMem.entrySet()) {
                String value = (String)map.get(mapEntry.getKey());
                if (value == null || ((List)mapEntry.getValue()).contains(value)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"BgControlServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{mapEntry.getKey(), value}));
            }
        }
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        return this.queryBalance(modelId, members, types, bussinessModelId);
    }

    public String queryMemberBalance(Long modelId, List<Map<String, String>> members, Boolean hasSetQueryRule) {
        ArrayList<String> types = new ArrayList<String>();
        BizModel model = ModelUtils.getBizModel((Long)modelId);
        ArrayList dimensionByModel = new ArrayList(16);
        HashMap allDimensionMem = new HashMap(16);
        QFBuilder builder = new QFBuilder();
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        builder.add(qfModel);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel, issysdimension", (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> {
            Dimension dimension = Dimension.loadFromDynamicobject((DynamicObject)dim);
            dimension.setModelId(modelId);
            dimensionByModel.add(dimension);
        });
        for (Dimension dimension : dimensionByModel) {
            DynamicObjectCollection dimensions = QueryServiceHelper.query((String)dimension.getMemberModel(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimension.getId())});
            ArrayList<String> list = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : dimensions) {
                list.add(dynamicObject.getString("number"));
            }
            allDimensionMem.put(dimension.getNumber(), list);
        }
        for (Map map : members) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) {
                map.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
            }
            if (model.isEBByModel()) {
                map.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
                map.put(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
            }
            for (Map.Entry mapEntry : allDimensionMem.entrySet()) {
                String value = (String)map.get(mapEntry.getKey());
                if (value == null || ((List)mapEntry.getValue()).contains(value)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"BgControlServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{mapEntry.getKey(), value}));
            }
        }
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        return this.queryBalanceWithoutCentralized(modelId, members, types, hasSetQueryRule);
    }

    public String queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types) {
        if (modelId == 0L || members == null || members.isEmpty()) {
            return null;
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter((ICalcParameter)new CalcMemberParameter(modelId, members, types));
        Collection balances = new QueryBalanceImpl((IControlParameter)parameter).queryMemberBalance();
        String jsonStr = null;
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(balances.size());
            for (IBudgetBalance balance : balances) {
                tmpColls.add(balance.toMap());
            }
            jsonStr = JSONUtils.toString(tmpColls);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return jsonStr;
    }

    public String queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, Long bussinessModelId) {
        if (modelId == 0L || members == null || members.isEmpty()) {
            return null;
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter((ICalcParameter)new CalcMemberParameter(modelId, members, types, bussinessModelId));
        Collection balances = new QueryBalanceImpl((IControlParameter)parameter).queryMemberBalance();
        String jsonStr = null;
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(balances.size());
            for (IBudgetBalance balance : balances) {
                tmpColls.add(balance.toMap());
            }
            jsonStr = JSONUtils.toString(tmpColls);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return jsonStr;
    }

    public String queryBalanceWithoutCentralized(Long modelId, List<Map<String, String>> members, Collection<String> types, Boolean hasSetQueryRule) {
        if (modelId == 0L || members == null || members.isEmpty()) {
            return null;
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setQueryCentralized(false);
        parameter.setCalcParameter((ICalcParameter)new CalcMemberParameter(modelId, members, types, hasSetQueryRule.booleanValue()));
        Collection balances = new QueryBalanceImpl((IControlParameter)parameter).queryMemberBalance();
        String jsonStr = null;
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(balances.size());
            for (IBudgetBalance balance : balances) {
                tmpColls.add(balance.toMap());
            }
            jsonStr = JSONUtils.toString(tmpColls);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return jsonStr;
    }

    public void closeBudget(String entityNumber, String bizId, String operationKey) {
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)bizId) || StringUtils.isEmpty((String)operationKey)) {
            return;
        }
        BgControlCallerImpl caller = new BgControlCallerImpl();
        caller.closeBudget(entityNumber, bizId, operationKey);
    }

    public void reopenBudget(String entityNumber, String bizId, String operation) {
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)bizId)) {
            return;
        }
        BgControlCallerImpl caller = new BgControlCallerImpl();
        caller.reopenBudget(entityNumber, bizId, operation);
    }

    public boolean isControl(String entityNumber, Long orgUnitId) {
        return BgContParamUtils.isControl((boolean[])this.getControlParam(entityNumber, orgUnitId));
    }

    public boolean isShowBalance(String entityNumber, Long orgUnitId) {
        return BgContParamUtils.isShowBalance((boolean[])this.getControlParam(entityNumber, orgUnitId));
    }

    public boolean isShowCheckMemPermission(String entityNumber, Long orgUnitId) {
        return BgContParamUtils.isShowCheckMemPermission((boolean[])this.getControlParam(entityNumber, orgUnitId));
    }

    public boolean isShowBeyondMessage(String entityNumber, Long orgUnitId) {
        return BgContParamUtils.isShowBeyondMessage((boolean[])this.getControlParam(entityNumber, orgUnitId));
    }

    public boolean[] getControlParam(String entityNumber, Long orgUnitId) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            throw new KDBizException("entityNumber is null.");
        }
        if (orgUnitId == null || orgUnitId == 0L) {
            throw new KDBizException("orgUnitId is null.");
        }
        return BgContParamUtils.getManagerParam((String)entityNumber, (Long)orgUnitId);
    }

    public void clearCentralizedCache(Long modelId) {
    }

    public void clearCentralizedCache(Long modelId, Long dimensionId) {
    }

    public JSONObject isBeyond(DynamicObject[] bizObjs, String operationKey) {
        for (DynamicObject bizObj : bizObjs) {
            BgControlCallerImpl call = new BgControlCallerImpl();
            String entityNumber = EntityUtils.getEntityNumber((DynamicObject)bizObj);
            IControlResult controlResult = call.isBeyond(bizObj, operationKey);
            JSONObject jsonObject = new JSONObject();
            if (controlResult.getResult() != ControlResultEnum.BEYOND) continue;
            List cause = controlResult.getCause();
            Boolean showBeyondMessage = controlResult.getShowBeyondMessage();
            String typeNumber = ControlMessageTypeEnum.BEYOND_BUDGET_TIP.getNumber();
            if (cause.stream().anyMatch(c -> c.getCause() == ControlCauseEnum.BYOND)) {
                List beyondCauses = cause.stream().filter(c -> c.getCause() == ControlCauseEnum.BYOND).collect(Collectors.toList());
                jsonObject.put("message", (Object)BgControlUtils.getControlMessage(beyondCauses, (String)entityNumber, (Boolean)showBeyondMessage, (String)typeNumber));
                jsonObject.put("canBeyond", (Object)"false");
                return jsonObject;
            }
            if (!cause.stream().anyMatch(c -> c.getCause() == ControlCauseEnum.PERMIT)) continue;
            List permitCauses = cause.stream().filter(c -> c.getCause() == ControlCauseEnum.PERMIT).collect(Collectors.toList());
            jsonObject.put("message", (Object)BgControlUtils.getControlMessage(permitCauses, (String)entityNumber, (Boolean)showBeyondMessage, (String)typeNumber));
            jsonObject.put("canBeyond", (Object)"true");
            return jsonObject;
        }
        return null;
    }

    public String checkOperation(String entityNumber) {
        return OpBizRuleUtils.checkOperation((String)entityNumber);
    }

    public void releaseBudget(String entityNumber, String bizId, String entryId) {
        BgControlCallerImpl caller = new BgControlCallerImpl();
        caller.releaseEntryBudget(entityNumber, bizId, entryId);
    }

    public void budgetRollBack(String entityNumber, Set<String> bizIds) {
        new BgControlCallerImpl().budgetRollBack(entityNumber, bizIds, null);
    }

    public void budgetRollBack(String entityNumber, Set<String> bizIds, String requestId) {
        new BgControlCallerImpl().budgetRollBack(entityNumber, bizIds, requestId);
    }

    public void requestSuccess(String entityNumber, Set<String> bizIds) {
        new BgControlCallerImpl().requestSuccess(entityNumber, bizIds, null);
    }

    public void requestSuccess(String entityNumber, Set<String> bizIds, String requestId) {
        new BgControlCallerImpl().requestSuccess(entityNumber, bizIds, requestId);
    }

    public Set<String> getQueryField(String entityNumber) {
        return QueryFieldByBill.queryFieldByDefault((String)entityNumber, (boolean)true, (boolean)false);
    }

    public boolean isSimpleField(String entityNumber) {
        return QueryFieldByBill.isSimpleField((String)entityNumber);
    }
}

