/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.expr.business.AccountExpr;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.utils.ExprServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.service.CalcService;

public class CalcServiceImpl
implements CalcService {
    private static Log log = LogFactory.getLog(CalcServiceImpl.class);

    public void calcFormula(Long modelId, List<Long> bizruleId, Map<String, Set<String>> calcRange) {
        if (modelId == null || modelId == 0L || bizruleId == null || bizruleId.isEmpty()) {
            return;
        }
        ArrayList<AccountExpr> exprs = new ArrayList<AccountExpr>();
        AccountExpr accountExpr = ExprServiceHelper.loadFromReportAccExpr(bizruleId, calcRange);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String cubeNumber = modelCacheHelper.getModelobj().getCubeNumber();
        if (accountExpr != null && accountExpr.getFormulas() != null && accountExpr.getFormulas().size() > 0) {
            exprs.add(accountExpr);
        }
        ScriptCommand command = null;
        if (!exprs.isEmpty()) {
            try {
                for (IExpress iExpress : exprs) {
                    command = ScriptCommand.getIntance((OlapConnection)ScriptCommand.getOlapConnection((String)cubeNumber));
                    command.execute(modelCacheHelper, iExpress);
                }
            }
            catch (Exception ex) {
                log.error("calcFormula", (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public void calcAggrageAndFormula(Long modelId, String cubeNumber, Long templateId, boolean isSave, Map<String, Set<String>> calcParams) {
        if (modelId == null || modelId == 0L || StringUtils.isEmpty((String)cubeNumber) || calcParams == null || calcParams.isEmpty()) {
            return;
        }
        ArrayList<Object> exprs = new ArrayList<Object>();
        QFilter qFilter = new QFilter("executetype", "=", (Object)"2");
        if (isSave) {
            qFilter.or(new QFilter("executetype", "=", (Object)"1"));
        } else {
            qFilter.or(new QFilter("executetype", "=", (Object)"0"));
        }
        AccountExpr accountExpr = ExprServiceHelper.loadFromReportAccExpr((Long)templateId, calcParams, (QFilter)qFilter);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (accountExpr != null && accountExpr.getFormulas() != null && accountExpr.getFormulas().size() > 0) {
            exprs.add(accountExpr);
        }
        AggregateExpr agg = new AggregateExpr();
        agg.addMembers(calcParams);
        exprs.add(agg);
        ScriptCommand command = null;
        if (!exprs.isEmpty()) {
            try {
                for (IExpress iExpress : exprs) {
                    command = ScriptCommand.getIntance((OlapConnection)ScriptCommand.getOlapConnection((String)cubeNumber));
                    command.execute(modelCacheHelper, iExpress);
                }
            }
            catch (Exception ex) {
                log.error("calcAggrageAndFormula", (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public void calcAggrage(Long modelId, String cubeNumber, Map<String, Set<String>> calcParams) {
        if (modelId == null || modelId == 0L || StringUtils.isEmpty((String)cubeNumber) || calcParams == null || calcParams.isEmpty()) {
            return;
        }
        AggregateExpr expr = new AggregateExpr();
        expr.addMembers(calcParams);
        ScriptCommand command = ScriptCommand.getIntance((OlapConnection)ScriptCommand.getOlapConnection((String)cubeNumber));
        command.execute(modelId, (IExpress)expr);
    }
}

