/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;

public class DimensionRelationServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(DimensionRelationServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"DimensionRelationServiceImpl");){
            try {
                this.excute();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void excute() {
        Long fid;
        String sql = "select fid,fmodelid,fdimension1,fdimensionview1,fdimension2,fdimensionview2 from t_eb_dimensionrelation where fid not in (select fid from t_eb_dimensionrelation_e)";
        DataSet ds = DB.queryDataSet((String)"DimensionRelationServiceImpl", (DBRoute)BgBaseConstant.epm, (String)sql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> upList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> schemeParamList = new ArrayList<Object[]>(10);
        ArrayList<String> schemeList = new ArrayList<String>(10);
        HashSet<String> modelSet = new HashSet<String>(16);
        HashMap<Long, String> dimModelMap = new HashMap<Long, String>(16);
        HashMap<Long, List<Dimension>> schemeDimMap = new HashMap<Long, List<Dimension>>(16);
        while (ds != null && ds.hasNext()) {
            try {
                Row row = ds.next();
                Long fmodelid = row.getLong("fmodelid");
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)fmodelid);
                fid = row.getLong("fid");
                Long fdimension1 = row.getLong("fdimension1");
                Long fdimension2 = row.getLong("fdimension2");
                Dimension dimension1 = modelCache.getDimension(fdimension1);
                log.info("scheme=" + fid);
                if (dimension1 == null) {
                    log.info("fdimension1 is not exist:" + fdimension1);
                    continue;
                }
                Dimension dimension2 = modelCache.getDimension(fdimension2);
                if (dimension2 == null) {
                    log.info("fdimension2 is not exist:" + fdimension2);
                    continue;
                }
                dimModelMap.put(fdimension1, fmodelid + "_" + fdimension1);
                dimModelMap.put(fdimension2, fmodelid + "_" + fdimension2);
                Long fdimensionview1 = row.getLong("fdimensionview1");
                if ((fdimensionview1 == null || fdimensionview1 == 0L) && this.needView(dimension1)) {
                    modelSet.add(String.valueOf(fmodelid));
                    log.info(fid + " fdimensionview1 is not exist:");
                }
                this.getDim(row, 1, paramList, fdimension1, fdimensionview1);
                Long fdimensionview2 = row.getLong("fdimensionview2");
                if ((fdimensionview2 == null || fdimensionview2 == 0L) && this.needView(dimension2)) {
                    modelSet.add(String.valueOf(fmodelid));
                    log.info(fid + " fdimensionview2 is not exist:");
                }
                this.getDim(row, 2, paramList, fdimension2, fdimensionview2);
                Object[] scheme = new Object[]{fid};
                schemeParamList.add(scheme);
                schemeList.add(String.valueOf(fid));
                schemeDimMap.put(fid, Arrays.asList(dimension1, dimension2));
            }
            catch (Exception e) {
                log.info("error dimension relation:" + e.getMessage());
            }
        }
        if (!modelSet.isEmpty()) {
            DataSet viewds = DB.queryDataSet((String)"DimensionRelationServiceImpl", (DBRoute)BgBaseConstant.epm, (String)("select fid,fmodelid,fdimensionid from t_eb_dimensionview where fsource = '1' and fmodelid in ( " + String.join((CharSequence)",", new ArrayList(modelSet)) + " )"));
            HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
            while (viewds != null && viewds.hasNext()) {
                Row next = viewds.next();
                fid = next.getLong("fid");
                Long fmodelid = next.getLong("fmodelid");
                Long fdimensionid = next.getLong("fdimensionid");
                viewMap.put(fmodelid + "_" + fdimensionid, fid);
            }
            for (Object[] objects : paramList) {
                Long dimension;
                Long baseview;
                Long view = (Long)objects[4];
                if (view != null && view != 0L || (baseview = (Long)viewMap.get(dimModelMap.get(dimension = (Long)objects[3]))) == null) continue;
                objects[4] = baseview;
            }
        }
        if (!schemeList.isEmpty()) {
            Object frelationid;
            DataSet relationMembersDs = DB.queryDataSet((String)"DimensionRelationServiceImpl", (DBRoute)BgBaseConstant.epm, (String)("select fid,frelationid,fcustomdimnumber1,fcustomdimnumber2,fcustomdim1,fcustomdim2,fentity,faccount,fyear,fperiod,fbudgetperiod,fversion,fcurrency,fdatatype,fchangetype,faudittrail,fmetric,finternalcompany,fscenario,fprocess from t_eb_dimmemberrelation where frelationid in ( " + String.join((CharSequence)",", schemeList) + " )"));
            while (relationMembersDs != null && relationMembersDs.hasNext()) {
                Long member2;
                Long member1;
                Row next = relationMembersDs.next();
                frelationid = next.getLong("frelationid");
                List dimensionList = (List)schemeDimMap.get(frelationid);
                Object[] dimension1 = (Object[])dimensionList.get(0);
                Dimension dimension2 = (Dimension)dimensionList.get(1);
                String flied1 = dimension1.isPreset() ? "f" + dimension1.getNumber() : "fcustomdim1";
                String flied2 = dimension2.isPreset() ? "f" + dimension2.getNumber() : "fcustomdim2";
                String fcustomdimnumber2 = next.getString("fcustomdimnumber2");
                if (dimension1.getNumber().equals(fcustomdimnumber2)) {
                    member1 = next.getLong(flied2);
                    member2 = next.getLong(flied1);
                } else {
                    member1 = next.getLong(flied1);
                    member2 = next.getLong(flied2);
                }
                if (member1 == 0L && member2 == 0L) continue;
                Object[] dim = new Object[]{member1, member2, next.getLong("fid")};
                upList.add(dim);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("INSERT INTO t_eb_dimensionrelation_e paramList = ");
            frelationid = paramList.iterator();
            while (frelationid.hasNext()) {
                Object[] objects;
                for (Object object : objects = (Object[])frelationid.next()) {
                    stringBuilder.append(object).append(",");
                }
                stringBuilder.append(";");
            }
            log.info(stringBuilder.toString());
            String insertSql = "INSERT INTO t_eb_dimensionrelation_e (fid,fentryid,fseq,fdimension,fdimview) values(?,?,?,?,?) ";
            if (!paramList.isEmpty()) {
                int[] ints = DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertSql, paramList);
                log.info("insert success:" + Arrays.toString(ints));
            }
            log.info("update t_eb_dimensionrelation upList = " + schemeList);
            String upSchemeSql = "update t_eb_dimensionrelation set faffectrange = '1' where fid = ?";
            if (!schemeList.isEmpty()) {
                int[] ints = DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)upSchemeSql, schemeParamList);
                log.info("update t_eb_dimensionrelation success:" + Arrays.toString(ints));
            }
            log.info("update t_eb_dimmemberrelation upList = " + upList);
            String upSql = "update t_eb_dimmemberrelation set fdimension1 = ?, fdimension2 = ?,fdimension3 =0,fdimension4 =0,fdimension5 =0,fdimension6 =0  where fid = ?";
            if (!upList.isEmpty()) {
                int[] ints = DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)upSql, upList);
                log.info("update t_eb_dimmemberrelation success:" + Arrays.toString(ints));
            }
        }
    }

    private boolean needView(Dimension dimension) {
        return SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || !dimension.isPreset();
    }

    private void getDim(Row row, int index, List<Object[]> paramList, Long dim1, Long view) {
        Object[] dim = new Object[]{row.getLong("fid"), GlobalIdUtil.genGlobalLongId(), index, dim1, view};
        paramList.add(dim);
    }
}

