/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.permission.EBPermissionImpl;
import kd.epm.eb.common.permission.EBPermissionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.model.serviceHelper.UserDistributeServiceHelper;
import kd.epm.eb.service.EPMPermissionService;

public class EPMPermissionServiceImpl
implements EPMPermissionService,
IUpgradeService {
    public void addEPMPermByUser(Long modelId, Long userId) {
        if (userId == null || userId == 0L) {
            return;
        }
        EBPermissionUtils.getInstance().addPermByUser(modelId, Collections.singletonList(userId), false);
    }

    public void addEPMPermByUser(Long modelId, Long userId, String appNum) {
        if (userId == null || userId == 0L) {
            return;
        }
        EBPermissionUtils.getInstance().addPermByUser(modelId, Collections.singletonList(userId), appNum, false);
    }

    public void addEPMPermByUser(Long modelId, Long userId, String appNum, String reportType) {
        if (userId == null || userId == 0L) {
            return;
        }
        EBPermissionUtils.getInstance().addPermByUser(modelId, Collections.singletonList(userId), appNum, reportType, false);
    }

    public void addEPMPermByUsers(Long modelId, List<Long> userIds) {
        EBPermissionUtils.getInstance().addPermByUser(modelId, userIds, null, false);
    }

    public void addEPMPermByUsers(Long modelId, List<Long> userIds, String appNum) {
        EBPermissionUtils.getInstance().addPermByUser(modelId, userIds, appNum, false);
    }

    public void addEPMPermByUsers(Long modelId, List<Long> userIds, String appNum, boolean hasClearPerm) {
        EBPermissionUtils.getInstance().addPermByUser(modelId, userIds, appNum, hasClearPerm);
    }

    public int delEPMPermNyUser(Long modelId, List<Long> userIds) {
        return EBPermissionUtils.getInstance().delPermNyUser(modelId, userIds);
    }

    public void checkPermission(Long modelId, Long userId, String appId, String source, String permKey) {
        new EBPermissionImpl().checkPermission(modelId, userId, appId, source, permKey);
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgradePerm();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
        }
        return result;
    }

    public void upgradePerm() {
        DynamicObject[] epm_modelperms;
        QFilter qf = new QFilter("1", "=", (Object)1);
        for (DynamicObject epm_modelperm : epm_modelperms = BusinessDataServiceHelper.load((String)"epm_modelperm", (String)"model,modelpermentry.etype,modelpermentry.eusers", (QFilter[])qf.toArray())) {
            Long modelId = epm_modelperm.getLong("model.id");
            if (modelId == 0L || !QueryServiceHelper.exists((String)"epm_model", (Object)modelId)) continue;
            Set<Long> userIds = this.getUserIds(epm_modelperm);
            this.addEPMPermByUsers(modelId, new ArrayList<Long>(userIds));
        }
    }

    private Set<Long> getUserIds(DynamicObject epm_modelperm) {
        HashSet<Long> ids = new HashSet<Long>(16);
        DynamicObjectCollection modelpermentry = epm_modelperm.getDynamicObjectCollection("modelpermentry");
        if (modelpermentry == null || modelpermentry.isEmpty()) {
            return ids;
        }
        for (DynamicObject mem : modelpermentry) {
            String type = mem.getString("etype");
            Long usid = mem.getLong("eusers.id");
            if (StringUtils.isEmpty((String)type) || usid == 0L) continue;
            if ("bos_user".equals(type)) {
                ids.add(usid);
                continue;
            }
            DynamicObjectCollection us = UserDistributeServiceHelper.queryAllUsersByGroupId((Object)usid);
            if (us == null) continue;
            for (DynamicObject dynamicObject : us) {
                ids.add(dynamicObject.getLong("user"));
            }
        }
        return ids;
    }
}

