/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.Language;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.pojo.BooleanObj;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class AnalyseRptLangUpServiceImpl {
    private static final String PLANT_KEY = "AnalyseRptLangUpServiceImpl";
    private static final Log log = LogFactory.getLog(AnalyseRptLangUpServiceImpl.class);

    public static void update() {
        if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
            List<Object[]> approveTypeData = AnalyseRptLangUpServiceImpl.selApproveTypeDefDataLang();
            List<Object[]> dimParmaData = AnalyseRptLangUpServiceImpl.selLangObjs("t_eb_dimparameter", false, "fdescription");
            List<Object[]> judConData = AnalyseRptLangUpServiceImpl.selLangObjs("t_eb_judgecondition", false, "fdescription");
            List<Object[]> rptSectionData = AnalyseRptLangUpServiceImpl.selLangObjs("t_eb_rptsection", true, "fdescription");
            List<Object[]> tempData = AnalyseRptLangUpServiceImpl.selLangObjs("t_eb_analyserpttemplate", true, "fdescription");
            try (TXHandle tx = TX.requiresNew((String)PLANT_KEY);){
                try {
                    if (!approveTypeData.isEmpty()) {
                        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"insert into t_eb_approvaltypeentity_l(fpkid,fid,flocaleid,fname,fdesc)values(?,?,?,?,?)", approveTypeData);
                    }
                    if (!dimParmaData.isEmpty()) {
                        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"insert into t_eb_dimparameter_l(fpkid,fid,flocaleid,fname,fdescription)values(?,?,?,?,?)", dimParmaData);
                    }
                    if (!judConData.isEmpty()) {
                        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"insert into t_eb_judgecondition_l(fpkid,fid,flocaleid,fname,fdescription)values(?,?,?,?,?)", judConData);
                    }
                    if (!rptSectionData.isEmpty()) {
                        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"update t_eb_rptsection_l set fdescription = ? where fid = ? and flocaleid = ?", rptSectionData);
                    }
                    if (!tempData.isEmpty()) {
                        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"update t_eb_analyserpttemplate_l set fdescription = ? where fid = ? and flocaleid = ?", tempData);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    tx.markRollback();
                }
            }
            UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
        }
    }

    private static List<Object[]> selLangObjs(String table, boolean onlyUpDesc, String descKey) {
        ArrayList<Object[]> objs = new ArrayList<Object[]>(16);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,").append(descKey);
        if (!onlyUpDesc) {
            sb.append(",fname");
        }
        sb.append(" from ").append(table);
        CommonServiceHelper.queryDataSetByDB((String)"selLangObjs", (String)sb.toString(), null, row -> {
            Object[] rowVals = onlyUpDesc ? new Object[]{row.getString(descKey), row.getLong("fid"), "zh_CN"} : new Object[]{null, row.getLong("fid"), "zh_CN", row.getString("fname"), row.getString(descKey)};
            objs.add(rowVals);
        });
        if (!objs.isEmpty() && !onlyUpDesc) {
            String[] ids = GlobalIdUtil.genStringIds((int)objs.size());
            int seq = 0;
            for (Object[] rowData : objs) {
                rowData[0] = ids[seq++];
            }
        }
        return objs;
    }

    private static List<Object[]> selApproveTypeDefDataLang() {
        ArrayList<Object[]> newDataList = new ArrayList<Object[]>(1);
        ArrayList mainId = new ArrayList(1);
        CommonServiceHelper.queryDataSetByDB((String)"defApproveType", (String)"select fid from t_eb_approvaltypeentity where fmodelid = 0 and fbizmodelid = 0", null, row -> mainId.add(row.getLong("fid")));
        if (!mainId.isEmpty()) {
            BooleanObj mark = new BooleanObj();
            CommonServiceHelper.queryDataSetByDB((String)"defApproveTypeLang", (String)"select flocaleid from t_eb_approvaltypeentity_l where fid = ?", (Object[])new Object[]{mainId.get(0)}, row -> {
                if ("en_US".equals(row.getString("flocaleid"))) {
                    mark.mark(true);
                }
            });
            if (!mark.marked()) {
                Object[] newRecord = new Object[]{GlobalIdUtil.genStringId(), mainId.get(0), "en_US", "Default Approval Type", "The system presets the approval type, which is suitable for reviewing the reports corresponding to all templates that are not associated with the approval type; that is, the approval form corresponding to this type of approval is preset with the approval type attribute."};
                newDataList.add(newRecord);
            }
        }
        return newDataList;
    }
}

