/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.Language;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.service.Language.AnalyseRptLangUpServiceImpl;
import kd.epm.eb.service.Language.LanguageUpgradeImpl;
import org.jetbrains.annotations.NotNull;

public class DimLanguageUpgradeImpl
extends LanguageUpgradeImpl {
    @Override
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return this.executeUpgrade(IDUtils.toLong((Object)ver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult executeUpgrade(Long modelId) {
        UpgradeResult result = new UpgradeResult();
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-upgrade-language.");
        if (IDUtils.isNotNull((Long)modelId)) {
            stats.addInfo("modelId:" + modelId);
        }
        try {
            this.upgradeViewMember(modelId, stats);
            stats.add("end-upgrade-viewMember.");
            this.upgradeDimView(modelId, stats);
            stats.add("end-upgrade-dimView.");
            AnalyseRptLangUpServiceImpl.update();
            this.upgradeTaskList(modelId, stats);
            stats.add("end-upgrade-taskList.");
            this.upgradeWeaveDesc(modelId, stats);
            stats.add("end-upgrade-weaveDesc.");
            this.upgradeCentralAppPlan(modelId, stats);
            stats.add("end-upgrade-centralAppPlan.");
            this.upgradeAdjustDim(modelId, stats);
            stats.add("end-upgrade-adjustDim.");
            this.upgradeAdjustRule(modelId, stats);
            stats.add("end-upgrade-adjustRule.");
            this.upgradeAdjustBill(modelId, stats);
            stats.add("end-upgrade-adjustBill.");
            this.upgradeDecomposeSchema(modelId, stats);
            stats.add("end-upgrade-decomposeSchema.");
            this.upgradeApproveTypeDesc(modelId, stats);
            stats.add("end-upgrade-approveTypeDesc.");
            this.upgradeBatchRule(modelId, stats);
            stats.add("end-upgrade-BatchRule.");
            result.setLog("language-upgrade-success.");
        }
        catch (Exception ex) {
            log.error("languageUpgradeImpl-error:", (Throwable)ex);
            result.setSuccess(false);
            String error = CommonServiceHelper.getStackTraceStr((Throwable)ex);
            stats.addInfo(error);
            result.setErrorInfo(error);
        }
        finally {
            if (IDUtils.isNotNull((Long)modelId)) {
                CubeUtils.updateCubeVersion((Long)modelId);
                ModelCacheContext.removeModel((Long)modelId);
            } else {
                ModelCacheContext.removeAllModel();
            }
            stats.addInfo("end-upgrade-language.");
            log.info(stats.toString());
        }
        return result;
    }

    private void upgradeViewMember(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_viewmember", "t_eb_viewmember_l", new String[]{"fname", "fsimplename"}, stats);
        CacheServiceHelper.clearEntityCache((String)"eb_viewmember");
    }

    private void upgradeDimView(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_dimensionview", "t_eb_dimensionview_l", new String[]{"fname", "fdescription"}, stats);
        CacheServiceHelper.clearEntityCache((String)"eb_dimensionview");
    }

    private void upgradeTaskList(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeTaskList");){
            try {
                String querySql = "select fid,fcatalog from t_eb_tasklist where fid in(select fid from t_eb_tasklist_l where fcatalog=' ')";
                ArrayList<Object[]> updateParameters = new ArrayList<Object[]>(16);
                try (DataSet ds = DB.queryDataSet((String)"querySrcTable", (DBRoute)BgBaseConstant.epm, (String)querySql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            Long id = row.getLong("fid");
                            String catalog = row.getString("fcatalog");
                            Object[] param = new Object[]{catalog, id};
                            updateParameters.add(param);
                        }
                    }
                }
                String sql = "update t_eb_tasklist_l set fcatalog=? where fid = ?";
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, updateParameters);
                CacheServiceHelper.clearEntityCache((String)"eb_tasklist");
            }
            catch (Exception e) {
                log.error("upgradeTaskList error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeWeaveDesc(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeWeaveDesc");){
            try {
                this.upgradeMultiLanguage(modelId, null, "t_eb_weavedescentity", "t_eb_weavedescentity_l", new String[]{"fdesc"}, stats);
                CacheServiceHelper.clearEntityCache((String)"eb_weavedescentity");
            }
            catch (Exception e) {
                log.error("upgradeWeaveDesc error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeCentralAppPlan(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeCentralAppPlan");){
            try {
                this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_centralappplan", "t_eb_centralappplan_l", new String[]{"fname", "fexplain"}, stats);
                CacheServiceHelper.clearEntityCache((String)"eb_centralappplanentity");
            }
            catch (Exception e) {
                log.error("upgradeCentralAppPlan error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeAdjustDim(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeAdjustDim");){
            try {
                this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_adjustdimension", "t_eb_adjustdimension_l", new String[]{"fname", "fillustrate"}, stats);
                CacheServiceHelper.clearEntityCache((String)"eb_adjustdimension");
            }
            catch (Exception e) {
                log.error("upgradeAdjustDim error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeAdjustRule(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeAdjustRule");){
            try {
                this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_adjustrule", "t_eb_adjustrule_l", new String[]{"fremark"}, stats);
                CacheServiceHelper.clearEntityCache((String)"eb_adjustrule");
            }
            catch (Exception e) {
                log.error("upgradeAdjustRule error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeAdjustBill(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeAdjustBill");){
            try {
                this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_adjustbill", "t_eb_adjustbill_l", new String[]{"fadjustreason"}, stats);
                CacheServiceHelper.clearEntityCache((String)"bgm_adjustbill");
                CacheServiceHelper.clearEntityCache((String)"bgm_adjpstbill");
            }
            catch (Exception e) {
                log.error("upgradeAdjustBill error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeDecomposeSchema(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeDecomposeSchema");){
            try {
                this.upgradeMultiLanguage(modelId, "fmodel", "t_eb_decompose_scheme", "t_eb_decompose_scheme_l", new String[]{"fname"}, stats);
                CacheServiceHelper.clearEntityCache((String)"eb_decompose_scheme");
            }
            catch (Exception e) {
                log.error("upgradeDecomposeSchema error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeApproveTypeDesc(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeApproveTypeDesc");){
            try {
                String querySql = "select fid,fdesc from t_eb_approvaltypeentity where fid in(select fid from t_eb_approvaltypeentity_l where fdesc=' ')";
                ArrayList<Object[]> updateParameters = new ArrayList<Object[]>(16);
                try (DataSet ds = DB.queryDataSet((String)"querySrcTable", (DBRoute)BgBaseConstant.epm, (String)querySql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            Long id = row.getLong("fid");
                            String desc = row.getString("fdesc");
                            Object[] param = new Object[]{desc, id};
                            updateParameters.add(param);
                        }
                    }
                }
                String sql = "update t_eb_approvaltypeentity_l set fdesc=? where fid = ?";
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, updateParameters);
                CacheServiceHelper.clearEntityCache((String)"eb_approvaltypeentity");
            }
            catch (Exception e) {
                log.error("upgradeApproveTypeDesc error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void upgradeBatchRule(Long modelId, @NotNull LogStats stats) {
        try (TXHandle tx = TX.requiresNew((String)"upgradeBatchRule");){
            try {
                this.upgradeMultiLanguage(modelId, "fmodel", "t_eb_rulebatch", "t_eb_rulebatch_l", new String[]{"fname"}, stats);
                CacheServiceHelper.clearEntityCache((String)"eb_rulebatch");
            }
            catch (Exception e) {
                log.error("upgradeBatchRule error:", (Throwable)e);
                tx.markRollback();
            }
        }
    }
}

