/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.Language;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class LanguageUpgradeImpl
implements IUpgradeService {
    public static final Log log = LogFactory.getLog(LanguageUpgradeImpl.class);
    public static final String FIELD_NAME = "fname";
    public static final String FIELD_SIMPLE_NAME = "fsimplename";
    public static final String FIELD_DESCRIPTION = "fdescription";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Long modelId = null;
        if (StringUtils.isNotEmpty((String)ver)) {
            try {
                modelId = IDUtils.toLong((Object)ver);
            }
            catch (Exception ex) {
                log.error(CommonServiceHelper.getStackTraceStr((Throwable)ex));
            }
        }
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-upgrade-language.");
        try {
            this.upgradeBusModel(modelId, stats);
            stats.add("end-upgrade-busModel.");
            this.upgradeDataset(modelId, stats);
            stats.add("end-upgrade-dataset.");
            this.upgradeApplicationScenario(modelId, stats);
            stats.add("end-upgrade-applicationScenario.");
            this.upgradeBgTemplate(modelId, stats);
            stats.add("end-upgrade-BgTemplate.");
            this.upgradeExamineCategory(modelId, stats);
            stats.add("end-upgrade-examineCategory.");
            result.setLog("language-upgrade-success.");
        }
        catch (Exception ex) {
            log.error("LanguageUpgradeImpl-error:", (Throwable)ex);
            result.setSuccess(false);
            result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)ex));
        }
        finally {
            stats.addInfo("end-upgrade-language.");
            log.info(stats.toString());
        }
        return result;
    }

    private void upgradeBusModel(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_businessmodel", "t_eb_businessmodel_l", new String[]{FIELD_NAME}, stats);
    }

    private void upgradeDataset(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodel", "t_eb_dataset", "t_eb_dataset_l", new String[]{FIELD_NAME}, stats);
    }

    private void upgradeBgTemplate(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_template", "t_eb_template_l", new String[]{FIELD_NAME}, stats);
    }

    private void upgradeExamineCategory(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_examinecategory", "t_eb_examinecategory_l", new String[]{FIELD_NAME}, stats);
    }

    private void upgradeApplicationScenario(Long modelId, @NotNull LogStats stats) {
        this.upgradeMultiLanguage(modelId, "fmodelid", "t_eb_applicationscenario", "t_eb_applicationscenario_l", new String[]{FIELD_NAME}, stats);
    }

    protected void upgradeMultiLanguage(@NotNull String srcTable, @NotNull String languageTable, @NotNull String[] fields, LogStats stats) {
        this.upgradeMultiLanguage(null, null, srcTable, languageTable, fields, stats);
    }

    protected void upgradeMultiLanguage(Long modelId, String modelFields, @NotNull String srcTable, @NotNull String languageTable, @NotNull String[] fields, LogStats stats) {
        if (!SqlBatchUtils.hasTable((String)srcTable)) {
            stats.addInfo("no src table - " + srcTable);
            return;
        }
        if (!SqlBatchUtils.hasTable((String)languageTable)) {
            stats.addInfo("no multi Language table - " + languageTable);
            return;
        }
        if (fields.length == 0) {
            stats.addInfo("no fields - " + StringUtils.join((Object[])fields, (char)','));
            return;
        }
        LinkedHashSet language = Sets.newLinkedHashSet();
        int MAX_SIZE = 100000;
        int index = 0;
        ArrayList sqlParams = Lists.newArrayListWithExpectedSize((int)MAX_SIZE);
        int sqlParamSize = 3 + fields.length;
        String currLang = Lang.get().toString();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from " + languageTable, new Object[0]);
        if (IDUtils.isNotNull((Long)modelId) && StringUtils.isNotEmpty((String)modelFields)) {
            sqlBuilder.append(" where fid in (select fid from " + srcTable + " where " + modelFields + " = ?)", new Object[]{modelId});
        } else {
            sqlBuilder.append(" where exists (select fid from " + srcTable + " where fid = " + languageTable + ".fid)", new Object[0]);
        }
        sqlBuilder.append(" and flocaleid = ?", new Object[]{currLang});
        try (DataSet ds = DB.queryDataSet((String)"queryMulTable", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    language.add(row.getLong("fid"));
                }
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid," + StringUtils.join((Object[])fields, (char)',') + " from " + srcTable, new Object[0]);
        if (IDUtils.isNotNull((Long)modelId) && StringUtils.isNotEmpty((String)modelFields)) {
            sqlBuilder.append(" where " + modelFields + " = ?", new Object[]{modelId});
        } else {
            sqlBuilder.append(" where not exists (select fid from " + languageTable + " where fid = " + srcTable + ".fid)", new Object[0]);
        }
        String sql = "insert into " + languageTable + "(fpkid,fid,flocaleid," + StringUtils.join((Object[])fields, (char)',') + ") values (" + SqlBatchUtils.getBatchParamsSql((int)sqlParamSize) + ")";
        DataSet ds = DB.queryDataSet((String)"querySrcTable", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    if (language.contains(row.getLong("fid"))) continue;
                    Object[] sqlParam = new Object[sqlParamSize];
                    sqlParam[0] = null;
                    sqlParam[1] = row.getLong("fid");
                    sqlParam[2] = currLang;
                    int in = fields.length;
                    for (int i = 0; i < in; ++i) {
                        String content = row.getString(fields[i]);
                        if (StringUtils.isNotEmpty((String)content) && content.length() > 2000) {
                            content = content.substring(0, 2000);
                        }
                        sqlParam[3 + i] = content;
                    }
                    sqlParams.add(sqlParam);
                    if (++index < MAX_SIZE) continue;
                    this.executeBatch(languageTable, sql, sqlParams);
                    index = 0;
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        this.executeBatch(languageTable, sql, sqlParams);
    }

    protected void executeBatch(String languageTable, String sql, List<Object[]> sqlParams) {
        if (!sqlParams.isEmpty()) {
            String[] ids = DBServiceHelper.genStringIds((String)languageTable, (int)sqlParams.size());
            int in = sqlParams.size();
            for (int i = 0; i < in; ++i) {
                sqlParams.get((int)i)[0] = ids[i];
            }
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, sqlParams);
            sqlParams.clear();
        }
    }
}

