/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaskDecomposeRootRecordUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "TaskDecomposeUpgradeService3";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"TaskDecomposeRootRecordUpgradeService");){
            StringBuilder upgradeLog;
            if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                if (this.checkNeedUpgrade()) {
                    upgradeLog = this.upgrade();
                    result.setLog(upgradeLog.toString());
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, (String)upgradeLog.toString(), null, (boolean)true);
                } else {
                    result.setLog("don't need upgrade.");
                }
            } else {
                result.setLog("this script had invoke.");
            }
            result.setSuccess(true);
            upgradeLog = result;
            return upgradeLog;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    public StringBuilder upgrade() {
        HashSet taskIds = Sets.newHashSetWithExpectedSize((int)1024);
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)8192);
        HashMap<Long, Set<Long>> taskSaveSupervisors = new HashMap<Long, Set<Long>>(1024);
        HashMap<Long, Long> taskSaveExecutors = new HashMap<Long, Long>(1024);
        this.findNeedData(taskIds, orgIds, taskSaveSupervisors, taskSaveExecutors);
        StringBuilder stringBuilder = new StringBuilder("upgrade success. ");
        Map<Long, Long> saveIdToDecomposeRecordIdMap = this.insertDecomposeRootRecord(orgIds, taskIds);
        stringBuilder.append("insertDecomposeRootRecord ");
        stringBuilder.append(saveIdToDecomposeRecordIdMap.size());
        stringBuilder.append(";");
        if (saveIdToDecomposeRecordIdMap.size() > 0) {
            int insertExecutorsCount = this.insertDecomposeRecordExecutors(saveIdToDecomposeRecordIdMap, taskSaveExecutors);
            stringBuilder.append("insertDecomposeRecordExecutors ");
            stringBuilder.append(insertExecutorsCount);
            stringBuilder.append(";");
            int insertSupervisorsCount = this.insertDecomposeRecordSupervisors(saveIdToDecomposeRecordIdMap, taskSaveSupervisors);
            stringBuilder.append("insertDecomposeRecordSupervisors ");
            stringBuilder.append(insertSupervisorsCount);
            stringBuilder.append(";");
        }
        return stringBuilder;
    }

    private void findNeedData(Set<Long> taskIds, Set<Long> orgIds, Map<Long, Set<Long>> taskSaveSupervisors, Map<Long, Long> taskSaveExecutors) {
        String getDispatchOrgIdsSql = "select fid,forgid,ftask,fexecutorid from t_eb_taskdistorg where ftaskstatus = '1'";
        DataSet dispatchOrgDs = DB.queryDataSet((String)"getTaskSaveDispatchOrgIds", (DBRoute)DB_EPM, (String)getDispatchOrgIdsSql, null);
        while (dispatchOrgDs != null && dispatchOrgDs.hasNext()) {
            Row dispatchRow = dispatchOrgDs.next();
            long id = dispatchRow.getLong("fid");
            long dispatchTaskId = dispatchRow.getLong("ftask");
            long dispatchOrgId = dispatchRow.getLong("forgid");
            long dispatchExecutorId = dispatchRow.getLong("fexecutorid");
            if (IDUtils.isEmptyLong((Long)dispatchOrgId).booleanValue() || IDUtils.isEmptyLong((Long)dispatchTaskId).booleanValue() || IDUtils.isEmptyLong((Long)dispatchExecutorId).booleanValue()) continue;
            taskIds.add(dispatchTaskId);
            orgIds.add(dispatchOrgId);
            taskSaveExecutors.put(id, dispatchExecutorId);
        }
        if (CollectionUtils.isNotEmpty(taskSaveExecutors.keySet())) {
            SqlBuilder dispatchSupervisorSql = new SqlBuilder();
            dispatchSupervisorSql.append("select fid,fsupervisor from t_eb_tasksupervisor where ", new Object[0]);
            dispatchSupervisorSql.appendIn("fid", taskSaveExecutors.keySet().toArray());
            DataSet dispatchSupervisorDs = DB.queryDataSet((String)"getDispatchSupervisor", (DBRoute)DB_EPM, (SqlBuilder)dispatchSupervisorSql);
            while (dispatchSupervisorDs != null && dispatchSupervisorDs.hasNext()) {
                Row supervisorRow = dispatchSupervisorDs.next();
                long supervisorRowId = supervisorRow.getLong("fid");
                long supervisorId = supervisorRow.getLong("fsupervisor");
                if (IDUtils.isEmptyLong((Long)supervisorRowId).booleanValue() || IDUtils.isEmptyLong((Long)supervisorId).booleanValue()) continue;
                Set supervisors = taskSaveSupervisors.computeIfAbsent(supervisorRowId, e -> new HashSet(5));
                supervisors.add(supervisorId);
            }
        }
    }

    private Set<String> getExistRootDecomposeRecord() {
        HashSet<String> existRootDecomposeRecord = new HashSet<String>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftask,forg,forgviewid from t_eb_taskdecompose where ", new Object[0]);
        sqlBuilder.append("fparentdecompose is null or fparentdecompose = 0", new Object[0]);
        DataSet ds = DB.queryDataSet((String)"getExistRootDecomposeRecord", (DBRoute)DB_EPM, (SqlBuilder)sqlBuilder);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            Long task = row.getLong("ftask");
            Long org = row.getLong("forg");
            Long orgView = row.getLong("forgviewid");
            if (IDUtils.isEmptyLong((Long)task).booleanValue() || IDUtils.isEmptyLong((Long)org).booleanValue()) continue;
            existRootDecomposeRecord.add(task + "_" + org + "_" + orgView);
        }
        return existRootDecomposeRecord;
    }

    private Map<Long, Long> getSubTaskModelMap(Set<Long> taskIds) {
        HashMap<Long, Long> subTaskModelMap = new HashMap<Long, Long>(16);
        if (taskIds.size() > 0) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid,fmodelid from t_eb_task where ", new Object[0]);
            sql.appendIn("fid", taskIds.toArray());
            DataSet ds = DB.queryDataSet((String)"getSubTaskModel", (DBRoute)DB_EPM, (SqlBuilder)sql);
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long task = row.getLong("fid");
                Long modelId = row.getLong("fmodelid");
                if (!IDUtils.isNotEmptyLong((Long)task).booleanValue() || !IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) continue;
                subTaskModelMap.put(task, modelId);
            }
        }
        return subTaskModelMap;
    }

    private Map<Long, String> getOrgDecomposeLongNumbers(Set<Long> orgIds) {
        HashMap<Long, String> orgDecomposeLongNumbers = new HashMap<Long, String>(16);
        if (orgIds.size() > 0) {
            ArrayList<Long> paramIdList = new ArrayList<Long>(orgIds);
            int fromIndex = 0;
            while (fromIndex < orgIds.size()) {
                fromIndex = this.getOrgNumber(orgIds, orgDecomposeLongNumbers, paramIdList, fromIndex);
            }
        }
        return orgDecomposeLongNumbers;
    }

    private int getOrgNumber(Set<Long> orgIds, Map<Long, String> orgDecomposeLongNumbers, List<Long> paramIdList, int fromIndex) {
        int toIndex = Math.min(fromIndex + 1000, orgIds.size());
        List<Long> paramIds = paramIdList.subList(fromIndex, toIndex);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fnumber from t_eb_structofent where ", new Object[0]);
        sql.appendIn("fid", paramIds.toArray());
        DataSet ds = DB.queryDataSet((String)"getOrgNumber", (DBRoute)DB_EPM, (SqlBuilder)sql);
        while (ds != null && ds.hasNext()) {
            Row orgRow = ds.next();
            orgDecomposeLongNumbers.put(orgRow.getLong("fid"), "|" + orgRow.getString("fnumber") + "|");
        }
        return fromIndex += 1000;
    }

    public Map<Long, Long> insertDecomposeRootRecord(Set<Long> orgIds, Set<Long> taskIds) {
        Map<Long, String> orgDecomposeLongNumbers = this.getOrgDecomposeLongNumbers(orgIds);
        Set<String> existRootDecomposeRecord = this.getExistRootDecomposeRecord();
        Map<Long, Long> subTaskModelMap = this.getSubTaskModelMap(taskIds);
        String sql = "select fid,forgid,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,forgviewid,ftask from t_eb_taskdistorg where ftaskstatus = '1'";
        DataSet ds = DB.queryDataSet((String)"insertDecomposeRootRecord", (DBRoute)DB_EPM, (String)sql);
        ArrayList decomposeRecord = Lists.newArrayListWithExpectedSize((int)8192);
        HashMap<String, Long> idRecord = new HashMap<String, Long>(8192);
        while (ds != null && ds.hasNext()) {
            String longNumber;
            Row row = ds.next();
            Long orgId = row.getLong("forgid");
            Long taskId = row.getLong("ftask");
            Long orgViewId = row.getLong("forgviewid");
            if (IDUtils.isEmptyLong((Long)orgId).booleanValue() || IDUtils.isEmptyLong((Long)taskId).booleanValue() || existRootDecomposeRecord.contains(taskId + "_" + orgId + "_" + orgViewId)) continue;
            Long manager = row.getLong("fcreaterid");
            Long modifier = row.getLong("fcreaterid");
            Date modifyDate = row.getDate("fcreatedate");
            Long model = subTaskModelMap.get(taskId);
            if (IDUtils.isEmptyLong((Long)model).booleanValue() || (longNumber = orgDecomposeLongNumbers.get(orgId)) == null) continue;
            Object[] data = new Object[]{0L, orgId, taskId, Character.valueOf('1'), modifier, modifyDate, manager, model, orgViewId, 0L, longNumber, modifier, modifyDate};
            decomposeRecord.add(data);
            idRecord.put(taskId + "_" + orgId + "_" + orgViewId, row.getLong("fid"));
        }
        HashMap<Long, Long> saveIdToDecomposeRecordIdMap = new HashMap<Long, Long>(8192);
        if (CollectionUtils.isNotEmpty((Collection)decomposeRecord)) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)decomposeRecord.size());
            for (int i = 0; i < decomposeRecord.size(); ++i) {
                ((Object[])decomposeRecord.get((int)i))[0] = ids[i];
                saveIdToDecomposeRecordIdMap.put((Long)idRecord.get(((Object[])decomposeRecord.get(i))[2] + "_" + ((Object[])decomposeRecord.get(i))[1] + "_" + ((Object[])decomposeRecord.get(i))[8]), ids[i]);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)decomposeRecord)) {
            String backupSql = "insert into t_eb_taskdecompose(fid,forg,ftask,fstatus,fmodifier,fmodifydate,fmanager,fmodel,forgviewid,fparentdecompose,flongnumber,fcreater,fcreatedate) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, (List)decomposeRecord);
        }
        return saveIdToDecomposeRecordIdMap;
    }

    private Integer insertDecomposeRecordExecutors(Map<Long, Long> saveIdToDecomposeRecordIdMap, Map<Long, Long> taskSaveExecutors) {
        if (taskSaveExecutors.size() == 0) {
            return 0;
        }
        ArrayList decomposeRecordExecutors = Lists.newArrayListWithExpectedSize((int)taskSaveExecutors.size());
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)taskSaveExecutors.size());
        int i = 0;
        for (Map.Entry<Long, Long> entry : taskSaveExecutors.entrySet()) {
            Long saveId = entry.getKey();
            Long executorId = entry.getValue();
            if (!saveIdToDecomposeRecordIdMap.containsKey(saveId)) continue;
            Object[] objects = new Object[]{ids[i++], saveIdToDecomposeRecordIdMap.get(saveId), executorId};
            decomposeRecordExecutors.add(objects);
        }
        if (CollectionUtils.isNotEmpty((Collection)decomposeRecordExecutors)) {
            String backupSql = "insert into t_eb_taskdec_executor(fpkid,fid,fbasedataid) values(?,?,?)";
            DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, (List)decomposeRecordExecutors);
        }
        return decomposeRecordExecutors.size();
    }

    private Integer insertDecomposeRecordSupervisors(Map<Long, Long> saveIdToDecomposeRecordIdMap, Map<Long, Set<Long>> taskSaveSupervisors) {
        if (taskSaveSupervisors.size() == 0) {
            return 0;
        }
        int count = 0;
        for (Set<Long> supervisors : taskSaveSupervisors.values()) {
            count += supervisors.size();
        }
        ArrayList decomposeRecordSupervisors = Lists.newArrayListWithExpectedSize((int)count);
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)count);
        int i = 0;
        for (Map.Entry<Long, Set<Long>> entry : taskSaveSupervisors.entrySet()) {
            Long saveId = entry.getKey();
            if (!saveIdToDecomposeRecordIdMap.containsKey(saveId)) continue;
            Set<Long> supervisors = entry.getValue();
            for (Long supervisor : supervisors) {
                Object[] objects = new Object[]{ids[i++], saveIdToDecomposeRecordIdMap.get(saveId), supervisor};
                decomposeRecordSupervisors.add(objects);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)decomposeRecordSupervisors)) {
            String backupSql = "insert into t_eb_taskdec_supervisor(fpkid,fid,fbasedataid) values(?,?,?)";
            DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, (List)decomposeRecordSupervisors);
        }
        return decomposeRecordSupervisors.size();
    }

    private boolean checkNeedUpgrade() {
        String sql1 = "select fid from t_eb_taskdistorg where ftaskstatus = '1'";
        return (Boolean)DB.query((DBRoute)DB_EPM, (String)sql1, ResultSet::next);
    }
}

