/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaskDispatchUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "TaskDispatchUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)PLANT_KEY);){
            Object stringBuilder;
            if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                if (!this.checkOrgSaveHasColumnTaskId() && !this.checkDisOrgHasColumnTask()) {
                    result.setSuccess(false);
                    result.setLog("add column for upgrade fail");
                } else if (this.checkNeedUpgradeDisOrg() || this.checkNeedUpgradeOrgSave()) {
                    stringBuilder = new StringBuilder("table");
                    if (this.checkNeedUpgradeOrgSave()) {
                        this.upgradeOrgSave();
                        ((StringBuilder)stringBuilder).append(" t_eb_tasksave ");
                    }
                    if (this.checkNeedUpgradeDisOrg()) {
                        this.upgradeDisOrg();
                        ((StringBuilder)stringBuilder).append(" t_eb_taskdistorg ");
                    }
                    ((StringBuilder)stringBuilder).append(" upgrade success.");
                    result.setLog(((StringBuilder)stringBuilder).toString());
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                } else {
                    result.setLog("table t_eb_tasksave and t_eb_taskdistorg don't need upgrade.");
                }
            } else {
                result.setLog("this script had invoke.");
            }
            result.setSuccess(true);
            stringBuilder = result;
            return stringBuilder;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    public void upgradeDisOrg() {
        String sql = "select fid,ftaskid,forgid,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,ftaskstatus,frangevalue,forgviewid from t_eb_taskdistorg where ftask is null or ftask = 0";
        HashMap needUpgradeTaskList = new HashMap(16);
        ArrayList needRemove = new ArrayList(16);
        ArrayList needBackup = new ArrayList(16);
        ArrayList taskDistorgIdList = new ArrayList(10);
        DB.query((DBRoute)DB_EPM, (String)sql, rs -> {
            while (rs.next()) {
                long taskListId = rs.getLong("ftaskid");
                long id = rs.getLong("fid");
                taskDistorgIdList.add(id);
                Object[] needRemoveId = new Object[]{id};
                needRemove.add(needRemoveId);
                long orgId = rs.getLong("forgid");
                long creator = rs.getLong("fcreaterid");
                Timestamp createDate = rs.getTimestamp("fcreatedate");
                long modifier = rs.getLong("fmodifier");
                Timestamp modifyDate = rs.getTimestamp("fmodifydate");
                long executor = rs.getLong("fexecutorid");
                String taskStatus = rs.getString("ftaskstatus");
                String orgRange = rs.getString("frangevalue");
                long orgView = rs.getLong("forgviewid");
                Object[] data = new Object[]{orgId, creator, createDate, modifier, modifyDate, executor, taskStatus, orgRange, orgView, id, taskListId};
                needBackup.add(data);
                ArrayList<Object[]> dataList = (ArrayList<Object[]>)needUpgradeTaskList.get(taskListId);
                if (CollectionUtils.isEmpty((Collection)dataList)) {
                    dataList = new ArrayList<Object[]>(10);
                }
                dataList.add(data);
                needUpgradeTaskList.put(taskListId, dataList);
            }
            return needUpgradeTaskList;
        });
        Set longs = needUpgradeTaskList.keySet();
        HashMap taskMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty(longs)) {
            String backupSql;
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,ftasklistid from t_eb_task where", new Object[0]).appendIn("ftasklistid", new ArrayList(longs));
            DB.query((DBRoute)DB_EPM, (SqlBuilder)sqlBuilder, rs -> {
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    long ftasklistid = rs.getLong("ftasklistid");
                    HashSet<Long> taskSet = (HashSet<Long>)taskMap.get(ftasklistid);
                    if (CollectionUtils.isEmpty((Collection)taskSet)) {
                        taskSet = new HashSet<Long>(16);
                    }
                    taskSet.add(fid);
                    taskMap.put(ftasklistid, taskSet);
                }
                return taskMap;
            });
            Iterator iterator = taskMap.entrySet().iterator();
            String insertSql = "insert into t_eb_taskdistorg(fid,ftask,ftaskid,forgid,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,ftaskstatus,frangevalue,forgviewid) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            HashMap<Long, ArrayList<Long>> refIdMap = new HashMap<Long, ArrayList<Long>>(16);
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Long key = (Long)next.getKey();
                Set value = (Set)next.getValue();
                List objects = (List)needUpgradeTaskList.get(key);
                if (!CollectionUtils.isNotEmpty((Collection)objects) || !CollectionUtils.isNotEmpty((Collection)value)) continue;
                long[] ids = GlobalIdUtil.genGlobalLongIds((int)(value.size() * objects.size()));
                int index = 0;
                for (Long aLong : value) {
                    for (Object[] array : objects) {
                        Object[] param = new Object[]{ids[index], aLong, key, array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]};
                        paramList.add(param);
                        ArrayList<Long> newSaveIdList = (ArrayList<Long>)refIdMap.get((Long)array[9]);
                        if (CollectionUtils.isEmpty((Collection)newSaveIdList)) {
                            newSaveIdList = new ArrayList<Long>(10);
                        }
                        newSaveIdList.add(ids[index]);
                        refIdMap.put((Long)array[9], newSaveIdList);
                        ++index;
                    }
                }
            }
            DB.executeBatch((DBRoute)DB_EPM, (String)insertSql, paramList);
            ArrayList<Object[]> insertSupervisor = new ArrayList<Object[]>(10);
            ArrayList<Object[]> backSupervisor = new ArrayList<Object[]>(10);
            String querySupervisor = this.getQuerySupervisorSql();
            if (CollectionUtils.isNotEmpty(refIdMap.keySet())) {
                String batchParamsSql = SqlBatchUtils.getBatchParamsSql((int)refIdMap.size());
                String query = querySupervisor + batchParamsSql + ")";
                DataSet dataSet = DB.queryDataSet((String)"querySupervisor", (DBRoute)DB_EPM, (String)query, (Object[])refIdMap.keySet().toArray());
                Object object = null;
                try {
                    while (dataSet != null && dataSet.hasNext()) {
                        Row next = dataSet.next();
                        Object[] backData = new Object[5];
                        long fid = next.getLong("fid");
                        long fentryid = next.getLong("fentryid");
                        long fseq = next.getLong("fseq");
                        long fsupervisor = next.getLong("fsupervisor");
                        long fuserfield = next.getLong("fuserfield");
                        backData[0] = fid;
                        backData[1] = fentryid;
                        backData[2] = fseq;
                        backData[3] = fsupervisor;
                        backData[4] = fuserfield;
                        backSupervisor.add(backData);
                        List newSaveIdList = (List)refIdMap.get(fid);
                        for (Long aLong : newSaveIdList) {
                            Object[] objects = new Object[]{aLong, GlobalIdUtil.genGlobalLongId(), fseq, fsupervisor, fuserfield};
                            insertSupervisor.add(objects);
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            if (SqlBatchUtils.hasTable((String)"t_eb_taskdistorg_bak") && CollectionUtils.isNotEmpty(needBackup)) {
                backupSql = "insert into t_eb_taskdistorg_bak(forgid,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,ftaskstatus,frangevalue,forgviewid,fid,ftaskid) values (?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, needBackup);
            }
            if (CollectionUtils.isNotEmpty(insertSupervisor)) {
                String insertSupervisorSql = "insert into t_eb_tasksupervisor(fid,fentryid,fseq,fsupervisor,fuserfield) values(?,?,?,?,?)";
                DB.executeBatch((DBRoute)DB_EPM, (String)insertSupervisorSql, insertSupervisor);
            }
            if (SqlBatchUtils.hasTable((String)"t_eb_tasksupervisor_bak") && CollectionUtils.isNotEmpty(backSupervisor)) {
                backupSql = "insert into t_eb_tasksupervisor_bak(fid,fentryid,fseq,fsupervisor,fuserfield) values(?,?,?,?,?)";
                DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, backSupervisor);
            }
        }
    }

    public void upgradeOrgSave() {
        String sql = "select fid,ftasklistid,forgid,forgrange,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,ftaskstatus,forgviewid from t_eb_tasksave where ftaskid is null or ftaskid =0";
        HashMap needUpgradeTaskList = new HashMap(16);
        ArrayList needRemove = new ArrayList(16);
        ArrayList needBackup = new ArrayList(16);
        ArrayList orgSaveIdList = new ArrayList(10);
        DB.query((DBRoute)DB_EPM, (String)sql, rs -> {
            while (rs.next()) {
                long taskListId = rs.getLong("ftasklistid");
                long id = rs.getLong("fid");
                orgSaveIdList.add(id);
                Object[] needRemoveId = new Object[]{id};
                needRemove.add(needRemoveId);
                long orgId = rs.getLong("forgid");
                String orgRange = rs.getString("forgrange");
                long creator = rs.getLong("fcreaterid");
                Timestamp createDate = rs.getTimestamp("fcreatedate");
                long modifier = rs.getLong("fmodifier");
                Timestamp modifyDate = rs.getTimestamp("fmodifydate");
                long executor = rs.getLong("fexecutorid");
                String taskStatus = rs.getString("ftaskstatus");
                long orgView = rs.getLong("forgviewid");
                Object[] data = new Object[]{orgId, orgRange, creator, createDate, modifier, modifyDate, executor, taskStatus, orgView, id, taskListId};
                needBackup.add(data);
                ArrayList<Object[]> dataList = (ArrayList<Object[]>)needUpgradeTaskList.get(taskListId);
                if (CollectionUtils.isEmpty((Collection)dataList)) {
                    dataList = new ArrayList<Object[]>(10);
                }
                dataList.add(data);
                needUpgradeTaskList.put(taskListId, dataList);
            }
            return needUpgradeTaskList;
        });
        Set longs = needUpgradeTaskList.keySet();
        HashMap taskMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty(longs)) {
            String backupSql;
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,ftasklistid from t_eb_task where", new Object[0]).appendIn("ftasklistid", new ArrayList(longs));
            DB.query((DBRoute)DB_EPM, (SqlBuilder)sqlBuilder, rs -> {
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    long ftasklistid = rs.getLong("ftasklistid");
                    HashSet<Long> taskSet = (HashSet<Long>)taskMap.get(ftasklistid);
                    if (CollectionUtils.isEmpty((Collection)taskSet)) {
                        taskSet = new HashSet<Long>(16);
                    }
                    taskSet.add(fid);
                    taskMap.put(ftasklistid, taskSet);
                }
                return taskMap;
            });
            Iterator iterator = taskMap.entrySet().iterator();
            String insertSql = "insert into t_eb_tasksave(fid,ftaskid,ftasklistid,forgid,forgrange,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,ftaskstatus,forgviewid) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            HashMap<Long, ArrayList<Long>> refIdMap = new HashMap<Long, ArrayList<Long>>(16);
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Long key = (Long)next.getKey();
                Set value = (Set)next.getValue();
                List objects = (List)needUpgradeTaskList.get(key);
                if (!CollectionUtils.isNotEmpty((Collection)objects) || !CollectionUtils.isNotEmpty((Collection)value)) continue;
                long[] ids = GlobalIdUtil.genGlobalLongIds((int)(value.size() * objects.size()));
                int index = 0;
                for (Long aLong : value) {
                    for (Object[] array : objects) {
                        Object[] param = new Object[]{ids[index], aLong, key, array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]};
                        paramList.add(param);
                        ArrayList<Long> newSaveIdList = (ArrayList<Long>)refIdMap.get((Long)array[9]);
                        if (CollectionUtils.isEmpty((Collection)newSaveIdList)) {
                            newSaveIdList = new ArrayList<Long>(10);
                        }
                        newSaveIdList.add(ids[index]);
                        refIdMap.put((Long)array[9], newSaveIdList);
                        ++index;
                    }
                }
            }
            DB.executeBatch((DBRoute)DB_EPM, (String)insertSql, paramList);
            ArrayList<Object[]> insertSupervisor = new ArrayList<Object[]>(10);
            ArrayList<Object[]> backSupervisor = new ArrayList<Object[]>(10);
            String querySupervisor = this.getQuerySupervisorSql();
            if (CollectionUtils.isNotEmpty(refIdMap.keySet())) {
                String batchParamsSql = SqlBatchUtils.getBatchParamsSql((int)refIdMap.size());
                String query = querySupervisor + batchParamsSql + ")";
                DataSet dataSet = DB.queryDataSet((String)"querySupervisor", (DBRoute)DB_EPM, (String)query, (Object[])refIdMap.keySet().toArray());
                Object object = null;
                try {
                    while (dataSet != null && dataSet.hasNext()) {
                        Row next = dataSet.next();
                        Object[] backData = new Object[5];
                        long fid = next.getLong("fid");
                        long fentryid = next.getLong("fentryid");
                        long fseq = next.getLong("fseq");
                        long fsupervisor = next.getLong("fsupervisor");
                        long fuserfield = next.getLong("fuserfield");
                        backData[0] = fid;
                        backData[1] = fentryid;
                        backData[2] = fseq;
                        backData[3] = fsupervisor;
                        backData[4] = fuserfield;
                        backSupervisor.add(backData);
                        List newSaveIdList = (List)refIdMap.get(fid);
                        for (Long aLong : newSaveIdList) {
                            Object[] objects = new Object[]{aLong, GlobalIdUtil.genGlobalLongId(), fseq, fsupervisor, fuserfield};
                            insertSupervisor.add(objects);
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            if (SqlBatchUtils.hasTable((String)"t_eb_tasksave_bak") && CollectionUtils.isNotEmpty(needBackup)) {
                backupSql = "insert into t_eb_tasksave_bak(forgid,forgrange,fcreaterid,fcreatedate,fmodifier,fmodifydate,fexecutorid,ftaskstatus,forgviewid,fid,ftasklistid) values (?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, needBackup);
            }
            if (CollectionUtils.isNotEmpty(insertSupervisor)) {
                String insertSupervisorSql = "insert into t_eb_tasksupervisor(fid,fentryid,fseq,fsupervisor,fuserfield) values(?,?,?,?,?)";
                DB.executeBatch((DBRoute)DB_EPM, (String)insertSupervisorSql, insertSupervisor);
            }
            if (SqlBatchUtils.hasTable((String)"t_eb_tasksupervisor_bak") && CollectionUtils.isNotEmpty(backSupervisor)) {
                backupSql = "insert into t_eb_tasksupervisor_bak(fid,fentryid,fseq,fsupervisor,fuserfield) values(?,?,?,?,?)";
                DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, backSupervisor);
            }
        }
    }

    private String getQuerySupervisorSql() {
        return "select fid,fentryid,fseq,fsupervisor,fuserfield from t_eb_tasksupervisor where fid in (";
    }

    private SqlBuilder getSupervisorSql(List<Long> ids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fentryid,fseq,fsupervisor,fuserfield from t_eb_tasksupervisor where", new Object[0]).appendIn("fid", new ArrayList<Long>(ids));
        return sqlBuilder;
    }

    private boolean checkOrgSaveHasColumnTaskId() {
        List columns = DB.getColumnNames((DBRoute)DB_EPM, (String)"t_eb_tasksave");
        for (String columnName : columns) {
            if (!"ftaskid".equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    private boolean checkDisOrgHasColumnTask() {
        List columns = DB.getColumnNames((DBRoute)DB_EPM, (String)"t_eb_taskdistorg");
        for (String columnName : columns) {
            if (!"ftask".equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNeedUpgradeOrgSave() {
        String sql = "select fid,ftaskid,ftasklistid from t_eb_tasksave where ftaskid is null or ftaskid = 0";
        return (Boolean)DB.query((DBRoute)DB_EPM, (String)sql, ResultSet::next);
    }

    private boolean checkNeedUpgradeDisOrg() {
        String sql = "select fid,ftask,ftaskid from t_eb_taskdistorg where ftask is null or ftask = 0";
        return (Boolean)DB.query((DBRoute)DB_EPM, (String)sql, ResultSet::next);
    }
}

